/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.naming;

import com.teamscale.index.naming.CppAndCNamingConventionAnalyzerBase;
import com.teamscale.index.resource.TokenElementInfo;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.cpp.CppCheckUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

public class CppNamingConventionAnalyzer
extends CppAndCNamingConventionAnalyzerBase {
    public CppNamingConventionAnalyzer() {
        super(ELanguage.CPP);
    }

    @Override
    protected void checkType(TokenElementInfo element, ShallowEntity entity) {
        if ("<anonymous>".equals(entity.getName()) || CppNamingConventionAnalyzer.isKnownTemplateSpecialization(entity)) {
            return;
        }
        super.checkType(element, entity);
    }

    private static boolean isKnownTemplateSpecialization(ShallowEntity typeEntity) {
        ShallowEntity previousEntity = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)typeEntity);
        if (!(previousEntity == null || previousEntity.getType() == EShallowEntityType.META && previousEntity.getSubtype().equals("template"))) {
            return false;
        }
        String namespace = CppNamingConventionAnalyzer.extractNamespaceFromTypeEntity(typeEntity);
        Set allowedSpecializations = (Set)CppCheckUtils.ALLOWED_SPECIALIZATIONS_BY_NAMESPACE.getOrDefault(namespace, CollectionUtils.emptySet());
        return allowedSpecializations.contains(typeEntity.getName());
    }

    private static String extractNamespaceFromTypeEntity(ShallowEntity typeEntity) {
        String parentNamespace = CppNamingConventionAnalyzer.findNamespacesInParentEntities(typeEntity);
        String entityNamespace = CppNamingConventionAnalyzer.findNamespacesInEntity(typeEntity);
        if (parentNamespace.isEmpty()) {
            return entityNamespace;
        }
        if (entityNamespace.isEmpty()) {
            return parentNamespace;
        }
        return parentNamespace + "::" + entityNamespace;
    }

    private static String findNamespacesInParentEntities(ShallowEntity entity) {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (ShallowEntity currentEntity = entity.getParent(); currentEntity != null && currentEntity.getSubtype().equals("namespace"); currentEntity = currentEntity.getParent()) {
            namespaces.addFirst(currentEntity.getName());
        }
        return StringUtils.concat(namespaces, (String)"::");
    }

    private static String findNamespacesInEntity(ShallowEntity entity) {
        ArrayList<String> namespaces = new ArrayList<String>();
        UnmodifiableList entityTokens = entity.ownStartTokens();
        for (int currentIndex = TokenStreamUtils.lastTokenMatchingIndexPredicate((List)entityTokens, (int)0, (index, tokens) -> ((IToken)tokens.get((int)index)).getText().equals(entity.getName())) - 1; currentIndex >= 0 && ((IToken)entityTokens.get(currentIndex)).getType() == ETokenType.SCOPE && currentIndex - 1 >= 0 && ((IToken)entityTokens.get(--currentIndex)).getType() == ETokenType.IDENTIFIER; --currentIndex) {
            namespaces.addFirst(((IToken)entityTokens.get(currentIndex)).getText());
        }
        return StringUtils.concat(namespaces, (String)"::");
    }
}

