/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.quality_report.slides;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.quality_report.ReportSlideBase;
import com.teamscale.index.quality_report.SlideRenderDataBase;
import com.teamscale.index.quality_report.slides.EReportSlide;
import com.teamscale.index.quality_report.slides.ESlideOptionType;
import com.teamscale.index.quality_report.slides.ISlideComment;
import com.teamscale.index.quality_report.slides.ProjectBranchPath;
import com.teamscale.index.quality_report.slides.SlideCommentRenderData;
import com.teamscale.index.quality_report.slides.SlideParameter;
import com.teamscale.index.quality_report.slides.SlideParametersBase;
import com.teamscale.index.quality_report.slides.TreeMapOutlineOptions;
import com.teamscale.index.testgap.treemap.TreeMapNode;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.lib.commons.test.IndexValueClass;

@IndexValueClass(containedInBackup=true)
public class MetricTreemapSlide
extends ReportSlideBase<MetricTreemapSlideParameters, MetricTreemapSlideResult> {
    private static final long serialVersionUID = 1L;

    @Override
    public EReportSlide getSlideType() {
        return EReportSlide.METRIC_TREEMAP;
    }

    @IndexValueClass(containedInBackup=true)
    public static class MetricTreemapSlideResult
    extends SlideRenderDataBase {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="treemap")
        private TreeMapNode treemap;
        @JsonProperty(value="comments")
        private List<SlideCommentRenderData> comments;

        @JsonCreator
        public MetricTreemapSlideResult() {
        }

        public MetricTreemapSlideResult(TreeMapNode treemap, List<SlideCommentRenderData> comments) {
            this.treemap = treemap;
            this.comments = comments;
        }

        public TreeMapNode getTreemap() {
            return this.treemap;
        }
    }

    @IndexValueClass(containedInBackup=true)
    public record MetricTreemapColorMetric(String colorMetricName, String color) implements Serializable
    {
    }

    @IndexValueClass(containedInBackup=true)
    public static class MetricTreemapSlideParameters
    extends SlideParametersBase {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="projectBranchPath")
        @SlideParameter(formattedName="Project, Branch & Path", type=ESlideOptionType.PROJECT_BRANCH_PATH)
        private ProjectBranchPath projectBranchPath;
        @JsonProperty(value="slideTitle")
        @SlideParameter(formattedName="Title", inputHint="Markdown supported", type=ESlideOptionType.STRING)
        private String slideTitle;
        @JsonProperty(value="colorMetric")
        @SlideParameter(formattedName="Color Metric", inputHint="The metric to use for the color.", type=ESlideOptionType.COLOR_METRIC)
        private MetricTreemapColorMetric colorMetric = new MetricTreemapColorMetric("Clone Coverage", null);
        @JsonProperty(value="hideMetricBadge")
        @SlideParameter(formattedName="Hide Metric Badge", type=ESlideOptionType.BOOLEAN)
        private boolean hideMetricBadge = false;
        @JsonProperty(value="areaMetricName")
        @SlideParameter(formattedName="Area Metric", inputHint="The metric to use for the area.", type=ESlideOptionType.AREA_METRIC)
        private String areaMetricName = "Lines of Code";
        @JsonProperty(value="minValue")
        @SlideParameter(formattedName="Minimum value", inputHint="All values equal or below this value are colored white. Use -1 to automatically use the lowest metric value as minimum value.", type=ESlideOptionType.SIZE)
        private int minValue = -1;
        @JsonProperty(value="maxValue")
        @SlideParameter(formattedName="Maximum value", inputHint="All values equal or greater this value are colored with the specified color. Use -1 to automatically use the largest metric value as maximum value.", type=ESlideOptionType.SIZE)
        private int maxValue = -1;
        @JsonProperty(value="includePattern")
        @SlideParameter(formattedName="Included files", inputHint="Only files whose path matches any of the provided regular expressions (e. g. .*\\.java$) are displayed.", type=ESlideOptionType.MULTILINE_STRING)
        private String includePattern;
        @JsonProperty(value="excludePattern")
        @SlideParameter(formattedName="Excluded files", inputHint="Files whose path matches the given regular expression (e. g. .*\\.java$) are being excluded.", type=ESlideOptionType.MULTILINE_STRING)
        private String excludePattern;
        @JsonProperty(value="outlineOptions")
        @SlideParameter(formattedName="Outline options", type=ESlideOptionType.TREEMAP_OUTLINE_OPTIONS)
        private @Nullable TreeMapOutlineOptions outlineOptions;
        @JsonProperty(value="comments")
        @SlideParameter(formattedName="Comments", inputHint="Markdown supported", type=ESlideOptionType.COMMENTS)
        private List<ISlideComment> comments;

        @Override
        public List<PublicProjectId> getReferencedProjects() {
            if (this.projectBranchPath == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(this.projectBranchPath.getProjectId());
        }

        public String getSlideTitle() {
            return this.slideTitle;
        }

        public List<ISlideComment> getComments() {
            return this.comments;
        }

        public String getColorMetricName() {
            return this.colorMetric.colorMetricName;
        }

        public String getAreaMetricName() {
            return this.areaMetricName;
        }

        public String getColor() {
            return this.colorMetric.color;
        }

        public int getMinValue() {
            return this.minValue;
        }

        public int getMaxValue() {
            return this.maxValue;
        }

        public String getIncludePattern() {
            return this.includePattern;
        }

        public String getExcludePattern() {
            return this.excludePattern;
        }

        public ProjectBranchPath getProjectBranchPath() {
            return this.projectBranchPath;
        }

        public @Nullable TreeMapOutlineOptions getOutlineOptions() {
            return this.outlineOptions;
        }
    }
}

