/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.fasterxml.jackson.annotation.JsonMerge;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlText;
import jakarta.xml.bind.annotation.XmlElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.regex.Patterns;
import org.conqat.lib.commons.string.StringUtils;

@JacksonXmlRootElement(localName="jqassistant-report")
public class JQAssistantReport {
    private static final String GROUP_ELEMENT = "group";
    private static final String CONSTRAINT_ELEMENT = "constraint";
    private static final String CONCEPT_ELEMENT = "concept";
    private static final String COLUMN_ELEMENT = "column";
    private static final String COLUMNS_ELEMENT = "columns";
    private static final String DESCRIPTION_ELEMENT = "description";
    private static final String RESULT_ELEMENT = "result";
    private static final String ROW_ELEMENT = "row";
    private static final String ROWS_ELEMENT = "rows";
    private static final String SOURCE_ELEMENT = "source";
    private static final String STATUS_ELEMENT = "status";
    private static final String VALUE_ELEMENT = "value";
    private static final String ID_ATTRIBUTE = "id";
    private static final String PRIMARY_ATTRIBUTE = "primary";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String FILE_NAME_ATTRIBUTE = "fileName";
    private static final String START_LINE_ATTRIBUTE = "startLine";
    private static final String END_LINE_ATTRIBUTE = "endLine";
    private static final String FAILURE = "failure";
    private static final String WARNING = "warning";
    @JacksonXmlElementWrapper(useWrapping=false)
    @XmlElement(name="group")
    private Set<Group> groups;

    public JQAssistantElements getElements() {
        return JQAssistantReport.collectConstraintsAndConcepts(this.groups);
    }

    private static JQAssistantElements collectConstraintsAndConcepts(Set<Group> groups) {
        if (groups == null) {
            return new JQAssistantElements(Collections.emptySet(), Collections.emptySet());
        }
        HashSet<Element> constraints = new HashSet<Element>();
        HashSet<Element> concepts = new HashSet<Element>();
        for (Group group : groups) {
            if (group == null) continue;
            constraints.addAll(JQAssistantReport.filterElementsWithNullResult(group.getConstraints()));
            concepts.addAll(JQAssistantReport.filterElementsWithNullResult(group.getConcepts()));
            JQAssistantElements subGroupConstraintsAndConcepts = JQAssistantReport.collectConstraintsAndConcepts(group.getGroups());
            constraints.addAll(subGroupConstraintsAndConcepts.constraints);
            concepts.addAll(subGroupConstraintsAndConcepts.concepts);
        }
        return new JQAssistantElements(constraints, concepts);
    }

    private static Set<Element> filterElementsWithNullResult(Set<Element> elements) {
        return elements.stream().filter(element -> element.getResult() != null).collect(Collectors.toSet());
    }

    private static @Nullable String normalizeString(String text) {
        if (text == null) {
            return null;
        }
        return MarkupUtils.escapeMarkdownRelevantSymbols((String)StringUtils.replaceAll((String)text, (Pattern)Patterns.WHITESPACE, (String)" "));
    }

    public record JQAssistantElements(Set<Element> constraints, Set<Element> concepts) {
    }

    private static class Group {
        @JacksonXmlElementWrapper(useWrapping=false)
        @JsonMerge
        @XmlElement(name="group")
        private Set<Group> groups;
        @JacksonXmlElementWrapper(useWrapping=false)
        @JsonMerge
        @XmlElement(name="constraint")
        private Set<Element> constraints;
        @JacksonXmlElementWrapper(useWrapping=false)
        @JsonMerge
        @XmlElement(name="concept")
        private Set<Element> concepts;

        private Group() {
        }

        private Set<Element> getConstraints() {
            if (this.constraints != null) {
                return Collections.unmodifiableSet(this.constraints);
            }
            return Collections.emptySet();
        }

        private Set<Element> getConcepts() {
            if (this.concepts != null) {
                return Collections.unmodifiableSet(this.concepts);
            }
            return Collections.emptySet();
        }

        private Set<Group> getGroups() {
            return this.groups;
        }
    }

    public static class Element {
        @JacksonXmlProperty(localName="id", isAttribute=true)
        private String id;
        @JacksonXmlProperty(localName="description")
        private Description description;
        @JacksonXmlProperty(localName="result")
        private Result result;
        @JacksonXmlProperty(localName="status")
        private Status status;

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description.getText();
        }

        public Result getResult() {
            return this.result;
        }

        public boolean isWarning() {
            return this.status != null && JQAssistantReport.WARNING.equals(this.status.getText());
        }

        public boolean isFailure() {
            return this.status != null && JQAssistantReport.FAILURE.equals(this.status.getText());
        }
    }

    public static class Result {
        @JacksonXmlProperty(localName="columns")
        private Columns columns;
        @JacksonXmlProperty(localName="rows")
        private Rows rows;

        public Set<Row> getRows() {
            int primaryColumnIndex = this.getPrimaryColumnIndex();
            if (primaryColumnIndex == -1) {
                return new HashSet<Row>();
            }
            HashSet<Row> resultRows = new HashSet<Row>();
            for (Row row : this.rows.getRows()) {
                RowColumn column;
                if (row == null || row.getColumns() == null || (column = row.getColumns().get(primaryColumnIndex)) == null) continue;
                resultRows.add(row);
            }
            return resultRows;
        }

        public int getPrimaryColumnIndex() {
            if (this.columns == null) {
                return -1;
            }
            return this.columns.getPrimaryColumnIndex();
        }
    }

    public static class Source {
        @JacksonXmlProperty(localName="fileName", isAttribute=true)
        private String fileName;
        @JacksonXmlProperty(localName="startLine", isAttribute=true)
        private String startLine;
        @JacksonXmlProperty(localName="endLine", isAttribute=true)
        private String endLine;

        public String getFileName() {
            return JQAssistantReport.normalizeString(this.fileName);
        }

        public String getStartLine() {
            return JQAssistantReport.normalizeString(this.startLine);
        }

        public String getEndLine() {
            return JQAssistantReport.normalizeString(this.endLine);
        }
    }

    private static class RowColumn {
        @JacksonXmlProperty(localName="name", isAttribute=true)
        private String columnName;
        @JacksonXmlProperty(localName="source")
        private Source source;
        @JacksonXmlProperty(localName="value")
        private String value;

        private RowColumn() {
        }

        public String getColumnName() {
            return JQAssistantReport.normalizeString(this.columnName);
        }

        public Source getSource() {
            return this.source;
        }

        public String getValue() {
            return JQAssistantReport.normalizeString(this.value);
        }
    }

    public static class Row {
        @JacksonXmlElementWrapper(useWrapping=false)
        @XmlElement(name="column")
        private List<RowColumn> columns;
        @JacksonXmlProperty(localName="key", isAttribute=true)
        private @Nullable String key;

        public List<RowColumn> getColumns() {
            return this.columns;
        }

        public @Nullable Source getSource(int primaryColumnIndex) {
            if (this.columns == null) {
                return null;
            }
            return this.columns.get(primaryColumnIndex).getSource();
        }

        public @Nullable String getKey() {
            return this.key;
        }

        public String getValue(int columnIndex) {
            return this.columns.get(columnIndex).getValue();
        }

        public Map<String, String> getProperties() {
            HashMap<String, String> properties = new HashMap<String, String>();
            for (RowColumn rowColumn : this.getColumns()) {
                properties.put(rowColumn.getColumnName(), rowColumn.getValue());
            }
            return properties;
        }
    }

    private static class Rows {
        @JacksonXmlElementWrapper(useWrapping=false)
        @XmlElement(name="row")
        private List<Row> rows;

        private Rows() {
        }

        public List<Row> getRows() {
            return this.rows;
        }
    }

    private static class Column {
        @JacksonXmlProperty(localName="primary", isAttribute=true)
        private String primary;
        @JacksonXmlText
        private @Nullable String text;

        private Column() {
        }

        public @Nullable String getText() {
            return JQAssistantReport.normalizeString(this.text);
        }
    }

    private static class Columns {
        @JacksonXmlElementWrapper(useWrapping=false)
        @XmlElement(name="column")
        private List<Column> columns;
        @JacksonXmlProperty(localName="primary", isAttribute=true)
        private @Nullable String primaryColumnName;

        private Columns() {
        }

        public int getPrimaryColumnIndex() {
            if (this.columns == null) {
                return -1;
            }
            if (this.primaryColumnName == null) {
                return 0;
            }
            for (int i = 0; i < this.columns.size(); ++i) {
                Column column = this.columns.get(i);
                if (!this.primaryColumnName.equals(column.getText())) continue;
                return i;
            }
            return 0;
        }
    }

    private static class Status {
        @JacksonXmlText
        private String text;

        private Status() {
        }

        public String getText() {
            return this.text;
        }
    }

    private static class Description {
        @JacksonXmlText
        private String text;

        private Description() {
        }

        public String getText() {
            return JQAssistantReport.normalizeString(this.text);
        }
    }
}

