/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.report.parser;

import com.teamscale.index.report.parser.ClangReportParser;
import com.teamscale.index.report.parser.EPlistElement;
import com.teamscale.index.report.parser.EPlistKey;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.commons.findings.StatementPathElement;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.engine.commons.findings.location.TextRegionLocation;
import org.conqat.engine.core.core.ConQATException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.io.SerializationUtils;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.test.NoIndexValueClass;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PlistHandler
extends DefaultHandler {
    private final ClangFindingsCreator findingsCreator;
    private final Stack<EPlistElement> openElements = new Stack();
    private final Stack<EPlistKey> openKeys = new Stack();
    private final List<String> reportPaths = new ArrayList<String>();
    private final StringBuilder builder = new StringBuilder();
    private String currentCategory;
    private String currentDescription;
    private int currentReportPathIndex;
    private int currentLine;
    private int currentColumn;
    private String currentFindingKind;
    private String currentFindingMessage;
    private List<Pair<Integer, Integer>> currentPathElementRange = new ArrayList<Pair<Integer, Integer>>();
    private ArrayList<StatementPathElement> currentFindingStatementPath = new ArrayList();
    private final List<PreparedFinding> preparedFindings = new ArrayList<PreparedFinding>();
    private final TokenElementLineInfoIndex tokenElementLineInfoIndex;
    private final IMatchingPathsLookup matchingPathsLookup;
    private final Map<String, LineOffsetConverter> reportPathToLineOffsetConverter = new HashMap<String, LineOffsetConverter>();

    PlistHandler(ClangFindingsCreator findingsCreator, TokenElementLineInfoIndex tokenElementLineInfoIndex, IMatchingPathsLookup matchingPathsLookup) {
        this.findingsCreator = findingsCreator;
        this.tokenElementLineInfoIndex = tokenElementLineInfoIndex;
        this.matchingPathsLookup = matchingPathsLookup;
    }

    @Override
    public void error(SAXParseException e) throws SAXException {
        throw e;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        EPlistElement element = (EPlistElement)EnumUtils.valueOfIgnoreCase(EPlistElement.class, (String)localName);
        if (element == null) {
            element = EPlistElement.OTHER;
        }
        this.openElements.push(element);
        this.builder.setLength(0);
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.builder.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) {
        EPlistElement element = this.openElements.pop();
        EPlistElement parentElement1 = null;
        if (!this.openElements.isEmpty()) {
            parentElement1 = this.openElements.peek();
        }
        EPlistElement parentElement = parentElement1;
        if (!this.openKeys.isEmpty()) {
            EPlistKey currentKey = this.openKeys.peek();
            this.handleElementEnd(element, currentKey, parentElement);
        }
        this.updateOpenKeys(element, parentElement);
    }

    private void handleElementEnd(EPlistElement element, EPlistKey currentKey, EPlistElement parentElement) {
        switch (element) {
            case STRING: {
                this.readStringValue(currentKey, parentElement);
                break;
            }
            case INTEGER: {
                this.readIntValue(currentKey);
                break;
            }
            case DICT: {
                if (parentElement != EPlistElement.ARRAY) break;
                if (currentKey == EPlistKey.DIAGNOSTICS) {
                    this.createFinding();
                    break;
                }
                if (currentKey == EPlistKey.PATH) {
                    this.addStatementPathElement();
                    break;
                }
                if (currentKey != EPlistKey.RANGES) break;
                this.currentPathElementRange.add((Pair<Integer, Integer>)new Pair((Object)this.currentLine, (Object)this.currentColumn));
                break;
            }
        }
    }

    private void addStatementPathElement() {
        if (!this.currentFindingKind.equals("event")) {
            return;
        }
        int statementsInPath = this.currentFindingStatementPath.size();
        Set<Object> predecessorPathElements = statementsInPath == 0 ? Collections.emptySet() : Collections.singleton(statementsInPath - 1);
        PreparedTextRegionLocation location = this.createPreparedTextRegionLocation();
        this.currentPathElementRange = new ArrayList<Pair<Integer, Integer>>();
        this.currentFindingStatementPath.add(new StatementPathElement(predecessorPathElements, (ElementLocation)location, this.currentFindingMessage));
    }

    private void readIntValue(EPlistKey currentKey) {
        int value = Integer.parseInt(this.builder.toString());
        switch (currentKey) {
            case LINE: {
                this.currentLine = value;
                break;
            }
            case FILE: {
                this.currentReportPathIndex = value;
                break;
            }
            case COL: {
                this.currentColumn = value - 1;
            }
        }
    }

    private void readStringValue(EPlistKey currentKey, EPlistElement parentElement) {
        String value = this.builder.toString();
        switch (currentKey) {
            case FILES: {
                if (parentElement != EPlistElement.ARRAY) break;
                this.reportPaths.add(value);
                break;
            }
            case DESCRIPTION: {
                this.currentDescription = value;
                break;
            }
            case CATEGORY: {
                if (ClangReportParser.KNOWN_CATEGORIES.contains(value)) {
                    this.currentCategory = value;
                    break;
                }
                this.currentCategory = ClangReportParser.CATEGORY_REPLACEMENTS.getOrDefault(value, "Other");
                break;
            }
            case KIND: {
                this.currentFindingKind = value;
                break;
            }
            case MESSAGE: {
                this.currentFindingMessage = value;
            }
        }
    }

    private void updateOpenKeys(EPlistElement element, EPlistElement parentElement) {
        if (element == EPlistElement.KEY) {
            EPlistKey key = (EPlistKey)EnumUtils.valueOfIgnoreCase(EPlistKey.class, (String)this.builder.toString());
            if (key == null) {
                key = EPlistKey.OTHER;
            }
            this.openKeys.push(key);
        } else if (parentElement == EPlistElement.DICT) {
            this.openKeys.pop();
        }
    }

    private void createFinding() {
        this.preparedFindings.add(new PreparedFinding(this.currentReportPathIndex, this.currentCategory, this.currentDescription, this.currentLine, this.currentFindingStatementPath));
        this.currentCategory = null;
        this.currentDescription = null;
        this.currentLine = 0;
        this.currentReportPathIndex = 0;
        this.currentColumn = 0;
        this.currentFindingKind = null;
        this.currentFindingMessage = null;
        this.currentPathElementRange = new ArrayList<Pair<Integer, Integer>>();
        this.currentFindingStatementPath = new ArrayList();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
        try {
            this.createLineOffsetConverters();
            List<PreparedFinding> filteredFindings = this.preparedFindings.stream().filter(finding -> this.reportPathToLineOffsetConverter.containsKey(this.reportPaths.get(finding.fileIndex))).toList();
            for (PreparedFinding preparedFinding : filteredFindings) {
                preparedFinding.createFinding(this.findingsCreator);
            }
        }
        catch (ConQATException e) {
            throw new SAXException((Exception)((Object)e));
        }
    }

    private void createLineOffsetConverters() throws StorageException, AssertionError {
        HashMap projectPathToReportPath = new HashMap();
        for (String reportPath : this.reportPaths) {
            Optional<String> projectPathOptional = this.matchingPathsLookup.lookupBestPath(reportPath);
            projectPathOptional.ifPresent(projectPath -> projectPathToReportPath.put(projectPath, reportPath));
        }
        ArrayList<String> uniformPaths = new ArrayList<String>(projectPathToReportPath.keySet());
        List<TokenElementLineInfo> tokenElementLineInfos = this.tokenElementLineInfoIndex.getLineInfos(uniformPaths);
        CollectionUtils.forEach(uniformPaths, tokenElementLineInfos, (uniformPath, tokenElementLineInfo) -> {
            CCSMAssert.isNotNull((Object)tokenElementLineInfo);
            LineOffsetConverter lineOffsetConverter = tokenElementLineInfo.getRawLineOffsetConverter();
            this.reportPathToLineOffsetConverter.put((String)projectPathToReportPath.get(uniformPath), lineOffsetConverter);
        });
    }

    private PreparedTextRegionLocation createPreparedTextRegionLocation() {
        int startLine = this.currentLine;
        int endLine = this.currentLine;
        int startColumn = this.currentColumn;
        int endColumn = this.currentColumn;
        if (!this.currentPathElementRange.isEmpty()) {
            startLine = (Integer)this.currentPathElementRange.get(0).getFirst();
            endLine = (Integer)this.currentPathElementRange.get(1).getFirst();
            startColumn = (Integer)this.currentPathElementRange.get(0).getSecond();
            endColumn = (Integer)this.currentPathElementRange.get(1).getSecond();
        }
        if (endLine < startLine) {
            LogManager.getLogger().warn("End line(" + endLine + ") smaller than start line (" + startLine + "), setting to start line. FileIndex: " + this.currentReportPathIndex);
            endLine = startLine;
        }
        if (endColumn < startColumn) {
            LogManager.getLogger().warn("End offset(" + endColumn + ") smaller than start offset (" + startColumn + "), setting to start offset. FileIndex: " + this.currentReportPathIndex);
            endColumn = startColumn;
        }
        return new PreparedTextRegionLocation(this.currentReportPathIndex, startColumn, endColumn, startLine, endLine);
    }

    @FunctionalInterface
    public static interface ClangFindingsCreator {
        public void apply(String var1, String var2, String var3, Integer var4, ArrayList<StatementPathElement> var5) throws ConQATException;
    }

    @NoIndexValueClass(rationale="This class can't end up in an index because its instances exist just locally in the PlistHandler. Before we store the findings, we resolve them to a TextRegionLocation with PreparedTextRegionLocation#resolve.")
    private class PreparedTextRegionLocation
    extends TextRegionLocation {
        private static final long serialVersionUID = 1L;
        private final int reportPathIndex;

        PreparedTextRegionLocation(int reportPathIndex, int startOffset, int endOffset, int startLine, int endLine) {
            super("", startOffset, endOffset, startLine, endLine);
            this.reportPathIndex = reportPathIndex;
        }

        public Optional<TextRegionLocation> resolve() {
            int rawEndOffset;
            int rawStartOffset;
            String reportPath = this.getReportPath();
            LineOffsetConverter lineOffsetConverter = PlistHandler.this.reportPathToLineOffsetConverter.get(reportPath);
            if (lineOffsetConverter == null || !lineOffsetConverter.isValidLine(this.getRawStartLine()) || !lineOffsetConverter.isValidLine(this.getRawEndLine())) {
                return Optional.empty();
            }
            if (this.getRawStartLine() == this.getRawEndLine() && this.getRawStartOffset() == 0 && this.getRawEndOffset() == 0) {
                rawStartOffset = lineOffsetConverter.getOffset(this.getRawStartLine());
                rawEndOffset = lineOffsetConverter.getOffset(this.getRawEndLine() + 1) - 1;
            } else {
                rawStartOffset = lineOffsetConverter.getOffset(this.getRawStartLine()) + this.getRawStartOffset();
                rawEndOffset = lineOffsetConverter.getOffset(this.getRawEndLine()) + this.getRawEndOffset();
            }
            return Optional.of(new TextRegionLocation(reportPath, rawStartOffset, rawEndOffset, this.getRawStartLine(), this.getRawEndLine()));
        }

        public String getReportPath() {
            return PlistHandler.this.reportPaths.get(this.reportPathIndex);
        }

        protected boolean canEqual(Object other) {
            return other instanceof StatementPathElement;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PreparedTextRegionLocation)) {
                return false;
            }
            PreparedTextRegionLocation that = (PreparedTextRegionLocation)((Object)o);
            return that.canEqual((Object)this) && this.reportPathIndex == that.reportPathIndex && super.equals(o);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.reportPathIndex);
        }

        private void writeObject(ObjectOutputStream stream) throws IOException {
            SerializationUtils.unsupportedWriteObject((ObjectOutputStream)stream);
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            SerializationUtils.unsupportedReadObject((ObjectInputStream)stream);
        }
    }

    private class PreparedFinding {
        private final String category;
        private final String description;
        private final int fileIndex;
        private final int line;
        private final ArrayList<StatementPathElement> findingStatementPath;

        private PreparedFinding(int fileIndex, String category, String description, int line, ArrayList<StatementPathElement> findingStatementPath) {
            this.fileIndex = fileIndex;
            this.category = category;
            this.description = description;
            this.line = line;
            this.findingStatementPath = findingStatementPath;
        }

        public void createFinding(ClangFindingsCreator findingsCreator) throws ConQATException {
            ArrayList<StatementPathElement> resolvedFindingStatementPaths = new ArrayList<StatementPathElement>();
            for (StatementPathElement element : this.findingStatementPath) {
                PreparedTextRegionLocation preparedTextRegionLocation = (PreparedTextRegionLocation)element.getLocation();
                Optional<TextRegionLocation> resolvedLocation = preparedTextRegionLocation.resolve();
                if (resolvedLocation.isEmpty()) {
                    LogManager.getLogger().error(String.format("Statement path element \"%s [lines %s]\" for finding \"%s [line %s]\" could not be resolved in %s. Discarding finding", element.getDescription(), element.getLocation(), this.description, this.line, preparedTextRegionLocation.getReportPath()));
                    return;
                }
                resolvedFindingStatementPaths.add(new StatementPathElement(element.getPredecessorPathElements(), (ElementLocation)resolvedLocation.get(), element.getDescription()));
            }
            findingsCreator.apply(this.category, this.description, PlistHandler.this.reportPaths.get(this.fileIndex), this.line, resolvedFindingStatementPaths);
        }
    }
}

