/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;

@Index(name="finding-issue-mapping-index", options={EStorageOption.NO_ROLLBACK})
public class FindingIssuesMappingIndex
implements IProjectIndex {
    private final ValueIndex<HashSet<TeamscaleIssueId>> delegate;

    public FindingIssuesMappingIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void storeFindingIssueMapping(List<String> findingIds, Collection<TeamscaleIssueId> issueIds) throws StorageException {
        PairList valuesToWrite = new PairList();
        @Nullable List existingValues = this.delegate.getValues(findingIds);
        for (int i = 0; i < findingIds.size(); ++i) {
            if (existingValues.get(i) == null) {
                valuesToWrite.add((Object)findingIds.get(i), new HashSet<TeamscaleIssueId>(issueIds));
                continue;
            }
            HashSet<TeamscaleIssueId> entries = new HashSet<TeamscaleIssueId>((Collection)existingValues.get(i));
            entries.addAll(issueIds);
            valuesToWrite.add((Object)findingIds.get(i), entries);
        }
        this.delegate.setValues(valuesToWrite);
    }

    public Set<TeamscaleIssueId> getIssuesForFindingIds(List<String> findingIds) throws StorageException {
        HashSet<TeamscaleIssueId> result = new HashSet<TeamscaleIssueId>();
        if (findingIds.isEmpty()) {
            return result;
        }
        for (HashSet issueIds : this.delegate.getValues(findingIds)) {
            if (issueIds == null) continue;
            result.addAll(issueIds);
        }
        return result;
    }
}

