/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository;

import com.teamscale.core.accounts.ExternalCredentialsIndex;
import com.teamscale.core.accounts.IExternalCredentialsProvider;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfigurationUtils;
import com.teamscale.core.analysis.configuration.model.ConfigurationInitializationContext;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.utils.UnresolvedCommitDescriptorUtils;
import com.teamscale.index.repository.IRevisionResolver;
import com.teamscale.index.repository.RepositoryRevisionIndex;
import com.teamscale.index.repository.RevisionResolverFactory;
import com.teamscale.index.repository.base.RepositoryConnectorDescriptorBase;
import com.teamscale.index.testimpact.CommitAndRevision;
import jakarta.ws.rs.NotFoundException;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.InternalProjectId;
import org.conqat.engine.index.shared.UnresolvedCommitDescriptor;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

public final class RevisionResolver {
    private static final Logger LOGGER = LogManager.getLogger();

    public static CommitDescriptor resolveRevisionOrCommit(CommitAndRevision commitAndRevision, String userName, InternalProjectId projectId, IndexLayer indexLayer) throws StorageException {
        if (!StringUtils.isEmpty((String)commitAndRevision.revision())) {
            return new UserAwareRevisionResolver(userName).resolveRevision(commitAndRevision.revision(), commitAndRevision.repository(), projectId, indexLayer).orElseThrow(() -> RevisionResolver.createNotFoundException(commitAndRevision));
        }
        return UnresolvedCommitDescriptorUtils.resolveCommitWithFallbackTimestamp((UnresolvedCommitDescriptor)commitAndRevision.commit(), (long)System.currentTimeMillis(), () -> indexLayer.openProjectStorageSystem((IProjectId)projectId));
    }

    public static Optional<Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository>> resolveRevisionAndRepository(String revision, @Nullable String repositoryName, @Nullable String userName, InternalProjectId projectId, IndexLayer indexLayer) throws StorageException {
        return Optional.ofNullable(new UserAwareRevisionResolver(userName).resolveRevisionToCommit(revision, repositoryName, projectId, indexLayer));
    }

    private static NotFoundException createNotFoundException(CommitAndRevision commitAndRevision) {
        String message = StringUtils.isEmpty((String)commitAndRevision.repository()) ? "Revision " + commitAndRevision.revision() + " not found in Teamscale and neither in any of the available VCS repositories." : "Revision " + commitAndRevision.revision() + " not found in Teamscale and also in VCS repository identified in Teamscale as: " + commitAndRevision.repository();
        return new NotFoundException(message);
    }

    private static boolean isExternalStorageBackendRevision(RepositoryRevisionIndex.RevisionAndRepository revisionAndRepository) {
        return "external-analysis-data".equals(revisionAndRepository.repositoryIdentifier());
    }

    private static class UserAwareRevisionResolver {
        private final @Nullable String userName;

        public UserAwareRevisionResolver(@Nullable String userName) {
            this.userName = userName;
        }

        public Optional<CommitDescriptor> resolveRevision(String revision, @Nullable String repositoryName, InternalProjectId projectId, IndexLayer indexLayer) throws StorageException {
            Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> resolvedCommit = this.resolveRevisionToCommit(revision, repositoryName, projectId, indexLayer);
            if (resolvedCommit == null) {
                return Optional.empty();
            }
            return Optional.of((CommitDescriptor)resolvedCommit.getFirst());
        }

        public @Nullable Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> resolveRevisionToCommit(String revision, @Nullable String repositoryName, InternalProjectId projectId, IndexLayer indexLayer) throws StorageException {
            CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem((IProjectId)projectId);
            Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> resolvedCommit = UserAwareRevisionResolver.resolveRevisionWithRepositoryRevisionIndex(revision, repositoryName, projectStorageSystem);
            if (resolvedCommit != null) {
                return resolvedCommit;
            }
            return this.resolveRevisionFromRepository(revision, repositoryName, projectId, projectStorageSystem, indexLayer);
        }

        private static @Nullable Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> resolveRevisionWithRepositoryRevisionIndex(String revision, @Nullable String repository, CommitResolvingStorageSystem projectStorageSystem) throws StorageException {
            PairList possibleRevisions = ((RepositoryRevisionIndex)projectStorageSystem.openProjectIndex(RepositoryRevisionIndex.class, null)).getProcessedCommits(revision);
            int numberOfPossibleCommits = (possibleRevisions = possibleRevisions.removeIf((commit, revisionAndRepository) -> RevisionResolver.isExternalStorageBackendRevision(revisionAndRepository))).size();
            if (numberOfPossibleCommits == 0) {
                LOGGER.warn("Revision {} not found in repository revision index.", (Object)revision);
                return null;
            }
            if (numberOfPossibleCommits == 1) {
                return (Pair)possibleRevisions.toList().getFirst();
            }
            if (repository == null) {
                LOGGER.warn("Commits present in multiple repositories but no repository specified for revision '{}': {}", (Object)revision, (Object)possibleRevisions);
                return null;
            }
            for (Pair possibleRevision : possibleRevisions) {
                if (!((RepositoryRevisionIndex.RevisionAndRepository)possibleRevision.getSecond()).repositoryIdentifier().equals(repository)) continue;
                return possibleRevision;
            }
            LOGGER.warn("Revision {} not found for repository {}", (Object)revision, (Object)repository);
            return null;
        }

        private @Nullable Pair<CommitDescriptor, RepositoryRevisionIndex.RevisionAndRepository> resolveRevisionFromRepository(String revision, @Nullable String repositoryName, InternalProjectId projectId, CommitResolvingStorageSystem projectStorage, IndexLayer indexLayer) throws StorageException {
            if (StringUtils.isEmpty((String)repositoryName)) {
                LOGGER.info("Revision {} not found in Teamscale. Resolving revision from all available VCS repositories.", (Object)revision);
            } else {
                LOGGER.info("Revision {} not found in Teamscale. Resolving revision from VCS repository identified in Teamscale as {}", (Object)revision, (Object)repositoryName);
            }
            ProjectConfiguration projectConfiguration = Objects.requireNonNull(ProjectConfigurationUtils.getProjectConfiguration((IProjectId)projectId, (IndexLayer)indexLayer), () -> "Project configuration for project ID '%s' not found.".formatted(projectId));
            for (ConnectorConfiguration connector : projectConfiguration.getConnectors()) {
                CommitDescriptor resolvedCommit;
                String repositoryIdentifier = connector.getIdentifier();
                if (!StringUtils.isEmpty((String)repositoryName) && !repositoryName.equals(repositoryIdentifier) || (resolvedCommit = this.resolveRevisionFromConnector(revision, connector, projectId, indexLayer)) == null) continue;
                UserAwareRevisionResolver.saveResolvedCommitToIndex(revision, repositoryIdentifier, resolvedCommit, projectStorage);
                LOGGER.info("Revision {} successfully resolved to {}", (Object)revision, (Object)resolvedCommit.toServiceCallFormat());
                return new Pair((Object)resolvedCommit, (Object)new RepositoryRevisionIndex.RevisionAndRepository(revision, connector.getIdentifier()));
            }
            return null;
        }

        private @Nullable CommitDescriptor resolveRevisionFromConnector(String revision, ConnectorConfiguration connectorConfiguration, InternalProjectId projectId, IndexLayer indexLayer) throws StorageException {
            ConnectorDescriptorBase connectorDescriptor = this.loadConnector(projectId, connectorConfiguration, indexLayer);
            if (!(connectorDescriptor instanceof RepositoryConnectorDescriptorBase)) {
                return null;
            }
            RepositoryConnectorDescriptorBase repositoryConnectorDescriptor = (RepositoryConnectorDescriptorBase)connectorDescriptor;
            return UserAwareRevisionResolver.tryResolveCommit(revision, repositoryConnectorDescriptor, projectId, indexLayer);
        }

        private @Nullable ConnectorDescriptorBase loadConnector(InternalProjectId project, ConnectorConfiguration connector, IndexLayer indexLayer) throws StorageException {
            try {
                return ConnectorUtils.loadConnector((ConnectorConfiguration)connector, (ConfigurationInitializationContext)new ConfigurationInitializationContext(this.userName, indexLayer, (IExternalCredentialsProvider)indexLayer.openGlobalIndex(ExternalCredentialsIndex.class), ConfigurationInitializationContext.EInitializationReason.OTHER), (InternalProjectId)project);
            }
            catch (ProjectConfigurationException e) {
                LOGGER.warn("Failed to load connector {} during external upload.", (Object)connector.getIdentifier());
                return null;
            }
        }

        private static @Nullable CommitDescriptor tryResolveCommit(String revision, RepositoryConnectorDescriptorBase connectorDescriptor, InternalProjectId projectId, IndexLayer indexLayer) throws StorageException {
            Optional<IRevisionResolver> revisionResolver = RevisionResolverFactory.getRevisionResolver(connectorDescriptor, projectId, indexLayer);
            if (revisionResolver.isEmpty()) {
                return null;
            }
            return revisionResolver.get().resolveToCommitDescriptor(revision).orElse(null);
        }

        private static void saveResolvedCommitToIndex(String revision, String repositoryIdentifier, CommitDescriptor commitDescriptor, CommitResolvingStorageSystem projectStorage) throws StorageException {
            ((RepositoryRevisionIndex)projectStorage.openProjectIndex(RepositoryRevisionIndex.class, null)).setProcessedCommit(new RepositoryRevisionIndex.RevisionAndRepository(revision, repositoryIdentifier), commitDescriptor);
        }
    }
}

