/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.analysis.configuration.ConnectorValidationException;
import com.teamscale.core.analysis.configuration.IConnectorDescriptorConsistencyValidator;
import com.teamscale.core.analysis.configuration.ITriggerParameter;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.TriggerBuilder;
import com.teamscale.core.analysis.configuration.model.ConnectorDescriptorBase;
import com.teamscale.core.analysis.configuration.model.ERepositoryConnector;
import com.teamscale.core.analysis.configuration.model.option.ConfigExposed;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.analysis.trigger.ChangeRetrieverAnalysisStep;
import com.teamscale.core.analysis.trigger.configuration.ESchedulingParameter;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.index.report.AnalysisReportIntegrator;
import com.teamscale.index.report.EReportFormat;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryInfoBase;
import com.teamscale.index.repository.artifact_store.DeletePartitionsWithoutUploadsConnectorConsistencyChecker;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryChangeRetriever;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryContentUpdater;
import com.teamscale.index.repository.artifact_store.revision_interpretation.ERevisionInterpretationFactory;
import com.teamscale.index.repository.base.CredentialsBasedRepositoryConnectorDescriptorBase;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.enums.EnumUtils;
import org.conqat.lib.commons.filesystem.AntPatternUtils;
import org.conqat.lib.commons.string.StringUtils;

public abstract class ArtifactStoreRepositoryConnectorDescriptorBase<T extends ArtifactStoreRepositoryInfoBase>
extends CredentialsBasedRepositoryConnectorDescriptorBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String DEFAULT_BRANCH_NAME = "master";
    public static final String DELETE_PARTITIONS_WITHOUT_NEW_UPLOADS = "Delete Partitions Without New Uploads";
    @ConfigExposed(name="Branch Extraction Pattern", description="Pattern used to extract the branch name from the full path. A regex pattern with exactly one capturing group. The group is used to find the branch name from the archive's path.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    public String branchExtractionPattern = "uploads/([^/]+)/\\d+(?:-[abcdef0-9]+)?/[^/]+/[^/]+/.*";
    @ConfigExposed(name="Repository Extraction Pattern", description="Pattern used to extract the repository name from the full path. A regex pattern with exactly one capturing group. The group is used to find the repository name from the archive's path.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    public String repositoryExtractionPattern = "";
    @ConfigExposed(name="Timestamp Extraction Pattern", description="Pattern used to extract the timestamp or revision from the full path. A regex pattern with exactly one capturing group. The group is used to find the timestamp name from the archive's path. If this is empty, the creation date from the artifact store will be used.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    public String timestampExtractionPattern = "uploads/[^/]+/(\\d+)(?:-[abcdef0-9]+)?/[^/]+/[^/]+/.*";
    @ConfigExposed(name="Max Change Detection Age", description="Normally Teamscale will detect changes to the history of the artifact store downloads for an unlimited amount of days. Add a number of days here, after which Teamscale will stop looking for changes in commits that are older than the given amount of days. Defaults to 14 days.", visibility=ConfigExposed.EConfigVisibility.ADVANCED, changeRequiresReAnalysis=false)
    protected String ignoreChangesOlderThanDays = "14";
    @ConfigExposed(name="Timestamp Interpretation", description="Describes how to interpret the value from timestamp extraction. Possible values are 'date:pattern', where pattern is a Java time format descriptor, 'timestamp:seconds' and 'timestamp:millis' for unix timestamps in seconds or milliseconds, 'svn:account-name' to interpret the value as a Subversion revision, 'git:account-name' to interpret the value as a git commit hash for a repository using the 'File System' connector,and 'connector:repository-identifier' to interpret the value as a revision of a connector in the same project.For 'connector:repository-identifier', the part after the colon is optional, i.e., 'connector' is also valid. Please refer for the Teamscale documentation for details.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    public String timestampInterpretation = "timestamp:millis";
    @ConfigExposed(name="Prefix Extraction Pattern", description="Pattern used to extract an additional prefix that is placed before the name of files extracted from the ZIP files. A regex pattern with exactly one capturing group. The group is used to find the prefix from the archive's path. If this is empty, no prefix will be used.", visibility=ConfigExposed.EConfigVisibility.ADVANCED)
    protected String prefixExtractionPattern = "(.*)";
    @ConfigExposed(name="Ignore extraction failures", description="When checked, Teamscale will try to ignore errors during timestamp extraction according to the given extraction pattern. This can be useful when many non-conforming paths are expected to be analyzed alongside the conforming paths. When this is unchecked, such errors will stop the import until they are corrected (to avoid importing inconsistent data), when checked the non-conforming path will be skipped but all conforming paths will still be imported.", visibility=ConfigExposed.EConfigVisibility.EXPERT, changeRequiresReAnalysis=false)
    boolean ignoreExtractionFailures;
    @ConfigExposed(name="Filter duplicate archives per revision", description="When activated, Teamscale will only keep the newest archive for all archives with the same simple name (without path) that are mapped to the same revision.", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    boolean filterDuplicateArchivesPerRevision = false;
    @ConfigExposed(name="Required ZIP path patterns", description="List of patterns (comma separated), for which at least one matching path of a ZIP file must be found. If this is not the case, the revision will be skipped by the connector. This can be used to skip incomplete builds.", changeRequiresReAnalysis=false, multilineText=true, visibility=ConfigExposed.EConfigVisibility.EXPERT)
    List<String> requiredZipFilePatterns = new ArrayList<String>();
    @ConfigExposed(name="Delete Partitions Without New Uploads", description="Whether to remove data in partitions that have not been updated in a commit in an upload to S3/Artifactory, instead of keeping it. (off = keep data)", visibility=ConfigExposed.EConfigVisibility.EXPERT)
    public boolean deletePartitionsWithoutNewUploads = true;
    public static final String BRANCH_EXTRACTION_PATTERN_OPTION = "Branch Extraction Pattern";
    public static final String TIME_EXTRACTION_PATTERN_OPTION = "Timestamp Extraction Pattern";
    public static final String REPOSITORY_EXTRACTION_PATTERN_OPTION = "Repository Extraction Pattern";
    public static final String PREFIX_EXTRACTION_PATTERN_OPTION = "Prefix Extraction Pattern";
    public static final String TIMESTAMP_INTERPRETATION_OPTION = "Timestamp Interpretation";

    protected ArtifactStoreRepositoryConnectorDescriptorBase(ERepositoryConnector connectorType) {
        super(connectorType, DEFAULT_BRANCH_NAME);
        this.autoExpose();
        this.hideOption("Path suffix");
        ConnectorUtils.registerConnectorConsistencyValidator((IConnectorDescriptorConsistencyValidator)DeletePartitionsWithoutUploadsConnectorConsistencyChecker.getInstance());
    }

    @Override
    protected void configureIndices(ConnectorDescriptorBase.IIndexCreator indexCreator) {
        super.configureIndices(indexCreator);
        this.createArchiveIndex(indexCreator);
        try {
            if (ERevisionInterpretationFactory.getReferencedConnectorId(this.timestampInterpretation).isEmpty()) {
                indexCreator.createProjectIndex(CommitTreeIndex.class, this.getDummyCommitTreeName());
            }
        }
        catch (RepositoryException e) {
            LOGGER.warn("Failed to parse referenced connector id from: {}", (Object)this.timestampInterpretation, (Object)e);
        }
    }

    @Override
    protected void configureTriggers(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        AnalysisReportIntegrator.PreservePartitionsWithoutNewUploadsEnablementMarker marker;
        super.configureTriggers(triggerCreator);
        if (!this.deletePartitionsWithoutNewUploads && !triggerCreator.isMetaIndexEntryAlreadyAdded((Serializable)(marker = new AnalysisReportIntegrator.PreservePartitionsWithoutNewUploadsEnablementMarker()))) {
            triggerCreator.addMetaIndexEntry((Serializable)marker);
        }
    }

    @Override
    protected Class<? extends ChangeRetrieverAnalysisStep> getChangeRetrieverBlockName() {
        return ArtifactoryChangeRetriever.class;
    }

    @Override
    protected Class<? extends ChangeProcessorAnalysisStep> getContentUpdaterBlockName() {
        return ArtifactoryContentUpdater.class;
    }

    @Override
    protected void setCommonParameters(TriggerBuilder triggerBuilder, ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        triggerBuilder.setTriggerParameter("branch-extraction-pattern", this.branchExtractionPattern);
        triggerBuilder.setTriggerParameter("repository-extraction-pattern", this.repositoryExtractionPattern);
        triggerBuilder.setTriggerParameter("timestamp-extraction-pattern", this.timestampExtractionPattern);
        triggerBuilder.setTriggerParameter("timestamp-interpretation", this.timestampInterpretation);
        triggerBuilder.setTriggerParameter("prefix-extraction-pattern", this.prefixExtractionPattern);
        triggerBuilder.setTriggerParameter("ignore-extraction-failures", this.ignoreExtractionFailures);
        triggerBuilder.setTriggerParameter("filter-duplicate-archives-per-revision", this.filterDuplicateArchivesPerRevision);
        triggerBuilder.setTriggerParameter("required-zip-file-pattern", ITriggerParameter.of(this.requiredZipFilePatterns));
        if (!StringUtils.isEmpty((String)this.ignoreChangesOlderThanDays)) {
            triggerBuilder.setTriggerParameter("ignore-changes-older-than-days", this.ignoreChangesOlderThanDays);
        }
        this.renameArchiveIndex(triggerBuilder);
        try {
            Optional<String> repositoryId = ERevisionInterpretationFactory.getReferencedConnectorId(this.timestampInterpretation);
            if (repositoryId.isPresent()) {
                triggerBuilder.renameIndex("foreign-commit-tree", ArtifactStoreRepositoryConnectorDescriptorBase.getCommitTreeName(repositoryId.get()));
                triggerBuilder.setTriggerParameter("foreign-repository-identifier", repositoryId.get());
            } else {
                triggerBuilder.renameIndex("foreign-commit-tree", this.getDummyCommitTreeName());
            }
        }
        catch (RepositoryException e) {
            throw new ProjectConfigurationException((Throwable)e);
        }
        triggerBuilder.setTriggerParameter("repository-name", this.getRepositoryOrBucketName());
        super.setCommonParameters(triggerBuilder, triggerCreator);
    }

    @Override
    protected void createChangeRetrieverTrigger(ConnectorDescriptorBase.ITriggerCreator triggerCreator) throws ProjectConfigurationException {
        super.createChangeRetrieverTrigger(triggerCreator);
        triggerCreator.addPostBuildCompletenessAnalysisTrigger(this.changeRetrieverTriggerName);
    }

    @Override
    protected void setChangeRetrieverParameters(TriggerBuilder trigger) throws ProjectConfigurationException {
        super.setChangeRetrieverParameters(trigger);
        trigger.setTriggerParameter("report-mapping", ITriggerParameter.of((Object)this.reportMapping.mapSecond(s -> (EReportFormat)EnumUtils.valueOfIgnoreCase(EReportFormat.class, (String)s))));
        trigger.setSchedulingParameter(ESchedulingParameter.RUN_POST_BUILD_COMPLETENESS, (Object)true);
    }

    protected abstract void createArchiveIndex(ConnectorDescriptorBase.IIndexCreator var1);

    protected abstract void renameArchiveIndex(TriggerBuilder var1);

    private String getDummyCommitTreeName() {
        return "dummy-" + this.getCommitTreeName();
    }

    @Override
    public void validate() throws ConnectorValidationException {
        super.validate();
        ArtifactStoreRepositoryConnectorDescriptorBase.checkExtractionPattern("branch", this.branchExtractionPattern);
        ArtifactStoreRepositoryConnectorDescriptorBase.checkExtractionPattern("timestamp", this.timestampExtractionPattern);
        ArtifactStoreRepositoryConnectorDescriptorBase.checkExtractionPattern("prefix", this.prefixExtractionPattern);
        this.checkTimestampInterpretation();
        this.checkConnection();
        this.checkZipExcludePattern();
        this.checkRequiredZipFilePatterns();
    }

    private static void checkExtractionPattern(String patternName, String pattern) throws ConnectorValidationException {
        if (StringUtils.isEmpty((String)pattern)) {
            return;
        }
        try {
            Pattern.compile(pattern);
        }
        catch (PatternSyntaxException e) {
            throw new ConnectorValidationException("Invalid " + patternName + " pattern '" + pattern + "': " + e.getMessage(), (Throwable)e);
        }
    }

    private void checkTimestampInterpretation() throws ConnectorValidationException {
        try {
            if (ERevisionInterpretationFactory.getReferencedConnectorId(this.timestampInterpretation).isPresent()) {
                return;
            }
            ERevisionInterpretationFactory.RevisionInterpretationContext revisionInterpretationContext = new ERevisionInterpretationFactory.RevisionInterpretationContext(this.getContext().getExternalCredentialsProvider());
            ERevisionInterpretationFactory.createFromDescriptor(this.timestampInterpretation, revisionInterpretationContext);
            if (this.timestampInterpretation.toLowerCase().startsWith(ERevisionInterpretationFactory.DATE.name().toLowerCase()) && this.timestampInterpretation.contains("Y")) {
                throw new ConnectorValidationException("Found uppercase 'Y' in date pattern '" + this.timestampInterpretation + "', which refers to the week year. You will probably want to use lowercase 'y' instead.");
            }
        }
        catch (RepositoryException e) {
            throw new ConnectorValidationException((Throwable)e);
        }
    }

    private void checkZipExcludePattern() throws ConnectorValidationException {
        for (String pattern : this.getExcludePatterns()) {
            try {
                AntPatternUtils.convertPattern((String)pattern, (boolean)false);
            }
            catch (PatternSyntaxException e) {
                throw new ConnectorValidationException("Failed to parse ant pattern '" + pattern + "': " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private void checkRequiredZipFilePatterns() throws ConnectorValidationException {
        for (String pattern : this.requiredZipFilePatterns) {
            try {
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                throw new ConnectorValidationException("Invalid regular expression '" + pattern + "' in required ZIP path patterns: " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected abstract void checkConnection() throws ConnectorValidationException;

    @Override
    protected boolean validateRevision(String revision) {
        try {
            if (ERevisionInterpretationFactory.getReferencedConnectorId(this.timestampInterpretation).isPresent()) {
                return true;
            }
            ERevisionInterpretationFactory.RevisionInterpretationContext revisionInterpretationContext = new ERevisionInterpretationFactory.RevisionInterpretationContext(this.getContext().getExternalCredentialsProvider());
            ERevisionInterpretationFactory.createFromDescriptor(this.timestampInterpretation, revisionInterpretationContext).interpretRevision(revision, this.defaultBranchName);
        }
        catch (RepositoryException e) {
            return false;
        }
        return true;
    }

    @Override
    public URI getRepositoryUri() throws ConnectorValidationException {
        return this.parseUri(ArtifactStoreRepositoryConnectorDescriptorBase.concatenateNonEmptyWithSlash(this.resolveExternalCredentials().uri, this.getRepositoryOrBucketName(), this.getPathSuffix()));
    }

    protected abstract String getRepositoryOrBucketName();

    protected abstract List<String> getExcludePatterns();

    @Override
    protected boolean branchingEnabledDefaultValue() {
        return true;
    }

    @Override
    protected PairList<String, String> reportMappingDefaultValue() {
        PairList reportMappings = new PairList();
        for (EReportFormat reportFormat : EReportFormat.values()) {
            reportMappings.add((Object)("**/" + reportFormat.name() + "/**"), (Object)reportFormat.toString());
        }
        return reportMappings;
    }

    @Override
    protected String partitionPatternDefaultValue() {
        return "([^/]+)\\/[^/]+\\/.*";
    }

    @Override
    protected boolean hasPreselectedUIBranchBeforeBranchTransformationUnlikeDefaultBranch(String preselectedUIBranchBeforeTransform) throws ConnectorValidationException {
        Set<String> branches;
        try {
            branches = this.fetchBranches();
        }
        catch (ProjectConfigurationException | RepositoryException e) {
            throw new ConnectorValidationException(e);
        }
        return branches.contains(preselectedUIBranchBeforeTransform);
    }

    private Set<String> fetchBranches() throws RepositoryException, ProjectConfigurationException {
        T repositoryInfo = this.getRepositoryInfo();
        ((ArtifactStoreRepositoryInfoBase)repositoryInfo).setRepositoryOrBucketName(this.getRepositoryOrBucketName());
        ((ArtifactStoreRepositoryInfoBase)repositoryInfo).setBranchExtractionPattern(this.branchExtractionPattern);
        SimpleArtifactStoreClientBase<T> client = this.getClient();
        return client.fetchBranches(repositoryInfo);
    }

    protected abstract T getRepositoryInfo();

    protected abstract SimpleArtifactStoreClientBase<T> getClient() throws ConnectorValidationException;
}

