/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.committree.CommitTreeIndex;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.core.option.server.ServerOptionIndex;
import com.teamscale.index.external.input.external_storage.EExternalStorageBackendProtocol;
import com.teamscale.index.external.input.external_storage.ExternalStorageBackend;
import com.teamscale.index.repository.artifact_store.ArtifactStoreRepositoryInfoBase;
import com.teamscale.index.repository.artifact_store.ExtractionFailedException;
import com.teamscale.index.repository.artifact_store.IArtifactStoreTimestampResolver;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import com.teamscale.index.repository.artifact_store.artifactory.ArtifactoryRepositoryInfo;
import com.teamscale.index.repository.artifact_store.s3.S3ArtifactStore;
import com.teamscale.index.repository.artifact_store.s3.S3RepositoryInfo;
import com.teamscale.index.s3.CredentialsProcess;
import com.teamscale.index.s3.S3ClientFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.RescheduleRequestedException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.mem.InMemoryStore;
import org.conqat.lib.commons.collections.Pair;

public class ArtifactStoreUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int EXCEPTION_COLLECTION_LIMIT = 10;

    private static void initializeRepositoryInfoForPreview(ArtifactStoreRepositoryInfoBase info, ConnectorConfiguration connectorConfiguration, CommitTreeIndex foreignCommitTreeIndex) {
        ArtifactStoreUtils.initializeRepositoryInfoFromConnectorOptions(info, connectorConfiguration);
        info.setIncludeAndExcludePatterns(connectorConfiguration);
        info.setIgnoreExtractionFailures(true);
        info.setForeignCommitTreeIndex(Objects.requireNonNullElseGet(foreignCommitTreeIndex, () -> new CommitTreeIndex((IStore)new InMemoryStore())));
        info.initializeInMemoryIndexes();
    }

    private static void initializeRepositoryInfoFromConnectorOptions(ArtifactStoreRepositoryInfoBase info, ConnectorConfiguration connectorConfiguration) {
        info.setRepositoryOrBucketName(connectorConfiguration);
        info.setBranchExtractionPattern(connectorConfiguration.getOptionValue("Branch Extraction Pattern"));
        info.setTimestampExtractionPattern(connectorConfiguration.getOptionValue("Timestamp Extraction Pattern"));
        info.setTimestampInterpretation(connectorConfiguration.getOptionValue("Timestamp Interpretation"));
        info.setPrefixExtractionPattern(connectorConfiguration.getOptionValue("Prefix Extraction Pattern"));
    }

    public static <T extends ArtifactStoreRepositoryInfoBase> Collection<String> fetchFilesFromArtifactStore(@Nullable ProjectConfiguration projectConfiguration, ConnectorConfiguration connectorConfiguration, T info, SimpleArtifactStoreClientBase<T> client) throws RepositoryException, ProjectConfigurationException {
        if (projectConfiguration != null) {
            info.setProjectConfiguration(projectConfiguration);
        }
        String defaultBranchName = connectorConfiguration.getOptionValue("Default branch name");
        SimpleArtifactStoreClientBase.ItemQueryResultData archiveFiles = ArtifactStoreUtils.findItems(client, info);
        List<SimpleArtifactStoreClientBase.ItemData> filteredItemData = info.getKeyIncludeExcludePatterns().filterArtifacts(archiveFiles.results);
        return ArtifactStoreUtils.getLatestArchivePathsOnBranch(filteredItemData, info, defaultBranchName);
    }

    private static <T extends ArtifactStoreRepositoryInfoBase> SimpleArtifactStoreClientBase.ItemQueryResultData findItems(SimpleArtifactStoreClientBase<T> client, T info) throws RepositoryException, ProjectConfigurationException {
        try {
            return client.findItems(info, 0);
        }
        catch (RescheduleRequestedException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private static List<String> getLatestArchivePathsOnBranch(List<SimpleArtifactStoreClientBase.ItemData> archiveFiles, ArtifactStoreRepositoryInfoBase info, String defaultBranchName) throws RepositoryException {
        IArtifactStoreTimestampResolver timestampResolver = info.createTimestampResolver();
        ArrayList<String> archivePaths = new ArrayList<String>();
        long latestTimestamp = 0L;
        ArrayList<String> extractionErrors = new ArrayList<String>(10);
        for (SimpleArtifactStoreClientBase.ItemData archiveFile : archiveFiles) {
            long currentTimestamp;
            Optional<Pair<String, CommitDescriptor>> revisionAndTimestamp;
            String pathBranch;
            String fullPath = archiveFile.getFullPath();
            try {
                pathBranch = info.determineBranchName(fullPath, defaultBranchName);
            }
            catch (ExtractionFailedException e) {
                if (extractionErrors.size() >= 10) continue;
                extractionErrors.add(e.getMessage());
                continue;
            }
            if (!pathBranch.equals(defaultBranchName) || (revisionAndTimestamp = timestampResolver.resolveRevisionAndTimestamp(archiveFile, pathBranch)).isEmpty() || (currentTimestamp = ((CommitDescriptor)revisionAndTimestamp.get().getSecond()).getTimestamp()) < latestTimestamp) continue;
            if (currentTimestamp > latestTimestamp) {
                archivePaths.clear();
                latestTimestamp = currentTimestamp;
            }
            archivePaths.add(fullPath);
        }
        if (!extractionErrors.isEmpty()) {
            Consumer<Message> warnOrErrorLogger;
            if (archivePaths.isEmpty()) {
                LOGGER.error("No files matched the given patterns. Maybe the connector is not configured correctly?");
                warnOrErrorLogger = arg_0 -> ((Logger)LOGGER).error(arg_0);
            } else {
                warnOrErrorLogger = arg_0 -> ((Logger)LOGGER).warn(arg_0);
            }
            warnOrErrorLogger.accept((Message)new ParameterizedMessage("Some extractions failed (only showing the first {} messages):\n{}", (Object)10, (Object)String.join((CharSequence)"\n", extractionErrors)));
        }
        return archivePaths;
    }

    public static S3RepositoryInfo createS3RepositoryInfo(ConnectorConfiguration connectorConfiguration, CommitTreeIndex foreignCommitTreeIndex) {
        S3RepositoryInfo info = new S3RepositoryInfo();
        info.setUseCredentialsProcess(connectorConfiguration);
        ArtifactStoreUtils.initializeRepositoryInfoForPreview(info, connectorConfiguration, foreignCommitTreeIndex);
        return info;
    }

    public static ArtifactoryRepositoryInfo createArtifactoryRepositoryInfo(ConnectorConfiguration connectorConfiguration, CommitTreeIndex foreignCommitTreeIndex) {
        ArtifactoryRepositoryInfo info = new ArtifactoryRepositoryInfo();
        ArtifactStoreUtils.initializeRepositoryInfoForPreview(info, connectorConfiguration, foreignCommitTreeIndex);
        return info;
    }

    public static SimpleArtifactStoreClientBase<?> getClientForProtocol(ExternalStorageBackend externalStorageBackend, ExternalCredentials credentials, IndexLayer indexLayer) throws StorageException, RepositoryException, ProjectConfigurationException {
        CredentialsProcess credentialsProcess;
        if (Objects.requireNonNull(externalStorageBackend.backendProtocol()) == EExternalStorageBackendProtocol.S3) {
            credentialsProcess = null;
            if (externalStorageBackend.useS3CredentialsProcess()) {
                credentialsProcess = CredentialsProcess.readFromServerOptions((ServerOptionIndex)indexLayer.openGlobalIndex(ServerOptionIndex.class));
            }
        } else {
            throw ArtifactStoreUtils.createProtocolNotSupportedException(externalStorageBackend.backendProtocol());
        }
        S3ArtifactStore client = S3ArtifactStore.createS3ArtifactStore(new S3ClientFactory(), credentials, credentialsProcess);
        return client;
    }

    public static RepositoryException createProtocolNotSupportedException(EExternalStorageBackendProtocol backendProtocol) {
        return new RepositoryException("Backend protocol " + backendProtocol.name() + " is not yet supported.");
    }
}

