/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.index.repository.artifact_store.ExtractionFailedException;
import com.teamscale.index.repository.artifact_store.IArtifactStoreTimestampResolver;
import com.teamscale.index.repository.artifact_store.PatternBasedItemPathExtractor;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import com.teamscale.index.repository.artifact_store.revision_interpretation.IRevisionInterpretation;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.Pair;

public class ItemPathInterpretingTimestampResolver
implements IArtifactStoreTimestampResolver {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PatternBasedItemPathExtractor revisionExtractor;
    private final IRevisionInterpretation timestampInterpretation;
    private final boolean ignoreExtractionFailures;

    public ItemPathInterpretingTimestampResolver(PatternBasedItemPathExtractor revisionExtractor, IRevisionInterpretation timestampInterpretation, boolean ignoreExtractionFailures) {
        this.revisionExtractor = revisionExtractor;
        this.timestampInterpretation = timestampInterpretation;
        this.ignoreExtractionFailures = ignoreExtractionFailures;
    }

    @Override
    public Optional<Pair<String, CommitDescriptor>> resolveRevisionAndTimestamp(SimpleArtifactStoreClientBase.ItemData item, @Nullable String branchName) throws RepositoryException {
        try {
            String revision = this.revisionExtractor.extractFrom(item.getFullPath());
            return this.resolveTimestamp(revision, branchName).map(timestamp -> Pair.createPair((Object)revision, (Object)timestamp));
        }
        catch (ExtractionFailedException | RepositoryException e) {
            if (!this.ignoreExtractionFailures) {
                throw new RepositoryException("There was an error during timestamp interpretation of path: " + item.getFullPath(), e);
            }
            LOGGER.warn("Ignoring timestamp extraction failure due to configuration setting.", e);
            return Optional.empty();
        }
    }

    @Override
    public Optional<CommitDescriptor> resolveTimestamp(String revision, @Nullable String branchName) throws RepositoryException {
        return this.timestampInterpretation.interpretRevision(revision, branchName);
    }

    @Override
    public boolean mayRequireReschedule() {
        return this.timestampInterpretation.mayRequireReschedule();
    }

    @Override
    public void close() {
        this.timestampInterpretation.close();
    }
}

