/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.artifact_store;

import com.teamscale.index.repository.artifact_store.IArtifactStoreTimestampResolver;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.Pair;

public class RevisionFromItemCreationTimestampResolver
implements IArtifactStoreTimestampResolver {
    private static final Logger LOGGER = LogManager.getLogger();

    @Override
    public Optional<Pair<String, CommitDescriptor>> resolveRevisionAndTimestamp(SimpleArtifactStoreClientBase.ItemData item, @Nullable String branchName) {
        if (branchName == null) {
            return Optional.empty();
        }
        long timestamp = item.getCreationTimestamp();
        return Optional.of(Pair.createPair((Object)Long.toString(timestamp), (Object)new CommitDescriptor(branchName, timestamp)));
    }

    @Override
    public Optional<CommitDescriptor> resolveTimestamp(String revision, String branchName) {
        try {
            return Optional.of(new CommitDescriptor(branchName, Long.parseLong(revision)));
        }
        catch (NumberFormatException e) {
            LOGGER.error("Unable to interpret simple timestamp from value {}. Please check if timestamp interpretation is correctly configured.", (Object)revision);
            return Optional.empty();
        }
    }

    @Override
    public void close() {
    }
}

