/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git;

import com.teamscale.core.shutdown.ShutdownManager;
import com.teamscale.index.repository.git.ApacheMinaSshSessionFactory;
import com.teamscale.index.repository.git.GitPrivateKeyOption;
import com.teamscale.index.repository.git.GitWriteLockManager;
import com.teamscale.index.repository.git.TeamscaleGitCredentialsProvider;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.sshd.common.util.OsUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.cancel.ICancelable;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.EGitProtocol;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.io.ProcessUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.FetchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.GitCommand;
import org.eclipse.jgit.api.TransportCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.diff.DiffEntry;
import org.eclipse.jgit.diff.DiffFormatter;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.EmptyProgressMonitor;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.file.WindowCacheConfig;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.SshTransport;
import org.eclipse.jgit.transport.Transport;
import org.eclipse.jgit.transport.TransportHttp;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.io.DisabledOutputStream;

public class GitUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int GIT_OPERATIONS_TIMEOUT_SECONDS = Integer.getInteger("com.teamscale.git-timeout-secs", 300);
    public static final String LARGE_FILE_THRESHOLD_FLAG = "com.teamscale.git-largefile-threshold-mb";
    private static final int LARGE_FILE_THRESHOLD = Integer.getInteger("com.teamscale.git-largefile-threshold-mb", -1) * 0x100000;
    private static final String REPOSITORY_NOT_FOUND_EXCEPTION_MESSAGE = "Can neither find a bare nor a cloned git repository along the path: ";
    public static final String SEPARATOR = "/";

    private static Repository getExistingLocalRepository(Path gitRepoDir) throws RepositoryException {
        try {
            return GitUtils.openRepository(gitRepoDir);
        }
        catch (IOException iOException) {
            Optional<Repository> bareRepo = GitUtils.searchForBareRepositoryAlongPath(gitRepoDir);
            if (bareRepo.isPresent()) {
                return bareRepo.get();
            }
            throw new RepositoryException(REPOSITORY_NOT_FOUND_EXCEPTION_MESSAGE + String.valueOf(gitRepoDir));
        }
    }

    public static Repository getExistingLocalRepository(URI uri) throws RepositoryException {
        return GitUtils.getExistingLocalRepository(Paths.get(uri));
    }

    private static Repository openRepository(Path gitRepoDir) throws IOException {
        return Git.open((File)gitRepoDir.toFile()).getRepository();
    }

    private static Optional<Repository> searchForBareRepositoryAlongPath(Path repoPath) {
        while (repoPath != null) {
            Repository repo = GitUtils.openBareRepository(repoPath);
            if (repo != null) {
                return Optional.of(repo);
            }
            repoPath = repoPath.getParent();
        }
        return Optional.empty();
    }

    private static Repository openBareRepository(Path repoPath) {
        if (!Files.exists(repoPath, new LinkOption[0])) {
            return null;
        }
        try {
            return GitUtils.openRepository(repoPath);
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Repository cloneAndSetUpRepository(Path localDirectory, URI location, TeamscaleGitCredentialsProvider credentials, ICancelable cancelable, @Nullable String defaultBranch) throws RepositoryException {
        try (GitWriteLockManager.GitDirectoryLock autoReleaseLock = GitWriteLockManager.lockGitDirectoryForWriting(localDirectory);){
            if (GitUtils.localGitCloneExists(localDirectory)) {
                Repository repository = GitUtils.getExistingLocalRepository(localDirectory.toAbsolutePath());
                return repository;
            }
            CloneCommand cloneCommand222 = ((CloneCommand)GitUtils.configureCommand(location, credentials, Git.cloneRepository(), cancelable).setBare(true).setURI(location.toString()).setTimeout(GIT_OPERATIONS_TIMEOUT_SECONDS)).setDirectory(localDirectory.toFile());
            if (defaultBranch != null) {
                cloneCommand222.setBranch(defaultBranch);
            }
            Repository repository = cloneCommand222.call().getRepository();
            return repository;
        }
        catch (GitAPIException e) {
            try {
                FileSystemUtils.deleteRecursively((Path)localDirectory);
            }
            catch (IOException ioException) {
                e.addSuppressed((Throwable)ioException);
            }
            String errorMessage = GitUtils.buildRepositorySetupErrorMessage(localDirectory, location, defaultBranch);
            throw new RepositoryException(errorMessage, (Throwable)e);
        }
    }

    private static String buildRepositorySetupErrorMessage(Path localDirectory, URI location, String defaultBranch) {
        return "Error during git repository setup. Tried to initialize '" + String.valueOf(location) + "' in local directory '" + String.valueOf(localDirectory) + "' with the default branch '" + defaultBranch + "'.";
    }

    public static ProcessUtils.ExecutionResult runNativeGitCommand(Repository repository, Duration timeout, String command, String ... args) throws IOException {
        CharSequence[] processCommand = new String[2 + args.length];
        processCommand[0] = OsUtils.isWin32() ? "git.exe" : "git";
        processCommand[1] = command;
        System.arraycopy(args, 0, processCommand, 2, args.length);
        LOGGER.info("Running native git command '{}'.", new Supplier[]{() -> GitUtils.lambda$runNativeGitCommand$0((String[])processCommand)});
        ProcessUtils.ExecutionResult result = ProcessUtils.execute((ProcessBuilder)new ProcessBuilder((String[])processCommand).directory(repository.getDirectory()), null, (Duration)timeout);
        if (result.terminatedByTimeoutOrInterruption() || result.getReturnCode() != 0) {
            LOGGER.error("Problem running native git command '{}' (process exit code: {} | terminated by timeout or interruption: {}). Standard output:\n{}\n\nError output:\n{}", (Object)String.join((CharSequence)" ", processCommand), (Object)result.getReturnCode(), (Object)result.terminatedByTimeoutOrInterruption(), (Object)result.getStdout(), (Object)result.getStderr());
        }
        return result;
    }

    public static <COMMAND_TYPE extends TransportCommand<C, T>, C extends GitCommand<T>, T> COMMAND_TYPE configureCommand(URI location, TeamscaleGitCredentialsProvider credentialsProvider, COMMAND_TYPE command, ICancelable cancelable) {
        command.setTransportConfigCallback(transport -> GitUtils.configureTransport(transport, location, credentialsProvider));
        command.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        GitUtils.configureShutdownSupport(command, cancelable);
        return command;
    }

    private static void configureTransport(Transport transport, URI location, TeamscaleGitCredentialsProvider credentialsProvider) {
        transport.setTimeout(GIT_OPERATIONS_TIMEOUT_SECONDS);
        if (transport instanceof SshTransport) {
            SshTransport sshTransport = (SshTransport)transport;
            if (GitUtils.hasSshPrivateKeyConfigured(credentialsProvider)) {
                sshTransport.setSshSessionFactory((SshSessionFactory)new ApacheMinaSshSessionFactory(location, credentialsProvider));
            }
        }
        if (transport instanceof TransportHttp) {
            String password;
            TransportHttp transportHttp = (TransportHttp)transport;
            if (StringUtils.isEmpty((String)credentialsProvider.getUsername(location)) && !StringUtils.isEmpty((String)credentialsProvider.getPassword(location))) {
                transportHttp.setAdditionalHeaders(Map.of("Authorization", "Bearer " + credentialsProvider.getPassword(location)));
            } else if (EFeatureToggle.ENABLE_PREEMPTIVE_GIT_BASIC_AUTH.isEnabled() && (password = credentialsProvider.getPassword(location)) != null) {
                transportHttp.setPreemptiveBasicAuthentication(credentialsProvider.getUsername(location), password);
            }
        }
    }

    private static void configureShutdownSupport(GitCommand<?> command, ICancelable cancelable) {
        try {
            Method setProgressMonitor = command.getClass().getMethod("setProgressMonitor", ProgressMonitor.class);
            setProgressMonitor.invoke(command, GitUtils.createShutdownAndCancelAwareProgressMonitor(cancelable));
        }
        catch (NoSuchMethodException setProgressMonitor) {
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOGGER.error("Unable to set progress monitor of command: {}", command.getClass(), (Object)e);
        }
    }

    public static ProgressMonitor createShutdownAndCancelAwareProgressMonitor(ICancelable cancelable) {
        return new ShutdownAndCancelAwareProgressMonitor(cancelable);
    }

    private static boolean hasSshPrivateKeyConfigured(TeamscaleGitCredentialsProvider credentials) {
        return credentials != null && !StringUtils.isEmpty((String)credentials.getSshPrivateKey());
    }

    public static URIish toURIish(URI uri) {
        try {
            return new URIish(uri.toString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Every URI should be URIish", e);
        }
    }

    private static boolean localGitCloneExists(Path localDir) {
        boolean bl;
        block8: {
            Git ignored = Git.open((File)localDir.toFile());
            try {
                bl = true;
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return false;
                }
            }
            ignored.close();
        }
        return bl;
    }

    public static TeamscaleGitCredentialsProvider createCredentialsProvider(String username, String password, GitPrivateKeyOption privateKeyOption) {
        return new TeamscaleGitCredentialsProvider(StringUtils.emptyIfNull((String)username), StringUtils.emptyIfNull((String)password), privateKeyOption);
    }

    public static TeamscaleGitCredentialsProvider createEmptyCredentialsProvider() {
        return new TeamscaleGitCredentialsProvider("", "", null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RevCommit getCommit(Repository repository, String revisionBranchOrTag) throws RepositoryException {
        try (RevWalk revWalk = new RevWalk(repository);){
            Ref head = repository.findRef(revisionBranchOrTag);
            if (head != null) {
                RevCommit revCommit = revWalk.parseCommit((AnyObjectId)head.getLeaf().getObjectId());
                return revCommit;
            }
            RevCommit revCommit = revWalk.parseCommit((AnyObjectId)ObjectId.fromString((String)revisionBranchOrTag));
            return revCommit;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<ObjectId> getId(Repository repository, RevCommit commit, String path) throws RepositoryException {
        try (TreeWalk walk = TreeWalk.forPath((Repository)repository, (String)path, (RevTree)commit.getTree());){
            if (walk == null) {
                Optional<ObjectId> optional2 = Optional.empty();
                return optional2;
            }
            Optional<ObjectId> optional = Optional.of(walk.getObjectId(0));
            return optional;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public static DiffFormatter createDiffFormatter(Repository repository) {
        DiffFormatter diffFormatter = new DiffFormatter((OutputStream)DisabledOutputStream.INSTANCE);
        diffFormatter.setRepository(repository);
        diffFormatter.setDiffComparator(RawTextComparator.DEFAULT);
        diffFormatter.setDetectRenames(true);
        return diffFormatter;
    }

    public static TreeWalk createTreeWalk(Repository repository) {
        TreeWalk treeWalk = new TreeWalk(repository);
        treeWalk.setFilter(TreeFilter.ANY_DIFF);
        treeWalk.setRecursive(true);
        return treeWalk;
    }

    public static @Nullable EGitProtocol getProtocolFromUrl(String url) {
        return EGitProtocol.fromUri((String)url).orElse(null);
    }

    public static Optional<EGitProtocol> getProtocolFromUri(URI uri) {
        return EGitProtocol.fromUri((URI)uri);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<Long> getTimestampFromRevision(Repository repository, String revision) {
        try (RevWalk revWalk = new RevWalk(repository);){
            ObjectId commitId = repository.resolve(revision);
            if (commitId != null) {
                RevCommit commit = revWalk.parseCommit((AnyObjectId)commitId);
                Optional<Long> optional = Optional.of(GitUtils.getCommitTimestamp(commit));
                return optional;
            }
            Optional<Long> optional = Optional.empty();
            return optional;
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static Optional<String> getTaggedRevision(Repository repository, String tagName) {
        try {
            Ref ref = repository.getRefDatabase().peel(repository.findRef(tagName));
            ObjectId objectId = ref.getPeeledObjectId() != null ? ref.getPeeledObjectId() : ref.getObjectId();
            return Optional.ofNullable(objectId).map(ObjectId::toString);
        }
        catch (IOException e) {
            return Optional.empty();
        }
    }

    public static long getCommitTimestamp(RevCommit commit) {
        return commit.getCommitterIdent().getWhen().getTime();
    }

    public static @NonNull String rewriteGitAtUrl(@NonNull String url) {
        return GitUtils.rewriteGitAtUrl(url, false);
    }

    public static @NonNull String rewriteGitAtUrl(@NonNull String url, boolean convertSshToHttps) {
        if (!StringUtils.startsWithOneOf((String)url, (String[])new String[]{"ssh://", "git@"})) {
            return url;
        }
        if (((String)(url = ((String)url).replaceFirst(":(?!\\d|//)", SEPARATOR))).startsWith("git@")) {
            url = "ssh://" + (String)url;
        }
        if (convertSshToHttps) {
            url = ((String)url).replaceFirst("ssh://git@", "https://");
        }
        return url;
    }

    public static Optional<DiffEntry.ChangeType> determineChangeType(DiffEntry diff) {
        boolean wasActualFile = GitUtils.isActualFile(diff.getOldMode());
        boolean isActualFile = GitUtils.isActualFile(diff.getNewMode());
        if (wasActualFile && isActualFile) {
            return Optional.of(diff.getChangeType());
        }
        if (!wasActualFile && isActualFile) {
            return Optional.of(DiffEntry.ChangeType.ADD);
        }
        if (wasActualFile) {
            return Optional.of(DiffEntry.ChangeType.DELETE);
        }
        return Optional.empty();
    }

    private static boolean isActualFile(FileMode mode) {
        return GitUtils.isActualFile(mode.getBits());
    }

    public static boolean isActualFile(int modeBits) {
        return FileMode.REGULAR_FILE.equals(modeBits) || FileMode.EXECUTABLE_FILE.equals(modeBits);
    }

    public static FetchCommand createFetchCommand(Git git, URI location, TeamscaleGitCredentialsProvider credentialsProvider, ICancelable cancelable) {
        FetchCommand fetchCommand = ((FetchCommand)((FetchCommand)git.fetch().setTimeout(GIT_OPERATIONS_TIMEOUT_SECONDS)).setCredentialsProvider((CredentialsProvider)credentialsProvider)).setRemoveDeletedRefs(true);
        GitUtils.configureCommand(location, credentialsProvider, fetchCommand, cancelable);
        return fetchCommand;
    }

    public static Optional<String> getBranchNameFromRef(Ref ref) {
        if (!GitUtils.isBranchHeadRef(ref)) {
            return Optional.empty();
        }
        return Optional.of(StringUtils.stripPrefix((String)ref.getName(), (String)"refs/heads/"));
    }

    public static boolean isHeadRef(Ref ref) {
        return "HEAD".equals(ref.getName());
    }

    public static boolean isBranchHeadRef(Ref ref) {
        return ref.getName().startsWith("refs/heads/");
    }

    public static long extractLocalCommitTime(RevCommit commit) {
        return commit.getCommitterIdent().getWhen().getTime();
    }

    public static Instant getCommitTime(RevCommit revCommit) {
        return Instant.ofEpochSecond(GitUtils.getCommitTimestamp(revCommit));
    }

    private static /* synthetic */ Object lambda$runNativeGitCommand$0(String[] processCommand) {
        return String.join((CharSequence)" ", processCommand);
    }

    static {
        if (LARGE_FILE_THRESHOLD >= 0) {
            WindowCacheConfig windowCacheConfig = new WindowCacheConfig();
            windowCacheConfig.setStreamFileThreshold(LARGE_FILE_THRESHOLD);
            windowCacheConfig.install();
        }
    }

    private static class ShutdownAndCancelAwareProgressMonitor
    extends EmptyProgressMonitor {
        private final ICancelable cancelable;

        private ShutdownAndCancelAwareProgressMonitor(ICancelable cancelable) {
            this.cancelable = cancelable;
        }

        public boolean isCancelled() {
            return this.cancelable.isCanceled() || Thread.currentThread().isInterrupted() || ShutdownManager.getInstance().isShutdownStarted();
        }
    }
}

