/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import com.teamscale.index.merge_request.testcoverage.LineCoverageChange;
import com.teamscale.index.repository.git.common.TestingIntegrationRequirementsChecker;
import java.util.List;

public record LineCoverageVotingInfo(TestingIntegrationRequirementsChecker.ETestingIntegrationRequirementsCheckerResult votingRequirementsCheckerResult, boolean hasCoverableLines, double coverage, boolean isCoverageAboveThreshold, double threshold, List<LineCoverageChange> lineCoverageChangesPerFile) {
    public String toReadableDescription() {
        if (!this.votingRequirementsCheckerResult().isRequirementsFulfilled()) {
            return this.votingRequirementsCheckerResult().getFailureReason();
        }
        if (!this.hasCoverableLines) {
            return "This pull request contains no changes that can be covered by tests.";
        }
        if (this.isCoverageAboveThreshold) {
            return "This pull request has a line coverage of %.2f%% and reaches the configured threshold of %.0f%%.".formatted(this.coverage, this.threshold);
        }
        return "This pull request does not reach the configured line coverage threshold of %.0f%%. Only %.2f%% of the added or changed code lines are covered by tests.".formatted(this.threshold, this.coverage);
    }
}

