/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.common;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SystemPropertyUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static long getSystemPropertyAsLong(String propertyKey, long defaultValue) {
        String propertyValue = System.getProperty(propertyKey);
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(propertyValue);
        }
        catch (NumberFormatException e) {
            LOGGER.error("System property '{}' was set to '{}' which could not be parsed as long. Falling back to default value '{}'", (Object)propertyKey, (Object)propertyValue, (Object)defaultValue);
            return defaultValue;
        }
    }

    private SystemPropertyUtils() {
    }
}

