/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.debug_dump.dump;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.teamscale.core.analysis.RepositoryNeedsRollbackException;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.debug.DebugDumperRegistry;
import com.teamscale.core.debug.EDebugDumpEvent;
import com.teamscale.index.repository.git.CommitGraphNode;
import com.teamscale.index.repository.git.GitMainRepository;
import com.teamscale.index.repository.git.debug_dump.dump.CommitGraphNodeDump;
import com.teamscale.index.repository.git.debug_dump.dump.EGitRepositoryDumpState;
import com.teamscale.index.repository.git.debug_dump.dump.GitConnectorConfigurationDump;
import com.teamscale.index.repository.git.debug_dump.dump.GitRepositoryDebugDumpAnonymizer;
import com.teamscale.index.repository.git.debug_dump.dump.GitRepositoryDump;
import com.teamscale.index.repository.git.debug_dump.dump.IGitRepositoryDebugDumper;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.engine.index.shared.ProjectInfo;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.function.RunnableWithException;
import org.conqat.lib.commons.io.SerializationUtils;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ListBranchCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.revwalk.RevCommit;

public final class GitRepositoryDebugDumper
implements IGitRepositoryDebugDumper {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String REPOSITORY_STATE = "repository-state";
    public static final String BRANCH_NAMES_BY_COMMIT_NAME = "branch-names-by-commit-name";
    public static final String INITIAL_DEFAULT_BRANCH_ROOT_REVISION = "initial-default-branch-root-revision";
    private static final String COMMIT_TREES_HUMAN_READABLE = "commit-trees-human-readable";
    public static final String COMMIT_TREES_SERIALIZED = "commit-trees-serialized";
    public static final String COMMIT_GRAPHS = "commit-graphs";
    public static final String CONNECTOR_CONFIGURATION_JSON = "connector-configuration.json";
    private static final String BRANCH_LABELER_ARGS_TXT = "branch-labeler-args.txt";
    private static final String ROLLBACK_ID_PREFIX = "rollback-id_";
    private static final String ANONYMIZED_DUMP_DIRECTORY = "anonymized";
    private static final String ANONYMIZATION_MAPPING_FILE_NAME = "anonymization-mapping.json";
    private final GitConnectorConfigurationDump configurationDump;
    private final boolean anonymizeBranchNames;
    private final Map<EGitRepositoryDumpState, GitRepositoryDump> repositoryDumpsByState = new HashMap<EGitRepositoryDumpState, GitRepositoryDump>();
    private final Map<EGitRepositoryDumpState, Map<String, String>> branchNamesByCommitNameByState = new HashMap<EGitRepositoryDumpState, Map<String, String>>();
    private final Map<EGitRepositoryDumpState, ICommitTree> commitTreesByState = new HashMap<EGitRepositoryDumpState, ICommitTree>();
    private final Map<EGitRepositoryDumpState, Map<String, CommitGraphNodeDump>> commitGraphsByState = new HashMap<EGitRepositoryDumpState, Map<String, CommitGraphNodeDump>>();
    private final Map<EGitRepositoryDumpState, String> initialDefaultBranchRootRevisionByState = new HashMap<EGitRepositoryDumpState, String>();
    private final ProjectInfo projectInfo;
    private RepositoryNeedsRollbackException rollbackException;

    public GitRepositoryDebugDumper(ProjectInfo projectInfo, String defaultBranchName, IncludeExcludeRegexSupport branchPatternSupport, PatternList importantBranchPatterns, String startRevisionOrDate, String endRevisionOrDate, boolean branchingEnabled, boolean anonymizeBranchNames, boolean keepResurrectedBranchHistory) {
        this.projectInfo = projectInfo;
        this.anonymizeBranchNames = anonymizeBranchNames;
        this.configurationDump = new GitConnectorConfigurationDump(defaultBranchName, branchPatternSupport, importantBranchPatterns, startRevisionOrDate, endRevisionOrDate, branchingEnabled, keepResurrectedBranchHistory);
    }

    private static void runSafe(RunnableWithException<?> action, String operation) {
        try {
            action.run();
        }
        catch (Exception e) {
            LOGGER.warn("Error during {}", (Object)operation, (Object)e);
        }
    }

    @Override
    public void recordRepositoryState(EGitRepositoryDumpState state, GitMainRepository repository) {
        GitRepositoryDebugDumper.runSafe(() -> this.repositoryDumpsByState.put(state, GitRepositoryDebugDumper.getRepositoryDump(repository)), "recordRepositoryState");
    }

    @Override
    public void recordBranchNamesByCommitName(EGitRepositoryDumpState state, Map<String, String> branchNamesByCommitName) {
        GitRepositoryDebugDumper.runSafe(() -> this.branchNamesByCommitNameByState.put(state, Map.copyOf(branchNamesByCommitName)), "recordBranchNamesByCommitName");
    }

    @Override
    public void recordCommitTree(EGitRepositoryDumpState state, ICommitTree commitTree) {
        GitRepositoryDebugDumper.runSafe(() -> this.commitTreesByState.put(state, commitTree.deepCopy()), "recordCommitTree");
    }

    @Override
    public void recordInitialDefaultBranchRootRevision(EGitRepositoryDumpState state, String initialDefaultBranchRootRevision) {
        GitRepositoryDebugDumper.runSafe(() -> this.initialDefaultBranchRootRevisionByState.put(state, initialDefaultBranchRootRevision), "recordInitialDefaultBranchRootRevision");
    }

    @Override
    public void recordCommitGraph(EGitRepositoryDumpState state, Map<String, CommitGraphNode> nodesByName) {
        GitRepositoryDebugDumper.runSafe(() -> this.commitGraphsByState.put(state, GitRepositoryDebugDumper.getCommitGraphNodeDump(nodesByName)), "recordCommitGraph");
    }

    @Override
    public void recordRollbackException(RepositoryNeedsRollbackException rollbackException) {
        GitRepositoryDebugDumper.runSafe(() -> {
            this.rollbackException = rollbackException;
        }, "recordRollbackException");
    }

    private static Map<String, CommitGraphNodeDump> getCommitGraphNodeDump(Map<String, CommitGraphNode> nodesByName) {
        return Map.copyOf(Maps.transformValues(nodesByName, CommitGraphNodeDump::new));
    }

    @Override
    public void performDump() {
        GitRepositoryDebugDumper.runSafe(() -> {
            if (this.rollbackException != null) {
                DebugDumperRegistry.writeDump((EDebugDumpEvent)EDebugDumpEvent.GIT_TRIGGERED_ROLLBACK, (ProjectInfo)this.projectInfo, this::writeDump);
            } else {
                DebugDumperRegistry.writeDump((EDebugDumpEvent)EDebugDumpEvent.USER_REQUESTED_GIT_DUMP, (ProjectInfo)this.projectInfo, this::writeDump);
            }
        }, "performDump");
    }

    private static GitRepositoryDump getRepositoryDump(GitMainRepository repository) throws RepositoryException {
        GitRepositoryDump gitRepositoryDump;
        block8: {
            Git git = repository.createGit();
            try {
                ImmutableList commits = ImmutableList.copyOf((Iterable)git.log().all().call());
                List refs = git.branchList().setListMode(ListBranchCommand.ListMode.ALL).call();
                gitRepositoryDump = new GitRepositoryDump(refs, (List<RevCommit>)commits, true);
                if (git == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (git != null) {
                        try {
                            git.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | GitAPIException e) {
                    throw new RepositoryException(e);
                }
            }
            git.close();
        }
        return gitRepositoryDump;
    }

    private void writeDump(File parentDirectory) throws JsonSerializationException, IOException {
        Path dumpDirectory;
        if (this.rollbackException != null) {
            dumpDirectory = Files.createDirectories(parentDirectory.toPath().resolve(String.valueOf(this.rollbackException.getRollbackId()) + "_" + System.currentTimeMillis() + "_" + String.valueOf(EDebugDumpEvent.GIT_TRIGGERED_ROLLBACK)), new FileAttribute[0]);
            Path rollbackIdPath = dumpDirectory.resolve(ROLLBACK_ID_PREFIX + String.valueOf(this.rollbackException.getRollbackId()) + ".txt");
            FileSystemUtils.writeFileUTF8((Path)rollbackIdPath, (String)String.valueOf(this.rollbackException.getRollbackId()));
        } else {
            dumpDirectory = Files.createDirectories(parentDirectory.toPath().resolve(String.valueOf(UUID.randomUUID()) + "_" + System.currentTimeMillis() + "_" + String.valueOf(EDebugDumpEvent.USER_REQUESTED_GIT_DUMP)), new FileAttribute[0]);
        }
        this.writeRegularDump(dumpDirectory);
        if (this.anonymizeBranchNames) {
            GitRepositoryDebugDumpAnonymizer anonymizer = GitRepositoryDebugDumpAnonymizer.createAnonymizer(this.repositoryDumpsByState, this.branchNamesByCommitNameByState, this.initialDefaultBranchRootRevisionByState, this.commitTreesByState, this.commitGraphsByState, this.configurationDump);
            this.writeAnonymizedDump(anonymizer, dumpDirectory);
        }
        Path connectorConfigurationPath = dumpDirectory.resolve(CONNECTOR_CONFIGURATION_JSON);
        FileSystemUtils.writeFileUTF8((Path)connectorConfigurationPath, (String)JsonUtils.serializeToJSONPrettyPrinted((Object)this.configurationDump));
        Path branchLabelerArgumentsPath = dumpDirectory.resolve(BRANCH_LABELER_ARGS_TXT);
        FileSystemUtils.writeFileUTF8((Path)branchLabelerArgumentsPath, (String)this.configurationDump.toGitBranchLabelerCommandLineParameters());
    }

    private void writeRegularDump(Path dumpDirectory) throws JsonSerializationException, IOException {
        GitRepositoryDebugDumper.dumpMap(this.repositoryDumpsByState, REPOSITORY_STATE, dumpDirectory);
        GitRepositoryDebugDumper.dumpMap(this.branchNamesByCommitNameByState, BRANCH_NAMES_BY_COMMIT_NAME, dumpDirectory);
        GitRepositoryDebugDumper.dumpMap(this.initialDefaultBranchRootRevisionByState, INITIAL_DEFAULT_BRANCH_ROOT_REVISION, dumpDirectory);
        GitRepositoryDebugDumper.dumpMap(GitRepositoryDebugDumper.getCommitTreeDumpsByState(this.commitTreesByState), COMMIT_TREES_HUMAN_READABLE, dumpDirectory);
        GitRepositoryDebugDumper.dumpMap(GitRepositoryDebugDumper.getSerializedCommitTreeDumpsByState(this.commitTreesByState), COMMIT_TREES_SERIALIZED, dumpDirectory);
        GitRepositoryDebugDumper.dumpMap(this.commitGraphsByState, COMMIT_GRAPHS, dumpDirectory);
    }

    private void writeAnonymizedDump(GitRepositoryDebugDumpAnonymizer anonymizer, Path dumpDirectory) throws JsonSerializationException, IOException {
        FileSystemUtils.writeFileUTF8((Path)dumpDirectory.resolve(ANONYMIZATION_MAPPING_FILE_NAME), (String)JsonUtils.serializeToJSONPrettyPrinted(anonymizer.getAnonymizedBranchNamesByOriginalBranchName()));
        dumpDirectory = dumpDirectory.resolve(ANONYMIZED_DUMP_DIRECTORY);
        GitRepositoryDebugDumper.dumpMap(anonymizer.getAnonymizedRepositoryDumpsByState(), REPOSITORY_STATE, dumpDirectory);
        GitRepositoryDebugDumper.dumpMap(anonymizer.getAnonymizedBranchNamesByCommitNameByState(), BRANCH_NAMES_BY_COMMIT_NAME, dumpDirectory);
        GitRepositoryDebugDumper.dumpMap(anonymizer.getInitialDefaultBranchRootRevision(), INITIAL_DEFAULT_BRANCH_ROOT_REVISION, dumpDirectory);
        Map<EGitRepositoryDumpState, ICommitTree> anonymizedCommitTreesByState = anonymizer.getAnonymizedCommitTreesByState();
        GitRepositoryDebugDumper.dumpMap(GitRepositoryDebugDumper.getCommitTreeDumpsByState(anonymizedCommitTreesByState), COMMIT_TREES_HUMAN_READABLE, dumpDirectory);
        GitRepositoryDebugDumper.dumpMap(GitRepositoryDebugDumper.getSerializedCommitTreeDumpsByState(anonymizedCommitTreesByState), COMMIT_TREES_SERIALIZED, dumpDirectory);
        GitRepositoryDebugDumper.dumpMap(anonymizer.getAnonymizedCommitGraphsByState(), COMMIT_GRAPHS, dumpDirectory);
        Path connectorConfigurationPath = dumpDirectory.resolve(CONNECTOR_CONFIGURATION_JSON);
        FileSystemUtils.writeFileUTF8((Path)connectorConfigurationPath, (String)JsonUtils.serializeToJSONPrettyPrinted((Object)anonymizer.getAnonymizedConfigurationDump()));
    }

    private static Map<EGitRepositoryDumpState, String> getCommitTreeDumpsByState(Map<EGitRepositoryDumpState, ICommitTree> commitTreesByState) {
        HashMap<EGitRepositoryDumpState, String> commitTreeDumpsByState = new HashMap<EGitRepositoryDumpState, String>();
        commitTreesByState.forEach((state, commitTree) -> commitTreeDumpsByState.put((EGitRepositoryDumpState)((Object)state), commitTree.getCommitTreeDump()));
        return commitTreeDumpsByState;
    }

    private static Map<EGitRepositoryDumpState, String> getSerializedCommitTreeDumpsByState(Map<EGitRepositoryDumpState, ICommitTree> commitTreesByState) {
        HashMap<EGitRepositoryDumpState, String> serializedCommitTreeDumpsByState = new HashMap<EGitRepositoryDumpState, String>();
        commitTreesByState.forEach((state, commitTree) -> {
            try {
                serializedCommitTreeDumpsByState.put((EGitRepositoryDumpState)((Object)state), Base64.getEncoder().encodeToString(SerializationUtils.serializeToByteArray((Serializable)commitTree)));
            }
            catch (IOException e) {
                LOGGER.warn("Unable to dump commit tree data", (Throwable)e);
            }
        });
        return serializedCommitTreeDumpsByState;
    }

    private static <V> void dumpMap(Map<EGitRepositoryDumpState, V> map, String fileNamePrefix, Path dumpDirectory) throws IOException, JsonSerializationException {
        for (Map.Entry<EGitRepositoryDumpState, V> entry : map.entrySet()) {
            Path repositoryStatePath = dumpDirectory.resolve(GitRepositoryDebugDumper.constructFilename(fileNamePrefix, entry.getKey()));
            FileSystemUtils.writeFileUTF8((Path)repositoryStatePath, (String)JsonUtils.serializeToJSONPrettyPrinted(entry.getValue()));
        }
    }

    public static @NonNull String constructFilename(String fileNamePrefix, EGitRepositoryDumpState dumpState) {
        return fileNamePrefix + "_" + dumpState.getReadableName() + ".json";
    }
}

