/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.debug_dump.replay;

import com.fasterxml.jackson.databind.JavaType;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.index.repository.git.CommitGraphNode;
import com.teamscale.index.repository.git.debug_dump.dump.CommitGraphNodeDump;
import com.teamscale.index.repository.git.debug_dump.dump.EGitRepositoryDumpState;
import com.teamscale.index.repository.git.debug_dump.dump.GitConnectorConfigurationDump;
import com.teamscale.index.repository.git.debug_dump.dump.GitRepositoryDebugDumper;
import com.teamscale.index.repository.git.debug_dump.dump.GitRepositoryDump;
import com.teamscale.index.repository.git.debug_dump.replay.CommitGraphNodeMock;
import com.teamscale.index.repository.git.labeling.TestCommitGraphNode;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.conqat.engine.commons.util.JsonSerializationException;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.io.SerializationUtils;

public class GitRepositoryDebugDumpReader {
    public static final String COMMIT_GRAPHS_FILE_NAME = GitRepositoryDebugDumper.constructFilename("commit-graphs", EGitRepositoryDumpState.PRE_LABEL);
    public static final String REPOSITORY_STATE_FILE_NAME = GitRepositoryDebugDumper.constructFilename("repository-state", EGitRepositoryDumpState.POST_SYNCHRONIZE);
    public static final String BRANCH_NAMES_PRE_LABEL_FILE_NAME = GitRepositoryDebugDumper.constructFilename("branch-names-by-commit-name", EGitRepositoryDumpState.PRE_LABEL);
    public static final String BRANCH_NAMES_POST_LABEL_FILE_NAME = GitRepositoryDebugDumper.constructFilename("branch-names-by-commit-name", EGitRepositoryDumpState.POST_LABEL);
    public static final String INITIAL_DEFAULT_BRANCH_ROOT_REVISION_FILE_NAME = GitRepositoryDebugDumper.constructFilename("initial-default-branch-root-revision", EGitRepositoryDumpState.PRE_LABEL);

    public static GitRepositoryDump readGitRepositoryDump(Path debugDumpPath) {
        Path inputFilePath = debugDumpPath.resolve(REPOSITORY_STATE_FILE_NAME);
        return GitRepositoryDebugDumpReader.readFile(inputFilePath, GitRepositoryDump.class);
    }

    public static GitConnectorConfigurationDump readConfigFile(Path debugDumpPath) {
        Path inputFilePath = debugDumpPath.resolve("connector-configuration.json");
        return GitRepositoryDebugDumpReader.readFile(inputFilePath, GitConnectorConfigurationDump.class);
    }

    public static Map<String, String> readBranchesByCommitName(Path debugDumpPath) {
        Path inputFilePath = debugDumpPath.resolve(BRANCH_NAMES_PRE_LABEL_FILE_NAME);
        return (Map)GitRepositoryDebugDumpReader.readFile(inputFilePath, (JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructMapType(HashMap.class, String.class, String.class));
    }

    public static String readInitialDefaultBranchRootRevision(Path debugDumpPath) {
        Path inputFilePath = debugDumpPath.resolve(INITIAL_DEFAULT_BRANCH_ROOT_REVISION_FILE_NAME);
        return (String)GitRepositoryDebugDumpReader.readFile(inputFilePath, JsonUtils.getObjectMapper().getTypeFactory().constructType(String.class));
    }

    public static ICommitTree readCommitTree(Path debugDumpPath, EGitRepositoryDumpState state) {
        Path inputFilePath = debugDumpPath.resolve(GitRepositoryDebugDumper.constructFilename("commit-trees-serialized", state));
        try {
            String serializedCommitTree = GitRepositoryDebugDumpReader.readFile(inputFilePath, String.class);
            return (ICommitTree)SerializationUtils.deserializeFromByteArray((byte[])Base64.getDecoder().decode(serializedCommitTree));
        }
        catch (IOException | ClassNotFoundException e) {
            CCSMAssert.fail((String)("Could not read required dump file " + String.valueOf(inputFilePath)), (Throwable)e);
            throw new IllegalStateException();
        }
    }

    public static Map<String, CommitGraphNode> readCommitGraph(Path debugDumpPath) {
        Map<String, CommitGraphNodeDump> commitGraphNodeDump = GitRepositoryDebugDumpReader.readCommitGraphNodeDump(debugDumpPath);
        HashMap<String, CommitGraphNode> nodesByName = new HashMap<String, CommitGraphNode>();
        GitRepositoryDebugDumpReader.createAllCommitGraphNodes(commitGraphNodeDump, nodesByName, GitRepositoryDebugDumpReader.readReferenceLabels(debugDumpPath));
        GitRepositoryDebugDumpReader.linkCommitGraphParents(commitGraphNodeDump, nodesByName);
        GitRepositoryDebugDumpReader.overwriteCommitGraphSuccessors(commitGraphNodeDump, nodesByName);
        return nodesByName;
    }

    public static Map<String, CommitGraphNodeDump> readCommitGraphNodeDump(Path debugDumpPath) {
        Path inputFilePath = debugDumpPath.resolve(COMMIT_GRAPHS_FILE_NAME);
        return (Map)GitRepositoryDebugDumpReader.readFile(inputFilePath, (JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructMapType(HashMap.class, String.class, CommitGraphNodeDump.class));
    }

    public static Map<String, String> readReferenceLabels(Path debugDumpPath) {
        Path referenceInputFilePath = debugDumpPath.resolve(BRANCH_NAMES_POST_LABEL_FILE_NAME);
        return (Map)GitRepositoryDebugDumpReader.readFile(referenceInputFilePath, (JavaType)JsonUtils.getObjectMapper().getTypeFactory().constructMapType(HashMap.class, String.class, String.class));
    }

    private static void createAllCommitGraphNodes(Map<String, CommitGraphNodeDump> commitGraphNodeDump, Map<String, CommitGraphNode> nodesByName, Map<String, String> referenceBranchLabels) {
        for (Map.Entry<String, CommitGraphNodeDump> dumpEntry : commitGraphNodeDump.entrySet()) {
            String commitName = dumpEntry.getKey();
            CommitGraphNodeDump nodeDump = dumpEntry.getValue();
            CommitGraphNodeMock node = new CommitGraphNodeMock(commitName, nodeDump.message, nodeDump.commitTimestamp, nodeDump.authorTime);
            node.setBranchName(nodeDump.branchName);
            node.setReferenceBranchName(referenceBranchLabels.get(nodeDump.name));
            nodesByName.put(commitName, node);
        }
    }

    private static void linkCommitGraphParents(Map<String, CommitGraphNodeDump> commitGraphNodeDump, Map<String, CommitGraphNode> nodesByName) {
        for (Map.Entry<String, CommitGraphNodeDump> dumpEntry : commitGraphNodeDump.entrySet()) {
            String commitName = dumpEntry.getKey();
            CommitGraphNodeDump nodeDump = dumpEntry.getValue();
            TestCommitGraphNode node = (TestCommitGraphNode)nodesByName.get(commitName);
            for (CommitGraphNodeDump parent : nodeDump.parents) {
                node.addParent((TestCommitGraphNode)nodesByName.get(parent.name));
            }
        }
    }

    private static void overwriteCommitGraphSuccessors(Map<String, CommitGraphNodeDump> commitGraphNodeDump, Map<String, CommitGraphNode> nodesByName) {
        for (Map.Entry<String, CommitGraphNodeDump> dumpEntry : commitGraphNodeDump.entrySet()) {
            String commitName = dumpEntry.getKey();
            CommitGraphNodeDump nodeDump = dumpEntry.getValue();
            TestCommitGraphNode node = (TestCommitGraphNode)nodesByName.get(commitName);
            node.setSuccessors(CollectionUtils.map(nodeDump.successors, n -> (CommitGraphNode)nodesByName.get(n.name)));
        }
    }

    private static <T> T readFile(Path inputFilePath, Class<T> expectedClass) {
        return GitRepositoryDebugDumpReader.readFile(inputFilePath, JsonUtils.getObjectMapper().getTypeFactory().constructType(expectedClass));
    }

    public static <T> T readFile(Path inputFilePath, JavaType expectedType) {
        try {
            BufferedReader reader = Files.newBufferedReader(inputFilePath);
            return (T)JsonUtils.deserializeFromJson((Reader)reader, (JavaType)expectedType);
        }
        catch (IOException | JsonSerializationException e) {
            CCSMAssert.fail((String)("Could not read required dump file " + String.valueOf(inputFilePath)), (Throwable)e);
            throw new IllegalStateException();
        }
    }
}

