/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit;

import com.teamscale.index.merge_request.voting.VotingException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.CommitDescriptor;

class GerritVotingSkippedException
extends VotingException.Skipped {
    private static final long serialVersionUID = 1L;

    private GerritVotingSkippedException(String comment, VotingException.Skipped.Reason reason, @NonNull CommitDescriptor commit) {
        super(comment, reason, commit);
    }

    public static GerritVotingSkippedException notAGerritBranch(CommitDescriptor commit) {
        return new GerritVotingSkippedException("Not a Gerrit branch.", VotingException.Skipped.Reason.GERRIT_SPECIFIC_NOT_A_GERRIT_BRANCH, commit);
    }

    public static GerritVotingSkippedException mergedOrAbandoned(CommitDescriptor commit) {
        return new GerritVotingSkippedException("Commit is already merged or abandoned.", VotingException.Skipped.Reason.GERRIT_SPECIFIC_MERGED_OR_ABANDONED, commit);
    }

    public static GerritVotingSkippedException emptyCommitAndNoComments(CommitDescriptor commit) {
        return new GerritVotingSkippedException("Commit is empty and we don't have any comments to add. Commenting will be skipped.", VotingException.Skipped.Reason.GERRIT_SPECIFIC_EMPTY_COMMIT_AND_NO_COMMENTS, commit);
    }

    public static GerritVotingSkippedException changeDoesNotAffectIncludedFiles(CommitDescriptor commit) {
        return new GerritVotingSkippedException("Gerrit change does not affect included files", VotingException.Skipped.Reason.GERRIT_SPECIFIC_CHANGE_DOES_NOT_AFFECT_INCLUDED_FILES, commit);
    }
}

