/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.gerrit.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.teamscale.index.merge_request.comments.comments.IReviewComment;
import com.teamscale.index.repository.git.gerrit.data.CommentRange;
import org.conqat.lib.commons.assessment.ETrafficLightColor;

public class RobotCommentInput {
    private static final String PATH_PROPERTY = "path";
    private static final String MESSAGE_PROPERTY = "message";
    private static final String RANGE_PROPERTY = "range";
    private static final String ROBOT_ID_PROPERTY = "robot_id";
    private static final String ROBOT_RUN_ID_PROPERTY = "robot_run_id";
    private static final String URL_PROPERTY = "url";
    @JsonProperty(value="path")
    private final String path;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="range")
    private final CommentRange range;
    @JsonProperty(value="robot_id")
    private final String robotId = "Teamscale";
    @JsonProperty(value="robot_run_id")
    private final String robotRunId;
    @JsonProperty(value="url")
    private final String url;

    @JsonCreator
    public RobotCommentInput(@JsonProperty(value="path") String path, @JsonProperty(value="message") String message, @JsonProperty(value="robot_id") CommentRange range, @JsonProperty(value="robot_run_id") String robotRunId, @JsonProperty(value="url") String url) {
        this.path = path;
        this.message = message;
        this.range = range;
        this.robotRunId = robotRunId;
        this.url = url;
    }

    public RobotCommentInput(IReviewComment reviewComment, String robotRunId) {
        this(reviewComment.getLocation().getUniformPath(), RobotCommentInput.createMessage(reviewComment), new CommentRange(reviewComment.getStartLine()), robotRunId, reviewComment.getTeamscaleCommitDetailUrl());
    }

    private static String createMessage(IReviewComment reviewComment) {
        StringBuilder sb = new StringBuilder();
        if (reviewComment.getAssessment() == ETrafficLightColor.YELLOW) {
            sb.appendCodePoint(9888);
        } else if (reviewComment.getAssessment() == ETrafficLightColor.RED) {
            sb.appendCodePoint(9940);
        }
        sb.append(" ").append(reviewComment.getText());
        return sb.toString();
    }

    public String getPath() {
        return this.path;
    }
}

