/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.data;

import com.google.common.base.Preconditions;
import com.teamscale.index.repository.git.github.ECheckRunType;
import com.teamscale.index.repository.git.github.data.CheckRun;
import java.net.URI;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.TestOnly;

public class CheckRunBuilder {
    private final String headSha;
    private final TeamscaleCheckRunName checkRunName;
    private CheckRun.Status status;
    private @Nullable URI detailsUrl;
    private @Nullable Long id;
    private @Nullable String contextIdentifier;
    private @Nullable CheckRun.Conclusion conclusion;
    private @Nullable String outputTitle;
    private @Nullable String outputText;
    private @Nullable LocalDateTime startedAt;
    private @Nullable LocalDateTime completedAt;
    private @Nullable String markdownBadge;
    private @Nullable String commentLimitExceededWarning;
    private List<CheckRun.CheckRunAnnotation> annotations = new ArrayList<CheckRun.CheckRunAnnotation>();

    public CheckRunBuilder(String headSha, ECheckRunType type) {
        this.headSha = headSha;
        this.checkRunName = TeamscaleCheckRunName.fromType(type);
        this.outputTitle = type.getDefaultSummary();
    }

    public CheckRunBuilder(CheckRun checkRun) {
        String completedAt;
        String startedAt;
        this.headSha = checkRun.headSha();
        this.checkRunName = TeamscaleCheckRunName.fromName(checkRun.name());
        this.withId(checkRun.id());
        this.withDetailsUrl(URI.create(checkRun.detailsUrl()));
        this.withConclusion(checkRun.conclusion());
        this.withStatus(checkRun.status());
        CheckRun.Output output = checkRun.output();
        if (output != null) {
            this.withOutputTitle(output.title());
            this.withOutputText(output.text());
            this.withAnnotations(output.annotations());
        }
        if ((startedAt = checkRun.startedAt()) != null) {
            this.startedAt = LocalDateTime.parse(startedAt, CheckRun.ISO_8601_FORMAT);
        }
        if ((completedAt = checkRun.completedAt()) != null) {
            this.completedAt = LocalDateTime.parse(completedAt, CheckRun.ISO_8601_FORMAT);
        }
    }

    public CheckRunBuilder withDetailsUrl(URI detailsUrl) {
        this.detailsUrl = detailsUrl;
        return this;
    }

    private CheckRunBuilder withStatus(CheckRun.Status status) {
        this.status = status;
        return this;
    }

    public CheckRunBuilder withId(@Nullable Long id) {
        this.id = id;
        return this;
    }

    public CheckRunBuilder withContextIdentifier(@Nullable String contextIdentifier) {
        this.contextIdentifier = contextIdentifier;
        return this;
    }

    public CheckRunBuilder withConclusion(@Nullable CheckRun.Conclusion conclusion) {
        this.conclusion = conclusion;
        this.status = CheckRun.Status.COMPLETED;
        return this;
    }

    public CheckRunBuilder withOutputTitle(@Nullable String outputTitle) {
        this.outputTitle = outputTitle;
        return this;
    }

    public CheckRunBuilder withOutputText(@Nullable String outputText) {
        this.outputText = outputText;
        return this;
    }

    @TestOnly
    public CheckRunBuilder withStartedAt(@Nullable LocalDateTime startedAt) {
        this.startedAt = startedAt;
        return this;
    }

    public CheckRunBuilder withMarkdownBadge(@Nullable String markdownBadge) {
        this.markdownBadge = markdownBadge;
        return this;
    }

    public CheckRunBuilder withCommentLimitExceededWarning(@Nullable String commentLimitExceededWarning) {
        this.commentLimitExceededWarning = commentLimitExceededWarning;
        return this;
    }

    public CheckRunBuilder withAnnotations(CheckRun.CheckRunAnnotation ... annotations) {
        if (annotations != null) {
            this.withAnnotations(List.of(annotations));
        }
        return this;
    }

    private CheckRunBuilder withAnnotations(List<CheckRun.CheckRunAnnotation> annotations) {
        this.annotations = annotations;
        return this;
    }

    public CheckRun build() {
        this.initializeTimestamps();
        this.attachPlaceholderAnnotationIfNecessary();
        this.checkConsistency();
        return new CheckRun(this.id, this.checkRunName.create(this.contextIdentifier), this.headSha, this.getDetailsUrlString(), this.status, this.conclusion, this.getStartedAt(), this.getCompletedAt(), this.getOutput());
    }

    private void attachPlaceholderAnnotationIfNecessary() {
        if (this.status != CheckRun.Status.COMPLETED) {
            return;
        }
        if (!this.annotations.isEmpty()) {
            return;
        }
        this.withAnnotations(new CheckRun.CheckRunAnnotation("Teamscale Check Run", 1, 1, CheckRun.CheckRunAnnotation.Level.NOTICE, "This check run was completed at " + DateTimeUtils.getUiFormattedDateString((long)Objects.requireNonNull(this.completedAt).atZone(ZoneOffset.UTC).toInstant().toEpochMilli()) + "."));
    }

    private void checkConsistency() {
        Preconditions.checkArgument((this.status != null ? 1 : 0) != 0, (Object)"'status' cannot be null.");
        if (this.status == CheckRun.Status.COMPLETED) {
            Preconditions.checkArgument((this.conclusion != null ? 1 : 0) != 0, (Object)"'conclusion' must be set if status is completed.");
            Preconditions.checkArgument((this.completedAt != null ? 1 : 0) != 0, (Object)"'completedAt' must be set if status is completed.");
        } else {
            Preconditions.checkArgument((this.conclusion == null ? 1 : 0) != 0, (Object)"'conclusion' should not be set if status is not completed.");
            Preconditions.checkArgument((this.completedAt == null ? 1 : 0) != 0, (Object)"'completedAt' should not be set if status is not completed.");
        }
    }

    private @Nullable CheckRun.Output getOutput() {
        if (this.outputTitle == null) {
            Preconditions.checkArgument((this.outputText == null ? 1 : 0) != 0, (Object)"Output text must not be set if output title is not set.");
            Preconditions.checkArgument((this.markdownBadge == null ? 1 : 0) != 0, (Object)"Markdown badge must not be set if output title is not set.");
            return null;
        }
        return new CheckRun.Output(this.outputTitle, StringUtils.emptyIfNull((String)this.commentLimitExceededWarning), this.getOutputText(), this.annotations.toArray(new CheckRun.CheckRunAnnotation[0]));
    }

    private String getOutputText() {
        return (StringUtils.emptyIfNull((String)this.markdownBadge) + "\n\n" + StringUtils.emptyIfNull((String)this.outputText)).trim();
    }

    private @Nullable String getStartedAt() {
        return CheckRunBuilder.formatAsIsoString(this.startedAt);
    }

    private @Nullable String getCompletedAt() {
        return CheckRunBuilder.formatAsIsoString(this.completedAt);
    }

    private void initializeTimestamps() {
        if (this.status == CheckRun.Status.IN_PROGRESS && this.startedAt == null) {
            this.startedAt = LocalDateTime.now(ZoneOffset.UTC);
        }
        if (this.status == CheckRun.Status.COMPLETED && this.completedAt == null) {
            this.completedAt = LocalDateTime.now(ZoneOffset.UTC);
        }
    }

    public CheckRunBuilder setInProgress() {
        this.conclusion = null;
        this.completedAt = null;
        this.status = CheckRun.Status.IN_PROGRESS;
        return this;
    }

    @Contract(value="null->null")
    private static @Nullable String formatAsIsoString(@Nullable LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return CheckRun.ISO_8601_FORMAT.format(dateTime);
    }

    private @Nullable String getDetailsUrlString() {
        if (this.detailsUrl == null) {
            return null;
        }
        return this.detailsUrl.toString();
    }

    public static Set<String> getTeamscaleCheckRunNames(String contextIdentifier) {
        return Arrays.stream(ECheckRunType.values()).map(type -> TeamscaleCheckRunName.fromType(type).create(contextIdentifier)).collect(Collectors.toSet());
    }

    private static final class TeamscaleCheckRunName {
        private final @Nullable String name;
        private final @Nullable ECheckRunType type;

        private TeamscaleCheckRunName(@Nullable String name, @Nullable ECheckRunType type) {
            CCSMAssert.isTrue((boolean)(name == null ^ type == null), (String)"Exactly one of name and type must be set.");
            this.name = name;
            this.type = type;
        }

        public static TeamscaleCheckRunName fromName(@NonNull String name) {
            return new TeamscaleCheckRunName(name, null);
        }

        public static TeamscaleCheckRunName fromType(@NonNull ECheckRunType type) {
            return new TeamscaleCheckRunName(null, type);
        }

        public String create(String contextIdentifier) {
            if (this.name != null) {
                return this.name;
            }
            return contextIdentifier + " | " + Objects.requireNonNull(this.type).getReadableName();
        }
    }
}

