/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.github.index;

import com.teamscale.index.repository.git.github.ECheckRunType;
import com.teamscale.index.repository.git.github.index.GitHubCheckRunEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;

@Index(name="github-check-runs", options={EStorageOption.NO_ROLLBACK, EStorageOption.COMPRESSED}, valueClasses={GitHubCheckRunEntry.class})
public class GitHubCheckRunIndex
implements IProjectIndex {
    private final ValueIndex<ArrayList<GitHubCheckRunEntry>> delegate;

    public GitHubCheckRunIndex(IStore store) {
        this.delegate = ValueIndex.forSerializable((IStore)store);
    }

    public void storeId(CommitDescriptor commit, ECheckRunType type, Long checkRunId) throws StorageException {
        GitHubCheckRunEntry newEntry = new GitHubCheckRunEntry(commit, checkRunId, type);
        ArrayList<GitHubCheckRunEntry> entriesToKeep = new ArrayList<GitHubCheckRunEntry>(this.getEntriesToKeep(commit, type));
        entriesToKeep.add(newEntry);
        this.delegate.setValue(GitHubCheckRunIndex.asKey(commit), entriesToKeep);
    }

    public Optional<Long> readId(CommitDescriptor commit, ECheckRunType type) throws StorageException {
        List entries = (List)this.delegate.getValue(GitHubCheckRunIndex.asKey(commit));
        if (entries == null) {
            return Optional.empty();
        }
        return entries.stream().filter(entry -> entry.getCheckRunType() == type).map(GitHubCheckRunEntry::getCheckRunId).findFirst();
    }

    public void removeCheckRun(CommitDescriptor commit, ECheckRunType type) throws StorageException {
        ArrayList<GitHubCheckRunEntry> entriesToKeep = this.getEntriesToKeep(commit, type);
        if (entriesToKeep.isEmpty()) {
            this.delegate.removeValue(GitHubCheckRunIndex.asKey(commit));
        } else {
            this.delegate.setValue(GitHubCheckRunIndex.asKey(commit), entriesToKeep);
        }
    }

    private ArrayList<GitHubCheckRunEntry> getEntriesToKeep(CommitDescriptor commit, ECheckRunType type) throws StorageException {
        ArrayList entriesToKeep = (ArrayList)this.delegate.getValue(GitHubCheckRunIndex.asKey(commit));
        if (entriesToKeep == null) {
            return new ArrayList<GitHubCheckRunEntry>();
        }
        entriesToKeep.removeIf(entry -> entry.getCheckRunType() == type);
        return entriesToKeep;
    }

    public List<GitHubCheckRunEntry> readAll() throws StorageException {
        return this.readByPrefix("");
    }

    public List<GitHubCheckRunEntry> readIdsForBranch(String branchName) throws StorageException {
        return this.readByPrefix(branchName);
    }

    private List<GitHubCheckRunEntry> readByPrefix(String prefix) throws StorageException {
        return this.delegate.getEntriesStartingWith(prefix).stream().flatMap(keyAndValue -> ((ArrayList)keyAndValue.getSecond()).stream()).toList();
    }

    private static String asKey(CommitDescriptor commit) {
        return commit.toString();
    }
}

