/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.labeling;

import com.google.common.base.Preconditions;
import com.teamscale.index.repository.git.CommitGraphNode;
import com.teamscale.index.repository.git.labeling.PathBuildingBranchLabeler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.pattern.PatternList;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.SetMapCollector;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.eclipse.jgit.lib.Ref;
import org.jetbrains.annotations.VisibleForTesting;

public class GitBranchPrioritizer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final PatternList branchPrioritizationPattern = new PatternList();

    public GitBranchPrioritizer(String defaultBranch, PatternList patterns) {
        this.branchPrioritizationPattern.add((Object)Pattern.compile(Pattern.quote(defaultBranch)));
        this.branchPrioritizationPattern.addAll((Collection)patterns);
    }

    public BranchNameSuggestions createSuggestions(SetMap<CommitGraphNode, String> branchNamesForNode, List<Ref> branchHeadRefs, CounterSet<String> branchNameFrequencies) {
        LOGGER.traceEntry();
        LOGGER.debug("Branch name frequencies:\n\n{}", branchNameFrequencies);
        return (BranchNameSuggestions)LOGGER.traceExit((Object)new BranchNameSuggestions(branchNamesForNode, branchHeadRefs, branchNameFrequencies));
    }

    public boolean isPrioritizedBranch(String branchName) {
        return this.branchPrioritizationPattern.matchesAny(branchName);
    }

    public class BranchNameSuggestions {
        private final SetMap<CommitGraphNode, String> possibleBranchNamesByNode;
        private final UnmodifiableList<Ref> branchHeadRefs;
        private final CounterSet<String> branchNameFrequency;
        private final Map<String, Integer> importanceByBranch = new HashMap<String, Integer>();

        private BranchNameSuggestions(SetMap<CommitGraphNode, String> possibleBranchNamesByNode, List<Ref> branchHeadRefs, CounterSet<String> branchNameFrequency) {
            this.possibleBranchNamesByNode = possibleBranchNamesByNode;
            this.branchNameFrequency = branchNameFrequency;
            this.branchHeadRefs = CollectionUtils.asUnmodifiable(this.getSortedBranchRefs(branchHeadRefs));
        }

        private List<Ref> getSortedBranchRefs(List<Ref> includedBranchHeadRefs) {
            return this.sort(includedBranchHeadRefs, PathBuildingBranchLabeler::determineBranchName);
        }

        public List<String> sort(Collection<String> branches) {
            return this.sort(branches, Function.identity(), null);
        }

        private <T> List<T> sort(Collection<T> unsorted, Function<T, String> branchExtractor) {
            return this.sort(unsorted, branchExtractor, null);
        }

        public <T> List<T> sort(Collection<T> unsortedValues, Function<T, String> branchExtractor, @Nullable Comparator<String> customComparator) {
            LOGGER.traceEntry("unsortedValues: {}", new Object[]{unsortedValues});
            ArrayList sortedResult = new ArrayList();
            SetMap valuesByImportance = (SetMap)unsortedValues.stream().collect(SetMapCollector.groupingBy(value -> this.getImportance((String)branchExtractor.apply(value))));
            LOGGER.trace((Object)valuesByImportance);
            Comparator sameImportanceComparator = this.createSameImportanceComparator(branchExtractor, customComparator);
            valuesByImportance.getKeys().stream().sorted(Comparator.reverseOrder()).forEach(importance -> {
                Set importanceBucket = (Set)valuesByImportance.getCollection(importance);
                List sortedImportanceBucket = importanceBucket.stream().sorted(sameImportanceComparator).collect(Collectors.toCollection(ArrayList::new));
                LOGGER.trace("importanceBucket: {}, sortedImportanceBucket: {}", (Object)importanceBucket, (Object)sortedImportanceBucket);
                BranchNameSuggestions.fixPrefixes(sortedImportanceBucket, branchExtractor);
                LOGGER.trace("sortedImportanceBucket: {}", (Object)sortedImportanceBucket);
                sortedResult.addAll(sortedImportanceBucket);
            });
            return (List)LOGGER.traceExit(sortedResult);
        }

        @VisibleForTesting
        static <T> void fixPrefixes(List<T> sortedValues, Function<T, String> branchExtractor) {
            SetMap<String, String> prefixMatches = BranchNameSuggestions.getPrefixMatches(CollectionUtils.map(sortedValues, branchExtractor));
            for (Map.Entry prefixMatch : prefixMatches) {
                Optional<Pair<Integer, Integer>> indexOfLongerAndIndexOfShorter = BranchNameSuggestions.findIncorrectlyOrderedPrefixMatch(sortedValues, branchExtractor, prefixMatch);
                indexOfLongerAndIndexOfShorter.ifPresent(indexes -> {
                    int indexOfShorter;
                    int indexOfLonger = (Integer)indexes.getFirst();
                    Preconditions.checkState((indexOfLonger < (indexOfShorter = ((Integer)indexes.getSecond()).intValue()) ? 1 : 0) != 0, (Object)"Expecting an incorrectly ordered prefix match to have the longer name at the lower index position.");
                    Object shorterPrefix = sortedValues.remove(indexOfShorter);
                    sortedValues.add(indexOfLonger, shorterPrefix);
                });
            }
        }

        private static <T> Optional<Pair<Integer, Integer>> findIncorrectlyOrderedPrefixMatch(List<T> sortedValues, Function<T, String> branchExtractor, Map.Entry<String, Set<String>> prefixMatchToCheck) {
            int position = -1;
            for (int i = 0; i < sortedValues.size(); ++i) {
                String branch = branchExtractor.apply(sortedValues.get(i));
                if (branch.equals(prefixMatchToCheck.getKey())) {
                    if (position == -1) {
                        return Optional.empty();
                    }
                    return Optional.of(Pair.createPair((Object)position, (Object)i));
                }
                if (!prefixMatchToCheck.getValue().contains(branch) || position != -1) continue;
                position = i;
            }
            return Optional.empty();
        }

        private <T> Comparator<T> createSameImportanceComparator(Function<T, String> branchExtractor, @Nullable Comparator<String> customComparator) {
            Comparator<Object> sameImportanceComparator = Comparator.comparingInt(value -> -this.getFrequency((String)branchExtractor.apply(value))).thenComparing(branchExtractor);
            if (customComparator != null) {
                return Comparator.comparing(branchExtractor, customComparator).thenComparing(sameImportanceComparator);
            }
            return sameImportanceComparator;
        }

        public Set<String> getPossibleBranchNames(CommitGraphNode node) {
            return (Set)this.possibleBranchNamesByNode.getCollectionOrEmpty((Object)node);
        }

        public SetMap<String, CommitGraphNode> getBranchesToPossibleNodes() {
            return this.possibleBranchNamesByNode.invert();
        }

        @VisibleForTesting
        int getFrequency(String branchName) {
            return this.branchNameFrequency.getValue((Object)branchName);
        }

        @VisibleForTesting
        int getImportance(String branchName) {
            return this.importanceByBranch.computeIfAbsent(branchName, this::determineBranchPriority);
        }

        public static int determineBranchPriority(String branchName, PatternList branchPrioritizationPattern) {
            int priority = branchPrioritizationPattern.size() * 2 + 1;
            for (Pattern pattern : branchPrioritizationPattern) {
                if (pattern.matcher(branchName).matches()) {
                    LOGGER.debug("Increasing frequency for branch {} due to matching pattern {}", (Object)branchName, (Object)pattern.toString());
                    return priority - 1;
                }
                priority -= 2;
            }
            return 0;
        }

        private int determineBranchPriority(String branchName) {
            return BranchNameSuggestions.determineBranchPriority(branchName, GitBranchPrioritizer.this.branchPrioritizationPattern);
        }

        private boolean hasEqualOrHigherImportance(String branchNameToTest, String referenceBranchName) {
            return this.getImportance(branchNameToTest) >= this.getImportance(referenceBranchName);
        }

        public boolean hasHigherImportance(String branchNameToTest, @Nullable String referenceBranchName) {
            CCSMAssert.isNotNull((Object)branchNameToTest);
            if (referenceBranchName == null) {
                return false;
            }
            return this.getImportance(branchNameToTest) > this.getImportance(referenceBranchName);
        }

        public List<Ref> getBranchHeadRefsByPriority() {
            return this.branchHeadRefs;
        }

        public boolean canBeLabeledWith(CommitGraphNode node, String branchName) {
            if (node.isBranchNameUnsetOrEqualTo(branchName)) {
                return true;
            }
            return !this.hasEqualOrHigherImportance(node.getBranchName(), branchName);
        }

        public void removePossibleBranchForCommit(CommitGraphNode commit, String branchName) {
            ((Set)this.possibleBranchNamesByNode.getCollectionOrEmpty((Object)commit)).remove(branchName);
        }

        public static SetMap<String, String> getPrefixMatches(Collection<String> potentialPrefixes) {
            SetMap prefixes = new SetMap();
            ArrayList sortedPotentialPrefixes = CollectionUtils.sort(potentialPrefixes);
            for (int i = 0; i < sortedPotentialPrefixes.size(); ++i) {
                String potentialPrefix = (String)sortedPotentialPrefixes.get(i);
                int j = 1;
                while (i + j < sortedPotentialPrefixes.size() && ((String)sortedPotentialPrefixes.get(i + j)).startsWith(potentialPrefix) && !potentialPrefix.equals(sortedPotentialPrefixes.get(i + j))) {
                    String match = (String)sortedPotentialPrefixes.get(i + j);
                    prefixes.add((Object)potentialPrefix, (Object)match);
                    ++j;
                }
            }
            return prefixes;
        }

        public String toString() {
            return "BranchNameSuggestions{possibleBranchNamesByNode=" + String.valueOf(this.possibleBranchNamesByNode) + ", branchHeadRefs=" + String.valueOf(this.branchHeadRefs) + ", branchNameFrequency=" + String.valueOf(this.branchNameFrequency) + ", importanceByBranch=" + String.valueOf(this.importanceByBranch) + "}";
        }
    }
}

