/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.git.scm_manager.data;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.URI;
import java.util.Arrays;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ScmManagerRepository {
    @JsonProperty(value="_links")
    private @Nullable Links links;

    public Optional<URI> getCloneUri() {
        if (this.links == null) {
            return Optional.empty();
        }
        return this.links.getHttpCloneUri();
    }

    private static class Links {
        @JsonProperty(value="protocol")
        private Protocol[] protocols;

        private Links() {
        }

        private Optional<URI> getHttpCloneUri() {
            return Arrays.stream(this.protocols).filter(protocol -> protocol.getName().startsWith("http")).findFirst().map(Protocol::getHref);
        }
    }

    private static class Protocol {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="href")
        private URI href;

        private Protocol() {
        }

        private String getName() {
            return this.name;
        }

        private URI getHref() {
            return this.href;
        }
    }
}

