/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.svn.SVNUtils;
import com.teamscale.index.repository.svn.SvnChangeEntry;
import com.teamscale.index.repository.svn.SvnExternalTarget;
import com.teamscale.index.repository.svn.SvnExternalsInfo;
import com.teamscale.index.repository.svn.SvnExternalsRetriever;
import com.teamscale.index.repository.svn.SvnLogCacheIndex;
import com.teamscale.index.repository.svn.SvnLogQueue;
import com.teamscale.index.repository.svn.SvnRepositoryViewBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ListMap;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.predicate.IPredicateWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.system.PerformanceMonitor;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNInfo;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCClient;

public class ExternalsSvnRepositoryView
extends SvnRepositoryViewBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IncludeExcludeAntPatternSupport externalsPatternSupport;

    public ExternalsSvnRepositoryView(SVNRepository repository, IPredicateWithException<String, RepositoryException> isPathIncluded, Predicate<String> canSubPathsBeIncluded, Function<String, Optional<String>> branchNameExtractor, SvnLogCacheIndex logCacheIndex, IncludeExcludeAntPatternSupport externalsPatternSupport, String branchDirectoryName) {
        super(repository, isPathIncluded, canSubPathsBeIncluded, branchNameExtractor, logCacheIndex, branchDirectoryName);
        this.externalsPatternSupport = externalsPatternSupport;
    }

    @Override
    public List<SvnChangeEntry> getNextLogEntries(long nextScanTimestamp, long startTimestamp, int maximumChunkSize) throws RepositoryException {
        PerformanceMonitor monitor = PerformanceMonitor.create((boolean)false);
        LOGGER.debug("Starting getNextLogEntries (" + nextScanTimestamp + ", startTimestamp: " + startTimestamp + ")");
        this.bootstrapLogIndexIfNeeded(startTimestamp);
        long timestamp = Math.max(nextScanTimestamp, startTimestamp);
        try {
            List<SvnChangeEntry> result = this.logCacheIndex.getPersistedEntries(timestamp);
            if (result.size() >= maximumChunkSize) {
                return new ArrayList<SvnChangeEntry>(result.subList(0, maximumChunkSize));
            }
            if (!result.isEmpty()) {
                timestamp = ((SvnChangeEntry)CollectionUtils.getLast(result)).getTimestamp() + 1L;
            }
            List<SvnChangeEntry> addedEntries = this.getAddedEntriesAfter(timestamp, result, maximumChunkSize);
            this.logCacheIndex.persistChangeEntries(addedEntries);
            LOGGER.debug("Finished getNextLogEntries (" + monitor.stop() + "ms)");
            return result;
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private List<SvnChangeEntry> getAddedEntriesAfter(long startTimestamp, List<SvnChangeEntry> result, int maximumChunkSize) throws RepositoryException {
        Optional<SvnChangeEntry> next;
        SvnExternalsInfo externalInfos = this.loadExternalInfos(startTimestamp);
        List<SvnLogQueue> logQueues = this.buildLogQueues(externalInfos, startTimestamp - 1L);
        ArrayList<SvnChangeEntry> addedEntries = new ArrayList<SvnChangeEntry>();
        while (result.size() < maximumChunkSize && !(next = ExternalsSvnRepositoryView.extractNextLogEntry(logQueues)).isEmpty()) {
            SvnChangeEntry entry = next.get();
            PairList<SvnExternalTarget, SvnExternalTarget> externalsChanges = externalInfos.updateFromLogEntry(entry);
            if (!externalsChanges.isEmpty()) {
                this.handleExternalChanges(externalInfos, entry, externalsChanges);
                logQueues = this.buildLogQueues(externalInfos, entry.getTimestamp());
            }
            addedEntries.add(entry);
            result.add(entry);
        }
        return addedEntries;
    }

    private void handleExternalChanges(SvnExternalsInfo externalInfos, SvnChangeEntry entry, PairList<SvnExternalTarget, SvnExternalTarget> externalsChanges) throws RepositoryException {
        HashSet<String> affectedRepositoryRoots = new HashSet<String>();
        for (int j = 0; j < externalsChanges.size(); ++j) {
            this.handleExternalChange((SvnExternalTarget)externalsChanges.getFirst(j), (SvnExternalTarget)externalsChanges.getSecond(j), entry, externalInfos, affectedRepositoryRoots);
        }
        this.updateLogCacheIndexAfterExternalsChange(externalInfos, entry, affectedRepositoryRoots);
    }

    private SvnExternalsInfo loadExternalInfos(long timestamp) throws RepositoryException {
        try {
            return this.logCacheIndex.getExternalInfos(timestamp);
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void bootstrapLogIndexIfNeeded(long startTimestamp) throws RepositoryException {
        try {
            if (this.logCacheIndex.isEmpty()) {
                this.bootstrapLogIndex(startTimestamp);
            }
        }
        catch (StorageException | SVNException e) {
            throw new RepositoryException(e);
        }
    }

    private void updateLogCacheIndexAfterExternalsChange(SvnExternalsInfo externalInfos, SvnChangeEntry entry, Set<String> affectedRepositoryRoots) throws RepositoryException {
        try {
            this.logCacheIndex.invalidateInformationStartingFrom(entry.getTimestamp(), affectedRepositoryRoots);
            this.logCacheIndex.insertExternalInfos(entry.getTimestamp(), externalInfos);
            this.logCacheIndex.insertLogEntries(Collections.singletonList(entry));
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void handleExternalChange(SvnExternalTarget oldTarget, SvnExternalTarget newTarget, SvnChangeEntry entry, SvnExternalsInfo externalInfos, Set<String> affectedRepositoryRoots) throws RepositoryException {
        PerformanceMonitor monitor = PerformanceMonitor.create((boolean)false);
        LOGGER.debug("Starting handleExternalChange (" + String.valueOf(oldTarget) + ", newTarget: " + String.valueOf(newTarget) + ", entry" + String.valueOf(entry) + ")");
        CCSMAssert.isFalse((oldTarget == null && newTarget == null ? 1 : 0) != 0, (String)"May not map null to null!");
        try {
            if (newTarget == null) {
                this.processDeletedExternal(oldTarget, entry, affectedRepositoryRoots).forEach(path -> entry.addChange((String)path, ERepositoryChangeType.DELETE, null, null));
            } else if (oldTarget == null) {
                this.processAddedExternal(newTarget, entry, externalInfos, affectedRepositoryRoots).forEach(path -> entry.addChange((String)path, ERepositoryChangeType.ADD, null, null));
            } else {
                List<String> deletedPaths = this.processDeletedExternal(oldTarget, entry, affectedRepositoryRoots);
                List<String> addedPaths = this.processAddedExternal(newTarget, entry, externalInfos, affectedRepositoryRoots);
                ExternalsSvnRepositoryView.updateEntryFromAddedAndDeletedPaths(deletedPaths, addedPaths, entry);
            }
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
        LOGGER.debug("Finished handleExternalChange (" + monitor.stop() + "ms)");
    }

    private static void updateEntryFromAddedAndDeletedPaths(List<String> deletedPaths, List<String> addedPaths, SvnChangeEntry entry) {
        CollectionUtils.differenceSet(deletedPaths, (Collection[])new Collection[]{addedPaths}).forEach(path -> entry.addChange((String)path, ERepositoryChangeType.DELETE, null, null));
        CollectionUtils.differenceSet(addedPaths, (Collection[])new Collection[]{deletedPaths}).forEach(path -> entry.addChange((String)path, ERepositoryChangeType.ADD, null, null));
        CollectionUtils.intersectionSet(addedPaths, (Collection[])new Collection[]{deletedPaths}).forEach(path -> entry.addChange((String)path, ERepositoryChangeType.EDIT, null, null));
    }

    private List<String> processDeletedExternal(SvnExternalTarget deletedTarget, SvnChangeEntry entry, Set<String> affectedRepositoryRoots) throws RepositoryException, SVNException {
        affectedRepositoryRoots.add(deletedTarget.getRepositoryRoot());
        long revision = this.resolveExternalRevision(entry.getCompositeRevision(), deletedTarget);
        if (!deletedTarget.hasFixedRevision() && deletedTarget.getRepositoryRoot().equals(entry.getRepositoryRoot())) {
            --revision;
        }
        SVNRepository rootRepository = this.getOrCreateRepository(deletedTarget.getRepositoryRoot());
        String basePath = deletedTarget.getRepositorySuffix();
        if (SVNUtils.fileExists(basePath, revision, rootRepository)) {
            if (this.isPathIncluded.test((Object)deletedTarget.getLocalPath())) {
                return Collections.singletonList(deletedTarget.getLocalPath());
            }
            return Collections.emptyList();
        }
        Set<String> deletedPaths = ExternalsSvnRepositoryView.crawl(rootRepository, basePath, revision, this.repositoryExecutor, (IPredicateWithException<String, RepositoryException>)((IPredicateWithException)path -> this.isPathIncluded.test((Object)deletedTarget.resolveServerToWcPath((String)path))), path -> this.canSubPathsBeIncluded.test(deletedTarget.resolveServerToWcPath((String)path)));
        return CollectionUtils.map(deletedPaths, deletedTarget::resolveServerToWcPath);
    }

    private List<String> processAddedExternal(SvnExternalTarget newTarget, SvnChangeEntry entry, SvnExternalsInfo externalInfos, Set<String> affectedRepositoryRoots) throws RepositoryException, SVNException {
        List<SvnExternalTarget> addedTargets = this.discoverExternalsRecursively(newTarget, entry.getTimestamp());
        affectedRepositoryRoots.addAll(CollectionUtils.map(addedTargets, SvnExternalTarget::getRepositoryRoot));
        for (SvnLogQueue queue : this.buildLogQueues(new SvnExternalsInfo(addedTargets), entry.getTimestamp() - 1L)) {
            queue.peekEntry();
        }
        ArrayList<String> result = new ArrayList<String>(this.crawl(newTarget.getLocalPath(), entry.getCompositeRevision(), addedTargets));
        addedTargets.remove(newTarget);
        externalInfos.addTargets(addedTargets);
        return result;
    }

    private List<SvnLogQueue> buildLogQueues(SvnExternalsInfo externalInfos, long timestamp) throws RepositoryException {
        PerformanceMonitor monitor = PerformanceMonitor.create((boolean)false);
        LOGGER.debug("Starting buildLogQueues (" + String.valueOf(externalInfos) + ", timestamp: " + timestamp + ")");
        ListMap<String, SvnExternalTarget> rootRepoToTargets = externalInfos.asRootRepoToTargetsWithoutFixedRevisions();
        List<String> allExternalWcPaths = externalInfos.getAllExternalWcPaths();
        ArrayList<SvnLogQueue> logQueues = new ArrayList<SvnLogQueue>();
        for (String repositoryRoot : rootRepoToTargets.getKeys()) {
            PerformanceMonitor innerMonitor = PerformanceMonitor.create((boolean)false);
            LOGGER.debug("\t new SvnLogQueue (" + repositoryRoot + ")");
            logQueues.add(new SvnLogQueue(repositoryRoot, this.getOrCreateRepository(repositoryRoot), (List)rootRepoToTargets.getCollection((Object)repositoryRoot), allExternalWcPaths, this.logCacheIndex, timestamp, this.externalsPatternSupport, this.repositoryExecutor, (IPredicateWithException<String, RepositoryException>)this.isPathIncluded, this.canSubPathsBeIncluded, this.branchNameExtractor, this.branchesDirectory));
            LOGGER.debug("\t Finished new SvnLogQueue (" + innerMonitor.stop() + "ms)");
        }
        LOGGER.debug("Finished buildLogQueues (" + monitor.stop() + "ms)");
        return logQueues;
    }

    private static Optional<SvnChangeEntry> extractNextLogEntry(List<SvnLogQueue> logQueues) throws RepositoryException {
        PerformanceMonitor monitor = PerformanceMonitor.create((boolean)false);
        LOGGER.debug("Starting extractNextLogEntry");
        long minTimestamp = Long.MAX_VALUE;
        SvnLogQueue bestQueue = null;
        for (SvnLogQueue logQueue : logQueues) {
            if (logQueue.isEmpty() || bestQueue != null && logQueue.peekEntry().getTimestamp() >= minTimestamp) continue;
            minTimestamp = logQueue.peekEntry().getTimestamp();
            bestQueue = logQueue;
        }
        LOGGER.debug("Finished extractNextLogEntry (" + monitor.stop() + "ms)");
        if (bestQueue != null) {
            return Optional.of(bestQueue.pollEntry());
        }
        return Optional.empty();
    }

    private void bootstrapLogIndex(long startTimestamp) throws RepositoryException, SVNException, StorageException {
        PerformanceMonitor monitor = PerformanceMonitor.create((boolean)false);
        LOGGER.debug("Bootstrapping Log Index...");
        String repositoryRoot = SVNUtils.determineRepositoryRoot(this.mainRepository, true).toDecodedString();
        String repositorySuffix = this.mainRepository.getLocation().toDecodedString().replace(repositoryRoot, "");
        SvnExternalsInfo externalInfos = new SvnExternalsInfo();
        externalInfos.addTargets(this.discoverExternalsRecursively(new SvnExternalTarget("", repositoryRoot, repositorySuffix, 0L), startTimestamp));
        this.logCacheIndex.insertExternalInfos(1L, externalInfos);
        LOGGER.debug("Finished bootstrap (" + monitor.stop() + "ms)");
    }

    private List<SvnExternalTarget> discoverExternalsRecursively(SvnExternalTarget startTarget, long timestamp) throws RepositoryException, SVNException {
        PerformanceMonitor monitor = PerformanceMonitor.create((boolean)false);
        LOGGER.debug("Starting discoverExternalsRecursively (" + String.valueOf(startTarget) + ", timestamp: " + timestamp + ")");
        LinkedList<SvnExternalTarget> externals = new LinkedList<SvnExternalTarget>();
        externals.add(startTarget);
        ArrayList<SvnExternalTarget> result = new ArrayList<SvnExternalTarget>();
        while (!externals.isEmpty()) {
            this.processNextExternal(timestamp, externals, result);
        }
        LOGGER.debug("Finished discoverExternalsRecursively (" + monitor.stop() + "ms)");
        return result;
    }

    private void processNextExternal(long timestamp, Queue<SvnExternalTarget> externals, List<SvnExternalTarget> result) throws RepositoryException, SVNException {
        SvnExternalTarget target = externals.poll();
        result.add(target);
        SVNRepository repository = this.getOrCreateRepository(target.getRepositoryRoot());
        long localStartRevision = SVNUtils.getRevisionForTimestamp(repository, timestamp);
        PerformanceMonitor extMonitor = PerformanceMonitor.create((boolean)false);
        if (SVNUtils.fileExists(target.getRepositorySuffix(), localStartRevision, repository)) {
            return;
        }
        LOGGER.debug("\t Starting getExternalsRemote (target:" + String.valueOf(target) + ", localStartRevision: " + localStartRevision + ")");
        List<SvnExternalTarget> newExternals = SvnExternalsRetriever.getExternalsRemote(target.getLocalPath(), repository, target.getRepositorySuffix(), localStartRevision, true, this.repositoryExecutor, this.externalsPatternSupport, this.canSubPathsBeIncluded);
        for (SvnExternalTarget newExternal : newExternals) {
            externals.add(newExternal.copyWithPrefixedLocalPath(target.getLocalPath()));
        }
        LOGGER.debug("\t Finished getExternalsRemote (" + extMonitor.stop() + "ms). Remaining: " + externals.size());
    }

    @Override
    public Map<String, Long> getHeadTimestamp(List<String> paths) throws RepositoryException {
        PerformanceMonitor monitor = PerformanceMonitor.create((boolean)false);
        LOGGER.debug("Starting getHeadTimestamp (" + String.valueOf(paths) + ")");
        SVNWCClient wcClient = this.clientManager.getWCClient();
        try {
            UnmodifiableCollection<SvnExternalTarget> externalTargets = this.logCacheIndex.getLatestExternalInfos().getAll();
            HashMap<String, Long> result = new HashMap<String, Long>();
            for (String path : paths) {
                result.put(path, this.getHeadTimestampForPath(path, (Collection<SvnExternalTarget>)externalTargets, wcClient));
            }
            LOGGER.debug("Finished getHeadTimestamp (" + monitor.stop() + "ms)");
            return result;
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private long getHeadTimestampForPath(String path, Collection<SvnExternalTarget> externalTargets, SVNWCClient wcClient) throws RepositoryException {
        long result = -1L;
        try {
            result = this.getTimestampForPath(wcClient, path);
        }
        catch (SVNException e) {
            if (ExternalsSvnRepositoryView.isIllegalUrlException(e)) {
                return -1L;
            }
            throw new RepositoryException((Throwable)e);
        }
        for (SvnExternalTarget target : externalTargets) {
            if (ExternalsSvnRepositoryView.isFixedRevisionOrUnrelatedTarget(path, target)) continue;
            try {
                SVNURL remotePath = this.getOrCreateRepository(target.getRepositoryRoot()).getLocation().appendPath(target.getRepositorySuffix(), false);
                SVNInfo externalEntry = wcClient.doInfo(remotePath, SVNRevision.HEAD, SVNRevision.HEAD);
                result = Math.max(result, externalEntry.getCommittedDate().getTime());
            }
            catch (SVNException e) {
                if (ExternalsSvnRepositoryView.isIllegalUrlException(e)) continue;
                throw new RepositoryException((Throwable)e);
            }
        }
        return result;
    }

    private static boolean isIllegalUrlException(SVNException e) {
        return e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_ILLEGAL_URL;
    }

    private static boolean isFixedRevisionOrUnrelatedTarget(String path, SvnExternalTarget target) {
        return target.hasFixedRevision() || !StringUtils.isEmpty((String)path) && !target.getLocalPath().startsWith(StringUtils.ensureEndsWith((String)path, (String)"/"));
    }

    private long getTimestampForPath(SVNWCClient wcClient, String path) throws SVNException {
        SVNInfo entry = wcClient.doInfo(this.mainRepository.getLocation().appendPath(path, false), SVNRevision.HEAD, SVNRevision.HEAD);
        return entry.getCommittedDate().getTime();
    }

    @Override
    public SvnChangeEntry getLogEntry(String compositeRevision) throws RepositoryException {
        Pair<Long, String> revisionAndRepository = SvnChangeEntry.parseCompositeRevision(compositeRevision);
        try {
            return this.logCacheIndex.getRepositoryLog((String)revisionAndRepository.getSecond(), (Long)revisionAndRepository.getFirst());
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public Set<String> crawl(String path, String compositeRevision) throws RepositoryException {
        return this.crawl(path, compositeRevision, (Collection<SvnExternalTarget>)this.getExternalInfos(compositeRevision).getAll());
    }

    private Set<String> crawl(String path, String compositeRevision, Collection<SvnExternalTarget> externalTargets) throws RepositoryException {
        PerformanceMonitor monitor = PerformanceMonitor.create((boolean)false);
        LOGGER.debug("Starting crawl (" + path + ", revision:  " + compositeRevision + ", targets:" + String.valueOf(externalTargets) + ")");
        HashSet<String> result = new HashSet<String>();
        for (SvnExternalTarget target : externalTargets) {
            String basePath;
            String localPath = target.getLocalPath();
            if (path.startsWith(localPath)) {
                basePath = UniformPathUtils.concatenate((String[])new String[]{SvnExternalTarget.trimSlashes(target.getRepositorySuffix()), SvnExternalTarget.trimSlashes(StringUtils.stripPrefix((String)path, (String)localPath))});
            } else {
                if (!localPath.startsWith(path)) continue;
                basePath = target.getRepositorySuffix();
            }
            this.crawInExternalTarget(basePath, compositeRevision, target, result);
        }
        LOGGER.debug("Finished crawl (" + monitor.stop() + "ms)");
        return result;
    }

    private void crawInExternalTarget(String basePath, String compositeRevision, SvnExternalTarget target, Set<String> result) throws RepositoryException {
        try {
            SVNRepository rootRepository = this.getOrCreateRepository(target.getRepositoryRoot());
            long revision = this.resolveExternalRevision(compositeRevision, target);
            if (SVNUtils.fileExists(basePath, revision, rootRepository)) {
                String fullPath = target.resolveServerToWcPath(basePath);
                if (this.isPathIncluded.test((Object)fullPath)) {
                    result.add(fullPath);
                }
            } else {
                Set<String> localResult = ExternalsSvnRepositoryView.crawl(rootRepository, basePath, revision, this.repositoryExecutor, (IPredicateWithException<String, RepositoryException>)((IPredicateWithException)repoPath -> this.isPathIncluded.test((Object)target.resolveServerToWcPath((String)repoPath))), repoPath -> this.canSubPathsBeIncluded.test(target.resolveServerToWcPath((String)repoPath)));
                result.addAll(CollectionUtils.map(localResult, target::resolveServerToWcPath));
            }
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    protected SvnRepositoryViewBase.BinaryContentAccessor getBinaryContentAccessor(String path, String compositeRevision) throws RepositoryException {
        SvnExternalsInfo externalInfos = this.getExternalInfos(compositeRevision);
        SvnExternalTarget target = externalInfos.getBestMatchingTarget(path);
        return new SvnRepositoryViewBase.BinaryContentAccessor(this, this.getOrCreateRepository(target.getRepositoryRoot()), target.resolveWcToServerPath(path), this.resolveExternalRevision(compositeRevision, target));
    }

    private SvnExternalsInfo getExternalInfos(String compositeRevision) throws RepositoryException {
        long timestamp = this.getLogEntry(compositeRevision).getTimestamp();
        try {
            return this.logCacheIndex.getExternalInfos(timestamp);
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private long resolveExternalRevision(String compositeRevision, SvnExternalTarget target) throws RepositoryException {
        if (target.hasFixedRevision()) {
            return target.getFixedRevision();
        }
        long timestamp = this.getLogEntry(compositeRevision).getTimestamp();
        try {
            Optional<Long> exactRevision = this.logCacheIndex.getRevisionForExactTimestamp(target.getRepositoryRoot(), timestamp);
            if (exactRevision.isPresent()) {
                return exactRevision.get();
            }
            long revision = SVNUtils.getRevisionForTimestamp(this.getOrCreateRepository(target.getRepositoryRoot()), timestamp);
            this.logCacheIndex.insertTimestampToRevisionMapping(timestamp, revision, target.getRepositoryRoot());
            return revision;
        }
        catch (StorageException | SVNException e) {
            throw new RepositoryException(e);
        }
    }

    @Override
    public String resolveMainRepositoryRevision(long revision) throws RepositoryException {
        try {
            return SvnChangeEntry.createCompositeRevision(revision, SVNUtils.determineRepositoryRoot(this.mainRepository, true).toDecodedString() + "/");
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
    }
}

