/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeInfo;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.base.RepositoryConnectionBase;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.svn.ExternalsSvnRepositoryView;
import com.teamscale.index.repository.svn.ISvnRepositoryView;
import com.teamscale.index.repository.svn.PlainSvnRepositoryView;
import com.teamscale.index.repository.svn.SVNUtils;
import com.teamscale.index.repository.svn.SvnChangeEntry;
import com.teamscale.index.repository.svn.SvnExternalTarget;
import com.teamscale.index.repository.svn.SvnLogCacheIndex;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.conqat.engine.core.pattern.IncludeExcludeAntPatternSupport;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.predicate.IPredicateWithException;
import org.conqat.lib.commons.region.RegionSet;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNMergeRange;
import org.tmatesoft.svn.core.SVNMergeRangeList;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.wc.SVNDiffClient;
import org.tmatesoft.svn.core.wc.SVNRevision;

public class SVNRepositoryConnection
extends RepositoryConnectionBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String SEPARATOR = "/";
    private static final int LOG_QUERY_SIZE = 2000;
    private final String branchesDirectory;
    private final ISvnRepositoryView repositoryView;
    private final SVNRepository repository;
    private final long startTimestamp;
    private final long endTimestamp;
    private final RegionSet ignoredRevisions;
    private static boolean noStartTimestampFoundWarningLogged = false;

    public SVNRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, String branchesDirectory, String url, String userName, String password, boolean enableExternals, IncludeExcludeAntPatternSupport externalsPatternSupport, SvnLogCacheIndex logCacheIndex, RegionSet ignoredRevisions) throws RepositoryException {
        super(connectorBaseParameterStep);
        this.branchesDirectory = branchesDirectory;
        this.ignoredRevisions = ignoredRevisions;
        this.repository = SVNRepositoryConnection.createRepository(url, userName, password);
        this.repositoryView = this.createRepositoryView(enableExternals, externalsPatternSupport, logCacheIndex);
        long configuredStartTimestamp = this.getInstantForStartDateOrRevision(connectorBaseParameterStep.getStartDateOrRevision(), connectorBaseParameterStep.getMinimalStartTimestamp()).toEpochMilli();
        SVNRepository correctedRepository = SVNRepositoryConnection.getRepositoryWithAccessibleRoot(this.repository, userName, password);
        Optional<SVNLogEntry> firstLogEntry = SVNUtils.getFirstLogEntry(correctedRepository, configuredStartTimestamp);
        Date repositoryStartDate = firstLogEntry.orElseThrow(() -> new RepositoryException("No commits found in repository " + correctedRepository.getLocation().toString())).getDate();
        if (repositoryStartDate == null) {
            if (!noStartTimestampFoundWarningLogged) {
                LOGGER.warn(String.format("No timestamp found on first SVN commit (Revision %d) in repository. Using configured timestamp instead.", firstLogEntry.get().getRevision()));
                noStartTimestampFoundWarningLogged = true;
            }
            this.startTimestamp = configuredStartTimestamp;
        } else {
            this.startTimestamp = Math.max(configuredStartTimestamp, repositoryStartDate.getTime());
            noStartTimestampFoundWarningLogged = false;
        }
        correctedRepository.closeSession();
        this.endTimestamp = this.getInstantForEndDateOrRevision(connectorBaseParameterStep.getEndDateOrRevision()).toEpochMilli();
    }

    private static SVNRepository createRepository(String url, String userName, String password) throws RepositoryException {
        try {
            return SVNUtils.createRepository(url, userName, password);
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private static SVNRepository getRepositoryWithAccessibleRoot(SVNRepository repository, String userName, String password) throws RepositoryException {
        try {
            SVNURL url = SVNUtils.determineRepositoryRoot(repository, true);
            return SVNUtils.createRepository(url, userName, password);
        }
        catch (SVNException e) {
            throw new RepositoryException("Could not create repository with corrected root.", (Throwable)e);
        }
    }

    private ISvnRepositoryView createRepositoryView(boolean enableExternals, IncludeExcludeAntPatternSupport externalsPatternSupport, SvnLogCacheIndex logCacheIndex) throws RepositoryException {
        Function<String, Optional<String>> branchNameExtractor = path -> {
            try {
                return Optional.of((String)this.splitToBranchNameAndPath((String)path).getFirst());
            }
            catch (RepositoryException e) {
                return Optional.empty();
            }
        };
        if (enableExternals) {
            return new ExternalsSvnRepositoryView(this.repository, (IPredicateWithException<String, RepositoryException>)((IPredicateWithException)this::isPathIncluded), this::canSubPathsBeIncluded, branchNameExtractor, logCacheIndex, externalsPatternSupport, this.branchesDirectory);
        }
        return new PlainSvnRepositoryView(this.repository, (IPredicateWithException<String, RepositoryException>)((IPredicateWithException)this::isPathIncluded), this::canSubPathsBeIncluded, branchNameExtractor, logCacheIndex, this.branchesDirectory);
    }

    @Override
    protected Optional<Long> convertRevisionToTimestamp(String revision) throws RepositoryException {
        return SVNUtils.convertRevisionToTimestamp(revision, this.repository);
    }

    @Override
    public CommitTreeExpansionResult expandCommitTreeNodes(ICommitTree commitTree) throws RepositoryException {
        Map<String, Long> latestTimestampInRepoByBranch;
        Map<String, Long> latestContainedTimestampByBranch = this.buildLatestContainedTimestampByBranch(commitTree);
        OptionalLong nextScanTimestampOptional = SVNRepositoryConnection.determineNextScanTimestamp(latestContainedTimestampByBranch, latestTimestampInRepoByBranch = this.determineLatestTimestampByBranch(commitTree.getAllKnownBranchNames()));
        if (nextScanTimestampOptional.isEmpty()) {
            nextScanTimestampOptional = this.scanForNewBranches(latestContainedTimestampByBranch.keySet());
        }
        if (nextScanTimestampOptional.isEmpty()) {
            return CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(false).build();
        }
        long nextScanTimestamp = nextScanTimestampOptional.getAsLong();
        int maxLogSize = 2000;
        if (commitTree.isEmpty()) {
            maxLogSize = 2;
        }
        return this.fillCommitTreeFromLog(commitTree, latestContainedTimestampByBranch, nextScanTimestamp, maxLogSize);
    }

    private OptionalLong scanForNewBranches(Set<String> knownBranches) throws RepositoryException {
        if (!this.isBranchingEnabled()) {
            return OptionalLong.empty();
        }
        HashSet<String> branches = new HashSet<String>(this.repositoryView.listDirectories(this.branchesDirectory));
        branches.add(this.getDefaultBranchName());
        branches.removeIf(name -> knownBranches.contains(name) || !this.isBranchNameIncludedOrDefaultBranch((String)name));
        if (branches.isEmpty()) {
            return OptionalLong.empty();
        }
        return branches.stream().mapToLong(branchName -> this.repositoryView.getFirstCommitTimestamp(this.buildBranchAwarePath("", (String)branchName))).filter(timestamp -> timestamp > 0L).min();
    }

    private Map<String, Long> buildLatestContainedTimestampByBranch(ICommitTree commitTree) throws RepositoryException {
        HashMap<String, Long> latestContainedTimestampByBranch = new HashMap<String, Long>();
        for (String branchName : commitTree.getAllKnownBranchNames()) {
            long timestamp = this.repositoryView.getLogEntry((String)commitTree.getLatestContainedRevisionForBranch(branchName).get()).getTimestamp();
            latestContainedTimestampByBranch.put(branchName, timestamp);
        }
        return latestContainedTimestampByBranch;
    }

    private CommitTreeExpansionResult fillCommitTreeFromLog(ICommitTree commitTree, Map<String, Long> latestContainedTimestampByBranch, long nextScanTimestamp, int maxLogSize) throws RepositoryException {
        int relevantEntriesFound = 0;
        HashSet<ICommitTreeNode> addedNodes = new HashSet<ICommitTreeNode>();
        while (relevantEntriesFound < maxLogSize) {
            List<SvnChangeEntry> logEntries = this.repositoryView.getNextLogEntries(nextScanTimestamp, this.startTimestamp, maxLogSize);
            if (logEntries.isEmpty() && SVNRepositoryConnection.isInitialAnalysis(latestContainedTimestampByBranch, relevantEntriesFound)) {
                logEntries = this.getFirstLogEntries(maxLogSize);
            }
            if (logEntries.isEmpty()) {
                return CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(true).build();
            }
            for (SvnChangeEntry logEntry : logEntries) {
                nextScanTimestamp = Math.max(nextScanTimestamp, logEntry.getTimestamp() + 1L);
                if (logEntry.getTimestamp() > this.endTimestamp || this.ignoredRevisions.contains((int)logEntry.getRevision())) continue;
                HashSet branchNames = CollectionUtils.unionSet(logEntry.getBranchNames(), (Collection[])new Collection[]{CollectionUtils.mapWithException(logEntry.getPaths(), path -> (String)this.splitToBranchNameAndPath((String)path).getFirst())});
                if (this.isInInitialAnalysisAndShouldIncludeDefaultBranch(latestContainedTimestampByBranch, relevantEntriesFound, branchNames)) {
                    ++relevantEntriesFound;
                    addedNodes.add(this.buildCommitTreeNode(commitTree, logEntry, this.getDefaultBranchName()));
                }
                for (String branchName : branchNames) {
                    if (SVNRepositoryConnection.logEntryWasProcessed(logEntry, branchName, latestContainedTimestampByBranch)) continue;
                    ++relevantEntriesFound;
                    addedNodes.add(this.buildCommitTreeNode(commitTree, logEntry, branchName));
                }
            }
        }
        return CommitTreeExpansionResult.builder().withFullyExpanded(false).withPerformedActualWork(true).withAddedNodes(addedNodes).build();
    }

    private boolean isInInitialAnalysisAndShouldIncludeDefaultBranch(Map<String, Long> latestContainedTimestampByBranch, int relevantEntriesFound, Set<String> branchNames) {
        return SVNRepositoryConnection.isInitialAnalysis(latestContainedTimestampByBranch, relevantEntriesFound) && this.isBranchNameIncludedOrDefaultBranch(this.getDefaultBranchName()) && !branchNames.contains(this.getDefaultBranchName());
    }

    private static boolean isInitialAnalysis(Map<String, Long> latestContainedTimestampByBranch, int relevantEntriesFound) {
        return latestContainedTimestampByBranch.isEmpty() && relevantEntriesFound == 0;
    }

    private List<SvnChangeEntry> getFirstLogEntries(int maxLogSize) throws RepositoryException {
        try {
            Optional<SVNLogEntry> firstLogEntryByRevision = SVNUtils.getFirstLogEntry(this.repository, SVNUtils.updateStartRevisionIfTooLate(this.repository, this.startTimestamp));
            if (firstLogEntryByRevision.isEmpty()) {
                return Collections.emptyList();
            }
            long timestamp = firstLogEntryByRevision.get().getDate().getTime();
            return this.repositoryView.getNextLogEntries(timestamp, timestamp, maxLogSize);
        }
        catch (SVNException e) {
            throw new RepositoryException("Failed to check if specified revision window contains path suffix and move it if not.", (Throwable)e);
        }
    }

    private ICommitTreeNode buildCommitTreeNode(ICommitTree commitTree, SvnChangeEntry logEntry, String branchName) throws RepositoryException {
        ArrayList<CommitTreeRevision> parentRevisions = new ArrayList<CommitTreeRevision>(this.determineParentRevisions(logEntry, branchName, commitTree));
        this.addMergeParents(parentRevisions, logEntry, branchName, commitTree);
        CommitTreeRevision revision = new CommitTreeRevision(logEntry.getCompositeRevision(), branchName);
        SVNRepositoryConnection.logYoungerParents(revision, parentRevisions);
        return commitTree.addNode(revision, logEntry.getTimestamp(), parentRevisions, arg_0 -> ((Logger)LOGGER).warn(arg_0));
    }

    private static void logYoungerParents(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) {
        Pair<String, Long> childRev = SVNRepositoryConnection.splitRemoteAndRevision(revision);
        parentRevisions.stream().filter(parentRev -> {
            Pair<String, Long> rev = SVNRepositoryConnection.splitRemoteAndRevision(revision);
            boolean remotesMatch = ((String)rev.getFirst()).equals(childRev.getFirst());
            return remotesMatch && (Long)rev.getSecond() < (Long)childRev.getSecond();
        }).forEach(youngerParent -> LOGGER.error("Added younger parent {} for revision {} to commit tree.", youngerParent, (Object)revision));
    }

    private static Pair<String, Long> splitRemoteAndRevision(CommitTreeRevision commitTreeRevision) {
        String revision = commitTreeRevision.getRevision();
        if (revision.contains("@")) {
            String[] split = revision.split("@", 2);
            return new Pair((Object)split[1], (Object)Long.parseLong(split[0]));
        }
        return new Pair((Object)"", (Object)Long.parseLong(revision));
    }

    private static boolean logEntryWasProcessed(SvnChangeEntry logEntry, String branchName, Map<String, Long> latestContainedTimestampByBranch) {
        Long timestamp = latestContainedTimestampByBranch.get(branchName);
        return timestamp != null && timestamp >= logEntry.getTimestamp();
    }

    private Map<String, Long> determineLatestTimestampByBranch(Collection<String> branchNames) throws RepositoryException {
        List allPaths = CollectionUtils.map(branchNames, branchName -> this.buildBranchAwarePath("", (String)branchName));
        Map<String, Long> pathToLatestTimestamp = this.repositoryView.getHeadTimestamp(allPaths);
        HashMap<String, Long> latestTimestampByBranch = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry : pathToLatestTimestamp.entrySet()) {
            String branchName2 = (String)this.splitToBranchNameAndPath(entry.getKey()).getFirst();
            latestTimestampByBranch.put(branchName2, entry.getValue());
        }
        return latestTimestampByBranch;
    }

    private static OptionalLong determineNextScanTimestamp(Map<String, Long> latestContainedTimestampByBranch, Map<String, Long> latestTimestampInRepoByBranch) {
        if (latestContainedTimestampByBranch.isEmpty()) {
            return OptionalLong.of(1L);
        }
        ArrayList<Long> nextScanTimestamps = new ArrayList<Long>();
        for (Map.Entry<String, Long> entry : latestContainedTimestampByBranch.entrySet()) {
            long repoHeadTimestamp = latestTimestampInRepoByBranch.get(entry.getKey());
            if (entry.getValue() >= repoHeadTimestamp && (repoHeadTimestamp != -1L || entry.getValue() >= System.currentTimeMillis())) continue;
            nextScanTimestamps.add(entry.getValue() + 1L);
        }
        return nextScanTimestamps.stream().mapToLong(x -> x).min();
    }

    private List<CommitTreeRevision> determineParentRevisions(SvnChangeEntry logEntry, String branchName, ICommitTree commitTree) throws RepositoryException {
        HashSet<String> originBranchNames = new HashSet<String>();
        HashSet<CommitDescriptor> originCommits = new HashSet<CommitDescriptor>();
        boolean hadEntriesWithoutOrigin = false;
        if (this.isBranchingEnabled()) {
            for (RepositoryChangeInfo entry : logEntry.getAffectedPaths().extractSecondList()) {
                if (entry.getOriginPath() != null) {
                    originCommits.add(entry.getOriginCommit());
                    originBranchNames.add((String)this.splitToBranchNameAndPath(entry.getOriginPath().toString()).getFirst());
                    continue;
                }
                if (entry.getChangeType() == ERepositoryChangeType.DELETE) continue;
                hadEntriesWithoutOrigin = true;
            }
            this.addOriginBranchNamesFromModifiedDirectories(logEntry, originBranchNames);
        }
        if (!this.isBranchingEnabled() || hadEntriesWithoutOrigin || originBranchNames.size() != 1 || originBranchNames.contains(branchName) || originCommits.isEmpty()) {
            Optional latestContained = commitTree.getLatestContainedRevisionForBranch(branchName);
            if (latestContained.isPresent()) {
                return Collections.singletonList(new CommitTreeRevision((String)latestContained.get(), branchName));
            }
            for (String originBranchName : originBranchNames) {
                latestContained = commitTree.getLatestContainedRevisionForBranch(originBranchName);
                if (!latestContained.isPresent()) continue;
                return Collections.singletonList(new CommitTreeRevision((String)latestContained.get(), originBranchName));
            }
            return Collections.emptyList();
        }
        return this.resolveOriginRevision((String)CollectionUtils.getAny(originBranchNames), (CommitDescriptor)originCommits.stream().max(CommitDescriptor::compareTo).get(), commitTree);
    }

    private void addOriginBranchNamesFromModifiedDirectories(SvnChangeEntry logEntry, Set<String> originBranchNames) {
        for (String directory : logEntry.getRootRepoModifiedDirectories()) {
            String branchNameFromDirectory;
            if ("trunk".equals(directory)) {
                originBranchNames.add("trunk");
                continue;
            }
            if (!directory.startsWith(this.branchesDirectory + SEPARATOR) || (branchNameFromDirectory = StringUtils.stripPrefix((String)directory, (String)(this.branchesDirectory + SEPARATOR))).contains(SEPARATOR)) continue;
            originBranchNames.add(branchNameFromDirectory);
        }
    }

    private List<CommitTreeRevision> resolveOriginRevision(String originBranchName, CommitDescriptor originCommit, ICommitTree commitTree) {
        Optional originRevision = Optional.empty();
        if (originCommit.getTimestamp() >= this.startTimestamp) {
            originRevision = commitTree.resolveLatestRevisionBefore(originBranchName, originCommit.getTimestamp());
        }
        return originRevision.map(s -> Collections.singletonList(new CommitTreeRevision(s, originBranchName))).orElse(Collections.emptyList());
    }

    private void addMergeParents(List<CommitTreeRevision> parentRevisions, SvnChangeEntry logEntry, String branchName, ICommitTree commitTree) throws RepositoryException {
        if (parentRevisions.isEmpty()) {
            return;
        }
        String workingCopyPath = SvnExternalTarget.trimSlashes(this.buildBranchAwarePath("", branchName));
        if (!this.isBranchingEnabled() || !logEntry.getRootRepoModifiedDirectories().contains(workingCopyPath)) {
            if (!CollectionUtils.map(parentRevisions, CommitTreeRevision::getBranchName).contains(branchName) && SVNUtils.directoryExists(workingCopyPath, logEntry.getRevision() - 1L, this.repository)) {
                Optional latestContained = commitTree.getLatestContainedRevisionForBranch(branchName);
                if (latestContained.isEmpty()) {
                    return;
                }
                CommitTreeRevision latestContainedRevision = new CommitTreeRevision((String)latestContained.get(), branchName);
                parentRevisions.clear();
                parentRevisions.add(latestContainedRevision);
            }
            return;
        }
        SVNDiffClient diffClient = this.repositoryView.getClientManager().getDiffClient();
        try {
            SVNURL path = this.repository.getLocation().appendPath(workingCopyPath, false);
            Map mergeInfos = diffClient.doGetMergedMergeInfo(path, SVNRevision.create((long)logEntry.getRevision()));
            if (mergeInfos == null) {
                return;
            }
            Map<SVNURL, SVNMergeRangeList> oldMergeInfos = SVNRepositoryConnection.getOldMergeInfos(logEntry, diffClient, path);
            this.processMergeInfosAndUpdateParentRevisions(mergeInfos, oldMergeInfos, branchName, parentRevisions, commitTree, logEntry);
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private void processMergeInfosAndUpdateParentRevisions(Map<SVNURL, SVNMergeRangeList> mergeInfos, Map<SVNURL, SVNMergeRangeList> oldMergeInfos, String branchName, List<CommitTreeRevision> parentRevisions, ICommitTree commitTree, SvnChangeEntry logEntry) throws RepositoryException {
        block0: for (Map.Entry<SVNURL, SVNMergeRangeList> mergeInfo : mergeInfos.entrySet()) {
            Optional<String> mergeBranchName;
            long oldMaxValue;
            SVNURL url = mergeInfo.getKey();
            long currentMaxValue = SVNRepositoryConnection.getMaxRevision(mergeInfo.getValue());
            if (currentMaxValue <= (oldMaxValue = SVNRepositoryConnection.getMaxRevision(oldMergeInfos.get(url))) || (mergeBranchName = this.computeMergeBranchName(url, logEntry, branchName)).isEmpty() || branchName.equals(mergeBranchName.get())) continue;
            for (long svnRevision = currentMaxValue; svnRevision > oldMaxValue; --svnRevision) {
                CommitTreeRevision commitTreeRevision = new CommitTreeRevision(this.repositoryView.resolveMainRepositoryRevision(svnRevision), mergeBranchName.get());
                if (!commitTree.nodeExists(commitTreeRevision)) continue;
                parentRevisions.add(commitTreeRevision);
                continue block0;
            }
        }
    }

    private Optional<String> computeMergeBranchName(SVNURL url, SvnChangeEntry logEntry, String branchName) {
        String decodedLocation = this.repository.getLocation().toDecodedString();
        String decodedUrlWithPath = url.toDecodedString();
        String relativePath = StringUtils.stripPrefix((String)decodedUrlWithPath, (String)(decodedLocation + SEPARATOR));
        LOGGER.trace("Stripping repository url prefix '{}' from path '{}' resulted in '{}'.", (Object)decodedLocation, (Object)decodedUrlWithPath, (Object)relativePath);
        try {
            return Optional.of((String)this.splitToBranchNameAndPath(relativePath + SEPARATOR).getFirst());
        }
        catch (RepositoryException e) {
            LOGGER.warn("Encountered invalid merge path '" + String.valueOf(url) + "' in merge infos on branch " + branchName + " from log entry " + String.valueOf(logEntry), (Throwable)e);
            return Optional.empty();
        }
    }

    private static Map<SVNURL, SVNMergeRangeList> getOldMergeInfos(SvnChangeEntry logEntry, SVNDiffClient diffClient, SVNURL path) {
        Map oldMergeInfos = null;
        try {
            oldMergeInfos = diffClient.doGetMergedMergeInfo(path, SVNRevision.create((long)(logEntry.getRevision() - 1L)));
        }
        catch (SVNException sVNException) {
            // empty catch block
        }
        if (oldMergeInfos == null) {
            return new HashMap<SVNURL, SVNMergeRangeList>();
        }
        return oldMergeInfos;
    }

    private static long getMaxRevision(SVNMergeRangeList mergeRangeList) {
        if (mergeRangeList == null) {
            return 0L;
        }
        return mergeRangeList.getRangesAsList().stream().mapToLong(SVNMergeRange::getEndRevision).max().orElse(0L);
    }

    @Override
    protected void updateLiveBranches(ICommitTree commitTree) throws RepositoryException {
        HashSet<String> allBranches = new HashSet<String>();
        allBranches.add(this.getDefaultBranchName());
        if (this.isBranchingEnabled()) {
            try {
                allBranches.addAll(CollectionUtils.filter(this.determineBranchesOnEndRevisionOrHead(), x$0 -> this.isBranchNameIncluded((String)x$0)));
            }
            catch (SVNException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        commitTree.setLiveBranchNames(allBranches);
    }

    private List<String> determineBranchesOnEndRevisionOrHead() throws SVNException, RepositoryException {
        ArrayList<String> branches = new ArrayList<String>();
        if (!this.getCodePatternSupport().isExplicitlyExcluded("trunk")) {
            branches.add("trunk");
        }
        long endRevision = SVNUtils.getEndRevision(this.repository, this.endTimestamp);
        try {
            SVNUtils.runWithRetry(() -> {
                ArrayList entries = new ArrayList();
                this.repository.getDir(this.branchesDirectory, endRevision, null, 1, entries);
                branches.addAll(CollectionUtils.filterAndMap(entries, entry -> entry.getKind() == SVNNodeKind.DIR, SVNDirEntry::getName));
            }, e -> LOGGER.warn("Failed to retrieve branches! Retrying.", (Throwable)e), (ConsumerWithException<SVNException, SVNException>)((ConsumerWithException)e -> {
                throw e;
            }));
        }
        catch (SVNException e2) {
            SVNUtils.verifyRepositoryUrlExistsAtRevision(this.repository, endRevision, e2);
            throw new RepositoryException((Throwable)e2);
        }
        return branches;
    }

    @Override
    public String getLocationDescription() {
        return SVNUtils.getSVNRepositoryLocation(this.repository);
    }

    @Override
    public RepositoryChangeSet getChangeSet(CommitTreeRevision revision, CommitTreeRevision parentRevision) throws RepositoryException {
        SvnChangeEntry logEntry = this.repositoryView.getLogEntry(revision.getRevision());
        if (logEntry == null) {
            LOGGER.error("Could not find SvnChangeEntry for revision " + String.valueOf(revision));
            return null;
        }
        RepositoryChangeSet changeSet = this.createChangeSet(revision, logEntry);
        PairList<String, RepositoryChangeInfo> affectedPaths = logEntry.getAffectedPaths();
        for (int i = 0; i < affectedPaths.size(); ++i) {
            Pair<String, String> branchNameAndPath = this.splitToBranchNameAndPath((String)affectedPaths.getFirst(i));
            if (this.isBranchingEnabled() && !((String)branchNameAndPath.getFirst()).equals(revision.getBranchName())) continue;
            String path = (String)branchNameAndPath.getSecond();
            this.insertChangeInfo(path, (RepositoryChangeInfo)affectedPaths.getSecond(i), changeSet);
        }
        return changeSet;
    }

    @Override
    public boolean supportsSkipping() {
        return false;
    }

    private RepositoryChangeSet createChangeSet(CommitTreeRevision revision, SvnChangeEntry logEntry) {
        return new RepositoryChangeSet(revision.getRevision(), revision.getBranchName(), logEntry.getTimestamp(), logEntry.getAuthor(), logEntry.getMessage(), this.getCodePatternSupport(), this.startTimestamp);
    }

    private void insertChangeInfo(String path, RepositoryChangeInfo changeInfo, RepositoryChangeSet changeSet) throws RepositoryException {
        if (changeInfo.getOriginPath() == null) {
            changeSet.addChange(path, changeInfo.getChangeType());
            return;
        }
        Pair<String, String> originBranchNameAndPath = this.splitToBranchNameAndPath(changeInfo.getOriginPath().toString());
        String originPath = (String)originBranchNameAndPath.getSecond();
        CommitDescriptor originCommit = new CommitDescriptor((String)originBranchNameAndPath.getFirst(), changeInfo.getOriginCommit().getTimestamp());
        changeSet.addChange(path, changeInfo.getChangeType(), originPath, originCommit);
    }

    @Override
    public Set<String> crawl(CommitTreeRevision revision) throws RepositoryException {
        Set<String> paths = this.repositoryView.crawl(this.buildBranchAwarePath("", revision.getBranchName()), revision.getRevision());
        return new HashSet<String>(CollectionUtils.mapWithException(paths, path -> (String)this.splitToBranchNameAndPath((String)path).getSecond()));
    }

    @Override
    public IStreamWithException<byte[], RepositoryException> getContent(List<String> paths, CommitTreeRevision revision) throws RepositoryException {
        List branchAwarePaths = CollectionUtils.map(paths, path -> this.buildBranchAwarePath((String)path, revision.getBranchName()));
        LOGGER.debug("Retrieving content for paths:\n{}", new Supplier[]{() -> String.join((CharSequence)"\n", branchAwarePaths)});
        return IStreamWithException.wrap(this.repositoryView.getContent(branchAwarePaths, revision.getRevision()).stream(), RepositoryException.class);
    }

    private String buildBranchAwarePath(String path, String branchName) {
        if (!this.isBranchingEnabled()) {
            return path;
        }
        if ("trunk".equals(branchName)) {
            return "trunk/" + path;
        }
        return this.branchesDirectory + SEPARATOR + branchName + SEPARATOR + path;
    }

    private Pair<String, String> splitToBranchNameAndPath(String path) throws RepositoryException {
        return SVNRepositoryConnection.splitToBranchNameAndPath(path, this.isBranchingEnabled(), this.getDefaultBranchName(), this.branchesDirectory);
    }

    @VisibleForTesting
    static Pair<String, String> splitToBranchNameAndPath(String path, boolean branchingEnabled, String defaultBranchName, String branchesDirectory) throws RepositoryException {
        LOGGER.traceEntry(null, new Object[]{path, branchingEnabled, defaultBranchName, branchesDirectory});
        if (!branchingEnabled) {
            return (Pair)LOGGER.traceExit((Object)new Pair((Object)defaultBranchName, (Object)path));
        }
        int index = path.indexOf(SEPARATOR);
        if (index < 0) {
            throw (RepositoryException)LOGGER.throwing(Level.TRACE, (Throwable)new RepositoryException("Invalid branching path (missing separator): " + path));
        }
        String trunkPrefix = "trunk/";
        if (path.startsWith(trunkPrefix)) {
            return (Pair)LOGGER.traceExit((Object)new Pair((Object)"trunk", (Object)path.substring(trunkPrefix.length())));
        }
        String branchesPrefix = branchesDirectory + SEPARATOR;
        if (!path.startsWith(branchesPrefix)) {
            throw (RepositoryException)LOGGER.throwing(Level.TRACE, (Throwable)new RepositoryException(String.format("Invalid branching path (must start with %2$s or %3$s): %1$s", path, "trunk", branchesDirectory)));
        }
        int endOfBranchNameIndex = path.indexOf(SEPARATOR, branchesPrefix.length() + 1);
        if (endOfBranchNameIndex < 0) {
            return (Pair)LOGGER.traceExit((Object)new Pair((Object)path.substring(branchesPrefix.length()), (Object)""));
        }
        return (Pair)LOGGER.traceExit((Object)new Pair((Object)path.substring(branchesPrefix.length(), endOfBranchNameIndex), (Object)path.substring(endOfBranchNameIndex + 1)));
    }

    private boolean isPathIncluded(String path) throws RepositoryException {
        if (!this.isBranchingEnabled()) {
            return this.isIncluded(path);
        }
        if (this.isNotBranchRelevantPath(path)) {
            return false;
        }
        Pair<String, String> parts = this.splitToBranchNameAndPath(path);
        return this.isBranchNameIncludedOrDefaultBranch((String)parts.getFirst()) && this.isIncluded((String)parts.getSecond());
    }

    private boolean canSubPathsBeIncluded(String path) {
        if (!this.isBranchingEnabled()) {
            return this.getCodePatternSupport().canSubPathsBeIncluded(path);
        }
        if (!path.contains(SEPARATOR)) {
            return true;
        }
        if (this.isNotBranchRelevantPath(path)) {
            return false;
        }
        try {
            Pair<String, String> parts = this.splitToBranchNameAndPath(path);
            return this.isBranchNameIncludedOrDefaultBranch((String)parts.getFirst()) && this.getCodePatternSupport().canSubPathsBeIncluded((String)parts.getSecond());
        }
        catch (RepositoryException e) {
            LOGGER.debug("Obtained invalid path which we do not crawl deeper: " + path, (Throwable)e);
            return false;
        }
    }

    private boolean isNotBranchRelevantPath(String path) {
        return !path.startsWith("trunk/") && !path.startsWith(this.branchesDirectory + SEPARATOR);
    }

    @Override
    public void close() throws RepositoryException {
        try {
            this.repositoryView.close();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        this.repository.closeSession();
    }

    @Override
    public Pair<String, String> getAuthorAndCommitMessage(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) throws RepositoryException {
        SvnChangeEntry logEntry = this.repositoryView.getLogEntry(revision.getRevision());
        return new Pair((Object)logEntry.getAuthor(), (Object)logEntry.getMessage());
    }

    @Override
    public String getEmail(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) {
        return null;
    }

    @Override
    public boolean shouldCacheContent() {
        return true;
    }

    @Override
    public String getRevisionIdentifier(CommitTreeRevision revision) {
        return SVNUtils.getSVNRepositoryLocation(this.repository) + revision.toString();
    }

    public Set<String> getMergedRevisions(ICommitTreeNode commitTreeNode) throws RepositoryException {
        Long mergeRevision = (Long)SvnChangeEntry.parseCompositeRevision(commitTreeNode.getRevision().getRevision()).getFirst();
        HashSet<String> mergedRevisions = new HashSet<String>();
        try {
            this.repository.log(null, mergeRevision.longValue(), mergeRevision.longValue(), false, false, 0L, true, null, svnLogEntry -> {
                String newRevision = String.valueOf(svnLogEntry.getRevision());
                if (newRevision.equals(mergeRevision.toString()) || newRevision.equals("-1")) {
                    return;
                }
                mergedRevisions.add(newRevision);
            });
        }
        catch (SVNException svnException) {
            throw new RepositoryException((Throwable)svnException);
        }
        return mergedRevisions;
    }

    public String getLatestRevisionForDefaultBranch() throws SVNException, RepositoryException {
        List<SVNLogEntry> latest = SVNUtils.getLatestLogEntries(this.getBranchPath(), this.repository, 1);
        if (latest.isEmpty()) {
            return null;
        }
        return Long.toString(latest.get(0).getRevision());
    }

    private String getBranchPath() throws RepositoryException {
        String defaultBranchName = this.getDefaultBranchName();
        if (this.baseParameters.isBranchingEnabled()) {
            return SVNUtils.createBranchUri(this.repository.getLocation().toDecodedString(), this.branchesDirectory, defaultBranchName);
        }
        HashSet<String> firstLevelDirs = new HashSet<String>(this.repositoryView.listDirectories(""));
        if ("trunk".equals(defaultBranchName)) {
            if (firstLevelDirs.contains("trunk")) {
                return SVNUtils.createBranchUri(this.repository.getLocation().toDecodedString(), this.branchesDirectory, defaultBranchName);
            }
            return "";
        }
        if (!firstLevelDirs.contains(this.branchesDirectory)) {
            return "";
        }
        HashSet<String> branches = new HashSet<String>(this.repositoryView.listDirectories(this.branchesDirectory));
        if (branches.contains(defaultBranchName)) {
            return SVNUtils.createBranchUri(this.repository.getLocation().toDecodedString(), this.branchesDirectory, defaultBranchName);
        }
        return "";
    }
}

