/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.google.common.primitives.Ints;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import java.net.URI;
import java.time.format.DateTimeFormatter;
import org.conqat.lib.commons.date.DateTimeUtils;
import org.conqat.lib.commons.string.StringUtils;

public class SVNRevisionRangeErrorCreator {
    private static final DateTimeFormatter TIMESTAMP_REVISION_FORMAT = DateTimeUtils.createDateTimeFormatter((String)"EEE MMM dd yyyy");

    public static String createErrorMessage(String startRevision, String endRevision, URI uri) {
        return "Path '" + String.valueOf(uri) + "' does not exist " + SVNRevisionRangeErrorCreator.buildRevisionErrorMessage(startRevision, endRevision) + ".";
    }

    private static String buildRevisionErrorMessage(String startRevision, String endRevision) {
        boolean hasEndRevision;
        boolean hasStartRevision = !StringUtils.isEmpty((String)startRevision);
        boolean bl = hasEndRevision = !StringUtils.isEmpty((String)endRevision);
        if (!hasStartRevision && !hasEndRevision) {
            return "in this repository";
        }
        if (!hasStartRevision && hasEndRevision) {
            return "until " + SVNRevisionRangeErrorCreator.formatRevision(endRevision);
        }
        if (hasStartRevision && !hasEndRevision) {
            return "from " + SVNRevisionRangeErrorCreator.formatRevision(startRevision);
        }
        if (startRevision.equals(endRevision)) {
            if (SVNRevisionRangeErrorCreator.isRevisionNumeric(startRevision)) {
                return "at " + SVNRevisionRangeErrorCreator.formatRevision(startRevision);
            }
            return "on " + SVNRevisionRangeErrorCreator.formatRevision(startRevision);
        }
        return "between " + SVNRevisionRangeErrorCreator.formatRevision(startRevision) + " and " + SVNRevisionRangeErrorCreator.formatRevision(endRevision);
    }

    private static String formatRevision(String revision) {
        if (SVNRevisionRangeErrorCreator.isRevisionNumeric(revision)) {
            return "revision " + revision;
        }
        return DateTimeUtils.formatTimestamp((long)((Long)ConnectorUtils.getTimestampForDate((String)revision).get()), (DateTimeFormatter)TIMESTAMP_REVISION_FORMAT);
    }

    private static boolean isRevisionNumeric(String revision) {
        return Ints.tryParse((String)revision) != null;
    }
}

