/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.svn;

import com.teamscale.core.accounts.ExternalCredentials;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.core.configuration.EFeatureToggle;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.concurrent.ThreadUtils;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.string.StringUtils;
import org.tmatesoft.svn.core.SVNAuthenticationException;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNLogEntryPath;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.fs.FSRepositoryFactory;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;
import org.tmatesoft.svn.core.wc2.SvnList;
import org.tmatesoft.svn.core.wc2.SvnOperationFactory;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public class SVNUtils {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int MAX_RETRIES = 3;
    private static final int RETRY_DELAY_SECONDS = 10;
    public static final long UNLIMITED = 0x7FFFFFFFFFFFFFFDL;
    public static final String TRUNK_DIR_NAME = "trunk";
    private static final Pattern TRUNK_DIR_PATTERN = Pattern.compile(".*/trunk/?");
    private static final int SVN_CONNECTION_TIMEOUT_MS = Integer.getInteger("com.teamscale.svn.timeout.minutes", 5) * 60 * 1000;
    private static final int ROOT_REPOSITORY_CACHE_SIZE = 200;
    private static final Map<String, SVNURL> ROOT_REPOSITORY_CACHE = Collections.synchronizedMap(new LinkedHashMap<String, SVNURL>(400, 0.6f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, SVNURL> eldest) {
            return this.size() > 200;
        }
    });

    private static void initializeProtocols() {
        DAVRepositoryFactory.setup();
        SVNRepositoryFactoryImpl.setup();
        FSRepositoryFactory.setup();
    }

    public static SVNRepository createRepository(SVNURL url, String username, String password) throws SVNException {
        SVNUtils.initializeProtocols();
        File defaultConfigurationDirectory = SVNWCUtil.getDefaultConfigurationDirectory();
        char[] passwordChar = new char[]{};
        if (password != null) {
            passwordChar = password.toCharArray();
        }
        DefaultSVNAuthenticationManager authManager = new DefaultSVNAuthenticationManager(defaultConfigurationDirectory, false, username, passwordChar, null, null){

            public int getConnectTimeout(SVNRepository repository) {
                int readTimeout = super.getReadTimeout(repository);
                if (readTimeout <= 0) {
                    return SVN_CONNECTION_TIMEOUT_MS;
                }
                return readTimeout;
            }
        };
        SVNRepository repository = SVNRepositoryFactory.create((SVNURL)url, (ISVNSession)ISVNSession.KEEP_ALIVE);
        repository.setAuthenticationManager((ISVNAuthenticationManager)authManager);
        return repository;
    }

    public static SVNRepository createRepository(String url, String username, String password) throws SVNException {
        return SVNUtils.createRepository(SVNURL.parseURIEncoded((String)url), username, password);
    }

    public static boolean isFile(SVNLogEntryPath path, long revision, SVNRepository repository) {
        SVNNodeKind nodeKind = path.getKind();
        return nodeKind == SVNNodeKind.FILE || nodeKind == SVNNodeKind.UNKNOWN && SVNUtils.fileExists(path.getPath(), revision, repository);
    }

    public static boolean fileExists(String path, long revision, SVNRepository repository) {
        try {
            return repository.checkPath(path, revision) == SVNNodeKind.FILE;
        }
        catch (SVNException e) {
            return false;
        }
    }

    public static boolean directoryExists(String path, long revision, SVNRepository repository) {
        try {
            return repository.checkPath(path, revision) == SVNNodeKind.DIR;
        }
        catch (SVNException e) {
            return false;
        }
    }

    public static boolean isDirectory(SVNLogEntryPath path, long revision, SVNRepository repository) {
        try {
            SVNNodeKind nodeKind = path.getKind();
            return nodeKind == SVNNodeKind.DIR || nodeKind == SVNNodeKind.UNKNOWN && repository.checkPath(path.getPath(), revision) == SVNNodeKind.DIR;
        }
        catch (SVNException e) {
            return false;
        }
    }

    public static String getSVNRepositoryLocation(SVNRepository repository) {
        return repository.getLocation().toDecodedString() + "/";
    }

    public static byte[] getBinaryContent(String path, long revision, SVNRepository repository) throws SVNException {
        byte[] byArray;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            repository.getFile(path, revision, null, (OutputStream)outputStream);
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertionError("Can never happen, as we are in memory!", e);
            }
        }
        outputStream.close();
        return byArray;
    }

    public static long getRevisionForTimestamp(SVNRepository repository, long timestamp) throws SVNException {
        Collection logEntries;
        long revision = repository.getDatedRevision(new Date(timestamp + 1L));
        if (revision == 0L) {
            return 0L;
        }
        try {
            logEntries = repository.log(null, null, revision, revision, false, false);
        }
        catch (SVNException e) {
            if (e.getErrorMessage().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                return revision;
            }
            throw e;
        }
        if (logEntries.isEmpty()) {
            return revision;
        }
        CCSMAssert.isTrue((logEntries.size() == 1 ? 1 : 0) != 0, (String)("Expected exactly one log entry for returned revision " + revision + " Entries: " + String.valueOf(logEntries)));
        SVNLogEntry logEntry = (SVNLogEntry)CollectionUtils.getAny((Iterable)logEntries);
        if (Objects.requireNonNull(logEntry).getDate() != null && logEntry.getDate().getTime() > timestamp) {
            return revision - 1L;
        }
        return revision;
    }

    public static Optional<Long> convertRevisionToTimestamp(String revision, SVNRepository repository) throws RepositoryException {
        if (StringUtils.isEmpty((String)revision) || revision.equals("0")) {
            return Optional.empty();
        }
        try {
            long integerRevision = Long.parseLong(revision);
            Optional<SVNLogEntry> firstLogEntryByRevision = SVNUtils.getFirstLogEntryByRevision(repository, integerRevision);
            if (firstLogEntryByRevision.filter(entry -> entry.getDate() == null).isPresent()) {
                throw new RepositoryException("No date set on revision " + revision + " on repository " + repository.getLocation().toDecodedString());
            }
            Optional<Long> timestamp = firstLogEntryByRevision.map(entry -> entry.getDate().getTime());
            if (timestamp.isEmpty()) {
                throw new RepositoryException("Invalid revision " + integerRevision + " provided for URL " + repository.getLocation().toDecodedString());
            }
            return timestamp;
        }
        catch (NumberFormatException e) {
            throw new RepositoryException("Invalid revision number: " + revision);
        }
        catch (SVNException e) {
            throw new RepositoryException("Invalid revision number: " + revision, (Throwable)e);
        }
    }

    public static Optional<SVNLogEntry> getFirstLogEntry(SVNRepository repository, long startTimestamp) throws RepositoryException {
        try {
            long startRevision = Math.max(1L, SVNUtils.getRevisionForTimestamp(repository, startTimestamp));
            return SVNUtils.getFirstLogEntryByRevision(repository, startRevision);
        }
        catch (SVNException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public static Optional<SVNLogEntry> getFirstLogEntryByRevision(SVNRepository repository, long startRevision) throws SVNException {
        long latestRevision;
        ArrayList entries = new ArrayList();
        long endRevision = latestRevision = repository.getLatestRevision();
        while (endRevision >= startRevision) {
            try {
                repository.log(new String[]{""}, startRevision, endRevision, false, true, 1L, entries::add);
            }
            catch (SVNException e) {
                SVNErrorCode errorCode = e.getErrorMessage().getErrorCode();
                if (errorCode == SVNErrorCode.FS_NOT_FOUND) {
                    latestRevision = endRevision;
                    endRevision = Math.min(endRevision - 1L, startRevision + (endRevision - startRevision) / 2L);
                    continue;
                }
                throw e;
            }
            if (!entries.isEmpty()) {
                return Optional.of((SVNLogEntry)entries.get(0));
            }
            startRevision = endRevision + 1L;
            endRevision = Math.min(endRevision + 1L, endRevision + (latestRevision - endRevision) / 2L);
        }
        throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_NOT_FOUND));
    }

    public static List<SVNLogEntry> getLatestLogEntries(String branchPath, SVNRepository repository, int limit) throws SVNException {
        ArrayList<SVNLogEntry> entries = new ArrayList<SVNLogEntry>();
        long endRevision = repository.getLatestRevision();
        repository.log(new String[]{branchPath}, endRevision, 1L, false, true, (long)limit, entries::add);
        return entries;
    }

    public static void runWithRetry(ISvnRunnable runnable, Consumer<SVNException> warningHandler, ConsumerWithException<SVNException, SVNException> fatalHandler) throws SVNException {
        for (int retriesLeft = 3; retriesLeft > 0; --retriesLeft) {
            try {
                runnable.run();
                return;
            }
            catch (SVNException e) {
                if (SVNUtils.isFatal(e) || retriesLeft <= 0) {
                    fatalHandler.accept((Object)e);
                    return;
                }
                warningHandler.accept(e);
                ThreadUtils.sleep((long)10000L);
                continue;
            }
        }
    }

    private static boolean isFatal(SVNException e) {
        SVNErrorCode errorCode = e.getErrorMessage().getErrorCode();
        return errorCode == SVNErrorCode.FS_NOT_FOUND;
    }

    public static SVNURL determineRepositoryRoot(SVNRepository repository, boolean forceConnection) throws SVNException {
        String[] localPathParts;
        String hashKey = SVNUtils.getSVNRepositoryLocation(repository) + ":" + System.identityHashCode(repository.getAuthenticationManager());
        SVNURL rootUrl = ROOT_REPOSITORY_CACHE.get(hashKey);
        if (rootUrl != null) {
            return rootUrl;
        }
        rootUrl = repository.getRepositoryRoot(forceConnection);
        if (SVNUtils.hasUrlAccess(rootUrl, repository.getAuthenticationManager())) {
            ROOT_REPOSITORY_CACHE.put(hashKey, rootUrl);
            return rootUrl;
        }
        for (String localPathPart : localPathParts = StringUtils.stripPrefix((String)repository.getLocation().toDecodedString(), (String)(rootUrl.toDecodedString() + "/")).split("/")) {
            if (!SVNUtils.hasUrlAccess(rootUrl = rootUrl.appendPath(localPathPart, false), repository.getAuthenticationManager())) continue;
            ROOT_REPOSITORY_CACHE.put(hashKey, rootUrl);
            return rootUrl;
        }
        throw new SVNAuthenticationException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.CLIENT_FORBIDDEN_BY_SERVER, (String)("Seems like the client has no access to " + repository.getLocation().toDecodedString())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasUrlAccess(SVNURL url, ISVNAuthenticationManager authenticationManager) throws SVNException {
        SVNRepository repository = null;
        try {
            repository = SVNRepositoryFactory.create((SVNURL)url);
            repository.setAuthenticationManager(authenticationManager);
            if (EFeatureToggle.SVN_THOROUGH_AUTH_CHECK_SUPPORT.isEnabled()) {
                repository.log(new String[]{""}, -1L, -1L, false, false, 1L, logEntry -> {});
            } else {
                repository.testConnection();
            }
            boolean bl = true;
            return bl;
        }
        catch (SVNAuthenticationException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (repository != null) {
                repository.closeSession();
            }
        }
    }

    public static long getEndRevision(SVNRepository repository, long endTimestamp) throws SVNException {
        if (endTimestamp >= 0x7FFFFFFFFFFFFFFDL) {
            return -1L;
        }
        return SVNUtils.getRevisionForTimestamp(repository, endTimestamp);
    }

    public static void verifyRepositoryUrlExistsAtRevision(SVNRepository repository, long revision, SVNException cause) throws RepositoryException {
        if (!SVNUtils.directoryExists("", revision, repository)) {
            Object revisionString = "the latest revision";
            if (revision != -1L) {
                revisionString = "revision " + revision;
            }
            throw new RepositoryException(String.valueOf(repository.getLocation()) + "  does not exist at " + (String)revisionString + ". Please check the path. If the path has been deleted in the past you can analyze the repository up to the deletion by setting a revision where it existed as end revision.", (Throwable)cause);
        }
    }

    public static long updateStartRevisionIfTooLate(SVNRepository repository, long startTimestamp) throws SVNException {
        String fullPath = repository.getLocation().toString().substring(SVNUtils.determineRepositoryRoot(repository, false).toString().length());
        List fullPathSegments = StringUtils.splitWithEscapeCharacter((String)fullPath, (Character)Character.valueOf('/'));
        for (int i = fullPathSegments.size(); i >= 1; --i) {
            String subPath = String.join((CharSequence)"/", fullPathSegments.subList(0, i));
            try {
                SVNDirEntry dirEntry = repository.info(subPath, -1L);
                if (dirEntry == null || dirEntry.getDate().getTime() >= startTimestamp) continue;
                return dirEntry.getDate().getTime();
            }
            catch (SVNAuthenticationException ex) {
                LOGGER.info("No permission to retrieve repository directory {}. Attempting next sub directory.", (Object)subPath);
            }
        }
        return startTimestamp;
    }

    public static Set<String> listFilesInDirectory(String username, String password, SVNURL repositoryURL) throws SVNException {
        return SVNUtils.listFilesInDirectoryWithDepth(username, password, repositoryURL, SVNDepth.IMMEDIATES, false);
    }

    public static Set<String> listFilesInDirectoryRecursively(String username, String password, SVNURL repositoryURL) throws SVNException {
        return SVNUtils.listFilesInDirectoryWithDepth(username, password, repositoryURL, SVNDepth.INFINITY, true);
    }

    private static Set<String> listFilesInDirectoryWithDepth(String username, String password, SVNURL repositoryURL, SVNDepth depth, boolean filesOnly) throws SVNException {
        HashSet<String> paths = new HashSet<String>();
        SVNRevision revision = SVNRevision.HEAD;
        SvnOperationFactory operationFactory = new SvnOperationFactory();
        char[] passwordValue = new char[]{};
        if (password != null) {
            passwordValue = password.toCharArray();
        }
        operationFactory.setAuthenticationManager((ISVNAuthenticationManager)BasicAuthenticationManager.newInstance((String)username, (char[])passwordValue));
        SvnList list = operationFactory.createList();
        list.setDepth(depth);
        list.setRevision(revision);
        list.addTarget(SvnTarget.fromURL((SVNURL)repositoryURL, (SVNRevision)revision));
        list.setReceiver((target, dirEntry) -> {
            String name;
            boolean canAddEntry = true;
            if (filesOnly) {
                boolean bl = canAddEntry = dirEntry.getKind().compareTo((Object)SVNNodeKind.FILE) == 0;
            }
            if ((name = dirEntry.getRelativePath()) != null && !name.isEmpty() && canAddEntry) {
                paths.add(name);
            }
        });
        list.run();
        return paths;
    }

    public static CommitDescriptor determineCommitFromRevision(ExternalCredentials credentials, boolean enableBranchAnalysis, String branchesDirectory, String pathSuffix, String revision, String defaultBranchName) throws SVNException {
        SVNClientManager clientManager = SVNClientManager.newInstance((DefaultSVNOptions)new DefaultSVNOptions(), (String)credentials.username, (String)credentials.password);
        SVNURL svnUrl = SVNURL.parseURIEncoded((String)UniformPathUtils.concatenate((String[])new String[]{credentials.uri, pathSuffix}));
        SVNRevision svnRevision = SVNRevision.create((long)Long.parseLong(revision));
        AtomicLong timestamp = new AtomicLong();
        ArrayList<String> changedPaths = new ArrayList<String>();
        clientManager.getLogClient().doLog(svnUrl, new String[]{""}, svnRevision, svnRevision, svnRevision, false, true, 1L, logEntry -> {
            changedPaths.addAll(logEntry.getChangedPaths().keySet());
            timestamp.set(logEntry.getDate().getTime());
        });
        if (!enableBranchAnalysis) {
            return new CommitDescriptor(defaultBranchName, timestamp.get());
        }
        CounterSet<String> branchNames = SVNUtils.collectAffectedBranchNames(branchesDirectory, pathSuffix, changedPaths);
        String primaryBranchName = (String)branchNames.getKeysByValueDescending().get(0);
        if (branchNames.getValue((Object)defaultBranchName) == branchNames.getValue((Object)primaryBranchName)) {
            primaryBranchName = defaultBranchName;
        }
        if (branchNames.getKeys().size() > 1) {
            LOGGER.warn("SVN revision {} affected multiple branches: [{}]. Assuming that this targets branch '{}' with {} affected path(s).", (Object)revision, (Object)StringUtils.concat((Iterable)branchNames.getKeys(), (String)", "), (Object)primaryBranchName, (Object)branchNames.getValue((Object)primaryBranchName));
        }
        return new CommitDescriptor(primaryBranchName, timestamp.get());
    }

    private static @NonNull CounterSet<String> collectAffectedBranchNames(String branchesDirectory, String pathSuffix, List<String> changedPaths) {
        CounterSet branchNames = new CounterSet();
        String normalizedPathSuffix = StringUtils.ensureStartsWith((String)StringUtils.ensureEndsWith((String)pathSuffix, (String)UniformPathUtils.SEPARATOR), (String)UniformPathUtils.SEPARATOR);
        for (String changedPath : changedPaths) {
            changedPath = StringUtils.ensureStartsWith((String)changedPath, (String)UniformPathUtils.SEPARATOR);
            if ((changedPath = StringUtils.stripPrefix((String)changedPath, (String)normalizedPathSuffix)).startsWith("tags/") && !branchesDirectory.equals("tags")) continue;
            String branchName = StringUtils.stripPrefix((String)changedPath, (String)(branchesDirectory + UniformPathUtils.SEPARATOR));
            branchNames.inc((Object)StringUtils.getFirstPart((String)branchName, (String)UniformPathUtils.SEPARATOR));
        }
        return branchNames;
    }

    public static String createBranchUri(String repositoryUri, String branchesDir, String branchName) {
        if (!branchName.equals(TRUNK_DIR_NAME)) {
            return UniformPathUtils.concatenate((String[])new String[]{branchesDir, branchName});
        }
        if (TRUNK_DIR_PATTERN.matcher(repositoryUri).matches()) {
            return "";
        }
        return TRUNK_DIR_NAME;
    }

    @FunctionalInterface
    public static interface ISvnRunnable {
        public void run() throws SVNException;
    }
}

