/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs;

import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.accounts.ExternalCredentials;
import com.teamscale.core.analysis.configuration.ConnectorUtils;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.committree.ICommitTree;
import com.teamscale.core.committree.ICommitTreeNode;
import com.teamscale.core.rest.client.retry.HttpRequestRetryPolicy;
import com.teamscale.index.repository.ERepositoryChangeType;
import com.teamscale.index.repository.RepositoryChangeSet;
import com.teamscale.index.repository.base.CommitTreeExpansionResult;
import com.teamscale.index.repository.base.RepositoryConnectionBase;
import com.teamscale.index.repository.base.RepositoryConnectorBaseParameterStep;
import com.teamscale.index.repository.tfs.TfsRepositoryInfoIndex;
import com.teamscale.index.repository.tfs.TfsRepositoryUtils;
import com.teamscale.index.repository.tfs.UniformPathCasingIndex;
import com.teamscale.index.repository.tfs.client.IAzureDevOpsTfvcRestApi;
import com.teamscale.index.repository.tfs.client.TfsHttpConnection;
import com.teamscale.index.repository.tfs.client.model.AssociatedWorkItemDto;
import com.teamscale.index.repository.tfs.client.model.AssociatedWorkItemsResponseBody;
import com.teamscale.index.repository.tfs.client.model.ETfvcChangeType;
import com.teamscale.index.repository.tfs.client.model.ETfvcChangesetOrder;
import com.teamscale.index.repository.tfs.client.model.ETfvcRecursionType;
import com.teamscale.index.repository.tfs.client.model.GetChangesetsBody;
import com.teamscale.index.repository.tfs.client.model.GetItemsBody;
import com.teamscale.index.repository.tfs.client.model.TfvcChangeDto;
import com.teamscale.index.repository.tfs.client.model.TfvcChangeTypeDto;
import com.teamscale.index.repository.tfs.client.model.TfvcChangesetDto;
import com.teamscale.index.repository.tfs.client.model.TfvcItemDescriptorDto;
import com.teamscale.index.repository.tfs.client.model.TfvcItemDto;
import com.teamscale.index.repository.tfs.client.model.TfvcMergeSourceDto;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.stream.IStreamWithException;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.ImmutablePair;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.function.ConsumerWithException;
import org.conqat.lib.commons.function.FunctionWithException;
import org.conqat.lib.commons.function.SupplierWithException;
import org.conqat.lib.commons.math.MathUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;
import org.joda.time.format.ISODateTimeFormat;

public class TfsRepositoryConnection
extends RepositoryConnectionBase {
    private static final boolean DISABLE_TFS_CONTENT_CACHE = Boolean.getBoolean("com.teamscale.disable-tfs-content-cache");
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String WORK_ITEM_REFERENCE_PREFIX = "WI#";
    private static final int REVISION_CHUNK_SIZE = 1000;
    private static final Pair<String, CommitDescriptor> EMPTY_ORIGIN_INFO = new Pair(null, null);
    private static final String ITEMS_NOT_FOUND_MESSAGE = "\"message\":\"The items requested either do not exist on the server at the specified versions, or you do not have permission to access them.\"";
    private final String basePath;
    private final String branchPathSuffix;
    private final List<String> branchLookupPaths;
    private final Integer startRevision;
    private final Integer endRevision;
    private final UniformPathCasingIndex uniformPathCasingIndex;
    private final TfsRepositoryInfoIndex repositoryInfoIndex;
    private final Map<Integer, Long> revisionToTimestampCache = new HashMap<Integer, Long>();
    private final IAzureDevOpsTfvcRestApi tfvcVersionControlRestClient;
    private final String serverAddress;
    private final boolean nonBranchedMode;
    private static final TfvcChangeTypeDto BRANCH_OR_MERGE = new TfvcChangeTypeDto(ETfvcChangeType.BRANCH, ETfvcChangeType.MERGE);

    public TfsRepositoryConnection(RepositoryConnectorBaseParameterStep connectorBaseParameterStep, ExternalCredentials credentials, List<String> branchLookupPaths, UniformPathCasingIndex uniformPathCasingIndex, TfsRepositoryInfoIndex repositoryInfoIndex, HttpRequestRetryPolicy retryPolicy, Logger interactionLogger, boolean nonBranchedMode) throws RepositoryException {
        super(connectorBaseParameterStep);
        this.branchLookupPaths = branchLookupPaths;
        this.uniformPathCasingIndex = uniformPathCasingIndex;
        this.repositoryInfoIndex = repositoryInfoIndex;
        this.nonBranchedMode = nonBranchedMode;
        this.branchPathSuffix = connectorBaseParameterStep.getBranchPathSuffix();
        this.serverAddress = credentials.uri;
        LOGGER.debug("Creating TfsHttpConnection for uri '{}'.", (Object)this.serverAddress);
        TfsHttpConnection tfsHttpConnection = new TfsHttpConnection(credentials, retryPolicy, interactionLogger);
        this.tfvcVersionControlRestClient = tfsHttpConnection.createAzureDevOpsTfvcRestClient();
        this.basePath = StringUtils.ensureEndsWith((String)connectorBaseParameterStep.getPathSuffix(), (String)"/");
        this.startRevision = this.determineStartRevision();
        LOGGER.info("Using start revision {}.", (Object)this.startRevision);
        this.endRevision = this.determineEndRevision();
    }

    private Integer determineStartRevision() throws RepositoryException {
        return TfsRepositoryConnection.initRevision(this.getStartDateOrRevision(), (FunctionWithException<ZonedDateTime, Integer, RepositoryException>)((FunctionWithException)date -> this.getFirstRevision((ZonedDateTime)date, false)), (SupplierWithException<OptionalInt, StorageException>)((SupplierWithException)this.repositoryInfoIndex::getStartRevision), (ConsumerWithException<Integer, StorageException>)((ConsumerWithException)this.repositoryInfoIndex::setStartRevision));
    }

    private Integer determineEndRevision() throws RepositoryException {
        return TfsRepositoryConnection.initRevision(this.getEndDateOrRevision(), (FunctionWithException<ZonedDateTime, Integer, RepositoryException>)((FunctionWithException)date -> this.getFirstRevision((ZonedDateTime)date, true)), (SupplierWithException<OptionalInt, StorageException>)((SupplierWithException)this.repositoryInfoIndex::getEndRevision), (ConsumerWithException<Integer, StorageException>)((ConsumerWithException)this.repositoryInfoIndex::setEndRevision));
    }

    private static Integer initRevision(String dateOrRevision, FunctionWithException<ZonedDateTime, Integer, RepositoryException> changeSetIdRetriever, SupplierWithException<OptionalInt, StorageException> cacheReadFunction, ConsumerWithException<Integer, StorageException> cacheWriteFunction) throws RepositoryException {
        try {
            OptionalInt cachedRevision = (OptionalInt)cacheReadFunction.get();
            if (cachedRevision.isPresent()) {
                return cachedRevision.getAsInt();
            }
            if (!StringUtils.isEmpty((String)dateOrRevision)) {
                Optional date = ConnectorUtils.parseDate((String)dateOrRevision);
                if (date.isEmpty()) {
                    int parsedRevision = Integer.parseInt(dateOrRevision);
                    cacheWriteFunction.accept((Object)parsedRevision);
                    return parsedRevision;
                }
                Integer result = (Integer)changeSetIdRetriever.apply((Object)((ZonedDateTime)date.get()));
                cacheWriteFunction.accept((Object)result);
                return result;
            }
            return null;
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private @NonNull Integer getFirstRevision(ZonedDateTime date, boolean older) throws RepositoryException {
        Integer revision = older ? this.getFirstRevisionBefore(date) : this.getFirstRevisionAfter(date);
        if (revision != null) {
            return revision;
        }
        revision = older ? this.getFirstRevisionAfter(date) : this.getFirstRevisionBefore(date);
        if (revision == null) {
            throw new RepositoryException("Could not find any revision for spec " + String.valueOf(date) + ". Please check the connector configuration.");
        }
        return revision;
    }

    private static String getFormattedDateFromCalendar(ZonedDateTime date) {
        return ISODateTimeFormat.dateTimeNoMillis().print(date.toInstant().toEpochMilli());
    }

    private Integer getFirstRevisionAfter(ZonedDateTime date) throws RepositoryException {
        List<TfvcChangesetDto> changesets;
        try {
            changesets = this.tfvcVersionControlRestClient.getChangesetsBetweenDates(TfsRepositoryConnection.getFormattedDateFromCalendar(date), null, this.basePath, 1, ETfvcChangesetOrder.ASCENDING).getChangesets();
        }
        catch (ServiceCallException e) {
            throw new RepositoryException((Throwable)e);
        }
        if (changesets.isEmpty()) {
            return null;
        }
        return changesets.getFirst().getChangesetId();
    }

    private Integer getFirstRevisionBefore(ZonedDateTime date) throws RepositoryException {
        List<TfvcChangesetDto> changesets;
        try {
            changesets = this.tfvcVersionControlRestClient.getChangesetsBetweenDates(null, TfsRepositoryConnection.getFormattedDateFromCalendar(date), this.basePath, 1, ETfvcChangesetOrder.DESCENDING).getChangesets();
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == 400 && e.getMessage().contains("is before any changeset in the repository")) {
                return null;
            }
            throw new RepositoryException((Throwable)e);
        }
        if (changesets.isEmpty()) {
            return null;
        }
        return changesets.getFirst().getChangesetId();
    }

    @Override
    public String getLocationDescription() {
        return this.serverAddress + "/" + this.basePath;
    }

    @Override
    public RepositoryChangeSet getChangeSet(CommitTreeRevision revision, CommitTreeRevision parentRevision) throws RepositoryException {
        try {
            LOGGER.debug("Calculating change set for revision {}, parent revision is {}.", (Object)revision, (Object)parentRevision);
            TfvcChangesetDto tfsChangeset = this.getChangeSet(revision);
            LOGGER.debug("Retrieved changeset with ID {}.", (Object)tfsChangeset.getChangesetId());
            RepositoryChangeSet teamscaleChangeSet = this.createChangeSet(revision, tfsChangeset, parentRevision);
            LOGGER.debug("Teamscale changeset: {}.", (Object)teamscaleChangeSet.toString());
            return teamscaleChangeSet;
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    @Override
    public boolean supportsSkipping() {
        return false;
    }

    private TfvcChangesetDto getChangeSet(CommitTreeRevision revision) throws ServiceCallException {
        LOGGER.info("Getting changeset from TFS for revision {}.", (Object)revision);
        return this.tfvcVersionControlRestClient.getChangeset(Integer.parseInt(revision.getRevision()), 0);
    }

    private @NonNull RepositoryChangeSet createChangeSet(CommitTreeRevision revision, TfvcChangesetDto changeSet, @Nullable CommitTreeRevision parentRevision) throws RepositoryException, StorageException, ServiceCallException {
        LOGGER.debug("Retrieving changes for changeset with ID {}.", (Object)changeSet.getChangesetId());
        List<TfvcChangeDto> changes = this.tfvcVersionControlRestClient.getChangesForChangeset(changeSet.getChangesetId(), 0x7FFFFFFE).getChanges();
        LOGGER.info("Got {} changes for revision {}.", (Object)changes.size(), (Object)changeSet.getChangesetId());
        changes.forEach(change -> LOGGER.debug("- Change: {}, is Branch: {}, is Folder: {}, changeset ID {}.", (Object)change.getItem().getPath(), (Object)change.getItem().getIsBranch(), (Object)change.getItem().getIsFolder(), (Object)change.getItem().getChangesetId()));
        String basePath = this.getBasePath(revision.getBranchName());
        LOGGER.info("Base path is {}.", (Object)basePath);
        RepositoryChangeSet result = this.createRepositoryChangeSet(revision, changeSet);
        this.insertChangesIntoChangeSet(changes, result, revision, revision, parentRevision);
        LOGGER.info("Repo change set for revision {}, parent branch {} and revision branch {} is {}.", (Object)revision, (Object)Objects.requireNonNullElse(parentRevision, revision).getBranchName(), (Object)revision.getBranchName(), (Object)result.toString());
        return result;
    }

    private RepositoryChangeSet createRepositoryChangeSet(CommitTreeRevision revision, TfvcChangesetDto changeSet) throws ServiceCallException {
        String message = this.getChangeSetMessage(changeSet);
        CommitDescriptor commit = new CommitDescriptor(revision.getBranchName(), changeSet.getDate().getTime());
        return new RepositoryChangeSet(revision.getRevision(), commit, changeSet.getAuthor().getUniqueName(), message, this.getCodePatternSupport(), this.obtainTimestampForRevision(this.startRevision));
    }

    private String getChangeSetMessage(TfvcChangesetDto changeSet) {
        String message = changeSet.getComment();
        if (message == null) {
            message = "";
        }
        try {
            AssociatedWorkItemsResponseBody queryResult = this.tfvcVersionControlRestClient.getAssociatedWorkItems(changeSet.getChangesetId());
            List<AssociatedWorkItemDto> associatedWorkItems = queryResult.getAssociatedWorkItems();
            if (CollectionUtils.isNullOrEmpty(associatedWorkItems)) {
                return message;
            }
            List prefixedWorkItems = CollectionUtils.map(associatedWorkItems, workItem -> WORK_ITEM_REFERENCE_PREFIX + String.valueOf(workItem));
            return message + " (" + StringUtils.concat((Iterable)prefixedWorkItems, (String)", ") + ")";
        }
        catch (ServiceCallException e) {
            LOGGER.error("Failed to fetch associated work items for change set {}", (Object)changeSet.getChangesetId(), (Object)e);
            return message;
        }
    }

    private void insertChangesIntoChangeSet(List<TfvcChangeDto> changes, RepositoryChangeSet result, CommitTreeRevision commitRevision, CommitTreeRevision currentRevision, CommitTreeRevision parentRevision) throws RepositoryException, StorageException, ServiceCallException {
        LOGGER.debug("Inserting {} changes into change set for revision {}.", (Object)changes.size(), (Object)commitRevision);
        HashSet<TfvcChangeDto> deleteChanges = new HashSet<TfvcChangeDto>();
        HashSet<TfvcChangeDto> otherChanges = new HashSet<TfvcChangeDto>();
        TfsRepositoryConnection.sortChangesIntoDeletedOrElse(deleteChanges, otherChanges, changes);
        CaseInsensitiveStringSet previouslyExistingPaths = TfsRepositoryUtils.getPreviouslyExistingPaths(otherChanges, this.tfvcVersionControlRestClient, currentRevision, parentRevision, this.basePath);
        CaseInsensitiveStringSet nowExistingPaths = TfsRepositoryUtils.getNowExistingPaths(otherChanges, this.tfvcVersionControlRestClient, currentRevision);
        Set<String> branches = this.listBranches();
        for (TfvcChangeDto change : changes) {
            Optional<ERepositoryChangeType> optionalChangeType;
            String path = change.getItem().getPath();
            if (change.getItem().getIsBranch() || change.getItem().getIsFolder() || !this.startsWithBasePath(path, commitRevision.getBranchName()) || (optionalChangeType = this.determineChangeType(currentRevision, parentRevision, change, deleteChanges, nowExistingPaths, previouslyExistingPaths)).isEmpty()) continue;
            ERepositoryChangeType changeType = optionalChangeType.get();
            String pathWithoutBasePath = this.stripBasePath(path, commitRevision.getBranchName());
            String casedPath = this.uniformPathCasingIndex.getCasedPath(pathWithoutBasePath, changeType);
            Pair<String, CommitDescriptor> originInfo = this.obtainOriginInfo(change, changeType, branches);
            if (originInfo.getSecond() != null && !commitRevision.getBranchName().equals(((CommitDescriptor)originInfo.getSecond()).getBranchName())) {
                String originPath = this.uniformPathCasingIndex.getCasedPath((String)originInfo.getFirst(), ERepositoryChangeType.DELETE);
                if (changeType == ERepositoryChangeType.ADD && !casedPath.equals(originPath)) {
                    result.addChange(originPath, ERepositoryChangeType.DELETE, null, null);
                }
                originInfo = EMPTY_ORIGIN_INFO;
            }
            result.addChange(casedPath, changeType, (String)originInfo.getFirst(), (CommitDescriptor)originInfo.getSecond());
            if (changeType != ERepositoryChangeType.ADD) continue;
            this.uniformPathCasingIndex.addPath(casedPath);
        }
    }

    private static void sortChangesIntoDeletedOrElse(Set<TfvcChangeDto> deleteChanges, Set<TfvcChangeDto> otherChanges, List<TfvcChangeDto> changes) {
        changes.forEach(change -> {
            if (change.getChangeType().contains(ETfvcChangeType.DELETE)) {
                deleteChanges.add((TfvcChangeDto)change);
                return;
            }
            otherChanges.add((TfvcChangeDto)change);
        });
    }

    private Optional<ERepositoryChangeType> determineChangeType(CommitTreeRevision currentRevision, @Nullable CommitTreeRevision parentRevision, TfvcChangeDto change, Set<TfvcChangeDto> deleteChanges, CaseInsensitiveStringSet nowExistingPaths, CaseInsensitiveStringSet previouslyExistingPaths) {
        boolean existedPreviously = previouslyExistingPaths.contains((Object)TfsRepositoryUtils.replaceNewWithOldBranchInPath(change.getItem().getPath(), currentRevision, parentRevision, this.basePath));
        boolean existsNow = nowExistingPaths.contains((Object)change.getItem().getPath());
        if (existsNow) {
            if (existedPreviously) {
                return Optional.of(ERepositoryChangeType.EDIT);
            }
            return Optional.of(ERepositoryChangeType.ADD);
        }
        if (existedPreviously || deleteChanges.contains(change)) {
            return Optional.of(ERepositoryChangeType.DELETE);
        }
        LOGGER.warn("{} was mentioned in changeset at revision {}, but did neither exist on this nor the previous revision {}.", (Object)change.getItem().getPath(), (Object)currentRevision.getRevision(), (Object)TfsRepositoryUtils.getPreviousRevisionString(currentRevision, parentRevision));
        return Optional.empty();
    }

    private boolean startsWithBasePath(String path, String branchName) {
        return StringUtils.startsWithIgnoreCase((String)path, (String)this.getBasePath(branchName));
    }

    private String stripBasePath(String path, String branchName) {
        return StringUtils.stripPrefixIgnoreCase((String)path, (String)this.getBasePath(branchName));
    }

    private Pair<String, CommitDescriptor> obtainOriginInfo(TfvcChangeDto change, ERepositoryChangeType changeType, Set<String> branches) throws RepositoryException, ServiceCallException {
        List<TfvcMergeSourceDto> mergeSources = change.getMergeSources();
        LOGGER.debug("Obtaining origin info for {}.", (Object)change.getItem().getPath());
        if (changeType != ERepositoryChangeType.ADD || mergeSources == null || mergeSources.isEmpty()) {
            LOGGER.debug("Returning empty origin due to change type or empty merge sources.");
            return EMPTY_ORIGIN_INFO;
        }
        for (TfvcMergeSourceDto mergeSource : mergeSources) {
            Pair<String, CommitDescriptor> origin = this.getOriginInfoFromMergeSource(mergeSource, branches);
            if (origin == null) continue;
            LOGGER.debug("Found origin info {}.", origin);
            return origin;
        }
        LOGGER.debug("Returning empty origin info.");
        return EMPTY_ORIGIN_INFO;
    }

    private @Nullable Pair<String, CommitDescriptor> getOriginInfoFromMergeSource(TfvcMergeSourceDto mergeSource, Set<String> branches) throws RepositoryException, ServiceCallException {
        String mergeSourceBranchName = this.getBranchForMergeSource(branches, mergeSource);
        LOGGER.debug("Getting origin for merge source {}, mergeSourceBranchName {}, and branches {}.", (Object)mergeSource.getServerItem(), (Object)mergeSourceBranchName, branches);
        if (mergeSourceBranchName == null) {
            LOGGER.debug("Could not find merge request source branch. Returning null.");
            return null;
        }
        if (!this.startsWithBasePath(mergeSource.getServerItem(), mergeSourceBranchName)) {
            LOGGER.debug("No shared base path, returning null.");
            return null;
        }
        String originPath = this.stripBasePath(mergeSource.getServerItem(), mergeSourceBranchName);
        LOGGER.debug("Origin path is {}.", (Object)originPath);
        if (!this.isIncluded(originPath)) {
            LOGGER.debug("Origin path '{}' is not included. Returning null.", (Object)originPath);
            return null;
        }
        if (!this.isFile(mergeSource.getServerItem(), mergeSource.getVersionFrom())) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = mergeSource::getServerItem;
            supplierArray[1] = mergeSource::getVersionFrom;
            LOGGER.debug("Merge source item '{}' from version '{}' is not a file. Returning null.", supplierArray);
            return null;
        }
        originPath = this.uniformPathCasingIndex.getCasedPath(originPath, null);
        CommitDescriptor commitDescriptor = new CommitDescriptor(mergeSourceBranchName, this.obtainTimestampForRevision(mergeSource.getVersionFrom()));
        LOGGER.debug("Returning {} for {} as origin info.", (Object)commitDescriptor, (Object)mergeSource.getVersionFrom());
        return new Pair((Object)originPath, (Object)commitDescriptor);
    }

    private boolean isFile(String itemPath, Integer revision) {
        List<TfvcItemDto> items;
        try {
            items = this.tfvcVersionControlRestClient.getItems(new GetItemsBody(new TfvcItemDescriptorDto(itemPath, String.valueOf(revision), ETfvcRecursionType.NONE))).getItemSets().getFirst();
        }
        catch (ServiceCallException e) {
            LOGGER.warn("Error checking type of item with path {}: {}.", (Object)itemPath, (Object)e, (Object)e);
            return false;
        }
        if (items.size() != 1) {
            return false;
        }
        TfvcItemDto item = items.getFirst();
        return item != null && !item.getIsBranch() && !item.getIsFolder();
    }

    @Override
    public Set<String> crawl(CommitTreeRevision revision) throws RepositoryException {
        String branchName = revision.getBranchName();
        try {
            return this.getFilePaths(revision.getRevision(), branchName);
        }
        catch (ServiceCallException | RepositoryException | StorageException e) {
            throw new RepositoryException(e);
        }
    }

    private @NonNull Set<String> getFilePaths(String revision, String branchName) throws ServiceCallException, RepositoryException, StorageException {
        List<TfvcItemDto> items = this.getFileItemsInBranch(branchName, revision);
        HashSet<String> paths = new HashSet<String>();
        for (String path : this.convertItemsToPaths(items, branchName)) {
            String casedPath = this.uniformPathCasingIndex.getCasedPath(path, ERepositoryChangeType.ADD);
            paths.add(casedPath);
            this.uniformPathCasingIndex.addPath(casedPath);
        }
        return paths;
    }

    private List<TfvcItemDto> getFileItemsInBranch(String branchName, String revision) throws ServiceCallException {
        List items;
        try {
            items = this.tfvcVersionControlRestClient.getItems(new GetItemsBody(new TfvcItemDescriptorDto(this.getBasePath(branchName), revision, ETfvcRecursionType.FULL))).getItemSets().stream().flatMap(Collection::stream).toList();
        }
        catch (ServiceCallException e) {
            if (TfsRepositoryConnection.isTfvcItemNotFoundException(e)) {
                LOGGER.warn("While fetching files for branch {} at revision {}: The branch does not exist at the given revision or Teamscale does not have permission to access it. Returning empty list.", (Object)branchName, (Object)revision);
                return new ArrayList<TfvcItemDto>();
            }
            throw e;
        }
        return items.stream().filter(item -> !item.getIsBranch() && !item.getIsFolder()).toList();
    }

    private static boolean isTfvcItemNotFoundException(ServiceCallException e) {
        return e.getResponseBody().contains(ITEMS_NOT_FOUND_MESSAGE);
    }

    private Set<String> convertItemsToPaths(List<TfvcItemDto> items, String branchName) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (TfvcItemDto item : items) {
            String path;
            if (!this.startsWithBasePath(item.getPath(), branchName) || !this.isIncluded(path = this.stripBasePath(item.getPath(), branchName))) continue;
            result.add(path);
        }
        return result;
    }

    @Override
    public IStreamWithException<byte[], RepositoryException> getContent(List<String> paths, CommitTreeRevision revision) throws RepositoryException {
        List fullItemPaths = CollectionUtils.map(paths, path -> this.getFullItemPath((String)path, revision.getBranchName()));
        try {
            return IStreamWithException.wrap(TfsRepositoryUtils.getItemContents(revision.getRevision(), fullItemPaths, this.tfvcVersionControlRestClient).stream(), RepositoryException.class);
        }
        catch (ServiceCallException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private String getFullItemPath(String path, String branchName) {
        return this.getBasePath(branchName) + path;
    }

    private String getBasePath(String branchName) {
        return TfsRepositoryUtils.getBasePath(this.basePath, branchName, this.branchPathSuffix, this.nonBranchedMode);
    }

    private long obtainTimestampForRevision(Integer revision) throws ServiceCallException {
        if (revision == null) {
            return -1L;
        }
        if (this.revisionToTimestampCache.containsKey(revision)) {
            return this.revisionToTimestampCache.get(revision);
        }
        long timestamp = this.tfvcVersionControlRestClient.getChangeset(revision, 0).getDate().getTime();
        this.revisionToTimestampCache.put(revision, timestamp);
        return timestamp;
    }

    private Map<Integer, Long> obtainTimestampsForRevisionBatch(List<Integer> revisions) throws ServiceCallException {
        ArrayList<Integer> changesetIdsToFetch = new ArrayList<Integer>();
        HashMap<Integer, Long> revisionsToTimestamps = new HashMap<Integer, Long>();
        for (int revision : revisions) {
            if (this.revisionToTimestampCache.containsKey(revision)) {
                revisionsToTimestamps.put(revision, this.revisionToTimestampCache.get(revision));
                continue;
            }
            changesetIdsToFetch.add(revision);
        }
        if (!changesetIdsToFetch.isEmpty()) {
            List<TfvcChangesetDto> changesets = this.tfvcVersionControlRestClient.getChangesetBatch(new GetChangesetsBody(changesetIdsToFetch)).getChangesets();
            for (TfvcChangesetDto changeset : changesets) {
                long timestamp = changeset.getDate().getTime();
                revisionsToTimestamps.put(changeset.getChangesetId(), timestamp);
                this.revisionToTimestampCache.put(changeset.getChangesetId(), timestamp);
            }
        }
        return revisionsToTimestamps;
    }

    @VisibleForTesting
    Set<String> listBranches() throws RepositoryException {
        if (!this.isBranchingEnabled()) {
            return Collections.singleton(this.getDefaultBranchName());
        }
        return this.getBranches(true);
    }

    private String getBranchForMergeSource(Set<String> allBranches, TfvcMergeSourceDto mergeSource) {
        for (String branch : allBranches) {
            if (!this.startsWithBasePath(mergeSource.getServerItem(), branch)) continue;
            return branch;
        }
        return null;
    }

    private UnmodifiableSet<String> getBranches(boolean includeDeleted) throws RepositoryException {
        if (this.nonBranchedMode) {
            return CollectionUtils.asUnmodifiable(Collections.emptySet());
        }
        Object paths = CollectionUtils.emptyList();
        if (!this.branchLookupPaths.isEmpty()) {
            paths = this.branchLookupPaths;
        }
        return CollectionUtils.asUnmodifiable(new HashSet<String>(TfsRepositoryUtils.listBranchesForPaths(this.tfvcVersionControlRestClient, this.basePath, (List<String>)paths, this.getBranchPatternSupport(), includeDeleted)));
    }

    private int getLatestChangesetId() throws ServiceCallException {
        List<TfvcChangesetDto> changesets = this.tfvcVersionControlRestClient.getChangesetsBetweenRevisions(null, null, this.basePath, 1, ETfvcChangesetOrder.DESCENDING).getChangesets();
        CCSMAssert.isNotEmpty(changesets, (String)"Did not receive a latest changeset");
        return changesets.getFirst().getChangesetId();
    }

    @Override
    public CommitTreeExpansionResult expandCommitTreeNodes(ICommitTree commitTree) throws RepositoryException {
        try {
            int toRevision;
            Map<String, Integer> fromRevisionsByBranch;
            PairList<Integer, String> branchRevisions;
            LOGGER.info("Expanding commit tree.");
            int latestChangesetID = this.getLatestChangesetId();
            Set<String> branches = null;
            do {
                if (branches != null) {
                    LOGGER.info("No revisions found. Scanning next revision interval.");
                }
                if (this.hasSeenLatestRevision(latestChangesetID)) {
                    LOGGER.info("Commit tree up to date with latest changeset {}.", (Object)latestChangesetID);
                    return CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(false).build();
                }
                branches = this.listBranches();
                TfsRepositoryConnection.ensureBranchesNotEmpty(branches);
                fromRevisionsByBranch = this.determineFromRevisions(commitTree, branches, latestChangesetID);
                LOGGER.info("Checking for new revisions with from revisions: {}.", fromRevisionsByBranch);
                toRevision = this.determineToRevision(fromRevisionsByBranch, latestChangesetID);
                if (!TfsRepositoryConnection.allBranchesAtRevision(fromRevisionsByBranch, toRevision)) continue;
                LOGGER.info("Reached a configured end commit (exhausted): {}.", (Object)toRevision);
                return CommitTreeExpansionResult.builder().withFullyExpanded(true).withPerformedActualWork(false).build();
            } while ((branchRevisions = this.getRevisions(fromRevisionsByBranch, toRevision, latestChangesetID)).isEmpty());
            Set<ICommitTreeNode> addedNodes = this.processRevisions(commitTree, branches, branchRevisions);
            return CommitTreeExpansionResult.builder().withFullyExpanded(false).withPerformedActualWork(true).withAddedNodes(addedNodes).build();
        }
        catch (ServiceCallException | StorageException e) {
            throw new RepositoryException(e);
        }
    }

    private Set<ICommitTreeNode> processRevisions(ICommitTree commitTree, Set<String> branches, PairList<Integer, String> branchRevisions) throws ServiceCallException {
        LOGGER.info("Processing revisions: {}.", branchRevisions);
        Map<Integer, Long> revisionsToTimestamps = this.obtainTimestampsForRevisionBatch((List<Integer>)branchRevisions.getFirstList());
        HashSet<ICommitTreeNode> addedNodes = new HashSet<ICommitTreeNode>();
        for (int i = 0; i < branchRevisions.size(); ++i) {
            addedNodes.add(this.processRevision(commitTree, branches, (String)branchRevisions.getSecond(i), (Integer)branchRevisions.getFirst(i), revisionsToTimestamps));
        }
        return addedNodes;
    }

    private static void ensureBranchesNotEmpty(Set<String> branches) throws RepositoryException {
        if (branches.isEmpty()) {
            throw new RepositoryException("Could not find any matching branches. Did you provide the correct include patterns?");
        }
    }

    private boolean hasSeenLatestRevision(int latestChangesetID) throws StorageException {
        OptionalInt lastScanRevision = this.repositoryInfoIndex.getLastScanRevision();
        return lastScanRevision.isPresent() && lastScanRevision.getAsInt() >= latestChangesetID;
    }

    private static boolean allBranchesAtRevision(Map<String, Integer> revisionsByBranch, Integer revision) {
        return !revisionsByBranch.isEmpty() && MathUtils.min(revisionsByBranch.values()) > (double)revision.intValue();
    }

    private Map<String, Integer> determineFromRevisions(ICommitTree commitTree, Set<String> branches, int latestChangesetID) throws ServiceCallException, StorageException {
        HashMap<String, Integer> fromRevisions = new HashMap<String, Integer>();
        OptionalInt lastScanRevision = this.repositoryInfoIndex.getLastScanRevision();
        LOGGER.info("Last scan revision: {}.", (Object)lastScanRevision);
        Set<String> knownBranches = this.repositoryInfoIndex.getKnownBranches();
        for (String branch : branches) {
            int fromRevision = knownBranches.contains(branch) && lastScanRevision.isPresent() ? lastScanRevision.getAsInt() + 1 : this.determineFromRevision(branch, commitTree, latestChangesetID);
            fromRevisions.put(branch, fromRevision);
        }
        this.repositoryInfoIndex.setKnownBranches(branches);
        return fromRevisions;
    }

    private int determineFromRevision(String branch, ICommitTree commitTree, int latestChangesetID) throws ServiceCallException {
        Optional latestRevision = commitTree.getLatestContainedRevisionForBranch(branch);
        if (latestRevision.isPresent()) {
            return Integer.parseInt((String)latestRevision.get()) + 1;
        }
        if (this.startRevision != null) {
            LOGGER.info("Using start revision as from revision {}.", (Object)this.startRevision);
            return this.startRevision;
        }
        List<Integer> firstRevision = TfsRepositoryUtils.getRevisionsBetween(this.tfvcVersionControlRestClient, this.getBasePath(branch), 0, latestChangesetID, 1);
        if (!firstRevision.isEmpty()) {
            LOGGER.info("Using first revision on branch {}: {}.", (Object)branch, (Object)firstRevision.getFirst());
            return firstRevision.getFirst();
        }
        return 0;
    }

    private int determineToRevision(Map<String, Integer> fromRevisions, int latestChangesetID) {
        int toRevision = !fromRevisions.isEmpty() ? (int)MathUtils.max(fromRevisions.values()) + 1000 : 1000;
        toRevision = Math.min(toRevision, latestChangesetID);
        if (this.endRevision != null && this.endRevision > 0) {
            toRevision = Math.min(toRevision, this.endRevision);
        }
        return toRevision;
    }

    private ICommitTreeNode processRevision(ICommitTree commitTree, Set<String> branches, String branch, Integer revision, Map<Integer, Long> revisionsToTimestamps) throws ServiceCallException {
        CommitTreeRevision commitTreeRevision = new CommitTreeRevision((long)revision.intValue(), branch);
        List<CommitTreeRevision> parentRevisions = this.determineParentRevisions(commitTree, branches, branch, revision);
        LOGGER.info("Adding commit tree node for {} with parents {}.", (Object)commitTreeRevision, parentRevisions);
        return commitTree.addNode(commitTreeRevision, revisionsToTimestamps.get(revision).longValue(), parentRevisions);
    }

    private List<CommitTreeRevision> determineParentRevisions(ICommitTree commitTree, Set<String> branches, String branch, Integer revision) throws ServiceCallException {
        LOGGER.debug("Determining parent revisions for branch {} and revision {}, with branches: {}.", (Object)branch, (Object)revision, branches);
        ArrayList<CommitTreeRevision> parentRevisions = new ArrayList<CommitTreeRevision>();
        Optional predecessor = commitTree.getLatestContainedRevisionForBranch(branch);
        predecessor.ifPresent(s -> parentRevisions.add(new CommitTreeRevision(s, branch)));
        if (!this.isBranchingEnabled()) {
            return parentRevisions;
        }
        if (predecessor.isEmpty() && !TfsRepositoryUtils.getRevisionsBetween(this.tfvcVersionControlRestClient, this.getBasePath(branch), revision - 1, 1, 0, false).isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, Integer> mergeRevisions = this.getMergeRevisions(branches, revision);
        for (Map.Entry<String, Integer> branchToRevisionEntry : mergeRevisions.entrySet()) {
            String mergeBranch = branchToRevisionEntry.getKey();
            if (mergeBranch.equals(branch)) continue;
            CommitTreeRevision parent = new CommitTreeRevision((long)branchToRevisionEntry.getValue().intValue(), mergeBranch);
            if (commitTree.nodeExists(parent)) {
                parentRevisions.add(parent);
                continue;
            }
            LOGGER.error("Parent not in commit tree: {}.", (Object)parent);
        }
        return parentRevisions;
    }

    private Map<String, Integer> getMergeRevisions(Set<String> branches, Integer revision) throws ServiceCallException {
        List<TfvcChangeDto> changes = this.tfvcVersionControlRestClient.getChangesForChangeset(revision, 0x7FFFFFFE).getChanges();
        List mergeSources = changes.stream().filter(change -> change.getChangeType().containsAny(BRANCH_OR_MERGE)).map(TfvcChangeDto::getMergeSources).filter(Objects::nonNull).flatMap(Collection::stream).toList();
        HashMap<String, Integer> branchToRevision = new HashMap<String, Integer>();
        for (TfvcMergeSourceDto mergeSource : mergeSources) {
            String sourceBranch;
            if (!this.isIncludedMergeSource(mergeSource, sourceBranch = this.getBranchForMergeSource(branches, mergeSource))) continue;
            int sourceRevision = mergeSource.getVersionTo();
            if (branchToRevision.containsKey(sourceBranch) && (Integer)branchToRevision.get(sourceBranch) >= sourceRevision || this.startRevision != null && sourceRevision < this.startRevision) continue;
            branchToRevision.put(sourceBranch, sourceRevision);
        }
        return branchToRevision;
    }

    private boolean isIncludedMergeSource(TfvcMergeSourceDto mergeSource, String mergeSourceBranchName) {
        if (mergeSourceBranchName == null) {
            return false;
        }
        if (!this.isBranchNameIncludedOrDefaultBranch(mergeSourceBranchName)) {
            return false;
        }
        if (!this.startsWithBasePath(mergeSource.getServerItem(), mergeSourceBranchName)) {
            return false;
        }
        String sourcePath = this.stripBasePath(mergeSource.getServerItem(), mergeSourceBranchName);
        return this.isIncluded(sourcePath);
    }

    private PairList<Integer, String> getRevisions(Map<String, Integer> fromRevisionsByBranch, Integer toRevision, int latestChangesetID) throws ServiceCallException, StorageException {
        LOGGER.debug("Fetching revisions, toRevision: {}, latestChangesetID: {}, fromRevisionsByBranch: {}.", (Object)toRevision, (Object)latestChangesetID, fromRevisionsByBranch);
        Set<String> branches = fromRevisionsByBranch.keySet();
        PairList branchRevisions = new PairList();
        for (Map.Entry<String, Integer> revisionByBranchEntry : fromRevisionsByBranch.entrySet()) {
            String branch = revisionByBranchEntry.getKey();
            String path = this.getBasePath(branch);
            if (revisionByBranchEntry.getValue() > latestChangesetID) {
                LOGGER.debug("Skipping branch {} as its from revision is greater than latestChangesetID {}.", (Object)branch, (Object)latestChangesetID);
                continue;
            }
            List<Integer> revisions = TfsRepositoryUtils.getRevisionsBetween(this.tfvcVersionControlRestClient, path, fromRevisionsByBranch.get(branch), toRevision, Integer.MAX_VALUE);
            for (Integer revision : revisions) {
                branchRevisions.add((Object)revision, (Object)branch);
            }
        }
        if (branches.contains(this.getDefaultBranchName())) {
            LOGGER.debug("Ensuring start revision is contained.");
            this.ensureStartRevisionContained(fromRevisionsByBranch.get(this.getDefaultBranchName()), (PairList<Integer, String>)branchRevisions);
        }
        this.repositoryInfoIndex.setLastScanRevision(toRevision);
        CollectionUtils.sortByFirst((PairList)branchRevisions);
        return branchRevisions;
    }

    private void ensureStartRevisionContained(Integer fromRevision, PairList<Integer, String> branchRevisions) throws ServiceCallException {
        if (fromRevision != null && fromRevision > 0 && fromRevision.equals(this.startRevision) && TfsRepositoryConnection.isNotContainedIn(fromRevision, branchRevisions) && !TfsRepositoryUtils.getRevisionsBetween(this.tfvcVersionControlRestClient, "$/", fromRevision, fromRevision, 1).isEmpty()) {
            branchRevisions.add((Object)fromRevision, (Object)this.getDefaultBranchName());
        }
    }

    private static boolean isNotContainedIn(int integer, PairList<Integer, String> pairList) {
        return pairList.stream().map(ImmutablePair::getFirst).noneMatch(first -> first.equals(integer));
    }

    @Override
    protected void updateLiveBranches(ICommitTree commitTree) throws RepositoryException {
        HashSet<String> branches = new HashSet<String>();
        branches.add(this.getDefaultBranchName());
        if (this.isBranchingEnabled()) {
            branches.addAll((Collection<String>)this.getBranches(false));
        }
        commitTree.setLiveBranchNames(branches);
    }

    @Override
    public Pair<String, String> getAuthorAndCommitMessage(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) throws RepositoryException {
        TfvcChangesetDto changeSet;
        try {
            changeSet = this.getChangeSet(revision);
        }
        catch (ServiceCallException e) {
            throw new RepositoryException((Throwable)e);
        }
        String message = this.getChangeSetMessage(changeSet);
        return new Pair((Object)changeSet.getAuthor().getUniqueName(), (Object)message);
    }

    @Override
    public @Nullable String getEmail(CommitTreeRevision revision, List<CommitTreeRevision> parentRevisions) {
        return null;
    }

    @Override
    public boolean shouldCacheContent() {
        return DISABLE_TFS_CONTENT_CACHE;
    }

    @Override
    public String getRevisionIdentifier(CommitTreeRevision revision) {
        return this.serverAddress + this.basePath + revision.toString();
    }

    @VisibleForTesting
    TfsRepositoryInfoIndex getRepositoryInfoIndex() {
        return this.repositoryInfoIndex;
    }
}

