/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.microsoft.tfs.core.clients.versioncontrol.GetItemsOptions;
import com.microsoft.tfs.core.clients.versioncontrol.VersionControlClient;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Changeset;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.DeletedState;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.Item;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemSet;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.ItemType;
import com.microsoft.tfs.core.clients.versioncontrol.soapextensions.RecursionType;
import com.microsoft.tfs.core.clients.versioncontrol.specs.ItemSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.ChangesetVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.LatestVersionSpec;
import com.microsoft.tfs.core.clients.versioncontrol.specs.version.VersionSpec;
import com.teamscale.commons.service.client.ServiceCallException;
import com.teamscale.core.analysis.configuration.index.model.ConnectorConfiguration;
import com.teamscale.core.committree.CommitTreeRevision;
import com.teamscale.core.concurrency.WrappedExecutorServiceProducer;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.repository.tfs.client.IAzureDevOpsTfvcRestApi;
import com.teamscale.index.repository.tfs.client.model.ETfvcChangesetOrder;
import com.teamscale.index.repository.tfs.client.model.ETfvcRecursionType;
import com.teamscale.index.repository.tfs.client.model.ETfvcVersionType;
import com.teamscale.index.repository.tfs.client.model.GetItemsBody;
import com.teamscale.index.repository.tfs.client.model.TfvcBranchRefDto;
import com.teamscale.index.repository.tfs.client.model.TfvcChangeDto;
import com.teamscale.index.repository.tfs.client.model.TfvcChangesetDto;
import com.teamscale.index.repository.tfs.client.model.TfvcItemDescriptorDto;
import com.teamscale.index.repository.tfs.client.model.TfvcItemDto;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.core.pattern.IncludeExcludeRegexSupport;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.lib.commons.collections.CaseInsensitiveStringSet;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.filesystem.FileSystemUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.jetbrains.annotations.VisibleForTesting;

public class TfsRepositoryUtils {
    private static final int MAX_PARALLEL_FILE_DOWNLOAD_THREADS = Integer.parseInt(System.getProperty("com.teamscale.tfs.thread-count", "5"));
    private static final long THREAD_TIMEOUT_IN_MINUTES = 60L;
    private static final Logger LOGGER = LogManager.getLogger();
    @VisibleForTesting
    public static final String ITEMS_DONT_EXIST_OR_NO_ACCESS_MESSAGE_EN = "The items requested either do not exist on the server at the specified versions, or you do not have permission to access them.";
    @VisibleForTesting
    public static final String ITEMS_DONT_EXIST_OR_NO_ACCESS_MESSAGE_DE = "Die angeforderten Elemente sind entweder auf dem Server in den angegebenen Versionen nicht vorhanden oder Sie haben nicht die Berechtigung, darauf zuzugreifen.";

    private static String replaceBranch(String itemPath, String branch, String branchToSet, String basePath) {
        String basePathWithSlash = StringUtils.ensureEndsWith((String)basePath, (String)"/");
        return itemPath.replace(basePathWithSlash + branch, basePathWithSlash + branchToSet);
    }

    public static List<byte @Nullable []> getItemContents(String revision, List<String> itemPaths, IAzureDevOpsTfvcRestApi tfcVersionControlRestClient) throws RepositoryException, ServiceCallException {
        ArrayList<Object> result = new ArrayList<Object>(Collections.nCopies(itemPaths.size(), null));
        ExecutorService executor = WrappedExecutorServiceProducer.newFixedThreadPool((int)MAX_PARALLEL_FILE_DOWNLOAD_THREADS);
        try {
            List<Future<Throwable>> futures = TfsRepositoryUtils.submitContentDownloadCallables(tfcVersionControlRestClient, itemPaths, executor, result, revision);
            for (Future<Throwable> future : futures) {
                Throwable throwable = future.get(60L, TimeUnit.MINUTES);
                if (throwable == null) continue;
                throw new RepositoryException(throwable.getMessage(), throwable);
            }
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            executor.shutdown();
        }
        return result;
    }

    private static List<Future<Throwable>> submitContentDownloadCallables(IAzureDevOpsTfvcRestApi tfvcRestClient, List<@Nullable String> itemPaths, ExecutorService executor, List<byte[]> contents, String revision) {
        ArrayList<Future<Throwable>> futures = new ArrayList<Future<Throwable>>();
        for (int i = 0; i < itemPaths.size(); ++i) {
            futures.add(executor.submit(new ContentDownloadCallable(tfvcRestClient, contents, itemPaths.get(i), revision, i)));
        }
        return futures;
    }

    public static List<Integer> getRevisionsBetween(IAzureDevOpsTfvcRestApi tfvcRestClient, String basePath, @NonNull Integer fromRevision, @NonNull Integer toRevision, int maxResults) throws ServiceCallException {
        return TfsRepositoryUtils.getRevisionsBetween(tfvcRestClient, basePath, fromRevision, toRevision, maxResults, true);
    }

    public static List<Integer> getRevisionsBetween(IAzureDevOpsTfvcRestApi tfvcRestClient, String basePath, @NonNull Integer fromRevision, @NonNull Integer toRevision, int maxResults, boolean ascending) throws ServiceCallException {
        LOGGER.info("Retrieving revisions for {} from {} to {}", (Object)basePath, (Object)fromRevision, (Object)toRevision);
        LinkedHashSet<Integer> result = new LinkedHashSet<Integer>();
        ETfvcChangesetOrder changesetOrder = null;
        if (ascending) {
            changesetOrder = ETfvcChangesetOrder.ASCENDING;
        }
        String from = String.valueOf(fromRevision);
        String to = String.valueOf(toRevision);
        List<TfvcChangesetDto> changesets = tfvcRestClient.getChangesetsBetweenRevisions(from, to, basePath, maxResults, changesetOrder).getChangesets();
        LOGGER.info("Got {} changesets", (Object)changesets.size());
        for (TfvcChangesetDto changeset : changesets) {
            result.add(changeset.getChangesetId());
        }
        return result.stream().toList();
    }

    public static Set<Changeset> getLatestChangeSetsWithNonEmptyComment(VersionControlClient versionControlClient, String path, int limit) {
        LinkedHashSet<Changeset> changesets = new LinkedHashSet<Changeset>();
        LatestVersionSpec to = LatestVersionSpec.INSTANCE;
        while (changesets.size() < limit) {
            LOGGER.info("Querying TFS for " + limit + " change sets on " + path + " until " + String.valueOf(to));
            Changeset[] retrievedChangesets = versionControlClient.queryHistory(path, (VersionSpec)LatestVersionSpec.INSTANCE, 0, RecursionType.FULL, null, null, (VersionSpec)to, limit - changesets.size(), false, false, false, false);
            if (retrievedChangesets == null || retrievedChangesets.length == 0) break;
            LOGGER.info("Retrieved " + retrievedChangesets.length + " changesets");
            to = new ChangesetVersionSpec(retrievedChangesets[retrievedChangesets.length - 1].getChangesetID() - 1);
            for (Changeset changeset : retrievedChangesets) {
                if (StringUtils.isEmpty((String)changeset.getComment())) continue;
                changesets.add(changeset);
            }
        }
        LOGGER.info("Changesets: " + String.valueOf(CollectionUtils.map(changesets, Changeset::getChangesetID)));
        return changesets;
    }

    public static CaseInsensitiveStringSet getPreviouslyExistingPaths(Set<TfvcChangeDto> nonDeleteChanges, IAzureDevOpsTfvcRestApi tfvcVersionControlRestClient, CommitTreeRevision currentRevision, @Nullable CommitTreeRevision parentRevision, String basePath) throws ServiceCallException {
        String previousRevision = TfsRepositoryUtils.getPreviousRevisionString(currentRevision, parentRevision);
        List paths = CollectionUtils.map(nonDeleteChanges, change -> TfsRepositoryUtils.replaceNewWithOldBranchInPath(change.getItem().getPath(), currentRevision, parentRevision, basePath));
        return TfsRepositoryUtils.getExistingPathsAtRevision(paths, tfvcVersionControlRestClient, previousRevision);
    }

    static String getPreviousRevisionString(CommitTreeRevision currentRevision, @Nullable CommitTreeRevision parentRevision) {
        if (parentRevision != null) {
            return parentRevision.getRevision();
        }
        return String.valueOf(Integer.parseInt(currentRevision.getRevision()) - 1);
    }

    public static CaseInsensitiveStringSet getNowExistingPaths(Set<TfvcChangeDto> nonDeleteChanges, IAzureDevOpsTfvcRestApi tfvcVersionControlRestClient, CommitTreeRevision currentRevision) throws ServiceCallException {
        List paths = CollectionUtils.map(nonDeleteChanges, change -> change.getItem().getPath());
        return TfsRepositoryUtils.getExistingPathsAtRevision(paths, tfvcVersionControlRestClient, currentRevision.getRevision());
    }

    @VisibleForTesting
    public static @NonNull CaseInsensitiveStringSet getExistingPathsAtRevision(List<String> paths, IAzureDevOpsTfvcRestApi tfvcVersionControlRestClient, String revision) throws ServiceCallException {
        try {
            if (paths.isEmpty() || revision.equals("0")) {
                return new CaseInsensitiveStringSet();
            }
            ArrayList items = new ArrayList(paths.size());
            List pathBatches = Lists.partition(paths, (int)Objects.requireNonNull((Integer)TeamscaleSystemProperties.TFS_MAXIMUM_NUMBER_OF_PATHS_IN_SINGLE_REQUEST.getValue()));
            for (List pathBatch : pathBatches) {
                items.addAll(tfvcVersionControlRestClient.getItems(new GetItemsBody(CollectionUtils.map((Collection)pathBatch, path -> new TfvcItemDescriptorDto((String)path, revision, ETfvcRecursionType.NONE)))).getItemSets().stream().filter(Objects::nonNull).flatMap(Collection::stream).toList());
            }
            return new CaseInsensitiveStringSet((Collection)items.stream().filter(Objects::nonNull).map(TfvcItemDto::getPath).collect(Collectors.toSet()));
        }
        catch (ServiceCallException e) {
            if (e.getStatusCode() == 400 && StringUtils.containsOneOf((String)e.getMessage(), (String[])new String[]{ITEMS_DONT_EXIST_OR_NO_ACCESS_MESSAGE_EN, ITEMS_DONT_EXIST_OR_NO_ACCESS_MESSAGE_DE})) {
                return new CaseInsensitiveStringSet();
            }
            throw e;
        }
    }

    public static String replaceNewWithOldBranchInPath(String path, CommitTreeRevision currentRevision, CommitTreeRevision parentRevision, String basePath) {
        String oldBranch = Objects.requireNonNullElse(parentRevision, currentRevision).getBranchName();
        return TfsRepositoryUtils.replaceBranch(path, currentRevision.getBranchName(), oldBranch, basePath);
    }

    public static Set<String> listBranchesForPaths(IAzureDevOpsTfvcRestApi tfvcRestClient, String basePath, List<String> branchLookupPaths, IncludeExcludeRegexSupport branchPatternSupport, boolean includeDeleted) throws RepositoryException {
        return TfsRepositoryUtils.iterateBranchesForPaths(tfvcRestClient, basePath, branchLookupPaths, branchPatternSupport, includeDeleted, null);
    }

    public static boolean existsBranchInPaths(IAzureDevOpsTfvcRestApi tfvcRestClient, String basePath, List<String> branchLookupPaths, IncludeExcludeRegexSupport branchPatternSupport, String searchedBranch) throws RepositoryException {
        Set<String> resultsOfSearch = TfsRepositoryUtils.iterateBranchesForPaths(tfvcRestClient, basePath, branchLookupPaths, branchPatternSupport, false, searchedBranch);
        return resultsOfSearch.size() == 1 && resultsOfSearch.contains(searchedBranch);
    }

    private static Set<String> iterateBranchesForPaths(IAzureDevOpsTfvcRestApi tfvcRestClient, String basePath, List<String> branchLookupPaths, IncludeExcludeRegexSupport branchPatternSupport, boolean includeDeleted, @Nullable String searchedBranch) throws RepositoryException {
        if (searchedBranch != null) {
            LOGGER.info("Searching for branch " + searchedBranch + " in " + basePath + " with lookup paths" + String.valueOf(branchLookupPaths));
        } else {
            LOGGER.info("Listing branches in " + basePath + " with lookup paths " + String.valueOf(branchLookupPaths));
        }
        if (branchLookupPaths.isEmpty()) {
            return TfsRepositoryUtils.iterateBranchesForPath(tfvcRestClient, basePath, basePath, branchPatternSupport, includeDeleted, searchedBranch);
        }
        TreeSet<String> branches = new TreeSet<String>();
        for (String branchLookupPath : branchLookupPaths) {
            if (branchLookupPath.equals(".")) {
                branchLookupPath = "";
            }
            String branchLookupPathIncludingBasePath = StringUtils.ensureEndsWith((String)basePath, (String)"/") + branchLookupPath.trim();
            Set<String> branchesForPath = TfsRepositoryUtils.iterateBranchesForPath(tfvcRestClient, basePath, branchLookupPathIncludingBasePath, branchPatternSupport, includeDeleted, searchedBranch);
            if (searchedBranch != null) {
                if (branchesForPath.size() != 1) continue;
                return branchesForPath;
            }
            branches.addAll(branchesForPath);
        }
        LOGGER.info("Found branches: " + String.valueOf(branches));
        return branches;
    }

    private static Set<String> iterateBranchesForPath(IAzureDevOpsTfvcRestApi tfvcRestClient, String basePath, String branchLookupPathIncludingBasePath, IncludeExcludeRegexSupport branchPatternSupport, boolean includeDeleted, @Nullable String searchedBranch) throws RepositoryException {
        List<TfvcBranchRefDto> branchRefs;
        try {
            branchRefs = tfvcRestClient.getBranchesBelowPath(branchLookupPathIncludingBasePath, includeDeleted).getBranches();
        }
        catch (ServiceCallException e) {
            throw new RepositoryException((Throwable)e);
        }
        HashSet<String> branches = new HashSet<String>();
        for (TfvcBranchRefDto branchRef : branchRefs) {
            String path = branchRef.getPath();
            String branchName = StringUtils.stripPrefixIgnoreCase((String)path, (String)basePath);
            boolean isDirectChildOfBranchLookUpPath = Arrays.stream(StringUtils.stripPrefixIgnoreCase((String)branchRef.getPath(), (String)branchLookupPathIncludingBasePath).split("/")).filter(s -> !StringUtils.isEmpty((String)s)).toArray().length == 1;
            if (!isDirectChildOfBranchLookUpPath || !branchPatternSupport.isIncluded(branchName)) continue;
            branchName = StringUtils.stripPrefix((String)StringUtils.stripSuffix((String)branchName, (String)"/"), (String)"/");
            if (searchedBranch != null && searchedBranch.equals(branchName)) {
                LOGGER.info("Found the searched branch: " + branchName);
                return Set.of(branchName);
            }
            branches.add(branchName);
        }
        if (searchedBranch != null) {
            return new HashSet<String>();
        }
        LOGGER.info("Found branches: " + String.valueOf(branches));
        return branches;
    }

    public static List<String> listFilesForRepositoryPath(String basePath, VersionControlClient tfsClient) {
        basePath = StringUtils.ensureEndsWith((String)basePath, (String)"/");
        ItemSet items = tfsClient.getItems(new ItemSpec(basePath, RecursionType.FULL), (VersionSpec)LatestVersionSpec.INSTANCE, DeletedState.NON_DELETED, ItemType.FILE, GetItemsOptions.NONE);
        ArrayList<String> files = new ArrayList<String>();
        for (Item item : items.getItems()) {
            String serverItem = item.getServerItem();
            String filePath = StringUtils.stripPrefixIgnoreCase((String)serverItem, (String)basePath);
            files.add(filePath);
        }
        return files;
    }

    public static String getBasePath(String basePath, String branchName, String branchPathSuffix, boolean nonBranchedMode) {
        Object result = basePath;
        if (!nonBranchedMode) {
            Preconditions.checkArgument((!StringUtils.isEmpty((String)branchName) ? 1 : 0) != 0, (Object)"Branch name should not be empty in branched mode.");
            result = (String)result + StringUtils.ensureEndsWith((String)branchName, (String)"/");
        }
        if (!StringUtils.isEmpty((String)branchPathSuffix)) {
            result = (String)result + StringUtils.ensureEndsWith((String)branchPathSuffix, (String)"/");
        }
        return StringUtils.ensureEndsWith((String)result, (String)"/");
    }

    public static List<String> getBranchLookupPaths(ConnectorConfiguration connector) {
        String branchLookupPaths = Objects.requireNonNull(connector.getOptionValue("Branch lookup paths"));
        String[] branchLookupPathsArray = branchLookupPaths.split("\\n");
        if (branchLookupPathsArray.length == 1 && branchLookupPathsArray[0].equals(branchLookupPaths)) {
            branchLookupPathsArray = branchLookupPaths.split(",");
        }
        return TfsRepositoryUtils.filterCommentedPaths(Arrays.asList(branchLookupPathsArray));
    }

    public static List<String> filterCommentedPaths(List<String> branchLookupPathsList) {
        return CollectionUtils.filter(branchLookupPathsList, path -> !path.startsWith("##"));
    }

    private record ContentDownloadCallable(IAzureDevOpsTfvcRestApi tfvcRestClient, List<byte[]> contents, String itemPath, String revision, int index) implements Callable<Throwable>
    {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Throwable call() {
            if (this.itemPath == null) {
                List<byte[]> list = this.contents;
                synchronized (list) {
                    this.contents.set(this.index, null);
                }
                return null;
            }
            try (InputStream inputStream = this.tfvcRestClient.getItemContent(this.itemPath, ETfvcRecursionType.NONE, this.revision, ETfvcVersionType.CHANGESET, false, false).byteStream();){
                byte[] content = FileSystemUtils.readStreamBinary((InputStream)inputStream);
                List<byte[]> list = this.contents;
                synchronized (list) {
                    this.contents.set(this.index, content);
                }
            }
            catch (Throwable t) {
                return t;
            }
            return null;
        }
    }
}

