/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.repository.tfs;

import com.teamscale.index.repository.ERepositoryChangeType;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.RepositoryException;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IKeyValueCallback;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.ResultStringListCallback;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.StringUtils;

@Index(name="path-casing", options={EStorageOption.COMPRESSED, EStorageOption.NO_ROLLBACK}, valueClasses={String.class})
public class UniformPathCasingIndex
extends IndexBase
implements IProjectIndex {
    private final Map<String, String> uniformParentPathCasingCache = new HashMap<String, String>();
    public static final String INDEX_NAME = "path-casing";

    public UniformPathCasingIndex(IStore store) {
        super(store);
    }

    public void addPaths(Collection<String> uniformPaths) throws StorageException {
        PairList values = new PairList();
        for (String uniformPath : uniformPaths) {
            values.add((Object)UniformPathCasingIndex.makeKey(uniformPath), (Object)UniformPathCasingIndex.makeValue(uniformPath));
        }
        this.store.putWithStrings(values);
    }

    public void addPath(String uniformPath) throws StorageException {
        this.store.putWithString(UniformPathCasingIndex.makeKey(uniformPath), UniformPathCasingIndex.makeValue(uniformPath));
    }

    private String getPath(String uniformPath) throws StorageException {
        return StringUtils.bytesToString((byte[])this.store.getWithString(UniformPathCasingIndex.makeKey(uniformPath)));
    }

    private List<String> getPathsStartingWith(@NonNull String prefix) throws StorageException {
        ResultStringListCallback callback = new ResultStringListCallback();
        this.store.scan(StringUtils.stringToBytes((String)UniformPathCasingIndex.makeKey(prefix)), (IKeyValueCallback)callback);
        return callback.getResultOrThrowException();
    }

    private static byte[] makeValue(String uniformPath) {
        return StringUtils.stringToBytes((String)uniformPath);
    }

    private static String makeKey(String uniformPath) {
        return uniformPath.toLowerCase();
    }

    public String getCasedPath(String path, ERepositoryChangeType changeType) throws RepositoryException {
        try {
            String casedPath = this.getPath(path);
            if (casedPath != null) {
                return casedPath;
            }
            if (changeType == ERepositoryChangeType.ADD) {
                String parent = UniformPathUtils.getParentPath((String)path);
                while (!StringUtils.isEmpty((String)parent)) {
                    String prefixCased = this.determineCasedParentPath(parent);
                    if (prefixCased == null) {
                        parent = UniformPathUtils.getParentPath((String)parent);
                        continue;
                    }
                    return prefixCased + path.substring(prefixCased.length());
                }
            }
            return path;
        }
        catch (StorageException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    private String determineCasedParentPath(String parent) throws StorageException {
        if (this.uniformParentPathCasingCache.containsKey(parent = UniformPathCasingIndex.makeKey(parent))) {
            return this.uniformParentPathCasingCache.get(parent);
        }
        List<String> children = this.getPathsStartingWith(parent);
        if (children.isEmpty()) {
            return null;
        }
        String casedPath = children.get(0).substring(0, parent.length());
        this.uniformParentPathCasingCache.put(parent, casedPath);
        return casedPath;
    }
}

