/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.merge_request;

import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.index.issue_reference.SpecItemCodeReferenceIndex;
import com.teamscale.index.resource.issue_reference.IssueReference;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.TwoDimHashMap;

public class MergeRequestImpactedSpecItemsCalculatorUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static boolean isSignatureEqual(SpecItemCodeReference firstReference, SpecItemCodeReference secondReference) {
        SpecItemCodeReference.ReferencedShallowEntity firstEntity = firstReference.getReferencedNonPreprocessedShallowEntity();
        SpecItemCodeReference.ReferencedShallowEntity secondEntity = secondReference.getReferencedNonPreprocessedShallowEntity();
        String firstEntityStartTokensConcatenated = firstEntity.getStartTokenTexts().stream().reduce(String::concat).orElse("");
        String secondEntityStartTokensConcatenated = secondEntity.getStartTokenTexts().stream().reduce(String::concat).orElse("");
        return firstEntityStartTokensConcatenated.equals(secondEntityStartTokensConcatenated);
    }

    public static TwoDimHashMap<String, TeamscaleIssueId, Set<SpecItemCodeReference>> buildSpecItemCodeReferencesByUniformPathAndSpecItemId(SpecItemCodeReferenceIndex specItemCodeReferenceIndex, List<TeamscaleIssueId> specItemIds, Set<String> uniformPaths) throws StorageException {
        List<List<SpecItemCodeReference>> codeReferencesForSpecItemIds = specItemCodeReferenceIndex.getSpecItemCodeReferences(CollectionUtils.map(specItemIds, TeamscaleIssueId::getInternalId));
        TwoDimHashMap codeReferencesByUniformPathAndSpecItemId = new TwoDimHashMap();
        for (int i = 0; i < specItemIds.size(); ++i) {
            TeamscaleIssueId specItemId = specItemIds.get(i);
            List<SpecItemCodeReference> codeReferencesForSpecItemId = codeReferencesForSpecItemIds.get(i);
            if (codeReferencesForSpecItemId == null) {
                LOGGER.info("Code references for spec item id {} missing.", (Object)specItemId);
                continue;
            }
            for (SpecItemCodeReference codeReference : codeReferencesForSpecItemId) {
                String uniformPath = codeReference.getUniformPath();
                if (!uniformPaths.contains(uniformPath)) continue;
                HashSet<SpecItemCodeReference> specItemCodeReferences = (HashSet<SpecItemCodeReference>)codeReferencesByUniformPathAndSpecItemId.getValue((Object)uniformPath, (Object)specItemId);
                if (specItemCodeReferences == null) {
                    specItemCodeReferences = new HashSet<SpecItemCodeReference>();
                }
                specItemCodeReferences.add(codeReference);
                codeReferencesByUniformPathAndSpecItemId.putValue((Object)uniformPath, (Object)specItemId, specItemCodeReferences);
            }
        }
        return codeReferencesByUniformPathAndSpecItemId;
    }

    public static List<TeamscaleIssueId> getDistinctSpecItemIds(Map<String, ArrayList<IssueReference>> issueReferences) {
        return issueReferences.values().stream().flatMap(Collection::stream).map(IssueReference::getId).distinct().collect(Collectors.toList());
    }
}

