/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.merge_request.ambiguity_resolution;

import com.teamscale.index.issue_reference.SpecItemCodeReference;
import com.teamscale.index.requirements_tracing.merge_request.SpecItemReferenceDiff;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.collections.Pair;

public class MethodHistoryTraversalStrategy {
    private final CommitDescriptor sourceHeadCommit;
    private final CommitDescriptor mergeBaseCommit;
    private final Set<CommitDescriptor> ancestorsOfSource;
    private final ProjectStorageSystem projectStorageSystem;
    private final Map<TeamscaleIssueId, TeamscaleIssueTypeInfo> specItemTypeInfoById;

    public MethodHistoryTraversalStrategy(CommitDescriptor sourceHeadCommit, CommitDescriptor mergeBaseCommit, Set<CommitDescriptor> ancestorsOfSource, ProjectStorageSystem projectStorageSystem, Map<TeamscaleIssueId, TeamscaleIssueTypeInfo> specItemTypeInfoById) {
        this.sourceHeadCommit = sourceHeadCommit;
        this.mergeBaseCommit = mergeBaseCommit;
        this.ancestorsOfSource = ancestorsOfSource;
        this.projectStorageSystem = projectStorageSystem;
        this.specItemTypeInfoById = specItemTypeInfoById;
    }

    public Set<SpecItemCodeReference> getSpecItemReferenceIntersection(String uniformPath, TeamscaleIssueId specItemId, Set<SpecItemCodeReference> referencesAtSourceHead, Set<SpecItemCodeReference> referencesAtMergeBase, List<SpecItemReferenceDiff> referencesInChangedCode) throws StorageException {
        HashSet<SpecItemCodeReference> specItemCodeReferenceIntersection = new HashSet<SpecItemCodeReference>();
        MethodInfoIndex methodInfoIndexForSourceHeadCommit = (MethodInfoIndex)this.projectStorageSystem.openProjectIndex(MethodInfoIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)this.sourceHeadCommit));
        for (SpecItemCodeReference reqCodeReferenceAtSourceHead : referencesAtSourceHead) {
            AssociatedMethodInfo associatedMethodInfo = MethodHistoryTraversalStrategy.getAssociatedMethodInfo(uniformPath, reqCodeReferenceAtSourceHead, methodInfoIndexForSourceHeadCommit);
            if (associatedMethodInfo == null) continue;
            boolean realChangeFound = associatedMethodInfo.getLastChangedTimestamp() > this.mergeBaseCommit.getTimestamp();
            Pair<List<Pair<CommitDescriptor, String>>, Boolean> predecessorsWithChangeFound = this.findFirstAvailableVersionsAfterMergeBase(associatedMethodInfo);
            realChangeFound |= ((Boolean)predecessorsWithChangeFound.getSecond()).booleanValue();
            for (Pair predecessor : (List)predecessorsWithChangeFound.getFirst()) {
                Optional<SpecItemCodeReference> sameReferenceAtMergeBase;
                Optional<AssociatedMethodInfo> predecessorMethodInfo = this.retrievePredecessorMethodInfo((Pair<CommitDescriptor, String>)predecessor, false);
                if (predecessorMethodInfo.isEmpty() || !(sameReferenceAtMergeBase = MethodHistoryTraversalStrategy.findTheSameReferenceInMergeBase(predecessorMethodInfo.get(), referencesAtMergeBase)).isPresent()) continue;
                this.addToIntersectionAndChangedCodeReferences(specItemId, uniformPath, sameReferenceAtMergeBase.get(), reqCodeReferenceAtSourceHead, specItemCodeReferenceIntersection, referencesInChangedCode, realChangeFound);
            }
        }
        return specItemCodeReferenceIntersection;
    }

    private void addToIntersectionAndChangedCodeReferences(TeamscaleIssueId specItemId, String uniformPath, SpecItemCodeReference referenceAtMergeBase, SpecItemCodeReference reqCodeReferenceAtSourceHead, Set<SpecItemCodeReference> specItemCodeReferenceIntersection, List<SpecItemReferenceDiff> referencesInChangedCode, boolean realChangeFound) {
        specItemCodeReferenceIntersection.add(referenceAtMergeBase);
        specItemCodeReferenceIntersection.add(reqCodeReferenceAtSourceHead);
        if (realChangeFound) {
            referencesInChangedCode.add(new SpecItemReferenceDiff(uniformPath, specItemId, reqCodeReferenceAtSourceHead.getCommentLineNumber(), referenceAtMergeBase.getCommentLineNumber(), this.sourceHeadCommit, this.mergeBaseCommit, reqCodeReferenceAtSourceHead.getReferencedShallowEntity(), referenceAtMergeBase.getReferencedShallowEntity(), referenceAtMergeBase.getTestImplementationUniformPath(), SpecItemReferenceDiff.ESpecItemCodeReferenceChangeType.MODIFIED, this.specItemTypeInfoById.get(specItemId)));
        }
    }

    private static Optional<SpecItemCodeReference> findTheSameReferenceInMergeBase(AssociatedMethodInfo firstMethodInfoAfterMergeBase, Set<SpecItemCodeReference> referencesAtMergeBase) {
        return referencesAtMergeBase.stream().filter(codeReference -> MethodHistoryTraversalStrategy.isMethodRegionTheSame(firstMethodInfoAfterMergeBase, codeReference) && MethodHistoryTraversalStrategy.isMethodNameTheSame(codeReference, firstMethodInfoAfterMergeBase.getMethodName())).findFirst();
    }

    private static boolean isMethodNameTheSame(SpecItemCodeReference codeReference, String firstMethodInfoAfterMergeBaseName) {
        String preprocessedEntityName = codeReference.getReferencedShallowEntity().getName();
        String nonPreprocessedEntityName = codeReference.getReferencedNonPreprocessedShallowEntity().getName();
        return preprocessedEntityName.equals(firstMethodInfoAfterMergeBaseName) || nonPreprocessedEntityName.equals(firstMethodInfoAfterMergeBaseName);
    }

    private Pair<List<Pair<CommitDescriptor, String>>, Boolean> findFirstAvailableVersionsAfterMergeBase(AssociatedMethodInfo associatedMethodInfo) throws StorageException {
        List<AssociatedMethodInfo> versionsAfterMergeBase = List.of(associatedMethodInfo);
        ArrayList predecessors = new ArrayList();
        boolean realChangeFound = false;
        while (!versionsAfterMergeBase.isEmpty()) {
            ArrayList<AssociatedMethodInfo> nextVersionsAfterMergeBase = new ArrayList<AssociatedMethodInfo>();
            predecessors.clear();
            for (AssociatedMethodInfo version : versionsAfterMergeBase) {
                if (version.getPredecessorCommitsWithKeys() == null) continue;
                predecessors.addAll(version.getPredecessorCommitsWithKeys().toList().stream().filter(predecessor -> !AssociatedMethodInfo.isDummyCommit((CommitDescriptor)predecessor.getFirst())).collect(Collectors.toList()));
            }
            for (Pair predecessor2 : predecessors) {
                Optional<AssociatedMethodInfo> predecessorMethodInfo = this.retrievePredecessorMethodInfo((Pair<CommitDescriptor, String>)predecessor2, true);
                if (predecessorMethodInfo.isEmpty()) continue;
                if (predecessorMethodInfo.get().getLastChangedTimestamp() == ((CommitDescriptor)predecessor2.getFirst()).getTimestamp()) {
                    realChangeFound = true;
                }
                if (predecessorMethodInfo.get().getLastInfoUpdateCommit().getTimestamp() <= this.mergeBaseCommit.getTimestamp()) continue;
                nextVersionsAfterMergeBase.add(predecessorMethodInfo.get());
            }
            versionsAfterMergeBase = nextVersionsAfterMergeBase;
        }
        return new Pair(predecessors, (Object)realChangeFound);
    }

    private static AssociatedMethodInfo getAssociatedMethodInfo(String uniformPath, SpecItemCodeReference specItemCodeReference, MethodInfoIndex methodInfoIndex) throws StorageException {
        AssociatedMethodInfo associatedMethodInfo = null;
        List<AssociatedMethodInfo> associatedMethodInfosAtSourceHead = methodInfoIndex.getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo(List.of(uniformPath));
        for (AssociatedMethodInfo methodInfo : associatedMethodInfosAtSourceHead) {
            if (!MethodHistoryTraversalStrategy.isMethodRegionTheSame(methodInfo, specItemCodeReference)) continue;
            associatedMethodInfo = methodInfo;
        }
        return associatedMethodInfo;
    }

    private static boolean isMethodRegionTheSame(AssociatedMethodInfo methodInfo, SpecItemCodeReference specItemCodeReference) {
        return methodInfo.getAssociatedRegion().getStart() == specItemCodeReference.getReferencedShallowEntity().getStartOffset() && methodInfo.getAssociatedRegion().getEnd() == specItemCodeReference.getReferencedShallowEntity().getEndOffset();
    }

    private Optional<AssociatedMethodInfo> retrievePredecessorMethodInfo(Pair<CommitDescriptor, String> predecessor, boolean onlyAncestorsOfSource) throws StorageException {
        if (onlyAncestorsOfSource && !this.ancestorsOfSource.contains(predecessor.getFirst())) {
            return Optional.empty();
        }
        String key = (String)predecessor.getSecond();
        MethodInfoIndex methodInfoIndex = (MethodInfoIndex)this.projectStorageSystem.openProjectIndex(MethodInfoIndex.class, HistoryAccessOption.readCommit((CommitDescriptor)((CommitDescriptor)predecessor.getFirst())));
        return Optional.of(methodInfoIndex.getAssociatedMethodInfoWithCrossAnnotationInfoLoaded(MethodInfoIndex.getUniformPathFromKey(key), MethodInfoIndex.getRegion(key)));
    }
}

