/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.util;

import com.polarion.alm.ws.client.types.tracker.WorkItem;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.PolarionExternalElementCache;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.importer.PolarionImportConfiguration;
import com.teamscale.index.requirements_tracing.tools.polarion.client.wrapper.util.PolarionWorkItemFieldResolvingUtils;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.EPolarionAdditionalFieldName;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.EPolarionDefaultWorkItemResolution;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.EPolarionDefaultWorkItemSeverity;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionDocumentLocation;
import com.teamscale.index.requirements_tracing.tools.polarion.model.polarion.PolarionWorkItemLinkRole;
import com.teamscale.wia.SpecItem;
import com.teamscale.wia.TeamscaleIssueId;
import com.teamscale.wia.TeamscaleIssueTypeInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.conqat.engine.persistence.index.keyed.EKeyedObjectType;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.net.UrlUtils;
import org.conqat.lib.commons.string.StringUtils;

public class PolarionWorkToSpecItemResolvingUtils {
    private static final String DEFAULT_TYPE_ABBREVIATION = "SI";

    public static PairList<Long, Pair<SpecItem, String>> buildSpecItemsWithLastUpdatedTimestamp(PairList<WorkItem, String> workItems, Map<String, String> possibleStatuses, String workItemBaseUrl, PolarionImportConfiguration configuration, List<WorkItem> createdWorkItems, PolarionExternalElementCache elementCache) throws InterruptedException {
        SpecItem specItem;
        PairList specItems = new PairList();
        long initialTimestamp = configuration.getInitialTimestamp().toEpochMilli();
        for (WorkItem item : createdWorkItems) {
            specItem = PolarionWorkToSpecItemResolvingUtils.buildSpecItem(item, configuration.getConnectorId(), possibleStatuses, workItemBaseUrl, configuration, elementCache);
            specItems.add((Object)Math.max(specItem.getCreated(), initialTimestamp), (Object)new Pair((Object)specItem, (Object)specItem.getAuthor()));
        }
        for (WorkItem item : workItems) {
            specItem = PolarionWorkToSpecItemResolvingUtils.buildSpecItem((WorkItem)item.getFirst(), configuration.getConnectorId(), possibleStatuses, workItemBaseUrl, configuration, elementCache);
            specItems.add((Object)Math.max(specItem.getUpdated(), initialTimestamp), (Object)new Pair((Object)specItem, (Object)((String)item.getSecond())));
        }
        return specItems;
    }

    public static SpecItem buildSpecItem(WorkItem item, String connectorId, Map<String, String> possibleStatuses, String workItemBaseUrl, PolarionImportConfiguration configuration, PolarionExternalElementCache elementCache) throws InterruptedException {
        PairList<String, String> additionalFields = PolarionWorkToSpecItemResolvingUtils.resolveAdditionalFields(item, configuration.getPolarionDocumentLocation(), configuration.getServiceClient().getCredentials().url(), elementCache);
        List<String> additionalFieldTypes = PolarionWorkToSpecItemResolvingUtils.getAdditionalFieldTypes((List<String>)additionalFields.getFirstList());
        List<String> assignees = PolarionWorkItemFieldResolvingUtils.resolveWorkItemAssignees(item);
        List<List<String>> includedLinkedWorkItems = PolarionWorkItemFieldResolvingUtils.resolveLinkedWorkItems(item, (Collection<PolarionWorkItemLinkRole>)configuration.getResolvedIncludedPolarionWorkItemLinkRoles().values());
        SpecItem.SpecItemBuilder builder = new SpecItem.SpecItemBuilder(new TeamscaleIssueId(connectorId, item.getId()), item.getCreated().getTimeInMillis(), (List)additionalFields.getFirstList(), (List)additionalFields.getSecondList(), additionalFieldTypes, workItemBaseUrl + item.getId(), PolarionWorkItemFieldResolvingUtils.getWorkItemParentIds(configuration.getIncludedPolarionWorkItemLinkRoles(), includedLinkedWorkItems));
        builder = builder.assignee((String)assignees.stream().findFirst().orElse(null)).author(item.getAuthor().getId()).updated(item.getUpdated().getTimeInMillis()).description(PolarionWorkItemFieldResolvingUtils.resolveWorkItemDescription(item)).status(possibleStatuses.get(item.getStatus().getId())).subject(item.getTitle()).typeInfo(new TeamscaleIssueTypeInfo(configuration.getIncludedWorkItemTypeIdToName().getOrDefault(item.getType().getId(), item.getType().getId()), configuration.getIncludedWorkItemTypeIdToAbbreviation().getOrDefault(item.getType().getId(), DEFAULT_TYPE_ABBREVIATION))).customFields(PolarionWorkItemFieldResolvingUtils.resolveWorkItemCustomFields(item, configuration.getCustomFieldConfiguration().getPolarionCustomFields()));
        if (assignees.size() > 1) {
            builder = builder.additionalAssignees(assignees.subList(1, assignees.size()));
        }
        builder = builder.linkedSpecItems(configuration.getIncludedPolarionWorkItemLinkRoles(), includedLinkedWorkItems);
        return builder.build();
    }

    private static PairList<String, String> resolveAdditionalFields(WorkItem item, PolarionDocumentLocation documentLocation, String polarionUri, PolarionExternalElementCache elementCache) throws InterruptedException {
        PairList additionalFieldsAndValues = new PairList();
        PolarionWorkToSpecItemResolvingUtils.resolveComponents(item, (PairList<String, String>)additionalFieldsAndValues);
        PolarionWorkToSpecItemResolvingUtils.resolveSeverity(item, (PairList<String, String>)additionalFieldsAndValues);
        PolarionWorkToSpecItemResolvingUtils.resolveResolution(item, (PairList<String, String>)additionalFieldsAndValues);
        PolarionWorkToSpecItemResolvingUtils.resolveDocumentTitle(item, elementCache, (PairList<String, String>)additionalFieldsAndValues);
        PolarionWorkToSpecItemResolvingUtils.resolveDocumentIdAndLink(item, documentLocation, polarionUri, elementCache, (PairList<String, String>)additionalFieldsAndValues);
        PolarionWorkToSpecItemResolvingUtils.resolvePlans(item, elementCache, (PairList<String, String>)additionalFieldsAndValues);
        return additionalFieldsAndValues;
    }

    private static void resolveComponents(WorkItem item, PairList<String, String> additionalFieldsAndValues) {
        String components = PolarionWorkItemFieldResolvingUtils.resolveWorkItemComponents(item).stream().reduce((partialComponentList, next) -> partialComponentList + ", " + next).orElse("");
        if (!components.isEmpty()) {
            additionalFieldsAndValues.add((Object)EPolarionAdditionalFieldName.COMPONENTS.getReadableName(), (Object)components);
        }
    }

    private static void resolveSeverity(WorkItem item, PairList<String, String> additionalFieldsAndValues) {
        String severity = EPolarionDefaultWorkItemSeverity.resolve(item.getSeverity()).toString();
        if (!severity.isEmpty()) {
            additionalFieldsAndValues.add((Object)EPolarionAdditionalFieldName.SEVERITY.getReadableName(), (Object)severity);
        }
    }

    private static void resolveResolution(WorkItem item, PairList<String, String> additionalFieldsAndValues) {
        String resolution = EPolarionDefaultWorkItemResolution.resolve(item.getResolution()).toString();
        if (!resolution.isEmpty()) {
            additionalFieldsAndValues.add((Object)EPolarionAdditionalFieldName.RESOLUTION.getReadableName(), (Object)resolution);
        }
    }

    private static void resolveDocumentTitle(WorkItem item, PolarionExternalElementCache elementCache, PairList<String, String> additionalFieldsAndValues) throws InterruptedException {
        PolarionWorkItemFieldResolvingUtils.resolveDocumentTitle(item, elementCache).ifPresent(title -> additionalFieldsAndValues.add((Object)EPolarionAdditionalFieldName.DOCUMENT_TITLE.getReadableName(), title));
    }

    private static void resolveDocumentIdAndLink(WorkItem item, PolarionDocumentLocation documentLocation, String polarionUri, PolarionExternalElementCache elementCache, PairList<String, String> additionalFieldsAndValues) throws InterruptedException {
        Optional<String> documentId = PolarionWorkItemFieldResolvingUtils.resolveDocumentId(item, elementCache);
        if (documentId.isPresent()) {
            String documentLink = PolarionWorkToSpecItemResolvingUtils.buildLinkToPolarionWiki(polarionUri, documentLocation.getProjectId(), PolarionWorkItemFieldResolvingUtils.resolveModuleFolderFromModuleUri(item), documentId.get());
            additionalFieldsAndValues.add((Object)EPolarionAdditionalFieldName.DOCUMENT_ID.getReadableName(), (Object)documentId.get());
            additionalFieldsAndValues.add((Object)EPolarionAdditionalFieldName.DOCUMENT_LINK.getReadableName(), (Object)documentLink);
        }
    }

    private static void resolvePlans(WorkItem item, PolarionExternalElementCache elementCache, PairList<String, String> additionalFieldsAndValues) throws InterruptedException {
        List<String> plans = PolarionWorkItemFieldResolvingUtils.resolvePlans(item, elementCache);
        if (!plans.isEmpty()) {
            String plannedIn = String.join((CharSequence)",", plans);
            additionalFieldsAndValues.add((Object)EPolarionAdditionalFieldName.PLANNED_IN.getReadableName(), (Object)plannedIn);
        }
    }

    private static List<String> getAdditionalFieldTypes(List<String> additionalFieldNames) {
        ArrayList<String> additionalFieldTypes = new ArrayList<String>(additionalFieldNames.size());
        for (String additionalField : additionalFieldNames) {
            String type = EKeyedObjectType.STRING.name();
            if (EPolarionAdditionalFieldName.PLANNED_IN.getReadableName().equals(additionalField)) {
                type = EKeyedObjectType.STRING_LIST.name();
            }
            additionalFieldTypes.add(type);
        }
        return additionalFieldTypes;
    }

    private static String buildLinkToPolarionWiki(String polarionUri, String projectId, String location, String documentName) {
        return StringUtils.ensureEndsWith((String)polarionUri, (String)"/") + "#/project/" + projectId + "/wiki/" + UrlUtils.encodePathSegment((String)location) + "/" + UrlUtils.encodePathSegment((String)documentName);
    }
}

