/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.wia.TeamscaleIssue;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.ISerializer;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.ValueIndex;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.uniformpath.UniformPath;

@Index(name="binary-content", options={EStorageOption.COMPRESSED, EStorageOption.BRANCHED}, valueClasses={TeamscaleIssue.class})
public class BinaryElementIndex
implements IProjectIndex {
    public static final String INDEX_NAME = "binary-content";
    private final ValueIndex<byte[]> delegate;

    public BinaryElementIndex(IStore store) {
        this.delegate = ValueIndex.of((IStore)store, (ISerializer)ISerializer.identity());
    }

    public void setContent(String uniformPath, byte[] binaryContent) throws StorageException {
        this.delegate.setValue(uniformPath, (Object)binaryContent);
    }

    public void setContent(UniformPath uniformPath, byte[] binaryContent) throws StorageException {
        this.delegate.setValue(uniformPath.toStringAsMigrationFrontier(), (Object)binaryContent);
    }

    public byte @Nullable [] getContent(String uniformPath) throws StorageException {
        return (byte[])this.delegate.getValue(uniformPath);
    }

    public List<byte @Nullable []> getContents(List<String> uniformPaths) throws StorageException {
        return this.delegate.getValues(uniformPaths);
    }

    public byte @Nullable [] getContent(UniformPath uniformPath) throws StorageException {
        return this.getContent(uniformPath.toStringAsMigrationFrontier());
    }

    public void removeContent(UniformPath uniformPath) throws StorageException {
        this.delegate.removeValue(uniformPath.toStringAsMigrationFrontier());
    }

    public void removeContents(Collection<String> uniformPaths) throws StorageException {
        this.delegate.removeValues(uniformPaths);
    }

    public PairList<String, byte[]> getAllContents() throws StorageException {
        return this.delegate.getAllEntries();
    }

    public void setContents(PairList<UniformPath, byte[]> binaryElementValues) throws StorageException {
        this.delegate.setValues(binaryElementValues.map(UniformPath::toStringAsMigrationFrontier, Function.identity()));
    }

    public List<String> getAllElements() throws StorageException {
        return this.delegate.getAllKeys();
    }
}

