/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.Index;
import org.conqat.engine.persistence.index.IndexBase;
import org.conqat.engine.persistence.index.schema.EStorageOption;
import org.conqat.engine.persistence.store.IStore;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.util.StorageStringAbbreviator;
import org.conqat.lib.commons.collections.ByteArrayWrapper;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.io.ByteArrayUtils;

@Index(name="code-to-coverage-report", options={EStorageOption.BRANCHED, EStorageOption.ABBREVIATE_STRINGS}, valueClasses={byte[].class})
public class CodeFileToCoverageReportIndex
extends IndexBase
implements IProjectIndex {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String INDEX_NAME = "code-to-coverage-report";

    public CodeFileToCoverageReportIndex(IStore store) {
        super(store);
    }

    public List<String> getAllReportPaths(List<String> codePaths, String connectorId) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        byte[] encodedConnectorId = ByteArrayUtils.intToByteArray((int)abbreviator.abbreviate(connectorId));
        List keys = CollectionUtils.map((Collection)abbreviator.abbreviate(codePaths), abbreviatedCodePath -> ByteArrayUtils.concat((byte[][])new byte[][]{ByteArrayUtils.intToByteArray((int)abbreviatedCodePath), encodedConnectorId}));
        List values = this.store.get(keys);
        List abbreviatedKeys = values.stream().filter(Objects::nonNull).map(ByteArrayUtils::deserializeIntegerList).flatMap(Collection::stream).toList();
        return abbreviator.unabbreviate(abbreviatedKeys);
    }

    public void removeCodePaths(List<String> deletedCodeUniformPathsAsStrings) throws StorageException {
        this.runLocked("update", () -> {
            Iterator iterator = this.store.getAbbreviator().abbreviate((SequencedCollection)deletedCodeUniformPathsAsStrings).iterator();
            while (iterator.hasNext()) {
                int abbreviation = (Integer)iterator.next();
                this.store.removeByPrefix(ByteArrayUtils.intToByteArray((int)abbreviation));
            }
        });
    }

    public void insertAssociations(Collection<CodeFileToCoverageReportAssociation> associationsToAdd) throws StorageException {
        if (associationsToAdd.isEmpty()) {
            return;
        }
        this.runLocked("update", () -> {
            SetMap<ByteArrayWrapper, Integer> entries = this.mapToKeyAndValues(associationsToAdd);
            List keys = CollectionUtils.map((Collection)entries.getKeys(), ByteArrayWrapper::getBytes);
            List<List<Integer>> valueLists = this.getAbbreviatedReportLists(keys);
            SetMap existingEntries = new SetMap();
            for (int i = 0; i < keys.size(); ++i) {
                ByteArrayWrapper key = new ByteArrayWrapper((byte[])keys.get(i));
                existingEntries.addAll((Object)key, (Collection)CollectionUtils.unionList((Collection)valueLists.get(i), (Collection[])new Collection[]{entries.getCollection((Object)key)}));
            }
            PairList newEntries = new PairList(entries.size());
            for (Map.Entry entry : existingEntries.entrySet()) {
                newEntries.add((Object)((ByteArrayWrapper)entry.getKey()).getBytes(), (Object)ByteArrayUtils.serializeIntegerList(new ArrayList((Collection)entry.getValue())));
            }
            this.store.put(newEntries);
        });
    }

    private List<@Nullable List<Integer>> getAbbreviatedReportLists(List<byte[]> keys) throws StorageException {
        List existingValues = this.store.get(keys);
        return CollectionUtils.map((Collection)existingValues, entry -> {
            if (entry == null) {
                return null;
            }
            return ByteArrayUtils.deserializeIntegerList((byte[])entry);
        });
    }

    public void removeAssociations(Collection<CodeFileToCoverageReportAssociation> associationsToRemove) throws StorageException {
        if (associationsToRemove.isEmpty()) {
            return;
        }
        this.runLocked("update", () -> {
            SetMap<ByteArrayWrapper, Integer> entriesToRemove = this.mapToKeyAndValues(associationsToRemove);
            List keys = CollectionUtils.map((Collection)entriesToRemove.getKeys(), ByteArrayWrapper::getBytes);
            List<List<Integer>> reportsLists = this.getAbbreviatedReportLists(keys);
            SetMap existingEntries = new SetMap();
            for (int i = 0; i < keys.size(); ++i) {
                List<Integer> reports = reportsLists.get(i);
                if (reports == null) {
                    LOGGER.info("Failed to delete reports for key " + String.valueOf(this.findAssociation((byte[])keys.get(i), associationsToRemove)) + " from CodeFileToCoverageReportIndex.");
                    continue;
                }
                existingEntries.addAll((Object)new ByteArrayWrapper((byte[])keys.get(i)), reports);
            }
            for (Map.Entry entry : entriesToRemove) {
                for (Integer valueInt : (Set)entry.getValue()) {
                    existingEntries.remove((Object)((ByteArrayWrapper)entry.getKey()), (Object)valueInt);
                }
            }
            PairList entriesToUpdate = new PairList();
            ArrayList<byte[]> keysToRemove = new ArrayList<byte[]>();
            for (Map.Entry entry : existingEntries) {
                if (entry.getValue() == null || ((Set)entry.getValue()).isEmpty()) {
                    keysToRemove.add(((ByteArrayWrapper)entry.getKey()).getBytes());
                    continue;
                }
                entriesToUpdate.add((Object)((ByteArrayWrapper)entry.getKey()).getBytes(), (Object)ByteArrayUtils.serializeIntegerList(new ArrayList((Collection)entry.getValue())));
            }
            this.store.remove(keysToRemove);
            this.store.put(entriesToUpdate);
        });
    }

    private SetMap<ByteArrayWrapper, Integer> mapToKeyAndValues(Collection<CodeFileToCoverageReportAssociation> associations) throws StorageException {
        HashSet<String> strings = new HashSet<String>();
        for (CodeFileToCoverageReportAssociation association : associations) {
            strings.add(association.codePath);
            strings.add(association.reportPath);
            strings.add(association.connectorId);
        }
        Map abbreviationMap = this.store.getAbbreviator().buildAbbreviationMap(strings);
        SetMap result = new SetMap();
        for (CodeFileToCoverageReportAssociation association : associations) {
            result.add((Object)association.toKey(abbreviationMap), (Object)((Integer)abbreviationMap.get(association.reportPath)));
        }
        return result;
    }

    private CodeFileToCoverageReportAssociation findAssociation(byte[] key, Collection<CodeFileToCoverageReportAssociation> associations) throws StorageException {
        StorageStringAbbreviator abbreviator = this.store.getAbbreviator();
        for (CodeFileToCoverageReportAssociation association : associations) {
            byte[] associationKey = association.toKey(abbreviator).getBytes();
            if (!Arrays.equals(key, associationKey)) continue;
            return association;
        }
        return null;
    }

    public record CodeFileToCoverageReportAssociation(String codePath, String reportPath, String connectorId) {
        public ByteArrayWrapper toKey(Map<String, Integer> abbreviationMap) {
            return this.toKey(abbreviationMap.get(this.codePath), abbreviationMap.get(this.connectorId));
        }

        public ByteArrayWrapper toKey(StorageStringAbbreviator abbreviator) throws StorageException {
            return this.toKey(abbreviator.abbreviate(this.codePath), abbreviator.abbreviate(this.connectorId));
        }

        private ByteArrayWrapper toKey(int codePath, int connectorId) {
            return new ByteArrayWrapper(ByteArrayUtils.intsToByteArray((int[])new int[]{codePath, connectorId}));
        }
    }
}

