/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.core.analysis.AnalysisStep;
import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EAnalysisStepParameter;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.GlobalIndexAccess;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.configuration.index.model.AnalysisProfile;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.core.log.parse.EParseLogOrigin;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.CompilationCommand;
import com.teamscale.index.resource.CompileCommandIndex;
import com.teamscale.index.resource.CppSystemIncludeDirectories;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.IEC61131ContentUtils;
import com.teamscale.index.resource.IndexAwareCPreprocessor;
import com.teamscale.index.resource.PreprocessorExpansionsIndex;
import com.teamscale.index.resource.SystemIncludeFileCacheIndex;
import com.teamscale.index.resource.SystemIncludeFileLookup;
import com.teamscale.index.resource.TokenElementIndex;
import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.resource.TokenElementLineInfoBuilder;
import com.teamscale.index.resource.TokenElementLineInfoIndex;
import com.teamscale.index.resource.element_details.CodeScopeDetail;
import com.teamscale.index.resource.element_details.HiddenTokenElementDetail;
import com.teamscale.index.resource.element_details.IncludePathDetail;
import com.teamscale.index.resource.element_details.InitialMacroDefinitionsDetail;
import com.teamscale.index.resource.element_details.PrependDirectivesDetail;
import com.teamscale.index.resource.element_details.ProjectModuleTokenElementDetail;
import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.resource.reparsing_dependency.ReparseRequiredIndex;
import eu.cqse.check.framework.preprocessor.IPreprocessor;
import eu.cqse.check.framework.preprocessor.PreprocessorUtils;
import eu.cqse.check.framework.preprocessor.abap.AbapPreprocessor;
import eu.cqse.check.framework.preprocessor.c.CPreprocessingUtils;
import eu.cqse.check.framework.preprocessor.c.IncludedTokens;
import eu.cqse.check.framework.preprocessor.c.ParsedMacroProvider;
import eu.cqse.check.framework.preprocessor.c.PreprocessorTokenReplacement;
import eu.cqse.check.framework.preprocessor.iec61131.Iec61131Preprocessor;
import eu.cqse.check.framework.preprocessor.swift.SwiftCompilerControlConfig;
import eu.cqse.check.framework.preprocessor.swift.SwiftPreprocessor;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageGroups;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.ShallowParserException;
import eu.cqse.check.framework.shallowparser.ShallowParserFactory;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.shallowparser.util.ParseLogMessage;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.index.shared.element_details.TokenElementDetailBase;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.text.filter.base.Deletion;
import org.conqat.engine.resource.text.filter.util.StringOffsetTransformer;
import org.conqat.engine.sourcecode.coverage.TokenElementLineInfo;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.string.LineOffsetConverter;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

@AnalysisStep(hints={EAnalysisStepParameter.MERGE_INPUT_DELTAS})
public class ContentIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    private static final Logger LOGGER = LogManager.getLogger();
    @DeltaSource(value=BasicTokenElementIndex.class)
    private KeyDelta basicTokenElementDelta;
    @DeltaSource(value=CompileCommandIndex.class)
    private KeyDelta compileCommandDelta;
    @GlobalIndexAccess(value=EIndexAccessMode.READ_WRITE)
    private SystemIncludeFileCacheIndex systemIncludeFileCacheIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="content")
    private TokenElementIndex contentIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private TokenElementLineInfoIndex tokenElementLineInfoIndex;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE)
    private PreprocessorExpansionsIndex preprocessorExpansionsIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private PathLookupIndex pathLookupIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private MetaIndex metaIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private CompileCommandIndex compileCommandIndex;
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private ReparseRequiredIndex reparseRequiredIndex;
    private FileIncludeLookup includeLookup = null;
    private SystemIncludeFileLookup systemIncludeFileLookup = null;
    private final ConcurrentMap<Pair<ELanguage, CodeScopeName>, List<IToken>> globalMacroDefinitions = new ConcurrentHashMap<Pair<ELanguage, CodeScopeName>, List<IToken>>();
    private final Set<String> nonExistingPaths = ConcurrentHashMap.newKeySet();
    private final ConcurrentMap<String, IncludedTokens> cachedTokens = new ConcurrentHashMap<String, IncludedTokens>();
    private final ConcurrentMap<CodeScopeName, SwiftCompilerControlConfig> globalSwiftConfiguration = new ConcurrentHashMap<CodeScopeName, SwiftCompilerControlConfig>();
    private static final SwiftCompilerControlConfig SWIFT_PROCESSING_DISABLED_MARKER = SwiftCompilerControlConfig.emptyConfig();

    public void execute() throws StorageException, ExecutionException {
        if (!this.basicTokenElementDelta.getDeletedKeys().isEmpty()) {
            Set<String> containedKeys = this.contentIndex.getContainedUniformPaths(this.basicTokenElementDelta.getDeletedKeysAsStrings());
            ArrayList<String> deletedUniformPaths = new ArrayList<String>(containedKeys);
            this.contentIndex.removeTokenElements(deletedUniformPaths);
            this.tokenElementLineInfoIndex.removeLineInfos(deletedUniformPaths);
        }
        this.executeInParallelBatches(this.determineChangedKeys(), this::processBatch);
        if (this.systemIncludeFileLookup != null) {
            this.systemIncludeFileLookup.syncIndexWithLocalCache();
        }
    }

    private void processBatch(List<String> changedKeys) throws StorageException {
        List<BasicTokenElementInfo> elements = this.basicTokenElementIndex.getTokenElements(changedKeys);
        List<CompilationCommand> compilationCommands = this.compileCommandIndex.getCommands(changedKeys);
        PairList values = new PairList();
        for (int i = 0; i < changedKeys.size(); ++i) {
            BasicTokenElementInfo element = elements.get(i);
            LOGGER.debug(() -> "Starting to process " + element.getUniformPath());
            elements.set(i, null);
            if (ContentIndexSynchronizer.shouldSkipElement(element)) {
                LOGGER.debug(() -> "Skipping " + element.getUniformPath());
                continue;
            }
            String uniformPath = changedKeys.get(i);
            this.createTokenElementInfo(element, compilationCommands.get(i)).ifPresent(tokenElement -> values.add((Object)uniformPath, (Object)tokenElement));
            LOGGER.debug(() -> "Finished processing " + element.getUniformPath());
        }
        this.contentIndex.setTokenElements((PairList<String, TokenElementInfo>)values);
        this.tokenElementLineInfoIndex.setLineInfos(ContentIndexSynchronizer.generateTokenElementLineInfos((PairList<String, TokenElementInfo>)values));
    }

    private static @NonNull PairList<String, TokenElementLineInfo> generateTokenElementLineInfos(PairList<String, TokenElementInfo> values) {
        PairList lineInfos = new PairList();
        for (Pair value : values) {
            try {
                lineInfos.add((Object)((String)value.getFirst()), (Object)TokenElementLineInfoBuilder.build((TokenElementInfo)((Object)value.getSecond())));
            }
            catch (RuntimeException e) {
                LOGGER.error("Severe unexpected error while generating TokenElementLineInfo for {}. Skipping line info for this file.", value.getFirst(), (Object)e);
            }
        }
        return lineInfos;
    }

    private List<String> determineChangedKeys() throws StorageException {
        HashSet<String> changedKeys = new HashSet<String>(this.basicTokenElementDelta.getAddedOrChangedKeysAsStrings());
        ArrayList<String> otherPathsRequiringReanalysis = new ArrayList<String>(this.reparseRequiredIndex.getAdditionalReparsingRequiredPaths(this.getSchedulingCommit()));
        if (!this.compileCommandDelta.isEmpty()) {
            otherPathsRequiringReanalysis.addAll(this.compileCommandDelta.getAllKeysAsStrings());
        }
        if (!otherPathsRequiringReanalysis.isEmpty()) {
            changedKeys.addAll(this.basicTokenElementIndex.getContainedUniformPaths(otherPathsRequiringReanalysis));
        }
        return new ArrayList<String>(changedKeys);
    }

    private static boolean isProjectModule(BasicTokenElementInfo element) {
        return element.getFirstDetailOfType(ProjectModuleTokenElementDetail.class).isPresent();
    }

    private static boolean shouldSkipElement(BasicTokenElementInfo element) {
        return element.getFirstDetailOfType(HiddenTokenElementDetail.class).isPresent();
    }

    private Optional<TokenElementInfo> createTokenElementInfo(BasicTokenElementInfo element, CompilationCommand compilationCommand) throws StorageException {
        List tokens;
        Object filterDeletions = element.getFilterDeletions();
        if (ContentIndexSynchronizer.isProjectModule(element)) {
            filterDeletions = Collections.singletonList(new Deletion(0, element.getText().length(), false));
        }
        String filteredText = "";
        try {
            StringOffsetTransformer transformer = new StringOffsetTransformer((List)filterDeletions);
            filteredText = transformer.filterString(element.getText());
        }
        catch (StringIndexOutOfBoundsException e) {
            LOGGER.error("Exception while applying deletions to " + element.getUniformPath(), (Throwable)e);
            return Optional.empty();
        }
        try {
            tokens = ScannerUtils.getTokens((String)filteredText, (ELanguage)element.getLanguage(), (String)element.getUniformPath());
            ContentIndexSynchronizer.findAndLogScannerErrors(element, tokens);
        }
        catch (RuntimeException e) {
            LOGGER.error("Severe unexpected error parsing file '{}', returning empty content.", (Object)element.getUniformPath(), (Object)e);
            return Optional.empty();
        }
        List<TokenElementDetailBase> elementDetails = this.preExtendElementDetails(element, compilationCommand);
        List<IToken> preprocessedTokens = this.preprocess(tokens, element, elementDetails);
        Optional<List<ShallowEntity>> entities = ContentIndexSynchronizer.parseTokensIfParserAvailable(element, preprocessedTokens);
        elementDetails = this.postExtendElementDetails(element, elementDetails, entities.orElse(null));
        return Optional.of(new TokenElementInfo(element.getUniformPath(), element.getLanguage(), element.getIsFileLanguageSetByUser(), element.getText(), (List<Deletion>)filterDeletions, elementDetails, preprocessedTokens, entities.orElse(null)));
    }

    private static void findAndLogScannerErrors(BasicTokenElementInfo element, List<IToken> tokens) {
        for (IToken token : tokens) {
            if (token == null || !token.getType().isError()) continue;
            String message = token.getType().name().toLowerCase().replace('_', ' ') + " at line " + token.getLineNumber() + " [" + token.getText() + "]";
            LOGGER.info(ShallowParsingUtils.PARSE_LOG_ENTRY_MARKER, (Message)new ParseLogMessage(EParseLogOrigin.SCANNER.name(), message, element.getUniformPath(), token.getLineNumber() + 1));
            break;
        }
    }

    private static Optional<List<ShallowEntity>> parseTokensIfParserAvailable(BasicTokenElementInfo element, List<IToken> preprocessedTokens) {
        if (!ShallowParserFactory.supportsLanguage((ELanguage)element.getLanguage())) {
            return Optional.empty();
        }
        try {
            List ast = ShallowParserFactory.createParser((ELanguage)element.getLanguage()).parseTopLevel(preprocessedTokens);
            ShallowEntity incomplete = ShallowEntityTraversalUtils.findIncompleteEntity((List)ast);
            if (incomplete != null) {
                LineOffsetConverter lineOffsetConverter = new LineOffsetConverter(element.getText());
                StringOffsetTransformer offsetTransformer = new StringOffsetTransformer((List)element.getFilterDeletions());
                String message = "Incompletely parsed node: " + incomplete.toLocalString();
                int rawStartOffset = offsetTransformer.getUnfilteredOffset(incomplete.getStartOffset());
                int startLine = lineOffsetConverter.getLine(rawStartOffset);
                LOGGER.info(ShallowParsingUtils.PARSE_LOG_ENTRY_MARKER, (Message)new ParseLogMessage(EParseLogOrigin.PARSER.name(), message, element.getUniformPath(), startLine));
            }
            return Optional.of(ast);
        }
        catch (ShallowParserException e) {
            CCSMAssert.fail((String)"Can not happen, as we checked for language before!");
            return Optional.empty();
        }
        catch (RuntimeException e) {
            LOGGER.error("Runtime Exception while parsing " + element.getUniformPath(), (Throwable)e);
            return Optional.of(List.of());
        }
        catch (Error e) {
            LOGGER.error("Error while parsing " + element.getUniformPath(), (Throwable)e);
            throw e;
        }
    }

    private List<TokenElementDetailBase> preExtendElementDetails(BasicTokenElementInfo basicElement, CompilationCommand compilationCommand) throws StorageException {
        ArrayList<TokenElementDetailBase> elementDetails = new ArrayList<TokenElementDetailBase>((Collection<TokenElementDetailBase>)basicElement.getDetails());
        if (LanguageGroups.C_AND_DERIVATIVES.contains(basicElement.getLanguage())) {
            CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(basicElement);
            this.loadCPreprocessingInputs(basicElement.getLanguage(), codeScopeName);
            IncludePathDetail includePathDetail = ContentIndexSynchronizer.buildIncludePathDetail(basicElement, compilationCommand, (CppSystemIncludeDirectories)this.metaIndex.getValue(CppSystemIncludeDirectories.class));
            elementDetails.removeIf(IncludePathDetail.class::isInstance);
            elementDetails.add(includePathDetail);
            PrependDirectivesDetail definitionsDetail = ContentIndexSynchronizer.buildPrependDirectivesDetail(basicElement, compilationCommand, (List)this.globalMacroDefinitions.get(Pair.createPair((Object)basicElement.getLanguage(), (Object)codeScopeName)));
            InitialMacroDefinitionsDetail initialMacroDefinitions = ContentIndexSynchronizer.buildInitialMacroDefinitionsDetail(basicElement, definitionsDetail, includePathDetail.getResolvedIncludeSearchPaths(), this.includeLookup, this.nonExistingPaths, this.cachedTokens, this.basicTokenElementIndex);
            elementDetails.removeIf(detail -> detail instanceof InitialMacroDefinitionsDetail || detail instanceof PrependDirectivesDetail);
            elementDetails.add(initialMacroDefinitions);
            elementDetails.add(definitionsDetail);
        }
        return elementDetails;
    }

    public static IncludePathDetail buildIncludePathDetail(BasicTokenElementInfo basicElement, CompilationCommand compilationCommand, CppSystemIncludeDirectories systemIncludeDirectories) {
        IncludePathDetail includePathDetail = basicElement.getFirstDetailOfType(IncludePathDetail.class).orElse(null);
        if (includePathDetail == null) {
            includePathDetail = new IncludePathDetail();
        } else {
            LOGGER.warn("BasicTokenElement already contains IncludePathDetail. That is unexpected. " + basicElement.getUniformPath());
        }
        if (compilationCommand != null) {
            includePathDetail.addToPath(compilationCommand.getIncludePathDetail());
        }
        if (systemIncludeDirectories != null) {
            includePathDetail.addToPath((Collection)systemIncludeDirectories.getDirectoriesForAllCodeScopes().getValue(CodeScopeAware.DEFAULT_CODE_SCOPE));
        }
        return includePathDetail;
    }

    public static @NonNull InitialMacroDefinitionsDetail buildInitialMacroDefinitionsDetail(BasicTokenElementInfo basicElement, PrependDirectivesDetail definitionsDetail, List<String> includePath, FileIncludeLookup includeLookup, Set<String> nonExistingPaths, ConcurrentMap<String, IncludedTokens> cachedTokens, BasicTokenElementIndex basicTokenElementIndex) {
        IndexAwareCPreprocessor preprocessor = new IndexAwareCPreprocessor(new ParsedMacroProvider(), includePath, includeLookup, nonExistingPaths, cachedTokens, basicTokenElementIndex, true, true);
        preprocessor.preprocess(basicElement.getUniformPath(), definitionsDetail.getPrependDirectiveTokens());
        List defaultMacros = preprocessor.getCurrentDefines().getAllDefines();
        return new InitialMacroDefinitionsDetail(defaultMacros);
    }

    public static PrependDirectivesDetail buildPrependDirectivesDetail(BasicTokenElementInfo basicElement, CompilationCommand compilationCommand, List<IToken> globalMacroDefinitionsForCodeScopeAndLanguage) {
        Optional definitionsDetailOptional = basicElement.getFirstDetailOfType(PrependDirectivesDetail.class);
        if (definitionsDetailOptional.isPresent()) {
            LOGGER.warn("BasicTokenElement already contains PrependDirectivesDetail. That is unexpected and the existing directives will be ignored/replaced. {}", (Object)basicElement.getUniformPath());
        }
        ArrayList<IToken> definitionTokens = new ArrayList<IToken>(globalMacroDefinitionsForCodeScopeAndLanguage);
        if (compilationCommand != null) {
            for (String definition : compilationCommand.getDefinitions()) {
                if (!definition.startsWith("-D") && !definition.startsWith("/D")) continue;
                String value = definition.substring(2);
                if (value.contains("=")) {
                    definitionTokens.addAll(ScannerUtils.getTokens((String)("#define " + value.replaceFirst("=", " ") + "\n"), (ELanguage)basicElement.getLanguage(), (String)"##compilation database compile command argument##"));
                    continue;
                }
                definitionTokens.addAll(ScannerUtils.getTokens((String)("#define " + value + " 1\n"), (ELanguage)basicElement.getLanguage(), (String)"##compilation database compile command argument##"));
            }
        }
        return new PrependDirectivesDetail(definitionTokens);
    }

    private List<TokenElementDetailBase> postExtendElementDetails(BasicTokenElementInfo basicElement, List<TokenElementDetailBase> elementDetails, List<ShallowEntity> entities) {
        if (basicElement.getLanguage() == ELanguage.IEC61131) {
            return IEC61131ContentUtils.getAndExtendIecDetails(basicElement.getUniformPath(), elementDetails, entities, this.basicTokenElementIndex);
        }
        if (basicElement.getFirstDetailOfType(CodeScopeDetail.class).isEmpty()) {
            String logMessage = "Found element without CodeScopeDetail: " + basicElement.getUniformPath() + " This indicates that we missed adding the detail when introducing this element. Assuming it is in the default code scope.";
            if (UniformPathCompatibilityUtil.convert((String)basicElement.getUniformPath()).isCodePath()) {
                LOGGER.error(logMessage);
            } else {
                LOGGER.warn(logMessage);
            }
            elementDetails.add(new CodeScopeDetail(CodeScopeAware.DEFAULT_CODE_SCOPE));
        }
        return elementDetails;
    }

    private List<IToken> preprocess(List<IToken> tokens, BasicTokenElementInfo element, List<TokenElementDetailBase> elementDetails) throws StorageException {
        try {
            Object preprocessor;
            switch (element.getLanguage()) {
                case CPP: 
                case CPP_MS_CLI: 
                case C: 
                case OBJECTIVE_C: 
                case OBJECTIVE_CPP: {
                    InitialMacroDefinitionsDetail initialMacros = (InitialMacroDefinitionsDetail)elementDetails.stream().filter(InitialMacroDefinitionsDetail.class::isInstance).findAny().orElseThrow();
                    IncludePathDetail includePathDetail = (IncludePathDetail)elementDetails.stream().filter(IncludePathDetail.class::isInstance).findAny().orElseThrow();
                    preprocessor = new IndexAwareCPreprocessor(initialMacros.definitions, includePathDetail.getResolvedIncludeSearchPaths(), this.includeLookup, this.nonExistingPaths, this.cachedTokens, this.basicTokenElementIndex, true, true);
                    break;
                }
                case ABAP: {
                    preprocessor = new AbapPreprocessor();
                    break;
                }
                case IEC61131: {
                    preprocessor = new Iec61131Preprocessor();
                    break;
                }
                case SWIFT: {
                    SwiftCompilerControlConfig swiftConfig = this.loadSwiftPreprocessorConfig(element);
                    if (swiftConfig == SWIFT_PROCESSING_DISABLED_MARKER) {
                        return tokens;
                    }
                    preprocessor = new SwiftPreprocessor(swiftConfig);
                    break;
                }
                default: {
                    return tokens;
                }
            }
            return this.applyPreprocessor(tokens, element, (IPreprocessor)preprocessor);
        }
        catch (Error | RuntimeException e) {
            LOGGER.error("Error while preprocessing '{}'", (Object)element.getUniformPath());
            throw e;
        }
    }

    private List<IToken> applyPreprocessor(List<IToken> tokens, BasicTokenElementInfo element, IPreprocessor preprocessor) throws StorageException {
        List<IToken> preprocessedTokens;
        if (preprocessor instanceof IndexAwareCPreprocessor) {
            IndexAwareCPreprocessor cPreprocessor = (IndexAwareCPreprocessor)preprocessor;
            List replacements = cPreprocessor.computeReplacementsForTranslationUnit(element.getUniformPath(), tokens);
            preprocessedTokens = this.applyReplacementsAndStoreExpansions(replacements, tokens, element);
        } else if (preprocessor instanceof SwiftPreprocessor) {
            SwiftPreprocessor swiftPreprocessor = (SwiftPreprocessor)preprocessor;
            List replacements = swiftPreprocessor.computeReplacements(element.getUniformPath(), tokens);
            preprocessedTokens = this.applyReplacementsAndStoreExpansions(replacements, tokens, element);
        } else {
            preprocessedTokens = preprocessor.preprocess(element.getUniformPath(), tokens);
            PreprocessorUtils.clearIfTokenNumberLimitExceeded((List)preprocessedTokens, (String)element.getUniformPath());
        }
        return preprocessedTokens;
    }

    private @NonNull List<IToken> applyReplacementsAndStoreExpansions(List<PreprocessorTokenReplacement> replacements, List<IToken> tokens, BasicTokenElementInfo element) throws StorageException {
        List preprocessedTokens = CPreprocessingUtils.applyReplacements(replacements, tokens);
        boolean limitExceeded = PreprocessorUtils.clearIfTokenNumberLimitExceeded((List)preprocessedTokens, (String)element.getUniformPath());
        if (!limitExceeded) {
            this.preprocessorExpansionsIndex.setExpansionsForUniformPath(element.getUniformPath(), new ArrayList<PreprocessorTokenReplacement>(replacements));
        }
        return preprocessedTokens;
    }

    private void loadCPreprocessingInputs(ELanguage language, CodeScopeName codeScopeName) throws StorageException {
        Pair key;
        if (this.systemIncludeFileLookup == null) {
            this.systemIncludeFileLookup = SystemIncludeFileLookup.create(this.metaIndex, this.systemIncludeFileCacheIndex);
        }
        if (this.includeLookup == null) {
            this.includeLookup = new FileIncludeLookup(this.pathLookupIndex.createPreloadedLookup(), this.systemIncludeFileLookup);
        }
        if (!this.globalMacroDefinitions.containsKey(key = Pair.createPair((Object)language, (Object)codeScopeName))) {
            ProjectConfiguration configuration = (ProjectConfiguration)this.metaIndex.getValue(ProjectConfiguration.class);
            if (configuration == null) {
                this.globalMacroDefinitions.put((Pair<ELanguage, CodeScopeName>)key, Collections.emptyList());
                return;
            }
            AnalysisProfile embeddedProfile = configuration.getEmbeddedProfile(codeScopeName);
            if (embeddedProfile == null) {
                this.globalMacroDefinitions.put((Pair<ELanguage, CodeScopeName>)key, Collections.emptyList());
                return;
            }
            String predefinedDirectives = embeddedProfile.getOptionValue("Predefined Preprocessor Macros");
            if (predefinedDirectives == null) {
                this.globalMacroDefinitions.put((Pair<ELanguage, CodeScopeName>)key, Collections.emptyList());
            } else {
                this.globalMacroDefinitions.put((Pair<ELanguage, CodeScopeName>)key, ScannerUtils.getTokens((String)predefinedDirectives, (ELanguage)language, (String)"default defines (analysis profile)"));
            }
        }
    }

    private SwiftCompilerControlConfig loadSwiftPreprocessorConfig(BasicTokenElementInfo basicElement) throws StorageException {
        CodeScopeName codeScopeName = CodeScopeDetail.getCodeScopeNameFromTokenElement(basicElement);
        return (SwiftCompilerControlConfig)CollectionUtils.computeIfAbsentWithException(this.globalSwiftConfiguration, (Object)codeScopeName, this::loadSwiftPreprocessorConfigForScope);
    }

    private SwiftCompilerControlConfig loadSwiftPreprocessorConfigForScope(CodeScopeName codeScopeName) throws StorageException {
        ProjectConfiguration configuration = (ProjectConfiguration)this.metaIndex.getValue(ProjectConfiguration.class);
        if (configuration == null) {
            return SwiftCompilerControlConfig.emptyConfig();
        }
        AnalysisProfile embeddedProfile = configuration.getEmbeddedProfile(codeScopeName);
        if (embeddedProfile == null) {
            return SwiftCompilerControlConfig.emptyConfig();
        }
        boolean swiftProcessingEnabled = Boolean.parseBoolean(embeddedProfile.getOptionValue("Swift: Enable Conditional Compilation Block Interpretation"));
        if (!swiftProcessingEnabled) {
            return SWIFT_PROCESSING_DISABLED_MARKER;
        }
        String customFlags = embeddedProfile.getOptionValue("Swift: Enabled Custom Compilation Flags");
        String platformConditions = embeddedProfile.getOptionValue("Swift: Platform Conditions Definitions");
        return SwiftCompilerControlConfig.fromStringOptions((String)platformConditions, (String)customFlags);
    }
}

