/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource;

import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.FileIncludeLookup;
import com.teamscale.index.resource.element_details.HiddenTokenElementDetail;
import eu.cqse.check.framework.preprocessor.c.CPreprocessor;
import eu.cqse.check.framework.preprocessor.c.EmptyMacroProvider;
import eu.cqse.check.framework.preprocessor.c.IMacroProvider;
import eu.cqse.check.framework.preprocessor.c.IncludeDirective;
import eu.cqse.check.framework.preprocessor.c.IncludedTokens;
import eu.cqse.check.framework.preprocessor.c.MacroDefinition;
import eu.cqse.check.framework.preprocessor.c.ParsedMacroProvider;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.ScannerUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class IndexAwareCPreprocessor
extends CPreprocessor {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<String> includePath;
    private final FileIncludeLookup includeLookup;
    private final Set<String> nonExistingPaths;
    private final ConcurrentMap<String, IncludedTokens> cachedTokens;
    private final BasicTokenElementIndex inputIndex;

    public IndexAwareCPreprocessor(List<MacroDefinition> definedMacros, List<String> includePath, FileIncludeLookup includeLookup, Set<String> nonExistingPaths, ConcurrentMap<String, IncludedTokens> cachedTokens, BasicTokenElementIndex inputIndex, boolean dropSourceCodeFromIncludedFiles, boolean disallowRepeatedIncludes) {
        this(new ParsedMacroProvider(definedMacros), includePath, includeLookup, nonExistingPaths, cachedTokens, inputIndex, dropSourceCodeFromIncludedFiles, disallowRepeatedIncludes);
    }

    public IndexAwareCPreprocessor(ParsedMacroProvider macroProvider, List<String> includePath, FileIncludeLookup includeLookup, Set<String> nonExistingPaths, ConcurrentMap<String, IncludedTokens> cachedTokens, BasicTokenElementIndex inputIndex, boolean dropSourceCodeFromIncludedFiles, boolean disallowRepeatedIncludes) {
        super(macroProvider, dropSourceCodeFromIncludedFiles, disallowRepeatedIncludes);
        this.includePath = includePath;
        this.includeLookup = includeLookup;
        this.nonExistingPaths = nonExistingPaths;
        this.cachedTokens = cachedTokens;
        this.inputIndex = inputIndex;
    }

    public IndexAwareCPreprocessor(FileIncludeLookup includeLookup, Set<String> nonExistingPaths, ConcurrentMap<String, IncludedTokens> cachedTokens, BasicTokenElementIndex inputIndex, boolean dropSourceCodeFromIncludedFiles, boolean disallowRepeatedIncludes) {
        this(new ParsedMacroProvider((IMacroProvider)new EmptyMacroProvider()), Collections.emptyList(), includeLookup, nonExistingPaths, cachedTokens, inputIndex, dropSourceCodeFromIncludedFiles, disallowRepeatedIncludes);
    }

    protected Optional<String> resolveInclude(String uniformPathOfIncludingFile, IncludeDirective includeDirective) {
        return this.includeLookup.resolveIncludeToUniformPath(includeDirective, uniformPathOfIncludingFile, this.includePath);
    }

    protected IncludedTokens resolveIncludedTokens(String uniformPathOfIncludingFile, IncludeDirective includeDirective) {
        try {
            Optional<String> includedPath = this.resolveInclude(uniformPathOfIncludingFile, includeDirective);
            if (includedPath.isEmpty()) {
                return IncludedTokens.empty();
            }
            return this.getUniformPathTokenList(uniformPathOfIncludingFile, includedPath.get());
        }
        catch (StorageException e) {
            LOGGER.error("Error while resolving included tokens in file {} for include {}: {}", (Object)uniformPathOfIncludingFile, (Object)includeDirective.getIncludedFilePath(), (Object)e.getMessage(), (Object)e);
            return IncludedTokens.empty();
        }
    }

    private IncludedTokens getUniformPathTokenList(String uniformPathOfIncludingFile, String resolvedIncludePath) throws StorageException {
        if (this.nonExistingPaths.contains(resolvedIncludePath)) {
            return null;
        }
        if (this.cachedTokens.containsKey(resolvedIncludePath)) {
            return (IncludedTokens)this.cachedTokens.get(resolvedIncludePath);
        }
        BasicTokenElementInfo element = this.inputIndex.getTokenElement(resolvedIncludePath);
        if (element != null) {
            List<IToken> tokens = IndexAwareCPreprocessor.scanAndDropCommentTokens(element.getUniformPath(), element.getText());
            if (this.dropSourceCodeFromIncludedFiles) {
                tokens = IndexAwareCPreprocessor.dropNonPreprocessorDirectiveTokens(tokens);
            }
            IncludedTokens includedTokens = new IncludedTokens(element.getUniformPath(), tokens, element.getFirstDetailOfType(HiddenTokenElementDetail.class).isEmpty());
            this.cachedTokens.put(resolvedIncludePath, includedTokens);
            return includedTokens;
        }
        Optional<List<IToken>> resolvedSystemInclude = this.includeLookup.getSystemIncludeFileLookup().readTokens(resolvedIncludePath);
        if (resolvedSystemInclude.isPresent()) {
            return new IncludedTokens(resolvedIncludePath, resolvedSystemInclude.get(), false);
        }
        LOGGER.error("Could neither find BasicTokenElementInfo nor resolve tokens for include path {} while processing {}", (Object)resolvedIncludePath, (Object)uniformPathOfIncludingFile);
        this.nonExistingPaths.add(resolvedIncludePath);
        return IncludedTokens.empty();
    }

    static List<IToken> scanAndDropCommentTokens(String uniformPath, String code) {
        List tokens = ScannerUtils.getTokens((String)code, (ELanguage)ELanguage.CPP, (String)uniformPath);
        return CollectionUtils.filter((Collection)tokens, token -> token.getType().getTokenClass() != ETokenType.ETokenClass.COMMENT);
    }

    private static List<IToken> dropNonPreprocessorDirectiveTokens(List<IToken> tokens) {
        EnumSet<ETokenType> tokenTypes = EnumSet.of(ETokenType.PREPROCESSOR_DIRECTIVE, ETokenType.PREPROCESSOR_INCLUDE, ETokenType.PRAGMA_DIRECTIVE);
        return CollectionUtils.filter(tokens, token -> tokenTypes.contains(token.getType()));
    }
}

