/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.metrics.code_scopes;

import com.teamscale.index.resource.CodeScopesMappingIndex;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.engine.index.shared.CodeScopeName;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

public class CodeScopesMetricsUtils {
    public static final String CODE_SCOPES_ROOT_PATH = UniformPath.EType.CODE_SCOPES.getPrefix();

    public static boolean isCodeScopesRootPath(String uniformPath) {
        return StringUtils.stripSuffix((String)uniformPath, (String)"/").equals(CODE_SCOPES_ROOT_PATH);
    }

    public static boolean isCodeScopeBasePath(String uniformPath) {
        return CodeScopesMetricsUtils.isCodeScopesPath(uniformPath) && UniformPathUtils.splitPath((String)uniformPath).length == 2;
    }

    public static boolean isCodeScopesPath(String uniformPath) {
        return uniformPath.startsWith(CODE_SCOPES_ROOT_PATH);
    }

    public static String removeCodeScopesPathPrefix(String uniformPath) {
        if (!CodeScopesMetricsUtils.isCodeScopesPath(uniformPath)) {
            return uniformPath;
        }
        if (CodeScopesMetricsUtils.isCodeScopesRootPath(uniformPath)) {
            return "";
        }
        return UniformPathUtils.removeFirstSegments((String)uniformPath, (int)2);
    }

    public static UniformPath removeCodeScopesPathPrefix(UniformPath uniformPath) {
        if (!uniformPath.isCodeScopesPath() || uniformPath.getPathSegments().size() < 2) {
            return uniformPath;
        }
        return UniformPath.codeRoot().resolve(uniformPath.getSubPath(1));
    }

    public static Optional<CodeScopeName> extractCodeScopeNameFromPath(String uniformPath) {
        if (!CodeScopesMetricsUtils.isCodeScopesPath(uniformPath)) {
            return Optional.empty();
        }
        String[] segments = UniformPathUtils.splitPath((String)uniformPath);
        if (segments.length < 2) {
            return Optional.empty();
        }
        return Optional.of(new CodeScopeName(segments[1]));
    }

    public static Set<UniformPath> getAllSubPathsInSameCodeScope(CodeScopesMappingIndex codeScopesMappingIndex, String uniformPath) throws StorageException {
        if (!CodeScopesMetricsUtils.isCodeScopesPath(uniformPath)) {
            return CollectionUtils.emptySet();
        }
        Map<UniformPath, CodeScopeName> codeScopeMappings = codeScopesMappingIndex.getAllMappings();
        Optional<CodeScopeName> codeScopeName = CodeScopesMetricsUtils.extractCodeScopeNameFromPath(uniformPath);
        if (codeScopeName.isEmpty()) {
            return codeScopeMappings.keySet();
        }
        UniformPath uniformPathWithoutCodeScope = UniformPathCompatibilityUtil.convert((String)CodeScopesMetricsUtils.removeCodeScopesPathPrefix(uniformPath));
        HashSet<UniformPath> codeScopeMappingsForSubPath = new HashSet<UniformPath>();
        for (Map.Entry<UniformPath, CodeScopeName> entry : codeScopeMappings.entrySet()) {
            if (!entry.getKey().hasAncestor(uniformPathWithoutCodeScope) || !entry.getValue().equals((Object)codeScopeName.get())) continue;
            codeScopeMappingsForSubPath.add(entry.getKey());
        }
        return codeScopeMappingsForSubPath;
    }
}

