/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.path_lookup;

import com.google.common.collect.ImmutableList;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.IPathMatchingPlausibilityCheck;
import java.util.Collection;
import java.util.Optional;
import org.apache.logging.log4j.Level;
import org.conqat.engine.core.logging.RateLimiting;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.Pair;

public class LoggingMatchingPathsLookup
implements IMatchingPathsLookup {
    private final IMatchingPathsLookup matchingPathsLookup;
    private final RateLimiting rateLimiting;

    private LoggingMatchingPathsLookup(IMatchingPathsLookup matchingPathsLookup, RateLimiting rateLimiting) {
        this.matchingPathsLookup = matchingPathsLookup;
        this.rateLimiting = rateLimiting;
    }

    public static LoggingMatchingPathsLookup wrap(IMatchingPathsLookup matchingPathsLookup) {
        return LoggingMatchingPathsLookup.wrap(matchingPathsLookup, new RateLimiting(100));
    }

    public static LoggingMatchingPathsLookup wrap(IMatchingPathsLookup matchingPathsLookup, RateLimiting rateLimiting) {
        CCSMAssert.isNotNull((Object)rateLimiting, () -> String.format("Expected \"%s\" to be not null", "rateLimiting"));
        return new LoggingMatchingPathsLookup(matchingPathsLookup, rateLimiting);
    }

    @Override
    public ImmutableList<String> lookupSuffix(String suffix) {
        ImmutableList<String> result = this.matchingPathsLookup.lookupSuffix(suffix);
        if (result == null || result.isEmpty()) {
            LOGGER.atLevel(this.getLevel()).log("Could not find an exact-suffix matching uniform path for: {}", (Object)suffix);
        }
        return result;
    }

    private Level getLevel() {
        return (Level)this.rateLimiting.applyLimit((Object)this, (Object)Level.WARN, (Object)Level.DEBUG, () -> LOGGER.warn("Reduced similar log messages. Turn on debug logging to see all."));
    }

    @Override
    public Optional<Pair<String, ImmutableList<String>>> lookupPath(String path) {
        return this.logPathIfEmpty(path, (Collection)((Object)this.matchingPathsLookup.lookupPath(path)));
    }

    @Override
    public Optional<String> lookupBestPath(String path) {
        return this.logPathIfEmpty(path, (Collection)((Object)this.matchingPathsLookup.lookupBestPath(path)));
    }

    @Override
    public Optional<String> lookupBestPath(String path, IPathMatchingPlausibilityCheck plausibilityCheck) {
        return this.logPathIfEmpty(path, (Collection)((Object)this.matchingPathsLookup.lookupBestPath(path, plausibilityCheck)));
    }

    private <T> Optional<T> logPathIfEmpty(String path, Optional<T> result) {
        if (result.isEmpty()) {
            LOGGER.atLevel(this.getLevel()).log("Could not find a matching uniform path for: {}", (Object)path);
        }
        return result;
    }

    private <C extends Collection<E>, E> C logPathIfEmpty(String path, C result) {
        if (result.isEmpty()) {
            LOGGER.atLevel(this.getLevel()).log("Could not find a matching uniform path for: {}", (Object)path);
        }
        return result;
    }

    @Override
    public ImmutableList<String> lookupAllPaths(String path) {
        ImmutableList<String> result = this.matchingPathsLookup.lookupAllPaths(path);
        if (result.size() > 1) {
            LOGGER.atLevel(this.getLevel()).log("Path lookup (all paths) did return more than one path for: {}", (Object)path);
        }
        return this.logPathIfEmpty(path, (Collection)result);
    }
}

