/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.path_lookup;

import com.google.common.collect.ImmutableList;
import com.teamscale.index.resource.path_lookup.IPathMatchingPlausibilityCheck;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public class PathLookupUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    static double getScore(String match, String suffix) {
        return (double)UniformPathUtils.splitPath((String)suffix).length / (double)UniformPathUtils.splitPath((String)match).length;
    }

    public static String normalizeAndReversePathEnsureEnding(String path) {
        return StringUtils.ensureEndsWith((String)PathLookupUtils.normalizeAndReversePath(path), (String)UniformPathUtils.SEPARATOR);
    }

    static String normalizeAndReversePath(String path) {
        CCSMAssert.isNotNull((Object)path);
        return StringUtils.reverse((String)UniformPathUtils.cleanPath((String)UniformPathUtils.normalizeAllSeparators((String)path.toLowerCase())));
    }

    public static String stripLeadingSlash(String path) {
        return StringUtils.stripPrefix((String)path, (String)UniformPathUtils.SEPARATOR);
    }

    static Optional<String> determinePlausibleAndHighestScoringMatch(String path, Pair<String, ImmutableList<String>> lookupResult, IPathMatchingPlausibilityCheck plausibilityCheck, double pathSuffixSizeRatioThreshold) {
        if (CollectionUtils.isNullOrEmpty((Collection)((Collection)lookupResult.getSecond()))) {
            return Optional.empty();
        }
        if (((ImmutableList)lookupResult.getSecond()).size() == 1) {
            return Optional.of((String)((ImmutableList)lookupResult.getSecond()).get(0));
        }
        Pair<String, ImmutableList<String>> lookupResultWithoutImplausibleMatches = PathLookupUtils.filterImplausiblePaths(path, plausibilityCheck, lookupResult);
        if (((ImmutableList)lookupResultWithoutImplausibleMatches.getSecond()).isEmpty()) {
            return PathLookupUtils.determineHighestScoringMatch(path, lookupResult, pathSuffixSizeRatioThreshold);
        }
        return PathLookupUtils.determineHighestScoringMatch(path, lookupResultWithoutImplausibleMatches, pathSuffixSizeRatioThreshold);
    }

    static int getLongestMatchingPathPrefixLength(String normalizedPathReversed, String reversedPathToMatch) {
        int lastSeparatorIndex = 0;
        for (int i = 0; i < Math.min(normalizedPathReversed.length(), reversedPathToMatch.length()); ++i) {
            char firstChar = normalizedPathReversed.charAt(i);
            char secondChar = reversedPathToMatch.charAt(i);
            if (secondChar != firstChar) break;
            if (firstChar != '/') continue;
            lastSeparatorIndex = i;
        }
        return lastSeparatorIndex;
    }

    static Optional<String> determineHighestScoringMatch(String pathFromReport, Pair<String, ImmutableList<String>> lookupResult, double pathSuffixSizeRatioThreshold) {
        List possiblePaths = (List)lookupResult.getSecond();
        if (possiblePaths.isEmpty()) {
            return Optional.empty();
        }
        String matchWithMinEditDistance = PathLookupUtils.getPathWithMinEditDistance(pathFromReport, possiblePaths);
        String suffix = UniformPathUtils.normalizeAllSeparators((String)((String)lookupResult.getFirst()));
        double score = PathLookupUtils.getScore((String)possiblePaths.get(0), suffix);
        if (score <= pathSuffixSizeRatioThreshold) {
            LOGGER.warn("Ignoring weak path matching '" + matchWithMinEditDistance + "' for report path '" + pathFromReport + "' as common suffix '" + suffix + "' is too small in relation to match");
            return Optional.empty();
        }
        if (possiblePaths.size() > 1) {
            LOGGER.warn("There are at least two possible, plausible matches for path '" + pathFromReport + "':\n" + StringUtils.concat(possiblePaths.subList(0, 2), (String)"\n") + "\nChoosing the first one due to a smaller edit distance.\n");
            return Optional.of(matchWithMinEditDistance);
        }
        return Optional.of(matchWithMinEditDistance);
    }

    private static String getPathWithMinEditDistance(String pathFromReport, List<String> possiblePaths) {
        String matchWithMinEditDistance = possiblePaths.get(0);
        if (possiblePaths.size() > 1) {
            matchWithMinEditDistance = possiblePaths.stream().min(Comparator.comparingInt(uniformPath -> StringUtils.editDistance((String)uniformPath, (String)pathFromReport))).get();
        }
        return matchWithMinEditDistance;
    }

    static boolean isOnlyFileName(String path) {
        return path.indexOf(47) < 0;
    }

    static float readPathLookupThresholdProperty() {
        return Float.parseFloat(System.getProperty("com.teamscale.path-lookup.suffix-threshold", "0"));
    }

    private static Pair<String, ImmutableList<String>> filterImplausiblePaths(String pathFromReport, @Nullable IPathMatchingPlausibilityCheck plausibilityCheck, Pair<String, ImmutableList<String>> lookupResult) {
        if (plausibilityCheck == null) {
            return lookupResult;
        }
        ImmutableList filteredPaths = (ImmutableList)((ImmutableList)lookupResult.getSecond()).stream().filter(possiblePath -> plausibilityCheck.check((String)possiblePath, pathFromReport)).collect(ImmutableList.toImmutableList());
        if (filteredPaths.isEmpty()) {
            LOGGER.warn("There are no known valid paths which passed the plausibility check for report path " + pathFromReport);
        }
        return Pair.createPair((Object)((String)lookupResult.getFirst()), (Object)filteredPaths);
    }
}

