/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.path_lookup;

import com.google.common.collect.ImmutableList;
import com.teamscale.index.resource.path_lookup.IMatchingPathsLookup;
import com.teamscale.index.resource.path_lookup.IPathLookupIndex;
import com.teamscale.index.resource.path_lookup.IPathMatchingPlausibilityCheck;
import com.teamscale.index.resource.path_lookup.LongestMatchingSuffixPathsCollector;
import com.teamscale.index.resource.path_lookup.PathLookupUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.tree.Trie;

public class PreloadedMatchingPathsLookup
implements IMatchingPathsLookup {
    private final double pathSuffixSizeRatioThreshold;
    private final Trie<ImmutableList<String>> pathsByNormalizedReversedPaths = new Trie();
    private final ConcurrentMap<String, Optional<Pair<String, ImmutableList<String>>>> lookupResultsByNormalizedReversedPaths = new ConcurrentHashMap<String, Optional<Pair<String, ImmutableList<String>>>>();
    private final ConcurrentMap<String, Optional<String>> lookupPathBestMatchCache = new ConcurrentHashMap<String, Optional<String>>();
    private final ConcurrentMap<String, ImmutableList<String>> lookupAllPathsCache = new ConcurrentHashMap<String, ImmutableList<String>>();

    private PreloadedMatchingPathsLookup(IPathLookupIndex pathLookupIndex, double pathSuffixSizeRatioThreshold) throws StorageException {
        this.pathSuffixSizeRatioThreshold = pathSuffixSizeRatioThreshold;
        HashMap collectorMap = new HashMap();
        pathLookupIndex.getEntries().forEach((key, value) -> {
            collectorMap.putIfAbsent(key, new ArrayList());
            ((List)collectorMap.get(key)).add(value);
        });
        for (Map.Entry entry : collectorMap.entrySet()) {
            this.pathsByNormalizedReversedPaths.put((String)entry.getKey(), (Object)ImmutableList.copyOf((Collection)((Collection)entry.getValue())));
        }
    }

    public static PreloadedMatchingPathsLookup createFrom(IPathLookupIndex pathLookupIndex, double pathSuffixSizeRatioThreshold) throws StorageException {
        return new PreloadedMatchingPathsLookup(pathLookupIndex, pathSuffixSizeRatioThreshold);
    }

    @Override
    public ImmutableList<String> lookupSuffix(String suffix) {
        if (suffix == null) {
            return ImmutableList.of();
        }
        Optional<Pair<String, ImmutableList<String>>> longestSuffixMatch = this.lookupPath(suffix);
        if (longestSuffixMatch.isEmpty() || !((String)longestSuffixMatch.get().getFirst()).toLowerCase().endsWith(suffix.toLowerCase())) {
            return ImmutableList.of();
        }
        return (ImmutableList)longestSuffixMatch.get().getSecond();
    }

    @Override
    public Optional<Pair<String, ImmutableList<String>>> lookupPath(String path) {
        if (path == null) {
            return Optional.empty();
        }
        Optional cacheLookupResult = (Optional)this.lookupResultsByNormalizedReversedPaths.get(path);
        if (cacheLookupResult != null) {
            return cacheLookupResult;
        }
        String normalizedPathReversed = PathLookupUtils.normalizeAndReversePathEnsureEnding(path);
        Optional<Pair<String, ImmutableList<String>>> result = this.lookupPath(path, normalizedPathReversed);
        this.lookupResultsByNormalizedReversedPaths.put(path, result);
        return result;
    }

    private Optional<Pair<String, ImmutableList<String>>> lookupPath(String path, String normalizedPathReversed) {
        List matchingPaths;
        if (this.pathsByNormalizedReversedPaths.containsKey(normalizedPathReversed) && (matchingPaths = (List)this.pathsByNormalizedReversedPaths.get(normalizedPathReversed)).size() == 1) {
            String matchedSuffix = (String)matchingPaths.getFirst();
            return Optional.of(Pair.createPair((Object)matchedSuffix, (Object)ImmutableList.of((Object)matchedSuffix)));
        }
        String reversedFileNameWithSlash = normalizedPathReversed.substring(0, normalizedPathReversed.indexOf(47) + 1);
        ConcurrentSkipListMap matchingPaths2 = new ConcurrentSkipListMap();
        this.pathsByNormalizedReversedPaths.streamValuesWithPrefix(reversedFileNameWithSlash).forEach(entry -> matchingPaths2.put((String)entry.getKey(), (ImmutableList)entry.getValue()));
        if (matchingPaths2.isEmpty() || !((String)matchingPaths2.firstEntry().getKey()).startsWith(reversedFileNameWithSlash)) {
            return Optional.empty();
        }
        LongestMatchingSuffixPathsCollector longestMatchingSuffixPathsCollector = new LongestMatchingSuffixPathsCollector(normalizedPathReversed);
        for (Map.Entry entry2 : matchingPaths2.entrySet()) {
            if (longestMatchingSuffixPathsCollector.collectPath((String)entry2.getKey(), (List)entry2.getValue())) break;
        }
        return longestMatchingSuffixPathsCollector.getLookupResult(path);
    }

    @Override
    public Optional<String> lookupBestPath(String pathFromReport) {
        return this.lookupBestPath(pathFromReport, null);
    }

    @Override
    public Optional<String> lookupBestPath(String pathFromReport, @Nullable IPathMatchingPlausibilityCheck plausibilityCheck) {
        return this.lookupPathBestMatchCache.computeIfAbsent(pathFromReport, s -> this.lookupBestPathAtomic((String)s, plausibilityCheck));
    }

    private Optional<String> lookupBestPathAtomic(String pathFromReport, @Nullable IPathMatchingPlausibilityCheck plausibilityCheck) {
        Optional<String> value = Optional.empty();
        Optional<Pair<String, ImmutableList<String>>> lookupResultOptional = this.lookupPath(pathFromReport);
        if (lookupResultOptional.isPresent()) {
            value = PathLookupUtils.determinePlausibleAndHighestScoringMatch(pathFromReport, lookupResultOptional.get(), plausibilityCheck, this.pathSuffixSizeRatioThreshold);
        }
        return value;
    }

    @Override
    public ImmutableList<String> lookupAllPaths(String pathFromReport) {
        return this.lookupAllPathsCache.computeIfAbsent(pathFromReport, this::lookupAllPathsAtomic);
    }

    private ImmutableList<String> lookupAllPathsAtomic(String pathFromReport) {
        Optional<Pair<String, ImmutableList<String>>> lookupResultOptional = this.lookupPath(pathFromReport);
        if (lookupResultOptional.isEmpty()) {
            return ImmutableList.of();
        }
        return (ImmutableList)lookupResultOptional.get().getSecond();
    }
}

