/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.resource.reparsing_dependency;

import com.teamscale.core.analysis.DeltaSource;
import com.teamscale.core.analysis.EIndexAccessMode;
import com.teamscale.core.analysis.IndexAccess;
import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.core.analysis.trigger.ChangeProcessorAnalysisStep;
import com.teamscale.index.resource.BasicTokenElementIndex;
import com.teamscale.index.resource.reparsing_dependency.PreprocessorIncludeReparseTrigger;
import com.teamscale.index.resource.reparsing_dependency.PreprocessorIncludeReparsingDependencyIndex;
import eu.cqse.check.framework.preprocessor.c.IncludeDirective;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ScannerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.conqat.engine.index.shared.BasicTokenElementInfo;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class PreprocessorIncludeReparsingDepedencyIndexSynchronizer
extends ChangeProcessorAnalysisStep {
    @IndexAccess(value=EIndexAccessMode.READ_ONLY)
    private BasicTokenElementIndex basicTokenElementIndex;
    @DeltaSource(value=BasicTokenElementIndex.class)
    private KeyDelta basicContentIndexDelta;
    @IndexAccess(value=EIndexAccessMode.READ_WRITE, indexName="reparsing-dependency")
    private PreprocessorIncludeReparsingDependencyIndex reparsingDependencyIndex;

    public void execute() throws StorageException {
        List deletedUniformPaths = this.basicContentIndexDelta.getDeletedKeysAsStrings();
        Map<String, ArrayList<String>> updatedValues = this.computeUpdatedValues(this.basicContentIndexDelta.getAddedOrChangedKeysAsStrings());
        this.reparsingDependencyIndex.putUpdatedValuesForChangedPaths(updatedValues, deletedUniformPaths);
    }

    private Map<String, ArrayList<String>> computeUpdatedValues(List<String> addedOrChangedUniformPaths) throws StorageException {
        HashMap<String, ArrayList<String>> result = new HashMap<String, ArrayList<String>>(addedOrChangedUniformPaths.size());
        List<BasicTokenElementInfo> basicElements = this.basicTokenElementIndex.getTokenElements(addedOrChangedUniformPaths);
        for (BasicTokenElementInfo basicElement : basicElements) {
            ELanguage language = basicElement.getLanguage();
            if (!PreprocessorIncludeReparseTrigger.RELEVANT_LANGUAGES.contains(language)) continue;
            List tokens = ScannerUtils.getTokens((String)basicElement.getText(), (ELanguage)language, (String)basicElement.getUniformPath());
            List<String> includedPaths = IncludeDirective.createFromTokens((List)tokens).stream().map(IncludeDirective::getIncludedFilePath).toList();
            ArrayList includeDependencyTargets = new ArrayList(CollectionUtils.map(includedPaths, PreprocessorIncludeReparsingDependencyIndex::buildDependencyTargetStorageKeyForIncludeName));
            result.put(basicElement.getUniformPath(), includeDependencyTargets);
        }
        return result;
    }
}

