/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.s3;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.SdkBaseException;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.DeleteObjectsRequest;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ListObjectsV2Request;
import com.amazonaws.services.s3.model.ListObjectsV2Result;
import com.google.common.base.Suppliers;
import com.google.common.collect.Lists;
import com.teamscale.core.config.TeamscaleSystemProperties;
import com.teamscale.index.repository.artifact_store.SimpleArtifactStoreClientBase;
import com.teamscale.index.s3.IS3Client;
import com.teamscale.index.s3.S3Exception;
import com.teamscale.index.s3.S3MultiPartOutputStream;
import com.teamscale.index.s3.S3ObjectMetadata;
import com.teamscale.index.s3.S3ObjectSummary;
import com.teamscale.index.s3.S3RegionUtils;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;

class S3Client
implements IS3Client {
    private static final int MAX_KEYS_PER_BATCH = 1000;
    private static final int REQUEST_TIMEOUT_MILLISECONDS;
    private static final int THREAD_POOL_SIZE;
    private static final ThreadPoolExecutor THREAD_POOL;
    private final Supplier<AmazonS3> s3ClientSupplier;
    private final @Nullable AWSCredentialsProvider credentialsProvider;

    public S3Client(String baseUri, @Nullable AWSCredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
        this.s3ClientSupplier = Suppliers.memoize(() -> ((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withCredentials(credentialsProvider)).withClientConfiguration(S3Client.createClientConfiguration())).withPathStyleAccessEnabled(Boolean.valueOf(true))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(baseUri, S3RegionUtils.extractRegionFromBaseUri(baseUri))))).build());
    }

    public S3Client(Supplier<AmazonS3> s3ClientSupplier, @Nullable AWSCredentialsProvider credentialsProvider) {
        this.s3ClientSupplier = s3ClientSupplier;
        this.credentialsProvider = credentialsProvider;
    }

    private static @NonNull ClientConfiguration createClientConfiguration() {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        clientConfiguration.setSocketTimeout(REQUEST_TIMEOUT_MILLISECONDS);
        return clientConfiguration;
    }

    @Override
    public InputStream getObjectContent(String bucket, String fullPath) throws S3Exception {
        try {
            return this.s3ClientSupplier.get().getObject(bucket, fullPath).getObjectContent();
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void writeObjectToFile(String bucket, String key, File file) throws S3Exception {
        try {
            this.s3ClientSupplier.get().getObject(new GetObjectRequest(bucket, key), file);
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public S3ObjectMetadata getObjectMetadata(String bucket, String fullPath) throws S3Exception {
        try {
            return new S3ObjectMetadata(this.s3ClientSupplier.get().getObjectMetadata(bucket, fullPath));
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void putObject(String bucket, String targetPath, InputStream dataStream, S3ObjectMetadata metadata) throws S3Exception {
        try {
            this.s3ClientSupplier.get().putObject(bucket, targetPath, dataStream, metadata.metadata());
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void putObject(String bucket, String targetPath, String content) throws S3Exception {
        try {
            this.s3ClientSupplier.get().putObject(bucket, targetPath, content);
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void deleteObject(String bucket, String path) throws S3Exception {
        try {
            this.s3ClientSupplier.get().deleteObject(bucket, path);
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public List<S3ObjectSummary> getAllObjectSummaries(String bucket, String prefix) throws S3Exception {
        try {
            ListObjectsV2Request request = (ListObjectsV2Request)new ListObjectsV2Request().withBucketName(bucket).withPrefix(prefix.trim()).withMaxKeys(Integer.valueOf(1000)).withSdkRequestTimeout(REQUEST_TIMEOUT_MILLISECONDS);
            ListObjectsV2Result response = this.s3ClientSupplier.get().listObjectsV2(request);
            ArrayList summaries = new ArrayList(response.getObjectSummaries());
            while (response.isTruncated()) {
                response = this.s3ClientSupplier.get().listObjectsV2(request.withContinuationToken(response.getNextContinuationToken()));
                summaries.addAll(response.getObjectSummaries());
            }
            return CollectionUtils.map(summaries, S3ObjectSummary::createFromAwsObject);
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public List<S3ObjectSummary> getAllObjectSummariesOptimizedByKnownPaths(String bucket, String prefix, SimpleArtifactStoreClientBase.ItemQueryResultData previouslyKnownPaths) throws S3Exception {
        List keyChunks = Lists.partition(previouslyKnownPaths.results.stream().map(SimpleArtifactStoreClientBase.ItemData::getFullPath).sorted().toList(), (int)Math.max(previouslyKnownPaths.results.size() / THREAD_POOL_SIZE, 1000));
        List<Pair<String, String>> chunkStartEndKeyPairs = S3Client.createStartAndEndKeyPairsForEachChunk(keyChunks);
        ArrayList<Future<List<S3ObjectSummary>>> futures = new ArrayList<Future<List<S3ObjectSummary>>>();
        for (Pair<String, String> chunkStartAndEndPair : chunkStartEndKeyPairs) {
            futures.add(THREAD_POOL.submit(() -> this.getS3ObjectSummariesForKeyChunk(bucket, prefix, chunkStartAndEndPair)));
        }
        return S3Client.waitForAndCollectObjectSummaries(futures);
    }

    private static @NonNull List<Pair<String, String>> createStartAndEndKeyPairsForEachChunk(List<List<String>> keyChunks) {
        if (keyChunks.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, String>> chunkStartEndKeyPairs = new ArrayList<Pair<String, String>>();
        chunkStartEndKeyPairs.add(new Pair(null, (Object)keyChunks.getFirst().getFirst()));
        for (int i = 0; i < keyChunks.size() - 1; ++i) {
            chunkStartEndKeyPairs.add((Pair<String, String>)new Pair((Object)keyChunks.get(i).getFirst(), (Object)keyChunks.get(i + 1).getFirst()));
        }
        chunkStartEndKeyPairs.add(new Pair((Object)keyChunks.getLast().getFirst(), null));
        return chunkStartEndKeyPairs;
    }

    private static @NonNull List<S3ObjectSummary> waitForAndCollectObjectSummaries(List<Future<List<S3ObjectSummary>>> futures) throws S3Exception {
        ArrayList<S3ObjectSummary> allObjectSummaries = new ArrayList<S3ObjectSummary>();
        for (Future<List<S3ObjectSummary>> future : futures) {
            try {
                List<S3ObjectSummary> result = future.get();
                allObjectSummaries.addAll(result);
            }
            catch (InterruptedException | ExecutionException e) {
                throw new S3Exception("Failed to list objects", e);
            }
        }
        return allObjectSummaries.stream().sorted(Comparator.comparing(S3ObjectSummary::key)).distinct().toList();
    }

    private @NonNull List<S3ObjectSummary> getS3ObjectSummariesForKeyChunk(String bucket, String prefix, Pair<String, String> startEndKeyPair) throws S3Exception {
        try {
            ListObjectsV2Request request = (ListObjectsV2Request)new ListObjectsV2Request().withBucketName(bucket).withStartAfter((String)startEndKeyPair.getFirst()).withPrefix(prefix.trim()).withMaxKeys(Integer.valueOf(1000)).withSdkRequestTimeout(REQUEST_TIMEOUT_MILLISECONDS);
            ListObjectsV2Result response = this.s3ClientSupplier.get().listObjectsV2(request);
            ArrayList summaries = new ArrayList(response.getObjectSummaries());
            while (response.isTruncated() && (startEndKeyPair.getSecond() == null || ((com.amazonaws.services.s3.model.S3ObjectSummary)summaries.getLast()).getKey().compareTo((String)startEndKeyPair.getSecond()) < 0)) {
                response = this.s3ClientSupplier.get().listObjectsV2(request.withContinuationToken(response.getNextContinuationToken()));
                summaries.addAll(response.getObjectSummaries());
            }
            return CollectionUtils.map(summaries, S3ObjectSummary::createFromAwsObject);
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void validateCredentials() throws S3Exception {
        try {
            if (this.credentialsProvider != null) {
                this.credentialsProvider.refresh();
            }
        }
        catch (IllegalStateException e) {
            throw new S3Exception(String.format("Failed to validate S3 credentials: %s", e.getMessage()), e);
        }
    }

    @Override
    public List<S3ObjectSummary> listObjects(String bucket, String keyPrefix) throws S3Exception {
        try {
            return CollectionUtils.map((Collection)this.s3ClientSupplier.get().listObjectsV2(bucket, keyPrefix).getObjectSummaries(), S3ObjectSummary::createFromAwsObject);
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void validateRead(String bucket, String keyPrefix) throws S3Exception {
        try {
            this.s3ClientSupplier.get().listObjects(new ListObjectsRequest().withBucketName(bucket).withPrefix(keyPrefix).withMaxKeys(Integer.valueOf(1)));
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public OutputStream initiateMultipartUpload(String bucket, String key) throws S3Exception {
        try {
            return S3MultiPartOutputStream.init(this.s3ClientSupplier.get(), bucket, key);
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    @Override
    public void deleteObjects(String bucket, Stream<String> keys) throws S3Exception {
        try {
            this.s3ClientSupplier.get().deleteObjects(new DeleteObjectsRequest(bucket).withKeys(keys.map(DeleteObjectsRequest.KeyVersion::new).toList()));
        }
        catch (SdkBaseException e) {
            throw new S3Exception(e, bucket);
        }
    }

    static {
        System.setProperty("aws.java.v1.disableDeprecationAnnouncement", Boolean.TRUE.toString());
        REQUEST_TIMEOUT_MILLISECONDS = Math.toIntExact(Duration.ofSeconds(TeamscaleSystemProperties.S3_REQUEST_TIMEOUT_SECONDS.getValue().orElse(60).intValue()).toMillis());
        THREAD_POOL_SIZE = TeamscaleSystemProperties.S3_THREAD_POOL_SIZE.getValue().orElse(40);
        THREAD_POOL = new ThreadPoolExecutor(THREAD_POOL_SIZE, THREAD_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
    }
}

