/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.simulink.clones;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkElementBase;
import org.conqat.lib.simulink.model.SimulinkLine;

public class BlockTripleGenerator {
    public static TripleGenerationResult generateTriples(Collection<SimulinkBlock> blocks) {
        Set<String> allIds = blocks.stream().map(SimulinkElementBase::getId).collect(Collectors.toSet());
        TripleGenerationResult result = new TripleGenerationResult();
        HashSet<String> seenTriples = new HashSet<String>();
        for (SimulinkBlock block : blocks) {
            List<SimulinkBlock> connected = BlockTripleGenerator.listConnectedBlocks(block, allIds);
            if (connected.isEmpty()) {
                result.singletonBlocks.add(block);
                continue;
            }
            if (connected.size() == 1) {
                if (block.getId().compareTo(connected.get(0).getId()) >= 0) continue;
                result.pairs.add((Pair<SimulinkBlock, SimulinkBlock>)Pair.createPair((Object)block, (Object)connected.get(0)));
                continue;
            }
            BlockTripleGenerator.generateTriples(block, connected, seenTriples, result.triples);
        }
        Set tripleIds = result.triples.stream().flatMap(Collection::stream).map(SimulinkElementBase::getId).collect(Collectors.toSet());
        result.pairs.removeIf(pair -> tripleIds.contains(((SimulinkBlock)pair.getFirst()).getId()) || tripleIds.contains(((SimulinkBlock)pair.getSecond()).getId()));
        return result;
    }

    private static List<SimulinkBlock> listConnectedBlocks(SimulinkBlock block, Set<String> allIds) {
        HashSet<String> containedIds = new HashSet<String>();
        containedIds.add(block.getId());
        ArrayList<SimulinkBlock> result = new ArrayList<SimulinkBlock>();
        for (SimulinkLine inLine : block.getInLines()) {
            SimulinkBlock inBlock;
            if (inLine.getSrcPort() == null || !allIds.contains((inBlock = inLine.getSrcPort().getBlock()).getId()) || containedIds.contains(inBlock.getId())) continue;
            result.add(inBlock);
            containedIds.add(inBlock.getId());
        }
        for (SimulinkLine outLine : block.getOutLines()) {
            SimulinkBlock outBlock;
            if (outLine.getDstPort() == null || !allIds.contains((outBlock = outLine.getDstPort().getBlock()).getId()) || containedIds.contains(outBlock.getId())) continue;
            result.add(outBlock);
            containedIds.add(outBlock.getId());
        }
        return result;
    }

    private static void generateTriples(SimulinkBlock pegBlock, List<SimulinkBlock> connected, Set<String> seenTriples, List<List<SimulinkBlock>> triples) {
        for (int i = 0; i < connected.size(); ++i) {
            for (int j = i + 1; j < connected.size(); ++j) {
                List<SimulinkBlock> triple = Arrays.asList(pegBlock, connected.get(i), connected.get(j));
                if (!seenTriples.add(BlockTripleGenerator.createIdCode(triple))) continue;
                triples.add(triple);
            }
        }
    }

    static String createIdCode(List<SimulinkBlock> triple) {
        return triple.stream().map(SimulinkElementBase::getId).sorted().collect(Collectors.joining("::"));
    }

    public static class TripleGenerationResult {
        private final List<SimulinkBlock> singletonBlocks = new ArrayList<SimulinkBlock>();
        private final List<Pair<SimulinkBlock, SimulinkBlock>> pairs = new ArrayList<Pair<SimulinkBlock, SimulinkBlock>>();
        private final List<List<SimulinkBlock>> triples = new ArrayList<List<SimulinkBlock>>();

        public List<SimulinkBlock> getSingletonBlocks() {
            return this.singletonBlocks;
        }

        public List<Pair<SimulinkBlock, SimulinkBlock>> getPairs() {
            return this.pairs;
        }

        public List<List<SimulinkBlock>> getTriples() {
            return this.triples;
        }
    }
}

