/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.stacktrace.resolver;

import com.teamscale.index.resource.path_lookup.PathLookupIndex;
import com.teamscale.index.stacktrace.component.StackFrame;
import java.util.Optional;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;

public class UniformPathResolver {
    private final PathLookupIndex pathLookupIndex;

    public UniformPathResolver(PathLookupIndex pathLookupIndex) {
        this.pathLookupIndex = pathLookupIndex;
    }

    public Optional<UniformPath> resolveFileName(StackFrame stackFrame) {
        if (stackFrame.getLocation() == null) {
            return Optional.empty();
        }
        StringBuilder stringBuilder = new StringBuilder();
        String classNameAsPath = stackFrame.getClassName().replace('.', '/');
        stringBuilder.append(StringUtils.removeLastPart((String)classNameAsPath, (char)'/'));
        stringBuilder.append('/');
        stringBuilder.append(stackFrame.getLocation().getFileName());
        Optional<String> foundPath = this.pathLookupIndex.lookupBestPath(stringBuilder.toString());
        if (foundPath.isPresent()) {
            String[] segments = UniformPathUtils.splitPath((String)foundPath.get());
            return Optional.of(UniformPath.ofSegments((String[])segments));
        }
        return Optional.empty();
    }
}

