/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.ExecutedMethodIndex;
import com.teamscale.index.testgap.MethodInfoIndex;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.persistence.store.hist.HistoryAccessOption;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.test.IndexValueClass;
import org.jetbrains.annotations.VisibleForTesting;

@IndexValueClass
public class MethodInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LogManager.getLogger();
    private final String methodName;
    private final long creationTimestamp;
    private final long lastChangedTimestamp;
    private final String hash;
    private final boolean isTrivial;
    private Set<ExecutedMethodIndex.ExecutedMethodAccessKey> crossAnnotationKeys;
    private final CommitDescriptor lastInfoUpdateCommit;
    private PairList<CommitDescriptor, String> predecessorCommitsWithKeys;
    private PairList<Integer, Long> semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp;

    public MethodInfo(String methodName, long creationTimestamp, long lastChangedTimestamp, String hash, CommitDescriptor lastInfoUpdateCommit, PairList<CommitDescriptor, String> predecessorCommitsWithKeys, Set<ExecutedMethodIndex.ExecutedMethodAccessKey> crossAnnotationKeys, boolean isTrivial, PairList<Integer, Long> semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp) {
        this.lastInfoUpdateCommit = lastInfoUpdateCommit;
        this.methodName = methodName;
        this.creationTimestamp = creationTimestamp;
        this.lastChangedTimestamp = lastChangedTimestamp;
        this.hash = hash;
        this.predecessorCommitsWithKeys = predecessorCommitsWithKeys;
        this.crossAnnotationKeys = crossAnnotationKeys;
        this.isTrivial = isTrivial;
        this.semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp = semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp;
    }

    @VisibleForTesting
    public MethodInfo(String methodName, long creationTimestamp, long lastChangedTimestamp, String hash, CommitDescriptor lastInfoUpdateCommit, PairList<CommitDescriptor, String> predecessorCommitsWithKeys, Set<ExecutedMethodIndex.ExecutedMethodAccessKey> crossAnnotationKeys) {
        this(methodName, creationTimestamp, lastChangedTimestamp, hash, lastInfoUpdateCommit, predecessorCommitsWithKeys, crossAnnotationKeys, false, (PairList<Integer, Long>)new PairList());
    }

    @VisibleForTesting
    public MethodInfo(String methodName, CommitDescriptor creationCommit) {
        this(methodName, creationCommit.getTimestamp(), creationCommit.getTimestamp(), "", creationCommit, MethodInfo.createPredecessorListWithOnlyOneDummyOnDummyBranch(), (Set<ExecutedMethodIndex.ExecutedMethodAccessKey>)CollectionUtils.emptySet(), false, (PairList<Integer, Long>)new PairList());
    }

    @VisibleForTesting
    public MethodInfo(String methodName, long creationTimestamp, long lastChangeTimestamp, CommitDescriptor lastInfoUpdateCommit, String predecessorKey, CommitDescriptor predecessor) {
        this(methodName, creationTimestamp, lastChangeTimestamp, "", lastInfoUpdateCommit, MethodInfo.zipPredecessors(predecessorKey, predecessor), (Set<ExecutedMethodIndex.ExecutedMethodAccessKey>)CollectionUtils.emptySet(), false, (PairList<Integer, Long>)new PairList());
    }

    @VisibleForTesting
    public MethodInfo(String methodName, long creationTimestamp, long lastChangeTimestamp, CommitDescriptor lastInfoUpdateCommit, PairList<CommitDescriptor, String> predecessorCommitsWithKeys, PairList<Integer, Long> semanticallyEquivalentPredecessorsWithLastChangeTimestamp) {
        this(methodName, creationTimestamp, lastChangeTimestamp, "", lastInfoUpdateCommit, predecessorCommitsWithKeys, (Set<ExecutedMethodIndex.ExecutedMethodAccessKey>)CollectionUtils.emptySet(), false, semanticallyEquivalentPredecessorsWithLastChangeTimestamp);
    }

    @VisibleForTesting
    public MethodInfo(String methodName, CommitDescriptor creationCommit, boolean isTrivial) {
        this(methodName, creationCommit.getTimestamp(), creationCommit.getTimestamp(), "", creationCommit, MethodInfo.createPredecessorListWithOnlyOneDummyOnDummyBranch(), (Set<ExecutedMethodIndex.ExecutedMethodAccessKey>)CollectionUtils.emptySet(), isTrivial, (PairList<Integer, Long>)new PairList());
    }

    @VisibleForTesting
    public MethodInfo(String methodName, CommitDescriptor creationCommit, String hash) {
        this(methodName, creationCommit.getTimestamp(), creationCommit.getTimestamp(), hash, creationCommit, MethodInfo.createPredecessorListWithOnlyOneDummyOnDummyBranch(), (Set<ExecutedMethodIndex.ExecutedMethodAccessKey>)CollectionUtils.emptySet(), false, (PairList<Integer, Long>)new PairList());
    }

    private static PairList<CommitDescriptor, String> createPredecessorListWithOnlyOneDummyOnDummyBranch() {
        PairList predecessors = new PairList();
        MethodInfo.addDummyPredecessor("dummy-branch-for-testing", (PairList<CommitDescriptor, String>)predecessors);
        return predecessors;
    }

    private static PairList<CommitDescriptor, String> zipPredecessors(String predecessorKey, CommitDescriptor predecessor) {
        if (predecessorKey == null) {
            return new PairList();
        }
        return new PairList(Collections.singletonMap(predecessor, predecessorKey));
    }

    public List<CommitDescriptor> extractPredecessorCommits() {
        return this.getPredecessorCommitsWithKeys().extractFirstList();
    }

    public List<String> extractPredecessorKeys() {
        return this.getPredecessorCommitsWithKeys().extractSecondList();
    }

    public @Nullable Pair<CommitDescriptor, String> extractPredecessorInBranch(String branchName) {
        return this.getPredecessorCommitsWithKeys().stream().filter(predecessor -> ((CommitDescriptor)predecessor.getFirst()).getBranchName().equals(branchName) && !MethodInfo.isDummyCommit((CommitDescriptor)predecessor.getFirst())).findFirst().orElse(null);
    }

    public static void addDummyPredecessor(String branchName, PairList<CommitDescriptor, String> predecessorList) {
        predecessorList.add((Object)new CommitDescriptor(branchName, 0L), null);
    }

    public static boolean isDummyCommit(CommitDescriptor commit) {
        return commit.getTimestamp() == 0L;
    }

    public boolean hasNoPredecessorOnCurrentBranch() {
        if (this.predecessorCommitsWithKeys.isEmpty()) {
            LOGGER.error("The method " + this.methodName + " has no predecessors, but should at least have a dummy predecessor.");
            return true;
        }
        return MethodInfo.isDummyCommit((CommitDescriptor)this.predecessorCommitsWithKeys.getFirst(0));
    }

    public String getHash() {
        return this.hash;
    }

    public boolean isTrivial() {
        return this.isTrivial;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public long getCreationTimestamp() {
        return this.creationTimestamp;
    }

    public long getLastChangedTimestamp() {
        return this.lastChangedTimestamp;
    }

    public CommitDescriptor getLastInfoUpdateCommit() {
        return this.lastInfoUpdateCommit;
    }

    public Set<ExecutedMethodIndex.ExecutedMethodAccessKey> getCrossAnnotationKeys() {
        return this.crossAnnotationKeys;
    }

    public PairList<CommitDescriptor, String> getPredecessorCommitsWithKeys() {
        return this.predecessorCommitsWithKeys;
    }

    public String toString() {
        return "MethodInfo [methodName=" + this.methodName + ", creationTimestamp=" + this.creationTimestamp + ", lastChangedTimestamp=" + this.lastChangedTimestamp + ", hash=" + this.hash + ", lastInfoUpdateCommit=" + String.valueOf(this.lastInfoUpdateCommit) + ", predecessorCommits=" + String.valueOf(this.getPredecessorCommitsWithKeys()) + ", crossAnnotationKeys=" + String.valueOf(this.crossAnnotationKeys) + "]";
    }

    public int hashCode() {
        return Objects.hash(this.methodName, this.creationTimestamp, this.lastChangedTimestamp, this.hash, this.lastInfoUpdateCommit, this.getPredecessorCommitsWithKeys(), this.crossAnnotationKeys);
    }

    public boolean equals(Object other) {
        if (other instanceof MethodInfo) {
            MethodInfo otherInfo = (MethodInfo)other;
            return Objects.equals(this.methodName, otherInfo.methodName) && Objects.equals(this.creationTimestamp, otherInfo.creationTimestamp) && Objects.equals(this.lastChangedTimestamp, otherInfo.lastChangedTimestamp) && Objects.equals(this.hash, otherInfo.hash) && Objects.equals(this.lastInfoUpdateCommit, otherInfo.lastInfoUpdateCommit) && Objects.equals(this.getPredecessorCommitsWithKeys(), otherInfo.getPredecessorCommitsWithKeys()) && Objects.equals(this.crossAnnotationKeys, otherInfo.crossAnnotationKeys);
        }
        return false;
    }

    void serializeWithoutCrossAnnotationsTo(DataOutputStream dataStream) throws IOException {
        dataStream.writeLong(this.creationTimestamp);
        dataStream.writeLong(this.lastChangedTimestamp);
        dataStream.writeUTF(this.lastInfoUpdateCommit.getBranchName());
        dataStream.writeLong(this.lastInfoUpdateCommit.getTimestamp());
        dataStream.writeUTF(this.hash);
        dataStream.writeUTF(this.methodName);
        dataStream.writeBoolean(this.isTrivial);
    }

    void serializeCrossAnnotationInfo(DataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.predecessorCommitsWithKeys.size());
        for (Pair predecessorWithKey : this.predecessorCommitsWithKeys) {
            outputStream.writeUTF(StringUtils.emptyIfNull((String)((String)predecessorWithKey.getSecond())));
            outputStream.writeUTF(((CommitDescriptor)predecessorWithKey.getFirst()).getBranchName());
            outputStream.writeLong(((CommitDescriptor)predecessorWithKey.getFirst()).getTimestamp());
        }
        outputStream.writeInt(this.crossAnnotationKeys.size());
        for (ExecutedMethodIndex.ExecutedMethodAccessKey key : this.crossAnnotationKeys) {
            outputStream.writeUTF(key.toMethodEntryKey());
        }
        outputStream.writeInt(this.semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp.size());
        for (Pair predecessor : this.semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp) {
            outputStream.writeInt((Integer)predecessor.getFirst());
            outputStream.writeLong((Long)predecessor.getSecond());
        }
    }

    void readCrossAnnotationInfo(DataInputStream dataInputStream) throws IOException {
        int predecessorCount = dataInputStream.readInt();
        this.predecessorCommitsWithKeys = new PairList(predecessorCount);
        for (int i = 0; i < predecessorCount; ++i) {
            String predecessorKey = StringUtils.nullIfEmpty((String)dataInputStream.readUTF());
            this.predecessorCommitsWithKeys.add((Object)new CommitDescriptor(dataInputStream.readUTF(), dataInputStream.readLong()), (Object)predecessorKey);
        }
        int crossAnnotationKeyCount = dataInputStream.readInt();
        this.crossAnnotationKeys = new HashSet<ExecutedMethodIndex.ExecutedMethodAccessKey>(crossAnnotationKeyCount);
        for (int i = 0; i < crossAnnotationKeyCount; ++i) {
            this.crossAnnotationKeys.add(ExecutedMethodIndex.ExecutedMethodAccessKey.fromMethodEntryKey(dataInputStream.readUTF()));
        }
        int semanticallyEquivalentPredecessorCount = dataInputStream.readInt();
        this.semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp = new PairList(semanticallyEquivalentPredecessorCount);
        for (int i = 0; i < semanticallyEquivalentPredecessorCount; ++i) {
            this.semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp.add((Object)dataInputStream.readInt(), (Object)dataInputStream.readLong());
        }
    }

    static MethodInfo deserializeWithoutCrossAnnotationsFrom(DataInputStream dataStream) throws IOException {
        long creationTimestamp = dataStream.readLong();
        long lastChangedTimestamp = dataStream.readLong();
        String creationCommitBranch = dataStream.readUTF();
        long creationCommitTimestamp = dataStream.readLong();
        CommitDescriptor creationCommit = new CommitDescriptor(creationCommitBranch, creationCommitTimestamp);
        String hash = dataStream.readUTF();
        String methodName = dataStream.readUTF();
        boolean isTrivial = dataStream.readBoolean();
        return new MethodInfo(methodName, creationTimestamp, lastChangedTimestamp, hash, creationCommit, null, null, isTrivial, null);
    }

    public @NonNull List<AssociatedMethodInfo> calculatePredecessors(ProjectStorageSystem projectStorageSystem) throws StorageException {
        ArrayList<AssociatedMethodInfo> result = new ArrayList<AssociatedMethodInfo>();
        if (this.predecessorCommitsWithKeys == null) {
            return result;
        }
        for (Pair predecessorWithKey : this.predecessorCommitsWithKeys) {
            CommitDescriptor predecessorCommit = (CommitDescriptor)predecessorWithKey.getFirst();
            String predecessorKey = (String)predecessorWithKey.getSecond();
            if (MethodInfo.isDummyCommit(predecessorCommit)) continue;
            MethodInfoIndex index = (MethodInfoIndex)projectStorageSystem.openProjectIndex(MethodInfoIndex.class, HistoryAccessOption.readTimestamp((String)predecessorCommit.getBranchName(), (long)predecessorCommit.getTimestamp()));
            String predecessorUniformPath = MethodInfoIndex.getUniformPathFromKey(predecessorKey);
            OffsetBasedRegion predecessorRegion = MethodInfoIndex.getRegion(predecessorKey);
            MethodInfo predecessorInfo = index.getMethodInfoWithCrossAnnotationInfo(predecessorUniformPath, predecessorRegion);
            CCSMAssert.isNotNull((Object)predecessorInfo, (String)("Incorrect predecessor info for method " + String.valueOf(this) + " at " + String.valueOf(this.lastInfoUpdateCommit) + ": Predecessor " + predecessorKey + " at " + String.valueOf(predecessorCommit) + " not found in index"));
            result.add(new AssociatedMethodInfo(predecessorUniformPath, predecessorRegion, predecessorInfo));
        }
        return result;
    }

    public boolean hadARealChangeSinceItsPredecessor() {
        return this.isAddedMethod() || this.lastChangedTimestamp == this.getLastInfoUpdateCommit().getTimestamp();
    }

    public boolean isMergeConflictResolution() {
        return this.isFromMergeCommit() && this.semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp.isEmpty();
    }

    private boolean isFromMergeCommit() {
        return this.predecessorCommitsWithKeys.size() > 1;
    }

    public boolean isAddedMethod() {
        return this.creationTimestamp == this.lastInfoUpdateCommit.getTimestamp();
    }

    public PairList<Integer, Long> getSemanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp() {
        return this.semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp;
    }

    public long getLastChangeTimestampForPredecessorCommit(CommitDescriptor commit) {
        Optional index = this.predecessorCommitsWithKeys.indexOfFirst((Object)commit);
        if (index.isEmpty()) {
            LOGGER.error("The specified commit is not part of the method's predecessors " + commit.toString());
            return -1L;
        }
        Optional indexInSemanticallyEquivalentPredecessors = this.semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp.indexOfFirst((Object)((Integer)index.get()));
        if (indexInSemanticallyEquivalentPredecessors.isEmpty()) {
            LOGGER.error("Could not find the last change timestamp for the given commit: " + commit.toString());
            return -1L;
        }
        return (Long)this.semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp.getSecond(((Integer)indexInSemanticallyEquivalentPredecessors.get()).intValue());
    }

    public Optional<CommitDescriptor> getSemanticallyEquivalentPredecessorCommitForBranchIndex(int branchIndex) {
        if (this.semanticallyEquivalentPredecessorIndicesWithLastChangeTimestamp.getFirstList().contains((Object)branchIndex)) {
            return Optional.of((CommitDescriptor)this.predecessorCommitsWithKeys.getFirst(branchIndex));
        }
        return Optional.empty();
    }

    public boolean isRelevantForTgaTreemap(boolean isTestCode, boolean isTgaEnabledInCodeScope) {
        return !this.isTrivial && !isTestCode && isTgaEnabledInCodeScope;
    }
}

