/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.core.analysis.KeyDelta;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.MethodInfo;
import com.teamscale.index.testgap.MethodInfoIndex;
import com.teamscale.index.testgap.MethodLocation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;

public class MethodInfoDelta {
    private final KeyDelta delta;
    private final MethodInfoIndex newMethodInfoIndex;
    private final MethodInfoIndex oldMethodInfoIndex;
    private final List<MethodLocation> deletedLocations = new ArrayList<MethodLocation>();
    private final List<ChangedMethod> addedOrChangedMethods = new ArrayList<ChangedMethod>();

    public MethodInfoDelta(KeyDelta methodInfoDelta, MethodInfoIndex newMethodInfoIndex, MethodInfoIndex oldMethodInfoIndex) throws StorageException {
        this.delta = methodInfoDelta;
        this.newMethodInfoIndex = newMethodInfoIndex;
        this.oldMethodInfoIndex = oldMethodInfoIndex;
        this.calculateLocationChanges();
    }

    private void calculateLocationChanges() throws StorageException {
        List<AssociatedMethodInfo> infosFromChangedFiles = this.newMethodInfoIndex.getAssociatedMethodInfosForExactPathsWithCrossAnnotationInfo(MethodInfoIndex.getUniformPathsFromDelta(this.delta.getAddedOrChangedKeysAsStrings()));
        for (AssociatedMethodInfo changedInfo : infosFromChangedFiles) {
            List<MethodLocation> predecessors = MethodInfoDelta.convertPredecessorKeysToLocations(changedInfo);
            ChangedMethod changedMethod = new ChangedMethod(changedInfo.getLocation(), predecessors, changedInfo.hadARealChangeSinceItsPredecessor(), changedInfo.isMergeConflictResolution());
            this.addedOrChangedMethods.add(changedMethod);
        }
        this.calculateDeletedLocations(infosFromChangedFiles);
    }

    private static List<MethodLocation> convertPredecessorKeysToLocations(AssociatedMethodInfo changedInfo) {
        ArrayList<MethodLocation> predecessors = new ArrayList<MethodLocation>();
        changedInfo.getPredecessorCommitsWithKeys().forEach((commit, predecessorKey) -> {
            if (MethodInfo.isDummyCommit(commit)) {
                predecessors.add(null);
            } else {
                predecessors.add(MethodLocation.fromIndexKey(predecessorKey));
            }
        });
        return predecessors;
    }

    private void calculateDeletedLocations(List<AssociatedMethodInfo> infosFromChangedFiles) throws StorageException {
        List<AssociatedMethodInfo> deletedInfos = this.oldMethodInfoIndex.getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(MethodInfoIndex.getUniformPathsFromDelta(this.delta.getDeletedKeysAsStrings()));
        this.deletedLocations.addAll(CollectionUtils.map(deletedInfos, AssociatedMethodInfo::getLocation));
        List<AssociatedMethodInfo> changedInfosInOldIndex = this.oldMethodInfoIndex.getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(MethodInfoIndex.getUniformPathsFromDelta(this.delta.getAddedOrChangedKeysAsStrings()));
        Set changedLocationsInOldIndex = changedInfosInOldIndex.stream().filter(Objects::nonNull).map(AssociatedMethodInfo::getLocation).collect(Collectors.toSet());
        Set changedLocationsInNewIndex = infosFromChangedFiles.stream().map(AssociatedMethodInfo::getLocation).collect(Collectors.toSet());
        this.deletedLocations.addAll(CollectionUtils.subtract(changedLocationsInOldIndex, changedLocationsInNewIndex));
    }

    public List<MethodLocation> getDeletedLocations() {
        return this.deletedLocations;
    }

    public List<ChangedMethod> getAddedOrChangedMethods() {
        return this.addedOrChangedMethods;
    }

    public static class ChangedMethod {
        private final MethodLocation newMethod;
        private final List<MethodLocation> predecessors;
        private final boolean isRealChange;
        private final boolean isMergeConflictResolution;

        public ChangedMethod(MethodLocation newMethod, List<MethodLocation> predecessors, boolean isRealChange, boolean isMergeConflictResolution) {
            this.newMethod = newMethod;
            this.predecessors = predecessors;
            this.isRealChange = isRealChange;
            this.isMergeConflictResolution = isMergeConflictResolution;
        }

        public ChangedMethod(MethodLocation newMethod, List<MethodLocation> predecessors, boolean isRealChange) {
            this(newMethod, predecessors, isRealChange, false);
        }

        public static ChangedMethod newAddition(MethodLocation location) {
            return new ChangedMethod(location, Collections.singletonList(null), true);
        }

        public MethodLocation getNewMethod() {
            return this.newMethod;
        }

        public List<MethodLocation> getPredecessors() {
            return this.predecessors;
        }

        public boolean isFromMergeCommit() {
            return this.predecessors.size() > 1;
        }

        public boolean isRealChange() {
            return this.isRealChange;
        }

        public boolean isMergeConflictResolution() {
            return this.isMergeConflictResolution;
        }

        public boolean isFirstParentAddition() {
            return this.predecessors.isEmpty() || this.predecessors.get(0) == null;
        }

        public String toString() {
            return "ChangedMethod [newMethod=" + String.valueOf(this.newMethod) + ", predecessors=" + String.valueOf(this.predecessors) + ", isRealChange=" + this.isRealChange + "]";
        }

        public final boolean equals(Object other) {
            if (!(other instanceof ChangedMethod)) {
                return false;
            }
            ChangedMethod castOther = (ChangedMethod)other;
            return Objects.equals(this.newMethod, castOther.newMethod) && Objects.equals(this.predecessors, castOther.predecessors) && Objects.equals(this.isRealChange, castOther.isRealChange) && Objects.equals(this.isMergeConflictResolution, castOther.isMergeConflictResolution);
        }

        public final int hashCode() {
            return Objects.hash(this.newMethod, this.predecessors, this.isRealChange, this.isMergeConflictResolution);
        }
    }
}

