/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap;

import com.teamscale.index.resource.TokenElementInfo;
import com.teamscale.index.testgap.MethodLocation;
import java.util.List;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.region.OffsetBasedRegion;
import org.conqat.lib.commons.string.LineOffsetConverter;

public class TestGapLineCoverageUtils {
    public static LineCoverageInfo createLineCoverageInfo(TokenElementInfo element, long timestamp, List<MethodLocation> methodLocations) {
        LineCoverageInfo info = new LineCoverageInfo(timestamp, timestamp, true);
        LineOffsetConverter converter = new LineOffsetConverter(element.getText());
        TestGapLineCoverageUtils.appendToLineCoverageInfo(converter, methodLocations, info);
        return info;
    }

    public static void appendToLineCoverageInfo(LineOffsetConverter converter, List<MethodLocation> methodLocations, LineCoverageInfo info) {
        for (MethodLocation methodLocation : methodLocations) {
            OffsetBasedRegion offsetBasedRegion = methodLocation.getRegion();
            int startLine = converter.getLine(offsetBasedRegion.getStart());
            int endLine = converter.getLine(offsetBasedRegion.getEnd());
            info.addRangeCoverage(startLine, endLine, ELineCoverage.PARTIALLY_COVERED);
        }
    }
}

