/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.index;

import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.index.resource.ContainerIndex;
import com.teamscale.index.resource.ContainerInfo;
import com.teamscale.index.resource.ResourceServiceUtils;
import com.teamscale.index.resource.metrics.architecture.ArchitectureMetricsUtils;
import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.TgaDataRetrieverIndexes;
import com.teamscale.index.testgap.index.CrossAnnotator;
import com.teamscale.index.testgap.index.DataRetrieverUtils;
import com.teamscale.index.testgap.index.ITgaDataRetriever;
import com.teamscale.index.testgap.index.TestInfoFilter;
import com.teamscale.index.testgap.index.UnassessedTestGapData;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;

public class ArchitecturePathDataRetriever
implements ITgaDataRetriever {
    private final String uniformPath;
    private final List<String> partitions;
    private final TgaDataRetrieverIndexes dataRetrieverIndexes;
    private final CrossAnnotator crossAnnotator;
    private final TestInfoFilter testInfoFilter;
    private final CodeScopeAware<Boolean> tgaEnablementPerCodeScope;

    public ArchitecturePathDataRetriever(String uniformPath, List<String> partitions, TgaDataRetrieverIndexes dataRetrieverIndexes, CrossAnnotator crossAnnotator, TestInfoFilter testInfoFilter, CodeScopeAware<Boolean> tgaEnablementPerCodeScope) {
        this.uniformPath = uniformPath;
        this.partitions = partitions;
        this.crossAnnotator = crossAnnotator;
        this.dataRetrieverIndexes = dataRetrieverIndexes;
        this.testInfoFilter = testInfoFilter;
        this.tgaEnablementPerCodeScope = tgaEnablementPerCodeScope;
    }

    @Override
    public UnassessedTestGapData fetchData(MethodInfoFilter methodInfoFilter) throws StorageException {
        if (ArchitectureMetricsUtils.isArchitectureRootPath(this.uniformPath)) {
            return new UnassessedTestGapData(this.createDataForRootPathToArchitectures(methodInfoFilter));
        }
        String pathWithSlash = ResourceServiceUtils.getUniformPathPrefixContainerAware(this.dataRetrieverIndexes.getContainerIndex(), this.uniformPath);
        Map<String, String> sourceToArchitecturePathMap = ArchitectureMetricsUtils.getRecursivePathMappings(this.dataRetrieverIndexes.getMetricsToArchitectureMetricsMappingIndex(), pathWithSlash);
        UnassessedTestGapData dataWithoutArchitecturePaths = this.fetchDataForUniformPaths(sourceToArchitecturePathMap.keySet(), methodInfoFilter);
        List<UnassessedTestGapData.UnassessedMethodData> methodsWithArchitecturePaths = ArchitecturePathDataRetriever.changeUniformPathBackToArchitecturePath(dataWithoutArchitecturePaths, sourceToArchitecturePathMap);
        return new UnassessedTestGapData(methodsWithArchitecturePaths);
    }

    private UnassessedTestGapData fetchDataForUniformPaths(Collection<String> uniformPaths, MethodInfoFilter methodInfoFilter) throws StorageException {
        ArrayList<String> uniformPathList = new ArrayList<String>(uniformPaths);
        List<AssociatedMethodInfo> methodInfos = this.dataRetrieverIndexes.getMethodInfoIndex().getAssociatedMethodInfosForExactPathsWithoutCrossAnnotationInfo(uniformPathList);
        return DataRetrieverUtils.createUnassessedTestGapData(methodInfos, this.partitions, this.crossAnnotator, this.dataRetrieverIndexes, methodInfoFilter, this.testInfoFilter, this.tgaEnablementPerCodeScope);
    }

    private List<UnassessedTestGapData.UnassessedMethodData> createDataForRootPathToArchitectures(MethodInfoFilter methodInfoFilter) throws StorageException {
        ContainerIndex containerIndex = this.dataRetrieverIndexes.getContainerIndex();
        ContainerInfo containerInfo = containerIndex.getContainer(ArchitectureMetricsUtils.ROOT_PATH_TO_ARCHITECTURES);
        if (containerInfo == null) {
            return CollectionUtils.emptyList();
        }
        Set<String> architectures = ArchitecturePathDataRetriever.getArchitectures(containerInfo, containerIndex);
        ArrayList<Map<String, String>> pathMappings = new ArrayList<Map<String, String>>();
        HashSet<String> sourcePaths = new HashSet<String>();
        for (String architecture : architectures) {
            Map<String, String> sourceToArchitecturePathMap = ArchitectureMetricsUtils.getRecursivePathMappings(this.dataRetrieverIndexes.getMetricsToArchitectureMetricsMappingIndex(), architecture);
            pathMappings.add(sourceToArchitecturePathMap);
            sourcePaths.addAll(sourceToArchitecturePathMap.keySet());
        }
        UnassessedTestGapData dataWithoutArchitecturePaths = this.fetchDataForUniformPaths(sourcePaths, methodInfoFilter);
        ArrayList<UnassessedTestGapData.UnassessedMethodData> methods = new ArrayList<UnassessedTestGapData.UnassessedMethodData>();
        for (Map map : pathMappings) {
            List<UnassessedTestGapData.UnassessedMethodData> translatedMethods = ArchitecturePathDataRetriever.changeUniformPathBackToArchitecturePath(dataWithoutArchitecturePaths, map);
            methods.addAll(translatedMethods);
        }
        return methods;
    }

    private static Set<String> getArchitectures(ContainerInfo containerInfo, ContainerIndex containerIndex) throws StorageException {
        HashSet<String> architectures = new HashSet<String>();
        Set<String> children = containerInfo.getChildren();
        for (String child : children) {
            if (UniformPathUtils.isArchitectureRootComponent((String)child)) {
                architectures.add(child);
                continue;
            }
            architectures.addAll(ArchitecturePathDataRetriever.getArchitectures(containerIndex.getContainer(child), containerIndex));
        }
        return architectures;
    }

    static List<UnassessedTestGapData.UnassessedMethodData> changeUniformPathBackToArchitecturePath(UnassessedTestGapData dataWithoutArchitecturePaths, @NonNull Map<String, String> sourceToArchitecturePathMap) {
        ArrayList<UnassessedTestGapData.UnassessedMethodData> translatedMethods = new ArrayList<UnassessedTestGapData.UnassessedMethodData>();
        for (UnassessedTestGapData.UnassessedMethodData method : dataWithoutArchitecturePaths.getMethods()) {
            String architecturePath = sourceToArchitecturePathMap.get(method.getLocation().getUniformPath());
            if (architecturePath == null) continue;
            translatedMethods.add(method.withUniformPath(architecturePath));
        }
        return translatedMethods;
    }
}

