/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.index;

import com.teamscale.index.testgap.AssociatedMethodInfo;
import com.teamscale.index.testgap.ExecutedMethodIndex;
import com.teamscale.index.testgap.MethodInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;

public class CrossAnnotator {
    private final List<ExecutedMethodIndex> executionIndexes;
    private final ProjectStorageSystem projectStorageSystem;
    private final BiPredicate<MethodInfo, MethodInfo> shouldBeConsideredForCrossAnnotationPredicate;

    private CrossAnnotator(List<ExecutedMethodIndex> executionIndexes, ProjectStorageSystem projectStorageSystem, BiPredicate<MethodInfo, MethodInfo> shouldBeConsideredForCrossAnnotationPredicate) {
        this.executionIndexes = executionIndexes;
        this.projectStorageSystem = projectStorageSystem;
        this.shouldBeConsideredForCrossAnnotationPredicate = shouldBeConsideredForCrossAnnotationPredicate;
    }

    public boolean isExecutedByCrossAnnotation(AssociatedMethodInfo methodInfo) throws StorageException {
        if (this.executionIndexes.isEmpty()) {
            return false;
        }
        AssociatedMethodInfo methodInfoForCrossAnnotation = this.createMethodInfoForCrossAnnotation(this.projectStorageSystem, methodInfo);
        return CrossAnnotator.isExecuted(this.executionIndexes, methodInfoForCrossAnnotation);
    }

    public List<ExecutedMethodIndex> getCrossAnnotationExecutedIndexesFor(AssociatedMethodInfo methodInfo) throws StorageException {
        ArrayList<ExecutedMethodIndex> results = new ArrayList<ExecutedMethodIndex>();
        if (this.executionIndexes.isEmpty()) {
            return results;
        }
        AssociatedMethodInfo methodInfoForCrossAnnotation = this.createMethodInfoForCrossAnnotation(this.projectStorageSystem, methodInfo);
        for (ExecutedMethodIndex index : this.executionIndexes) {
            if (!index.isMethodExecuted(methodInfoForCrossAnnotation)) continue;
            results.add(index);
        }
        return results;
    }

    private AssociatedMethodInfo createMethodInfoForCrossAnnotation(ProjectStorageSystem projectStorageSystem, AssociatedMethodInfo methodInfo) throws StorageException {
        HashSet<ExecutedMethodIndex.ExecutedMethodAccessKey> crossAnnotationKeys = new HashSet<ExecutedMethodIndex.ExecutedMethodAccessKey>();
        this.recursivelyAddRelevantCrossAnnotationsFromPredecessors(crossAnnotationKeys, methodInfo, methodInfo, projectStorageSystem);
        return methodInfo.cloneWithCrossAnnotationKeys(crossAnnotationKeys);
    }

    private static boolean isExecuted(List<ExecutedMethodIndex> executionIndexes, AssociatedMethodInfo methodInfo) throws StorageException {
        for (ExecutedMethodIndex index : executionIndexes) {
            if (!index.isMethodExecuted(methodInfo)) continue;
            return true;
        }
        return false;
    }

    private void recursivelyAddRelevantCrossAnnotationsFromPredecessors(Set<ExecutedMethodIndex.ExecutedMethodAccessKey> crossAnnotationKeys, AssociatedMethodInfo assessedMethod, AssociatedMethodInfo currentChild, ProjectStorageSystem projectStorage) throws StorageException {
        if (currentChild == null || !this.shouldBeConsideredForCrossAnnotationPredicate.test(assessedMethod, currentChild)) {
            return;
        }
        crossAnnotationKeys.add(new ExecutedMethodIndex.ExecutedMethodAccessKey(currentChild.getUniformPath(), currentChild));
        if (currentChild.getCrossAnnotationKeys() != null) {
            crossAnnotationKeys.addAll(currentChild.getCrossAnnotationKeys());
        }
        List<AssociatedMethodInfo> predecessors = currentChild.calculatePredecessors(projectStorage);
        for (AssociatedMethodInfo predecessor : predecessors) {
            this.recursivelyAddRelevantCrossAnnotationsFromPredecessors(crossAnnotationKeys, assessedMethod, predecessor, projectStorage);
        }
    }

    public static CrossAnnotator createForIssueRequest(List<ExecutedMethodIndex> executionIndexes, ProjectStorageSystem projectStorageSystem, long lastCommitToIssueTimestamp) {
        return new CrossAnnotator(executionIndexes, projectStorageSystem, (assessedMethod, predecessor) -> predecessor.getLastInfoUpdateCommit().getTimestamp() >= lastCommitToIssueTimestamp);
    }

    public static CrossAnnotator createForNonIssueRequest(List<ExecutedMethodIndex> executionIndexes, ProjectStorageSystem projectStorageSystem) {
        return new CrossAnnotator(executionIndexes, projectStorageSystem, (assessedMethod, predecessor) -> predecessor.getLastInfoUpdateCommit().getTimestamp() >= assessedMethod.getLastInfoUpdateCommit().getTimestamp());
    }

    public boolean hasCrossAnnotationIndices() {
        return !this.executionIndexes.isEmpty();
    }
}

