/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.query;

import com.teamscale.core.analysis.configuration.ProjectConfigurationException;
import com.teamscale.core.analysis.configuration.index.AnalysisProfileIndex;
import com.teamscale.core.analysis.configuration.index.model.ProjectConfiguration;
import com.teamscale.core.analysis.configuration.model.CodeScopeAware;
import com.teamscale.core.index.CommitResolvingStorageSystem;
import com.teamscale.core.index.IndexLayer;
import com.teamscale.index.merge_request.BranchPointNotFoundException;
import com.teamscale.index.merge_request.MergeRequestChangedMethod;
import com.teamscale.index.merge_request.MergeRequestTestGapInfo;
import com.teamscale.index.repository.MergeBaseInfo;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndex;
import com.teamscale.index.repository.RepositoryCommitIssueMappingIndexCache;
import com.teamscale.index.testgap.ETestGapState;
import com.teamscale.index.testgap.assessment.AssessedTgaData;
import com.teamscale.index.testgap.assessment.ETgaAssessmentType;
import com.teamscale.index.testgap.assessment.TgaAggregationUtils;
import com.teamscale.index.testgap.query.CoverageSourceParameterBase;
import com.teamscale.index.testgap.query.CoverageSourceQueryParameters;
import com.teamscale.index.testgap.query.IssueTgaParameters;
import com.teamscale.index.testgap.query.MethodInfoFilter;
import com.teamscale.index.testgap.query.TgaBranchMergeRequest;
import com.teamscale.index.testgap.query.TgaIssueRequest;
import com.teamscale.index.testgap.query.TgaRequestQueryOptions;
import com.teamscale.wia.TeamscaleIssueId;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.engine.index.shared.IProjectId;
import org.conqat.engine.index.shared.MergeRequestIdentifier;
import org.conqat.engine.index.shared.PublicProjectId;
import org.conqat.engine.persistence.index.IProjectIndex;
import org.conqat.engine.persistence.index.MetaIndex;
import org.conqat.engine.persistence.index.schema.GlobalStorageSystem;
import org.conqat.engine.persistence.index.schema.ProjectStorageSystem;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.CounterSet;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;

public class TgaRequestUtils {
    public static <T extends IProjectIndex> PairList<PublicProjectId, T> getCrossAnnotationIndexes(Collection<PublicProjectId> projectIds, Class<T> indexClass, IndexLayer indexLayer) throws StorageException {
        PairList indexes = new PairList();
        for (PublicProjectId projectId : projectIds) {
            indexes.add((Object)projectId, (Object)indexLayer.openNonHistorizedProjectIndex(indexClass, (IProjectId)projectId));
        }
        return indexes;
    }

    public static RepositoryCommitIssueMappingIndexCache createAndPreloadIssueMappingCache(List<TeamscaleIssueId> issueIds, CommitResolvingStorageSystem projectStorageSystem) throws StorageException {
        RepositoryCommitIssueMappingIndex mappingIndex = (RepositoryCommitIssueMappingIndex)projectStorageSystem.openProjectIndex(RepositoryCommitIssueMappingIndex.class, null);
        return new RepositoryCommitIssueMappingIndexCache(mappingIndex, issueIds);
    }

    public static Optional<Pair<Double, Boolean>> calculateTestGapRatioForIssue(TeamscaleIssueId issueId, IndexLayer indexLayer, IProjectId projectId, boolean autoSelectBranch, String branch, long endCommitTimestamp) throws StorageException {
        CommitResolvingStorageSystem projectStorageSystem = indexLayer.openProjectStorageSystem(projectId);
        RepositoryCommitIssueMappingIndexCache mappingIndexCache = TgaRequestUtils.createAndPreloadIssueMappingCache(Collections.singletonList(issueId), projectStorageSystem);
        if (mappingIndexCache.getValue(issueId) == null) {
            return Optional.empty();
        }
        IssueTgaParameters issueTgaParameters = new IssueTgaParameters(autoSelectBranch, branch, true);
        ETgaAssessmentType assessmentType = ETgaAssessmentType.TEST_GAP;
        TgaIssueRequest singleIssueRequest = TgaIssueRequest.createRequest(issueId, (CoverageSourceParameterBase)CoverageSourceQueryParameters.ALL_PARTITIONS, issueTgaParameters, assessmentType, endCommitTimestamp, projectId, indexLayer, mappingIndexCache);
        AssessedTgaData assessedData = singleIssueRequest.fetchAndAssessData();
        CounterSet<ETestGapState> states = TgaAggregationUtils.countStates(assessedData);
        double ratio = TgaAggregationUtils.calculateRatio(assessmentType, states);
        boolean hasChangedMethods = states.getTotal() > 0;
        return Optional.of(Pair.createPair((Object)ratio, (Object)hasChangedMethods));
    }

    public static MergeRequestTestGapInfo calculateTestGapsForMergeRequest(CommitDescriptor sourceCommit, MergeRequestIdentifier mergeRequestIdentifier, MergeBaseInfo mergeBase, IndexLayer indexLayer, IProjectId projectId) throws StorageException, BranchPointNotFoundException {
        TgaBranchMergeRequest tgaBranchMergeRequest = TgaRequestUtils.createTgaBranchMergeRequest(sourceCommit, mergeRequestIdentifier, mergeBase, ETgaAssessmentType.TEST_GAP, indexLayer, projectId);
        AssessedTgaData assessedTgaData = tgaBranchMergeRequest.fetchAndAssessData();
        List<AssessedTgaData.AssessedMethodData> untestedMethods = assessedTgaData.getChangedMethods(true);
        List allChangedMethods = CollectionUtils.map(assessedTgaData.getChangedMethods(false), method -> new MergeRequestChangedMethod(method.getMethodName(), method.getLocation()));
        return new MergeRequestTestGapInfo(TgaAggregationUtils.countStates(assessedTgaData), untestedMethods, allChangedMethods, mergeRequestIdentifier);
    }

    public static List<AssessedTgaData.AssessedMethodData> getAllChangedMethodsInMergeRequest(CommitDescriptor sourceCommit, MergeRequestIdentifier mergeRequestIdentifier, MergeBaseInfo mergeBase, IndexLayer indexLayer, IProjectId projectId) throws StorageException, BranchPointNotFoundException {
        TgaBranchMergeRequest tgaBranchMergeRequest = TgaRequestUtils.createTgaBranchMergeRequest(sourceCommit, mergeRequestIdentifier, mergeBase, ETgaAssessmentType.CHURN, indexLayer, projectId);
        return tgaBranchMergeRequest.fetchAndAssessData(MethodInfoFilter.DEFAULT).getChangedMethods(false);
    }

    private static TgaBranchMergeRequest createTgaBranchMergeRequest(CommitDescriptor sourceCommit, MergeRequestIdentifier mergeRequestIdentifier, MergeBaseInfo mergeBase, ETgaAssessmentType assessmentType, IndexLayer indexLayer, IProjectId projectId) throws StorageException, BranchPointNotFoundException {
        TgaRequestQueryOptions tgaRequestQueryOptions = new TgaRequestQueryOptions(false, null, true, null, null, mergeRequestIdentifier);
        return TgaBranchMergeRequest.createRequest(CoverageSourceQueryParameters.ALL_PARTITIONS, assessmentType, sourceCommit, tgaRequestQueryOptions, mergeBase, indexLayer, projectId);
    }

    public static CodeScopeAware<Boolean> getTgaEnablementPerCodeScope(ProjectStorageSystem projectStorageSystem, GlobalStorageSystem globalStorageSystem) throws StorageException {
        ProjectConfiguration projectConfiguration = (ProjectConfiguration)((MetaIndex)projectStorageSystem.openProjectIndex(MetaIndex.class, null)).getValue(ProjectConfiguration.class);
        AnalysisProfileIndex analysisProfileIndex = (AnalysisProfileIndex)globalStorageSystem.openGlobalIndex(AnalysisProfileIndex.class);
        try {
            return projectConfiguration.getAnalysisProfilePerScope(analysisProfileIndex).map(profile -> Boolean.parseBoolean(profile.getOptionValue("Enable Test Gap Analysis, Pareto Optimization and Test Impact Analysis")));
        }
        catch (ProjectConfigurationException e) {
            LogManager.getLogger().error("Failed to determine TGA enablement per Code Scope", (Throwable)e);
            return CodeScopeAware.emptyWithDefault((Object)true);
        }
    }
}

