/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.testgap.trend;

import com.teamscale.index.resource.CodeScopesMappingIndex;
import com.teamscale.index.resource.metrics.code_scopes.CodeScopesMetricsUtils;
import com.teamscale.index.testgap.MethodLocation;
import com.teamscale.index.testgap.trend.ITgaTrendAdjuster;
import com.teamscale.index.testgap.trend.TgaTrendDataCache;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.conqat.engine.persistence.store.StorageException;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.uniformpath.UniformPathCompatibilityUtil;

class CodeScopeTgaTrendAdjuster
implements ITgaTrendAdjuster {
    private final Set<String> allSubPathsInSameCodeScope;
    private final TgaTrendDataCache trendDataCache;

    public CodeScopeTgaTrendAdjuster(String codeScopePath, CodeScopesMappingIndex codeScopesMappingIndex, TgaTrendDataCache cache) throws StorageException {
        this.trendDataCache = cache;
        this.allSubPathsInSameCodeScope = UniformPathCompatibilityUtil.asUniformPathStringSet(CodeScopesMetricsUtils.getAllSubPathsInSameCodeScope(codeScopesMappingIndex, codeScopePath));
    }

    @Override
    public void invalidateRemovedFiles() {
        this.trendDataCache.invalidateFiles(CollectionUtils.differenceSet(this.trendDataCache.getKnownUniformPaths(), (Collection[])new Collection[]{this.allSubPathsInSameCodeScope}));
    }

    @Override
    public Set<MethodLocation> filterTouchedMethodsThatNeedNoUpdate(Set<MethodLocation> methods) {
        return CollectionUtils.filterToSet(methods, method -> this.allSubPathsInSameCodeScope.contains(method.getUniformPath()));
    }

    @Override
    public Set<String> adjustFilesThatNeedToBeRecalculated(Set<String> touchedFiles) {
        Stream<String> filteredFiles = this.filterTouchedPathsThatNeedNoUpdate(touchedFiles.stream());
        return Stream.concat(filteredFiles, this.pathsThatWereAddedToTheCodeScope()).collect(Collectors.toSet());
    }

    private Stream<String> pathsThatWereAddedToTheCodeScope() {
        return CollectionUtils.differenceSet(this.allSubPathsInSameCodeScope, (Collection[])new Collection[]{this.trendDataCache.getKnownUniformPaths()}).stream();
    }

    private Stream<String> filterTouchedPathsThatNeedNoUpdate(Stream<String> touchedPaths) {
        return touchedPaths.filter(this.allSubPathsInSameCodeScope::contains);
    }
}

